/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.algorithms.remote.streaming;

import java.lang.reflect.Constructor;
import java.util.Locale;
import java.util.Map;
import org.opensearch.ml.common.connector.Connector;
import org.opensearch.ml.common.connector.ConnectorClientConfig;
import org.opensearch.ml.common.exception.MLException;
import org.opensearch.ml.engine.algorithms.remote.streaming.HttpStreamingHandler;
import org.opensearch.ml.engine.algorithms.remote.streaming.StreamingHandler;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;

public class StreamingHandlerFactory {
    public static StreamingHandler createHandler(String llmInterface, Connector connector, SdkAsyncHttpClient httpClient, ConnectorClientConfig connectorClientConfig) {
        return StreamingHandlerFactory.createHandler(llmInterface, connector, httpClient, connectorClientConfig, null);
    }

    public static StreamingHandler createHandler(String llmInterface, Connector connector, SdkAsyncHttpClient httpClient, ConnectorClientConfig connectorClientConfig, Map<String, String> parameters) {
        switch (llmInterface.toLowerCase(Locale.ROOT)) {
            case "bedrock/converse": 
            case "bedrock/converse/claude": {
                return StreamingHandlerFactory.createBedrockHandler(httpClient, connector, parameters);
            }
            case "openai/v1/chat/completions": {
                return StreamingHandlerFactory.createHttpHandler(llmInterface, connector, connectorClientConfig, parameters);
            }
        }
        throw new IllegalArgumentException("Unsupported LLM interface: " + llmInterface);
    }

    private static StreamingHandler createBedrockHandler(SdkAsyncHttpClient httpClient, Connector connector, Map<String, String> parameters) {
        try {
            Class<?> handlerClass = Class.forName("org.opensearch.ml.engine.algorithms.remote.streaming.BedrockStreamingHandler");
            Constructor<?> constructor = handlerClass.getConstructor(SdkAsyncHttpClient.class, Class.forName("org.opensearch.ml.common.connector.AwsConnector"), Map.class);
            return (StreamingHandler)constructor.newInstance(httpClient, connector, parameters);
        }
        catch (ClassNotFoundException e) {
            throw new MLException("Bedrock streaming not available - Bedrock SDK not found", (Throwable)e);
        }
        catch (Exception e) {
            throw new MLException("Failed to initialize Bedrock streaming handler", (Throwable)e);
        }
    }

    private static StreamingHandler createHttpHandler(String llmInterface, Connector connector, ConnectorClientConfig connectorClientConfig, Map<String, String> parameters) {
        return new HttpStreamingHandler(llmInterface, connector, connectorClientConfig, parameters);
    }
}

