/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.memorycontainer;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.ml.action.handler.MLSearchHandler;
import org.opensearch.ml.common.settings.MLCommonsSettings;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.search.MLSearchActionRequest;
import org.opensearch.ml.helper.MemoryContainerHelper;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.remote.metadata.client.SearchDataObjectRequest;
import org.opensearch.remote.metadata.common.SdkClientUtils;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class TransportSearchMemoryContainerAction
extends HandledTransportAction<MLSearchActionRequest, SearchResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(TransportSearchMemoryContainerAction.class);
    private final Client client;
    private final SdkClient sdkClient;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;
    private final MemoryContainerHelper memoryContainerHelper;

    @Inject
    public TransportSearchMemoryContainerAction(TransportService transportService, ActionFilters actionFilters, Client client, SdkClient sdkClient, MLFeatureEnabledSetting mlFeatureEnabledSetting, MemoryContainerHelper memoryContainerHelper) {
        super("cluster:admin/opensearch/ml/memory_containers/search", transportService, actionFilters, MLSearchActionRequest::new);
        this.client = client;
        this.sdkClient = sdkClient;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
        this.memoryContainerHelper = memoryContainerHelper;
    }

    protected void doExecute(Task task, MLSearchActionRequest request, ActionListener<SearchResponse> actionListener) {
        if (!this.mlFeatureEnabledSetting.isAgenticMemoryEnabled()) {
            actionListener.onFailure((Exception)new OpenSearchStatusException(MLCommonsSettings.ML_COMMONS_AGENTIC_MEMORY_DISABLED_MESSAGE, RestStatus.FORBIDDEN, new Object[0]));
            return;
        }
        User user = RestActionUtils.getUserContext(this.client);
        ActionListener<SearchResponse> listener = MLSearchHandler.wrapRestActionListener(actionListener, "Fail to search");
        String tenantId = request.getTenantId();
        if (!TenantAwareHelper.validateTenantId(this.mlFeatureEnabledSetting, tenantId, actionListener)) {
            return;
        }
        this.preProcessRoleAndPerformSearch((SearchRequest)request, tenantId, user, listener);
    }

    private void preProcessRoleAndPerformSearch(SearchRequest request, String tenantId, User user, ActionListener<SearchResponse> listener) {
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListener.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore());
            ActionListener doubleWrappedListener = ActionListener.wrap(arg_0 -> ((ActionListener)wrappedListener).onResponse(arg_0), e -> RestActionUtils.wrapListenerToHandleSearchIndexNotFound(e, (ActionListener<SearchResponse>)wrappedListener));
            if (user != null && !this.memoryContainerHelper.isAdminUser(user)) {
                this.memoryContainerHelper.addUserBackendRolesFilter(user, request.source());
                log.debug("Filtering result by {}", (Object)user.getBackendRoles());
            }
            SearchDataObjectRequest searchDataObjecRequest = SearchDataObjectRequest.builder().indices(request.indices()).searchSourceBuilder(request.source()).tenantId(tenantId).build();
            this.sdkClient.searchDataObjectAsync(searchDataObjecRequest).whenComplete(SdkClientUtils.wrapSearchCompletion((ActionListener)doubleWrappedListener, (Class[])new Class[0]));
        }
        catch (Exception e2) {
            log.error("Failed to search", (Throwable)e2);
            listener.onFailure(e2);
        }
    }
}

