/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.TokenFilterBase;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinitionVariant;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class LimitTokenCountTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant,
ToCopyableBuilder<Builder, LimitTokenCountTokenFilter> {
    @Nullable
    private final Boolean consumeAllTokens;
    @Nullable
    private final Integer maxTokenCount;
    public static final JsonpDeserializer<LimitTokenCountTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, LimitTokenCountTokenFilter::setupLimitTokenCountTokenFilterDeserializer);

    private LimitTokenCountTokenFilter(Builder builder) {
        super(builder);
        this.consumeAllTokens = builder.consumeAllTokens;
        this.maxTokenCount = builder.maxTokenCount;
    }

    public static LimitTokenCountTokenFilter of(Function<Builder, ObjectBuilder<LimitTokenCountTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.Limit;
    }

    @Nullable
    public final Boolean consumeAllTokens() {
        return this.consumeAllTokens;
    }

    @Nullable
    public final Integer maxTokenCount() {
        return this.maxTokenCount;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "limit");
        super.serializeInternal(generator, mapper);
        if (this.consumeAllTokens != null) {
            generator.writeKey("consume_all_tokens");
            generator.write(this.consumeAllTokens.booleanValue());
        }
        if (this.maxTokenCount != null) {
            generator.writeKey("max_token_count");
            generator.write(this.maxTokenCount.intValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupLimitTokenCountTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        LimitTokenCountTokenFilter.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::consumeAllTokens, JsonpDeserializer.booleanDeserializer(), "consume_all_tokens");
        op.add(Builder::maxTokenCount, JsonpDeserializer.integerDeserializer(), "max_token_count");
        op.ignore("type");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.consumeAllTokens);
        result = 31 * result + Objects.hashCode(this.maxTokenCount);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LimitTokenCountTokenFilter other = (LimitTokenCountTokenFilter)o;
        return Objects.equals(this.consumeAllTokens, other.consumeAllTokens) && Objects.equals(this.maxTokenCount, other.maxTokenCount);
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, LimitTokenCountTokenFilter> {
        @Nullable
        private Boolean consumeAllTokens;
        @Nullable
        private Integer maxTokenCount;

        public Builder() {
        }

        private Builder(LimitTokenCountTokenFilter o) {
            super(o);
            this.consumeAllTokens = o.consumeAllTokens;
            this.maxTokenCount = o.maxTokenCount;
        }

        private Builder(Builder o) {
            super(o);
            this.consumeAllTokens = o.consumeAllTokens;
            this.maxTokenCount = o.maxTokenCount;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder consumeAllTokens(@Nullable Boolean value) {
            this.consumeAllTokens = value;
            return this;
        }

        @Nonnull
        public final Builder maxTokenCount(@Nullable Integer value) {
            this.maxTokenCount = value;
            return this;
        }

        @Override
        @Nonnull
        public LimitTokenCountTokenFilter build() {
            this._checkSingleUse();
            return new LimitTokenCountTokenFilter(this);
        }
    }
}

