/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.impl;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.collection.LazyList;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.AttributeMap;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.opensaml.saml.common.AbstractSignableSAMLObject;
import org.opensaml.saml.saml2.metadata.ContactPerson;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.Organization;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.xmlsec.signature.Signature;

public abstract class RoleDescriptorImpl
extends AbstractSignableSAMLObject
implements RoleDescriptor {
    @Nullable
    private String id;
    @Nullable
    private Instant validUntil;
    @Nullable
    private Duration cacheDuration;
    @Nonnull
    private final List<String> supportedProtocols;
    @Nullable
    private String errorURL;
    @Nullable
    private Extensions extensions;
    @Nullable
    private Organization organization;
    @Nonnull
    private final AttributeMap unknownAttributes = new AttributeMap(this);
    @Nonnull
    private final XMLObjectChildrenList<ContactPerson> contactPersons;
    @Nonnull
    private final XMLObjectChildrenList<KeyDescriptor> keyDescriptors;

    protected RoleDescriptorImpl(@Nullable String namespaceURI, @Nonnull String elementLocalName, @Nullable String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
        this.supportedProtocols = new LazyList<String>();
        this.contactPersons = new XMLObjectChildrenList(this);
        this.keyDescriptors = new XMLObjectChildrenList(this);
    }

    @Override
    @Nullable
    public String getID() {
        return this.id;
    }

    @Override
    public void setID(@Nullable String newID) {
        String oldID = this.id;
        this.id = this.prepareForAssignment(this.id, newID);
        this.registerOwnID(oldID, this.id);
    }

    @Override
    public boolean isValid() {
        if (null == this.validUntil) {
            return true;
        }
        return Instant.now().isBefore(this.validUntil);
    }

    @Override
    @Nullable
    public Instant getValidUntil() {
        return this.validUntil;
    }

    @Override
    public void setValidUntil(@Nullable Instant dt) {
        this.validUntil = this.prepareForAssignment(this.validUntil, dt);
    }

    @Override
    @Nullable
    public Duration getCacheDuration() {
        return this.cacheDuration;
    }

    @Override
    public void setCacheDuration(@Nullable Duration duration) {
        this.cacheDuration = this.prepareForAssignment(this.cacheDuration, duration);
    }

    @Override
    @Nonnull
    @NotLive
    @Unmodifiable
    public List<String> getSupportedProtocols() {
        return CollectionSupport.copyToList(this.supportedProtocols);
    }

    @Override
    public boolean isSupportedProtocol(@Nonnull @NotEmpty String protocol) {
        return this.supportedProtocols.contains(protocol);
    }

    @Override
    public void addSupportedProtocol(@Nonnull @NotEmpty String protocol) {
        String trimmed = StringSupport.trimOrNull(protocol);
        if (trimmed != null && !this.supportedProtocols.contains(trimmed)) {
            this.releaseThisandParentDOM();
            this.supportedProtocols.add(trimmed);
        }
    }

    @Override
    public void removeSupportedProtocol(@Nonnull @NotEmpty String protocol) {
        String trimmed = StringSupport.trimOrNull(protocol);
        if (trimmed != null && this.supportedProtocols.contains(trimmed)) {
            this.releaseThisandParentDOM();
            this.supportedProtocols.remove(trimmed);
        }
    }

    @Override
    public void removeSupportedProtocols(@Nonnull Collection<String> protocols) {
        for (String protocol : protocols) {
            assert (protocol != null);
            this.removeSupportedProtocol(protocol);
        }
    }

    @Override
    public void removeAllSupportedProtocols() {
        this.supportedProtocols.clear();
    }

    @Override
    @Nullable
    public String getErrorURL() {
        return this.errorURL;
    }

    @Override
    public void setErrorURL(@Nullable String url) {
        this.errorURL = this.prepareForAssignment(this.errorURL, url);
    }

    @Override
    @Nullable
    public Extensions getExtensions() {
        return this.extensions;
    }

    @Override
    public void setExtensions(@Nullable Extensions ext) {
        this.extensions = this.prepareForAssignment(this.extensions, ext);
    }

    @Override
    @Nullable
    public Organization getOrganization() {
        return this.organization;
    }

    @Override
    public void setOrganization(@Nullable Organization org) {
        this.organization = this.prepareForAssignment(this.organization, org);
    }

    @Override
    @Nonnull
    @Live
    public List<ContactPerson> getContactPersons() {
        return this.contactPersons;
    }

    @Override
    @Nonnull
    @Live
    public List<KeyDescriptor> getKeyDescriptors() {
        return this.keyDescriptors;
    }

    @Override
    @Nonnull
    public AttributeMap getUnknownAttributes() {
        return this.unknownAttributes;
    }

    @Override
    @Nullable
    public String getSignatureReferenceID() {
        return this.id;
    }

    @Override
    @Nullable
    @NotLive
    @Unmodifiable
    public List<XMLObject> getOrderedChildren() {
        ArrayList<XMLObject> children = new ArrayList<XMLObject>();
        Signature sig = this.getSignature();
        if (sig != null) {
            children.add(sig);
        }
        if (this.extensions != null) {
            children.add(this.getExtensions());
        }
        children.addAll(this.getKeyDescriptors());
        if (this.organization != null) {
            children.add(this.getOrganization());
        }
        children.addAll(this.getContactPersons());
        return CollectionSupport.copyToList(children);
    }
}

