/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.http;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.security.filter.SecurityRequest;

final class RemoteIpDetector {
    private static final Pattern commaSeparatedValuesPattern = Pattern.compile("\\s*,\\s*");
    protected final Logger log = LogManager.getLogger(this.getClass());
    private Pattern internalProxies = Pattern.compile("10\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}|192\\.168\\.\\d{1,3}\\.\\d{1,3}|169\\.254\\.\\d{1,3}\\.\\d{1,3}|127\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}|172\\.1[6-9]{1}\\.\\d{1,3}\\.\\d{1,3}|172\\.2[0-9]{1}\\.\\d{1,3}\\.\\d{1,3}|172\\.3[0-1]{1}\\.\\d{1,3}\\.\\d{1,3}");
    private String remoteIpHeader = "X-Forwarded-For";

    RemoteIpDetector() {
    }

    protected static String[] commaDelimitedListToStringArray(String commaDelimitedStrings) {
        return commaDelimitedStrings == null || commaDelimitedStrings.length() == 0 ? new String[]{} : commaSeparatedValuesPattern.split(commaDelimitedStrings);
    }

    public String getInternalProxies() {
        if (this.internalProxies == null) {
            return null;
        }
        return this.internalProxies.toString();
    }

    public String getRemoteIpHeader() {
        return this.remoteIpHeader;
    }

    String detect(SecurityRequest request, ThreadContext threadContext) {
        String originalRemoteAddr = request.getRemoteAddress().map(InetSocketAddress::getAddress).map(InetAddress::getHostAddress).orElseThrow();
        boolean isTraceEnabled = this.log.isTraceEnabled();
        if (isTraceEnabled) {
            this.log.trace("originalRemoteAddr {}", (Object)originalRemoteAddr);
        }
        if (this.internalProxies != null && this.internalProxies.matcher(originalRemoteAddr).matches()) {
            int idx;
            String remoteIp = null;
            StringBuilder concatRemoteIpHeaderValue = new StringBuilder();
            List<String> remoteIpHeaders = request.getHeaders().get(this.remoteIpHeader);
            if (remoteIpHeaders == null || remoteIpHeaders.isEmpty()) {
                return originalRemoteAddr;
            }
            for (String rh : remoteIpHeaders) {
                if (concatRemoteIpHeaderValue.length() > 0) {
                    concatRemoteIpHeaderValue.append(", ");
                }
                concatRemoteIpHeaderValue.append(rh);
            }
            if (isTraceEnabled) {
                this.log.trace("concatRemoteIpHeaderValue {}", (Object)concatRemoteIpHeaderValue.toString());
            }
            String[] remoteIpHeaderValue = RemoteIpDetector.commaDelimitedListToStringArray(concatRemoteIpHeaderValue.toString());
            for (idx = remoteIpHeaderValue.length - 1; idx >= 0; --idx) {
                String currentRemoteIp;
                remoteIp = currentRemoteIp = remoteIpHeaderValue[idx];
                if (this.internalProxies.matcher(currentRemoteIp).matches()) continue;
                --idx;
                break;
            }
            LinkedList<String> newRemoteIpHeaderValue = new LinkedList<String>();
            while (idx >= 0) {
                String currentRemoteIp = remoteIpHeaderValue[idx];
                newRemoteIpHeaderValue.addFirst(currentRemoteIp);
                --idx;
            }
            if (remoteIp != null) {
                if (isTraceEnabled) {
                    String originalRemoteHost = request.getRemoteAddress().map(InetSocketAddress::getAddress).map(InetAddress::getHostName).orElseThrow();
                    this.log.trace("Incoming request {} with originalRemoteAddr '{}', originalRemoteHost='{}', will be seen as newRemoteAddr='{}'", (Object)request.uri(), (Object)originalRemoteAddr, (Object)originalRemoteHost, (Object)remoteIp);
                }
                threadContext.putTransient("_opendistro_security_xff_done", (Object)Boolean.TRUE);
                return remoteIp;
            }
            this.log.warn("Remote ip could not be detected, this should normally not happen");
        } else if (isTraceEnabled) {
            this.log.trace("Skip RemoteIpDetector for request {} with originalRemoteAddr '{}' cause no internal proxy matches", (Object)request.uri(), request.getRemoteAddress().orElse(null));
        }
        return originalRemoteAddr;
    }

    public void setInternalProxies(String internalProxies) {
        this.internalProxies = internalProxies == null || internalProxies.length() == 0 ? null : Pattern.compile(internalProxies);
    }

    public void setRemoteIpHeader(String remoteIpHeader) {
        this.remoteIpHeader = remoteIpHeader;
    }
}

