/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.criteria;

import java.security.PublicKey;
import javax.annotation.Nonnull;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.resolver.Criterion;

public final class PublicKeyCriterion
implements Criterion {
    @Nonnull
    private PublicKey publicKey;

    public PublicKeyCriterion(@Nonnull PublicKey pubKey) {
        this.publicKey = Constraint.isNotNull(pubKey, "Public key criterion value cannot be null");
    }

    @Nonnull
    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(@Nonnull PublicKey key) {
        this.publicKey = Constraint.isNotNull(key, "Public key criterion value cannot be null");
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PublicKeyCriterion [publicKey=");
        builder.append(this.publicKey);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        return this.publicKey.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof PublicKeyCriterion) {
            PublicKeyCriterion keycrit = (PublicKeyCriterion)obj;
            return this.publicKey.equals(keycrit.publicKey);
        }
        return false;
    }
}

