/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.support;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.password4j.types.Hmac;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opensearch.common.settings.Settings;
import org.opensearch.security.auditlog.impl.AuditCategory;

public class ConfigConstants {
    public static final String OPENDISTRO_SECURITY_CONFIG_PREFIX = "_opendistro_security_";
    public static final String OPENSEARCH_SECURITY_CONFIG_PREFIX = "_opensearch_security_";
    public static final String SECURITY_SETTINGS_PREFIX = "plugins.security.";
    public static final String OPENSEARCH_SECURITY_DISABLED = "plugins.security.disabled";
    public static final boolean OPENSEARCH_SECURITY_DISABLED_DEFAULT = false;
    public static final String OPENDISTRO_SECURITY_CHANNEL_TYPE = "_opendistro_security_channel_type";
    public static final String OPENDISTRO_SECURITY_ORIGIN = "_opendistro_security_origin";
    public static final String OPENDISTRO_SECURITY_ORIGIN_HEADER = "_opendistro_security_origin_header";
    public static final String OPENDISTRO_SECURITY_DLS_QUERY_HEADER = "_opendistro_security_dls_query";
    public static final String OPENDISTRO_SECURITY_DLS_FILTER_LEVEL_QUERY_HEADER = "_opendistro_security_dls_filter_level_query";
    public static final String OPENDISTRO_SECURITY_DLS_FILTER_LEVEL_QUERY_TRANSIENT = "_opendistro_security_dls_filter_level_query_t";
    public static final String OPENDISTRO_SECURITY_DLS_MODE_HEADER = "_opendistro_security_dls_mode";
    public static final String OPENDISTRO_SECURITY_DLS_MODE_TRANSIENT = "_opendistro_security_dls_mode_t";
    public static final String OPENDISTRO_SECURITY_FLS_FIELDS_HEADER = "_opendistro_security_fls_fields";
    public static final String OPENDISTRO_SECURITY_MASKED_FIELD_HEADER = "_opendistro_security_masked_fields";
    public static final String OPENDISTRO_SECURITY_DOC_ALLOWLIST_HEADER = "_opendistro_security_doc_allowlist";
    public static final String OPENDISTRO_SECURITY_DOC_ALLOWLIST_TRANSIENT = "_opendistro_security_doc_allowlist_t";
    public static final String OPENDISTRO_SECURITY_FILTER_LEVEL_DLS_DONE = "_opendistro_security_filter_level_dls_done";
    public static final String OPENDISTRO_SECURITY_CONTAIN_PARENT_CHILD_QUERY = "_opendistro_security_is_parent_child_query";
    public static final String OPENDISTRO_SECURITY_DLS_QUERY_CCS = "_opendistro_security_dls_query_ccs";
    public static final String OPENDISTRO_SECURITY_FLS_FIELDS_CCS = "_opendistro_security_fls_fields_ccs";
    public static final String OPENDISTRO_SECURITY_MASKED_FIELD_CCS = "_opendistro_security_masked_fields_ccs";
    public static final String OPENDISTRO_SECURITY_CONF_REQUEST_HEADER = "_opendistro_security_conf_request";
    public static final String OPENSEARCH_SECURITY_REQUEST_HEADERS = "_opensearch_security_request_headers";
    public static final String OPENDISTRO_SECURITY_REMOTE_ADDRESS = "_opendistro_security_remote_address";
    public static final String OPENDISTRO_SECURITY_REMOTE_ADDRESS_HEADER = "_opendistro_security_remote_address_header";
    public static final String OPENDISTRO_SECURITY_INITIAL_ACTION_CLASS_HEADER = "_opendistro_security_initial_action_class_header";
    public static final String OPENDISTRO_SECURITY_SSL_PEER_CERTIFICATES = "_opendistro_security_ssl_peer_certificates";
    public static final String OPENDISTRO_SECURITY_SSL_PRINCIPAL = "_opendistro_security_ssl_principal";
    public static final String OPENDISTRO_SECURITY_SSL_TRANSPORT_INTERCLUSTER_REQUEST = "_opendistro_security_ssl_transport_intercluster_request";
    public static final String OPENDISTRO_SECURITY_SSL_TRANSPORT_TRUSTED_CLUSTER_REQUEST = "_opendistro_security_ssl_transport_trustedcluster_request";
    public static final String OPENDISTRO_SECURITY_SSL_TRANSPORT_EXTENSION_REQUEST = "_opendistro_security_ssl_transport_extension_request";
    public static final String OPENDISTRO_SECURITY_SSL_TRANSPORT_PRINCIPAL = "_opendistro_security_ssl_transport_principal";
    public static final String OPENDISTRO_SECURITY_USER = "_opendistro_security_user";
    public static final String OPENDISTRO_SECURITY_USER_HEADER = "_opendistro_security_user_header";
    public static final String OPENDISTRO_SECURITY_AUTHENTICATED_USER = "_opendistro_security_authenticated_user";
    public static final String OPENDISTRO_SECURITY_AUTHENTICATED_USER_HEADER = "_opendistro_security_authenticated_user_header";
    public static final String OPENDISTRO_SECURITY_USER_SAME_AS_SUBJECT_HEADER = "_opendistro_security_user_same_as_subject_header";
    public static final String OPENDISTRO_SECURITY_USER_INFO_THREAD_CONTEXT = "_opendistro_security_user_info";
    public static final String OPENDISTRO_SECURITY_INITIATING_USER = "_opendistro_security__initiating_user";
    public static final String OPENDISTRO_SECURITY_INJECTED_USER = "injected_user";
    public static final String OPENDISTRO_SECURITY_INJECTED_USER_HEADER = "injected_user_header";
    public static final String OPENDISTRO_SECURITY_INJECTED_USER_CUSTOM_ATTRIBUTES = "injected_user_custom_attributes";
    public static final String OPENDISTRO_SECURITY_XFF_DONE = "_opendistro_security_xff_done";
    public static final String SSO_LOGOUT_URL = "_opendistro_security_sso_logout_url";
    public static final String OPENDISTRO_SECURITY_DEFAULT_CONFIG_INDEX = ".opendistro_security";
    public static final String OPENSEARCH_SECURITY_DEFAULT_CONFIG_VERSIONS_INDEX = ".opensearch_security_config_versions";
    public static final String SECURITY_ENABLE_SNAPSHOT_RESTORE_PRIVILEGE = "plugins.security.enable_snapshot_restore_privilege";
    public static final boolean SECURITY_DEFAULT_ENABLE_SNAPSHOT_RESTORE_PRIVILEGE = true;
    public static final String SECURITY_CHECK_SNAPSHOT_RESTORE_WRITE_PRIVILEGES = "plugins.security.check_snapshot_restore_write_privileges";
    public static final boolean SECURITY_DEFAULT_CHECK_SNAPSHOT_RESTORE_WRITE_PRIVILEGES = true;
    public static final Set<String> SECURITY_SNAPSHOT_RESTORE_NEEDED_WRITE_PRIVILEGES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("indices:admin/create", "indices:data/write/index")));
    public static final String SECURITY_INTERCLUSTER_REQUEST_EVALUATOR_CLASS = "plugins.security.cert.intercluster_request_evaluator_class";
    public static final String OPENDISTRO_SECURITY_ACTION_NAME = "_opendistro_security_action_name";
    public static final String SECURITY_AUTHCZ_ADMIN_DN = "plugins.security.authcz.admin_dn";
    public static final String SECURITY_CONFIG_INDEX_NAME = "plugins.security.config_index_name";
    public static final String SECURITY_CONFIG_VERSIONS_INDEX_NAME = "plugins.security.config_versions_index_name";
    public static final String SECURITY_AUTHCZ_IMPERSONATION_DN = "plugins.security.authcz.impersonation_dn";
    public static final String SECURITY_AUTHCZ_REST_IMPERSONATION_USERS = "plugins.security.authcz.rest_impersonation_user";
    public static final String SECURITY_PERFORM_PERMISSION_CHECK_PARAM = "perform_permission_check";
    public static final String BCRYPT = "bcrypt";
    public static final String PBKDF2 = "pbkdf2";
    public static final String ARGON2 = "argon2";
    public static final String SECURITY_PASSWORD_HASHING_BCRYPT_ROUNDS = "plugins.security.password.hashing.bcrypt.rounds";
    public static final int SECURITY_PASSWORD_HASHING_BCRYPT_ROUNDS_DEFAULT = 12;
    public static final String SECURITY_PASSWORD_HASHING_BCRYPT_MINOR = "plugins.security.password.hashing.bcrypt.minor";
    public static final String SECURITY_PASSWORD_HASHING_BCRYPT_MINOR_DEFAULT = "Y";
    public static final String SECURITY_PASSWORD_HASHING_ALGORITHM = "plugins.security.password.hashing.algorithm";
    public static final String SECURITY_PASSWORD_HASHING_ALGORITHM_DEFAULT = "bcrypt";
    public static final String SECURITY_PASSWORD_HASHING_PBKDF2_ITERATIONS = "plugins.security.password.hashing.pbkdf2.iterations";
    public static final int SECURITY_PASSWORD_HASHING_PBKDF2_ITERATIONS_DEFAULT = 600000;
    public static final String SECURITY_PASSWORD_HASHING_PBKDF2_LENGTH = "plugins.security.password.hashing.pbkdf2.length";
    public static final int SECURITY_PASSWORD_HASHING_PBKDF2_LENGTH_DEFAULT = 256;
    public static final String SECURITY_PASSWORD_HASHING_PBKDF2_FUNCTION = "plugins.security.password.hashing.pbkdf2.function";
    public static final String SECURITY_PASSWORD_HASHING_PBKDF2_FUNCTION_DEFAULT = Hmac.SHA256.name();
    public static final String SECURITY_PASSWORD_HASHING_ARGON2_ITERATIONS = "plugins.security.password.hashing.argon2.iterations";
    public static final int SECURITY_PASSWORD_HASHING_ARGON2_ITERATIONS_DEFAULT = 3;
    public static final String SECURITY_PASSWORD_HASHING_ARGON2_MEMORY = "plugins.security.password.hashing.argon2.memory";
    public static final int SECURITY_PASSWORD_HASHING_ARGON2_MEMORY_DEFAULT = 65536;
    public static final String SECURITY_PASSWORD_HASHING_ARGON2_PARALLELISM = "plugins.security.password.hashing.argon2.parallelism";
    public static final int SECURITY_PASSWORD_HASHING_ARGON2_PARALLELISM_DEFAULT = 1;
    public static final String SECURITY_PASSWORD_HASHING_ARGON2_LENGTH = "plugins.security.password.hashing.argon2.length";
    public static final int SECURITY_PASSWORD_HASHING_ARGON2_LENGTH_DEFAULT = 32;
    public static final String SECURITY_PASSWORD_HASHING_ARGON2_TYPE = "plugins.security.password.hashing.argon2.type";
    public static final String SECURITY_PASSWORD_HASHING_ARGON2_TYPE_DEFAULT = "argon2id";
    public static final String SECURITY_PASSWORD_HASHING_ARGON2_VERSION = "plugins.security.password.hashing.argon2.version";
    public static final int SECURITY_PASSWORD_HASHING_ARGON2_VERSION_DEFAULT = 19;
    public static final String SECURITY_AUDIT_TYPE_DEFAULT = "plugins.security.audit.type";
    public static final String SECURITY_AUDIT_CONFIG_DEFAULT = "plugins.security.audit.config";
    public static final String SECURITY_AUDIT_CONFIG_ROUTES = "plugins.security.audit.routes";
    public static final String SECURITY_AUDIT_CONFIG_ENDPOINTS = "plugins.security.audit.endpoints";
    public static final String SECURITY_AUDIT_THREADPOOL_SIZE = "plugins.security.audit.threadpool.size";
    public static final String SECURITY_AUDIT_THREADPOOL_MAX_QUEUE_LEN = "plugins.security.audit.threadpool.max_queue_len";
    public static final String OPENDISTRO_SECURITY_AUDIT_LOG_REQUEST_BODY = "opendistro_security.audit.log_request_body";
    public static final String OPENDISTRO_SECURITY_AUDIT_RESOLVE_INDICES = "opendistro_security.audit.resolve_indices";
    public static final String OPENDISTRO_SECURITY_AUDIT_ENABLE_REST = "opendistro_security.audit.enable_rest";
    public static final String OPENDISTRO_SECURITY_AUDIT_ENABLE_TRANSPORT = "opendistro_security.audit.enable_transport";
    public static final String OPENDISTRO_SECURITY_AUDIT_CONFIG_DISABLED_TRANSPORT_CATEGORIES = "opendistro_security.audit.config.disabled_transport_categories";
    public static final String OPENDISTRO_SECURITY_AUDIT_CONFIG_DISABLED_REST_CATEGORIES = "opendistro_security.audit.config.disabled_rest_categories";
    public static final List<String> OPENDISTRO_SECURITY_AUDIT_DISABLED_CATEGORIES_DEFAULT = ImmutableList.of((Object)AuditCategory.AUTHENTICATED.toString(), (Object)AuditCategory.GRANTED_PRIVILEGES.toString());
    public static final String OPENDISTRO_SECURITY_AUDIT_IGNORE_USERS = "opendistro_security.audit.ignore_users";
    public static final String OPENDISTRO_SECURITY_AUDIT_IGNORE_REQUESTS = "opendistro_security.audit.ignore_requests";
    public static final String SECURITY_AUDIT_IGNORE_HEADERS = "plugins.security.audit.ignore_headers";
    public static final String OPENDISTRO_SECURITY_AUDIT_RESOLVE_BULK_REQUESTS = "opendistro_security.audit.resolve_bulk_requests";
    public static final boolean OPENDISTRO_SECURITY_AUDIT_SSL_VERIFY_HOSTNAMES_DEFAULT = true;
    public static final boolean OPENDISTRO_SECURITY_AUDIT_SSL_ENABLE_SSL_CLIENT_AUTH_DEFAULT = false;
    public static final String OPENDISTRO_SECURITY_AUDIT_EXCLUDE_SENSITIVE_HEADERS = "opendistro_security.audit.exclude_sensitive_headers";
    public static final String SECURITY_AUDIT_CONFIG_DEFAULT_PREFIX = "plugins.security.audit.config.";
    public static final String SECURITY_AUDIT_CONFIG_TIMEZONE = "plugins.security.audit.config.timezone";
    public static final String SECURITY_AUDIT_OPENSEARCH_DATASTREAM_NAME = "data_stream.name";
    public static final String SECURITY_AUDIT_OPENSEARCH_DATASTREAM_TEMPLATE_MANAGE = "data_stream.template.manage";
    public static final String SECURITY_AUDIT_OPENSEARCH_DATASTREAM_TEMPLATE_NAME = "data_stream.template.name";
    public static final String SECURITY_AUDIT_OPENSEARCH_DATASTREAM_TEMPLATE_NUMBER_OF_REPLICAS = "data_stream.template.number_of_replicas";
    public static final String SECURITY_AUDIT_OPENSEARCH_DATASTREAM_TEMPLATE_NUMBER_OF_SHARDS = "data_stream.template.number_of_shards";
    public static final String SECURITY_AUDIT_OPENSEARCH_INDEX = "index";
    public static final String SECURITY_AUDIT_OPENSEARCH_TYPE = "type";
    public static final String SECURITY_AUDIT_EXTERNAL_OPENSEARCH_HTTP_ENDPOINTS = "http_endpoints";
    public static final String SECURITY_AUDIT_CONFIG_USERNAME = "username";
    public static final String SECURITY_AUDIT_CONFIG_PASSWORD = "password";
    public static final String SECURITY_AUDIT_EXTERNAL_OPENSEARCH_ENABLE_SSL = "enable_ssl";
    public static final String SECURITY_AUDIT_EXTERNAL_OPENSEARCH_VERIFY_HOSTNAMES = "verify_hostnames";
    public static final String SECURITY_AUDIT_EXTERNAL_OPENSEARCH_ENABLE_SSL_CLIENT_AUTH = "enable_ssl_client_auth";
    public static final String SECURITY_AUDIT_EXTERNAL_OPENSEARCH_PEMKEY_FILEPATH = "pemkey_filepath";
    public static final String SECURITY_AUDIT_EXTERNAL_OPENSEARCH_PEMKEY_CONTENT = "pemkey_content";
    public static final String SECURITY_AUDIT_EXTERNAL_OPENSEARCH_PEMKEY_PASSWORD = "pemkey_password";
    public static final String SECURITY_AUDIT_EXTERNAL_OPENSEARCH_PEMCERT_FILEPATH = "pemcert_filepath";
    public static final String SECURITY_AUDIT_EXTERNAL_OPENSEARCH_PEMCERT_CONTENT = "pemcert_content";
    public static final String SECURITY_AUDIT_EXTERNAL_OPENSEARCH_PEMTRUSTEDCAS_FILEPATH = "pemtrustedcas_filepath";
    public static final String SECURITY_AUDIT_EXTERNAL_OPENSEARCH_PEMTRUSTEDCAS_CONTENT = "pemtrustedcas_content";
    public static final String SECURITY_AUDIT_EXTERNAL_OPENSEARCH_JKS_CERT_ALIAS = "cert_alias";
    public static final String SECURITY_AUDIT_EXTERNAL_OPENSEARCH_ENABLED_SSL_CIPHERS = "enabled_ssl_ciphers";
    public static final String SECURITY_AUDIT_EXTERNAL_OPENSEARCH_ENABLED_SSL_PROTOCOLS = "enabled_ssl_protocols";
    public static final String SECURITY_AUDIT_WEBHOOK_URL = "webhook.url";
    public static final String SECURITY_AUDIT_WEBHOOK_FORMAT = "webhook.format";
    public static final String SECURITY_AUDIT_WEBHOOK_SSL_VERIFY = "webhook.ssl.verify";
    public static final String SECURITY_AUDIT_WEBHOOK_PEMTRUSTEDCAS_FILEPATH = "webhook.ssl.pemtrustedcas_filepath";
    public static final String SECURITY_AUDIT_WEBHOOK_PEMTRUSTEDCAS_CONTENT = "webhook.ssl.pemtrustedcas_content";
    public static final String SECURITY_AUDIT_LOG4J_LOGGER_NAME = "log4j.logger_name";
    public static final String SECURITY_AUDIT_LOG4J_LEVEL = "log4j.level";
    public static final String SECURITY_AUDIT_RETRY_COUNT = "plugins.security.audit.config.retry_count";
    public static final String SECURITY_AUDIT_RETRY_DELAY_MS = "plugins.security.audit.config.retry_delay_ms";
    public static final String SECURITY_KERBEROS_KRB5_FILEPATH = "plugins.security.kerberos.krb5_filepath";
    public static final String SECURITY_KERBEROS_ACCEPTOR_KEYTAB_FILEPATH = "plugins.security.kerberos.acceptor_keytab_filepath";
    public static final String SECURITY_KERBEROS_ACCEPTOR_PRINCIPAL = "plugins.security.kerberos.acceptor_principal";
    public static final String SECURITY_CERT_OID = "plugins.security.cert.oid";
    public static final String SECURITY_CERT_INTERCLUSTER_REQUEST_EVALUATOR_CLASS = "plugins.security.cert.intercluster_request_evaluator_class";
    public static final String SECURITY_ADVANCED_MODULES_ENABLED = "plugins.security.advanced_modules_enabled";
    public static final String SECURITY_NODES_DN = "plugins.security.nodes_dn";
    public static final String SECURITY_NODES_DN_DYNAMIC_CONFIG_ENABLED = "plugins.security.nodes_dn_dynamic_config_enabled";
    public static final String SECURITY_DISABLED = "plugins.security.disabled";
    public static final String SECURITY_CACHE_TTL_MINUTES = "plugins.security.cache.ttl_minutes";
    public static final String SECURITY_ALLOW_UNSAFE_DEMOCERTIFICATES = "plugins.security.allow_unsafe_democertificates";
    public static final String SECURITY_ALLOW_DEFAULT_INIT_SECURITYINDEX = "plugins.security.allow_default_init_securityindex";
    public static final String SECURITY_ALLOW_DEFAULT_INIT_USE_CLUSTER_STATE = "plugins.security.allow_default_init_securityindex.use_cluster_state";
    public static final String SECURITY_BACKGROUND_INIT_IF_SECURITYINDEX_NOT_EXIST = "plugins.security.background_init_if_securityindex_not_exist";
    public static final String SECURITY_ROLES_MAPPING_RESOLUTION = "plugins.security.roles_mapping_resolution";
    public static final String OPENDISTRO_SECURITY_COMPLIANCE_HISTORY_WRITE_METADATA_ONLY = "opendistro_security.compliance.history.write.metadata_only";
    public static final String OPENDISTRO_SECURITY_COMPLIANCE_HISTORY_READ_METADATA_ONLY = "opendistro_security.compliance.history.read.metadata_only";
    public static final String OPENDISTRO_SECURITY_COMPLIANCE_HISTORY_READ_WATCHED_FIELDS = "opendistro_security.compliance.history.read.watched_fields";
    public static final String OPENDISTRO_SECURITY_COMPLIANCE_HISTORY_WRITE_WATCHED_INDICES = "opendistro_security.compliance.history.write.watched_indices";
    public static final String OPENDISTRO_SECURITY_COMPLIANCE_HISTORY_WRITE_LOG_DIFFS = "opendistro_security.compliance.history.write.log_diffs";
    public static final String OPENDISTRO_SECURITY_COMPLIANCE_HISTORY_READ_IGNORE_USERS = "opendistro_security.compliance.history.read.ignore_users";
    public static final String OPENDISTRO_SECURITY_COMPLIANCE_HISTORY_WRITE_IGNORE_USERS = "opendistro_security.compliance.history.write.ignore_users";
    public static final String OPENDISTRO_SECURITY_COMPLIANCE_HISTORY_EXTERNAL_CONFIG_ENABLED = "opendistro_security.compliance.history.external_config_enabled";
    public static final String OPENDISTRO_SECURITY_SOURCE_FIELD_CONTEXT = "_opendistro_security_source_field_context";
    public static final String SECURITY_COMPLIANCE_DISABLE_ANONYMOUS_AUTHENTICATION = "plugins.security.compliance.disable_anonymous_authentication";
    public static final String SECURITY_COMPLIANCE_IMMUTABLE_INDICES = "plugins.security.compliance.immutable_indices";
    public static final String SECURITY_COMPLIANCE_SALT = "plugins.security.compliance.salt";
    public static final String SECURITY_COMPLIANCE_SALT_DEFAULT = "e1ukloTsQlOgPquJ";
    public static final String SECURITY_COMPLIANCE_HISTORY_INTERNAL_CONFIG_ENABLED = "opendistro_security.compliance.history.internal_config_enabled";
    public static final String SECURITY_SSL_ONLY = "plugins.security.ssl_only";
    public static final String SECURITY_CONFIG_SSL_DUAL_MODE_ENABLED = "plugins.security_config.ssl_dual_mode_enabled";
    public static final String SECURITY_SSL_DUAL_MODE_SKIP_SECURITY = "_opendistro_security_passive_security";
    public static final String LEGACY_OPENDISTRO_SECURITY_CONFIG_SSL_DUAL_MODE_ENABLED = "opendistro_security_config.ssl_dual_mode_enabled";
    public static final String SECURITY_SSL_CERT_RELOAD_ENABLED = "plugins.security.ssl_cert_reload_enabled";
    public static final String SECURITY_SSL_CERTIFICATES_HOT_RELOAD_ENABLED = "plugins.security.ssl.certificates_hot_reload.enabled";
    public static final String SECURITY_DISABLE_ENVVAR_REPLACEMENT = "plugins.security.disable_envvar_replacement";
    public static final String SECURITY_DFM_EMPTY_OVERRIDES_ALL = "plugins.security.dfm_empty_overrides_all";
    public static final String SECURITY_FILTER_SECURITYINDEX_FROM_ALL_REQUESTS = "plugins.security.filter_securityindex_from_all_requests";
    public static final String SECURITY_DLS_MODE = "plugins.security.dls.mode";
    public static final String SECURITY_DLS_WRITE_BLOCKED = "plugins.security.dls.write_blocked";
    public static final boolean SECURITY_DLS_WRITE_BLOCKED_ENABLED_DEFAULT = false;
    public static final String SECURITY_RESTAPI_ROLES_ENABLED = "plugins.security.restapi.roles_enabled";
    public static final String SECURITY_RESTAPI_ADMIN_ENABLED = "plugins.security.restapi.admin.enabled";
    public static final String SECURITY_RESTAPI_ENDPOINTS_DISABLED = "plugins.security.restapi.endpoints_disabled";
    public static final String SECURITY_RESTAPI_PASSWORD_VALIDATION_REGEX = "plugins.security.restapi.password_validation_regex";
    public static final String SECURITY_RESTAPI_PASSWORD_VALIDATION_ERROR_MESSAGE = "plugins.security.restapi.password_validation_error_message";
    public static final String SECURITY_RESTAPI_PASSWORD_MIN_LENGTH = "plugins.security.restapi.password_min_length";
    public static final String SECURITY_RESTAPI_PASSWORD_SCORE_BASED_VALIDATION_STRENGTH = "plugins.security.restapi.password_score_based_validation_strength";
    public static final String SECURITY_UNSUPPORTED_DISABLE_REST_AUTH_INITIALLY = "plugins.security.unsupported.disable_rest_auth_initially";
    public static final String SECURITY_UNSUPPORTED_DELAY_INITIALIZATION_SECONDS = "plugins.security.unsupported.delay_initialization_seconds";
    public static final String SECURITY_UNSUPPORTED_DISABLE_INTERTRANSPORT_AUTH_INITIALLY = "plugins.security.unsupported.disable_intertransport_auth_initially";
    public static final String SECURITY_UNSUPPORTED_PASSIVE_INTERTRANSPORT_AUTH_INITIALLY = "plugins.security.unsupported.passive_intertransport_auth_initially";
    public static final String SECURITY_UNSUPPORTED_RESTORE_SECURITYINDEX_ENABLED = "plugins.security.unsupported.restore.securityindex.enabled";
    public static final String SECURITY_UNSUPPORTED_INJECT_USER_ENABLED = "plugins.security.unsupported.inject_user.enabled";
    public static final String SECURITY_UNSUPPORTED_INJECT_ADMIN_USER_ENABLED = "plugins.security.unsupported.inject_user.admin.enabled";
    public static final String SECURITY_UNSUPPORTED_ALLOW_NOW_IN_DLS = "plugins.security.unsupported.allow_now_in_dls";
    public static final String SECURITY_UNSUPPORTED_RESTAPI_ALLOW_SECURITYCONFIG_MODIFICATION = "plugins.security.unsupported.restapi.allow_securityconfig_modification";
    public static final String SECURITY_UNSUPPORTED_LOAD_STATIC_RESOURCES = "plugins.security.unsupported.load_static_resources";
    public static final String SECURITY_UNSUPPORTED_ACCEPT_INVALID_CONFIG = "plugins.security.unsupported.accept_invalid_config";
    public static final String SECURITY_PROTECTED_INDICES_ENABLED_KEY = "plugins.security.protected_indices.enabled";
    public static final Boolean SECURITY_PROTECTED_INDICES_ENABLED_DEFAULT = false;
    public static final String SECURITY_PROTECTED_INDICES_KEY = "plugins.security.protected_indices.indices";
    public static final List<String> SECURITY_PROTECTED_INDICES_DEFAULT = Collections.emptyList();
    public static final String SECURITY_PROTECTED_INDICES_ROLES_KEY = "plugins.security.protected_indices.roles";
    public static final List<String> SECURITY_PROTECTED_INDICES_ROLES_DEFAULT = Collections.emptyList();
    public static final String OPENDISTRO_SECURITY_INJECTED_ROLES = "opendistro_security_injected_roles";
    public static final String OPENDISTRO_SECURITY_INJECTED_ROLES_HEADER = "opendistro_security_injected_roles_header";
    public static final String OPENDISTRO_SECURITY_INJECTED_ROLES_VALIDATION = "opendistro_security_injected_roles_validation";
    public static final String OPENDISTRO_SECURITY_INJECTED_ROLES_VALIDATION_HEADER = "opendistro_security_injected_roles_validation_header";
    public static final String SYSTEM_INDEX_PERMISSION = "system:admin/system_index";
    public static final String SECURITY_SYSTEM_INDICES_ENABLED_KEY = "plugins.security.system_indices.enabled";
    public static final Boolean SECURITY_SYSTEM_INDICES_ENABLED_DEFAULT = false;
    public static final String SECURITY_SYSTEM_INDICES_PERMISSIONS_ENABLED_KEY = "plugins.security.system_indices.permission.enabled";
    public static final Boolean SECURITY_SYSTEM_INDICES_PERMISSIONS_DEFAULT = false;
    public static final String SECURITY_SYSTEM_INDICES_KEY = "plugins.security.system_indices.indices";
    public static final List<String> SECURITY_SYSTEM_INDICES_DEFAULT = Collections.emptyList();
    public static final String SECURITY_MASKED_FIELDS_ALGORITHM_DEFAULT = "plugins.security.masked_fields.algorithm.default";
    public static final String TENANCY_PRIVATE_TENANT_NAME = "private";
    public static final String TENANCY_GLOBAL_TENANT_NAME = "global";
    public static final String TENANCY_GLOBAL_TENANT_DEFAULT_NAME = "";
    public static final String EXPERIMENTAL_SECURITY_CONFIGURATIONS_VERSIONS_ENABLED = "plugins.security.configurations_versions.enabled";
    public static final boolean EXPERIMENTAL_SECURITY_CONFIGURATIONS_VERSIONS_ENABLED_DEFAULT = false;
    public static final String SECURITY_CONFIG_VERSION_RETENTION_COUNT = "plugins.security.config_version.retention_count";
    public static final int SECURITY_CONFIG_VERSION_RETENTION_COUNT_DEFAULT = 10;
    public static final String USER_ATTRIBUTE_SERIALIZATION_ENABLED = "plugins.security.user_attribute_serialization.enabled";
    public static final boolean USER_ATTRIBUTE_SERIALIZATION_ENABLED_DEFAULT = false;
    public static final String EXTENSIONS_BWC_PLUGIN_MODE = "bwcPluginMode";
    public static final boolean EXTENSIONS_BWC_PLUGIN_MODE_DEFAULT = false;
    public static final String OPENSEARCH_INITIAL_ADMIN_PASSWORD = "OPENSEARCH_INITIAL_ADMIN_PASSWORD";
    public static final String OPENSEARCH_RESOURCE_SHARING_ENABLED = "plugins.security.experimental.resource_sharing.enabled";
    public static final boolean OPENSEARCH_RESOURCE_SHARING_ENABLED_DEFAULT = false;
    public static final String OPENSEARCH_RESOURCE_SHARING_PROTECTED_TYPES = "plugins.security.experimental.resource_sharing.protected_types";
    public static final List<String> OPENSEARCH_RESOURCE_SHARING_PROTECTED_TYPES_DEFAULT = List.of();

    public static Set<String> getSettingAsSet(Settings settings, String key, List<String> defaultList, boolean ignoreCaseForNone) {
        List list = settings.getAsList(key, defaultList);
        if (list.size() == 1 && "NONE".equals(ignoreCaseForNone ? ((String)list.get(0)).toUpperCase() : list.get(0))) {
            return Collections.emptySet();
        }
        return ImmutableSet.copyOf((Collection)list);
    }

    public static enum RolesMappingResolution {
        MAPPING_ONLY,
        BACKENDROLES_ONLY,
        BOTH;

    }
}

