/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.indices;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.opensearch.OpenSearchGenerationException;
import org.opensearch.action.IndicesRequest;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.client.TimedRequest;
import org.opensearch.core.common.bytes.BytesArray;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;

public class PutMappingRequest
extends TimedRequest
implements IndicesRequest,
ToXContentObject {
    private final String[] indices;
    private IndicesOptions indicesOptions = IndicesOptions.fromOptions((boolean)false, (boolean)false, (boolean)true, (boolean)true);
    private BytesReference source;
    private MediaType mediaType;

    public PutMappingRequest(String ... indices) {
        this.indices = indices;
    }

    public String[] indices() {
        return this.indices;
    }

    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public PutMappingRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    public BytesReference source() {
        return this.source;
    }

    public MediaType mediaType() {
        return this.mediaType;
    }

    public PutMappingRequest source(Map<String, ?> mappingSource) {
        try {
            XContentBuilder builder = MediaTypeRegistry.contentBuilder((MediaType)MediaTypeRegistry.getDefaultMediaType());
            builder.map(mappingSource);
            return this.source(builder);
        }
        catch (IOException e) {
            throw new OpenSearchGenerationException("Failed to generate [" + String.valueOf(mappingSource) + "]", (Throwable)e);
        }
    }

    public PutMappingRequest source(String mappingSource, MediaType mediaType) {
        this.source = new BytesArray(mappingSource);
        this.mediaType = mediaType;
        return this;
    }

    public PutMappingRequest source(XContentBuilder builder) {
        this.source = BytesReference.bytes((XContentBuilder)builder);
        this.mediaType = builder.contentType();
        return this;
    }

    public PutMappingRequest source(BytesReference source, MediaType mediaType) {
        this.source = source;
        this.mediaType = mediaType;
        return this;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.source != null) {
            try (StreamInput stream = this.source.streamInput();){
                builder.rawValue((InputStream)stream, this.mediaType);
            }
        } else {
            builder.startObject().endObject();
        }
        return builder;
    }
}

