/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlVisitor;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlSelectOperator
extends SqlOperator {
    public static final SqlSelectOperator INSTANCE = new SqlSelectOperator();

    private SqlSelectOperator() {
        super("SELECT", SqlKind.SELECT, 2, true, ReturnTypes.SCOPE, null, null);
    }

    @Override
    public SqlSyntax getSyntax() {
        return SqlSyntax.SPECIAL;
    }

    @Override
    public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
        assert (functionQualifier == null);
        return new SqlSelect(pos, (SqlNodeList)operands[0], Objects.requireNonNull((SqlNodeList)operands[1], "selectList"), operands[2], operands[3], (SqlNodeList)operands[4], operands[5], (SqlNodeList)operands[6], operands[7], (SqlNodeList)operands[8], operands[9], operands[10], (SqlNodeList)operands[11]);
    }

    @Deprecated
    public SqlSelect createCall(SqlNodeList keywordList, SqlNodeList selectList, SqlNode fromClause, SqlNode whereClause, SqlNodeList groupBy, SqlNode having, SqlNodeList windowDecls, SqlNode qualify, SqlNodeList orderBy, SqlNode offset, SqlNode fetch, SqlNodeList hints, SqlParserPos pos) {
        return new SqlSelect(pos, keywordList, selectList, fromClause, whereClause, groupBy, having, windowDecls, qualify, orderBy, offset, fetch, hints);
    }

    @Override
    public <R> void acceptCall(SqlVisitor<R> visitor, SqlCall call, boolean onlyExpressions, SqlBasicVisitor.ArgHandler<R> argHandler) {
        if (!onlyExpressions) {
            super.acceptCall(visitor, call, onlyExpressions, argHandler);
        }
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlNode where;
        SqlSelect select = (SqlSelect)call;
        SqlWriter.Frame selectFrame = writer.startList(SqlWriter.FrameTypeEnum.SELECT);
        writer.sep("SELECT");
        if (select.hasHints()) {
            writer.sep("/*+");
            ((SqlNodeList)Nullness.castNonNull((Object)select.hints)).unparse(writer, 0, 0);
            writer.print("*/");
            writer.newlineAndIndent();
        }
        for (int i = 0; i < select.keywordList.size(); ++i) {
            SqlNode keyword = select.keywordList.get(i);
            keyword.unparse(writer, 0, 0);
        }
        writer.topN(select.fetch, select.offset);
        SqlNodeList selectClause = select.selectList;
        writer.list(SqlWriter.FrameTypeEnum.SELECT_LIST, SqlWriter.COMMA, selectClause);
        if (select.from != null) {
            writer.sep("FROM");
            SqlWriter.Frame fromFrame = writer.startList(SqlWriter.FrameTypeEnum.FROM_LIST);
            select.from.unparse(writer, SqlJoin.COMMA_OPERATOR.getLeftPrec() - 1, SqlJoin.COMMA_OPERATOR.getRightPrec() - 1);
            writer.endList(fromFrame);
        }
        if ((where = select.where) != null) {
            writer.sep("WHERE");
            if (!writer.isAlwaysUseParentheses()) {
                SqlNode node = where;
                SqlBinaryOperator whereSep = SqlStdOperatorTable.AND;
                if (node instanceof SqlCall && node.getKind() == SqlKind.OR) {
                    whereSep = SqlStdOperatorTable.OR;
                }
                ArrayList<Object> list = new ArrayList<Object>(0);
                while (node.getKind() == whereSep.kind) {
                    assert (node instanceof SqlCall);
                    SqlCall call1 = (SqlCall)node;
                    list.add(0, call1.operand(1));
                    node = call1.operand(0);
                }
                list.add(0, node);
                writer.list(SqlWriter.FrameTypeEnum.WHERE_LIST, whereSep, new SqlNodeList(list, where.getParserPosition()));
            } else {
                where.unparse(writer, 0, 0);
            }
        }
        if (select.groupBy != null) {
            SqlNodeList groupBy;
            SqlNodeList sqlNodeList = groupBy = select.groupBy.isEmpty() ? SqlNodeList.SINGLETON_EMPTY : select.groupBy;
            if (groupBy.size() == 1 && groupBy.get(0) != null && groupBy.get(0).getKind() == SqlKind.GROUP_BY_DISTINCT) {
                writer.sep("GROUP BY DISTINCT");
                List<SqlNode> operandList = ((SqlCall)groupBy.get(0)).getOperandList();
                groupBy = new SqlNodeList(operandList, groupBy.getParserPosition());
            } else {
                writer.sep("GROUP BY");
            }
            writer.list(SqlWriter.FrameTypeEnum.GROUP_BY_LIST, SqlWriter.COMMA, groupBy);
        }
        if (select.having != null) {
            writer.sep("HAVING");
            select.having.unparse(writer, 0, 0);
        }
        if (!select.windowDecls.isEmpty()) {
            writer.sep("WINDOW");
            writer.list(SqlWriter.FrameTypeEnum.WINDOW_DECL_LIST, SqlWriter.COMMA, select.windowDecls);
        }
        if (select.qualify != null) {
            writer.sep("QUALIFY");
            select.qualify.unparse(writer, 0, 0);
        }
        if (select.orderBy != null && !select.orderBy.isEmpty()) {
            writer.sep("ORDER BY");
            writer.list(SqlWriter.FrameTypeEnum.ORDER_BY_LIST, SqlWriter.COMMA, select.orderBy);
        }
        writer.fetchOffset(select.fetch, select.offset);
        writer.endList(selectFrame);
    }

    @Override
    public boolean argumentMustBeScalar(int ordinal) {
        return ordinal == 3;
    }
}

