/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.dcn;

import java.lang.reflect.Executable;
import java.util.EventObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.dcn.QueryChangeDescription;
import oracle.jdbc.dcn.TableChangeDescription;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.CHANGE_NOTIFICATION})
public abstract class DatabaseChangeEvent
extends EventObject {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;

    protected DatabaseChangeEvent(Object source) {
        super(source);
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, DatabaseChangeEvent.class, $$$methodRef$$$0, null, source);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, DatabaseChangeEvent.class, $$$methodRef$$$0, null);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, DatabaseChangeEvent.class, $$$methodRef$$$0, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, DatabaseChangeEvent.class, $$$methodRef$$$0, null, throwable2);
            }
            throw throwable;
        }
    }

    public abstract EventType getEventType();

    public abstract AdditionalEventType getAdditionalEventType();

    public abstract TableChangeDescription[] getTableChangeDescription();

    public abstract QueryChangeDescription[] getQueryChangeDescription();

    public abstract String getConnectionInformation();

    public abstract String getDatabaseName();

    public abstract int getRegistrationId();

    public abstract long getRegId();

    public abstract byte[] getTransactionId();

    public abstract String getTransactionId(boolean var1);

    @Override
    public abstract String toString();

    static {
        try {
            $$$methodRef$$$0 = DatabaseChangeEvent.class.getDeclaredConstructor(Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }

    public static final class AdditionalEventType
    extends Enum<AdditionalEventType> {
        public static final /* enum */ AdditionalEventType NONE;
        public static final /* enum */ AdditionalEventType TIMEOUT;
        public static final /* enum */ AdditionalEventType GROUPING;
        private final int code;
        private static final /* synthetic */ AdditionalEventType[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;

        public static AdditionalEventType[] values() {
            return (AdditionalEventType[])$VALUES.clone();
        }

        public static AdditionalEventType valueOf(String name) {
            return Enum.valueOf(AdditionalEventType.class, name);
        }

        private AdditionalEventType(int _code) {
            this.code = _code;
        }

        public final int getCode() {
            return this.code;
        }

        public static final AdditionalEventType getEventType(int code) {
            if (code == TIMEOUT.getCode()) {
                return TIMEOUT;
            }
            if (code == GROUPING.getCode()) {
                return GROUPING;
            }
            return NONE;
        }

        static {
            try {
                $$$methodRef$$$4 = AdditionalEventType.class.getDeclaredConstructor(String.class, Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = AdditionalEventType.class.getDeclaredMethod("getEventType", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = AdditionalEventType.class.getDeclaredMethod("getCode", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = AdditionalEventType.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = AdditionalEventType.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            NONE = new AdditionalEventType(0);
            TIMEOUT = new AdditionalEventType(1);
            GROUPING = new AdditionalEventType(2);
            $VALUES = new AdditionalEventType[]{NONE, TIMEOUT, GROUPING};
        }
    }

    public static final class EventType
    extends Enum<EventType> {
        public static final /* enum */ EventType NONE;
        public static final /* enum */ EventType STARTUP;
        public static final /* enum */ EventType SHUTDOWN;
        public static final /* enum */ EventType SHUTDOWN_ANY;
        public static final /* enum */ EventType DEREG;
        public static final /* enum */ EventType OBJCHANGE;
        public static final /* enum */ EventType QUERYCHANGE;
        private final int code;
        private static final /* synthetic */ EventType[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;

        public static EventType[] values() {
            return (EventType[])$VALUES.clone();
        }

        public static EventType valueOf(String name) {
            return Enum.valueOf(EventType.class, name);
        }

        private EventType(int _code) {
            this.code = _code;
        }

        public final int getCode() {
            return this.code;
        }

        public static final EventType getEventType(int code) {
            if (code == STARTUP.getCode()) {
                return STARTUP;
            }
            if (code == SHUTDOWN.getCode()) {
                return SHUTDOWN;
            }
            if (code == SHUTDOWN_ANY.getCode()) {
                return SHUTDOWN_ANY;
            }
            if (code == DEREG.getCode()) {
                return DEREG;
            }
            if (code == OBJCHANGE.getCode()) {
                return OBJCHANGE;
            }
            if (code == QUERYCHANGE.getCode()) {
                return QUERYCHANGE;
            }
            return NONE;
        }

        static {
            try {
                $$$methodRef$$$4 = EventType.class.getDeclaredConstructor(String.class, Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = EventType.class.getDeclaredMethod("getEventType", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = EventType.class.getDeclaredMethod("getCode", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = EventType.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = EventType.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            NONE = new EventType(0);
            STARTUP = new EventType(1);
            SHUTDOWN = new EventType(2);
            SHUTDOWN_ANY = new EventType(3);
            DEREG = new EventType(5);
            OBJCHANGE = new EventType(6);
            QUERYCHANGE = new EventType(7);
            $VALUES = new EventType[]{NONE, STARTUP, SHUTDOWN, SHUTDOWN_ANY, DEREG, OBJCHANGE, QUERYCHANGE};
        }
    }
}

