/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.expression.GreaterLesserExpression;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.LiteralValue;
import org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import org.thymeleaf.util.EvaluationUtils;

public final class GreaterOrEqualToExpression
extends GreaterLesserExpression {
    private static final long serialVersionUID = 4318966518910979010L;
    private static final Logger logger = LoggerFactory.getLogger(GreaterOrEqualToExpression.class);

    public GreaterOrEqualToExpression(IStandardExpression left, IStandardExpression right) {
        super(left, right);
    }

    @Override
    public String getStringRepresentation() {
        return this.getStringRepresentation(">=");
    }

    static Object executeGreaterOrEqualTo(IExpressionContext context, GreaterOrEqualToExpression expression, StandardExpressionExecutionContext expContext) {
        Object leftValue = expression.getLeft().execute(context, expContext);
        Object rightValue = expression.getRight().execute(context, expContext);
        leftValue = LiteralValue.unwrap(leftValue);
        rightValue = LiteralValue.unwrap(rightValue);
        Boolean result = null;
        BigDecimal leftNumberValue = EvaluationUtils.evaluateAsNumber(leftValue);
        BigDecimal rightNumberValue = EvaluationUtils.evaluateAsNumber(rightValue);
        if (leftNumberValue != null && rightNumberValue != null) {
            result = leftNumberValue.compareTo(rightNumberValue) != -1;
        } else if (leftValue != null && rightValue != null && leftValue.getClass().equals(rightValue.getClass()) && Comparable.class.isAssignableFrom(leftValue.getClass())) {
            result = ((Comparable)leftValue).compareTo(rightValue) >= 0;
        } else {
            throw new TemplateProcessingException("Cannot execute GREATER OR EQUAL TO from Expression \"" + expression.getStringRepresentation() + "\". Left is \"" + leftValue + "\", right is \"" + rightValue + "\"");
        }
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Evaluating GREATER OR EQUAL TO expression: \"{}\". Left is \"{}\", right is \"{}\". Result is \"{}\"", new Object[]{TemplateEngine.threadIndex(), expression.getStringRepresentation(), leftValue, rightValue, result});
        }
        return result;
    }
}

