/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.objects.floats.PFloat;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.lib.PyObjectRichCompare;
import com.oracle.graal.python.lib.PyObjectRichCompareBoolNodeGen;
import com.oracle.graal.python.lib.RichCmpOp;
import com.oracle.graal.python.nodes.object.IsNode;
import com.oracle.graal.python.nodes.truffle.PythonIntegerTypes;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateInline
@GenerateCached(value=false)
@GenerateUncached
@TypeSystemReference(value=PythonIntegerTypes.class)
public abstract class PyObjectRichCompareBool
extends Node {
    public abstract boolean execute(Frame var1, Node var2, Object var3, Object var4, RichCmpOp var5);

    public final boolean executeEq(Frame frame, Node inliningTarget, Object a, Object b) {
        return this.execute(frame, inliningTarget, a, b, RichCmpOp.Py_EQ);
    }

    public final boolean executeCached(Frame frame, Object a, Object b, RichCmpOp op) {
        return this.execute(frame, null, a, b, op);
    }

    public static boolean executeUncached(Object a, Object b, RichCmpOp op) {
        return PyObjectRichCompareBool.getUncached().execute(null, null, a, b, op);
    }

    public static boolean executeEqUncached(Object a, Object b) {
        return PyObjectRichCompareBool.executeUncached(a, b, RichCmpOp.Py_EQ);
    }

    @Specialization
    static boolean doInts(int a, int b, RichCmpOp op) {
        return op.compare(a, b);
    }

    public static boolean compareWithFakeIdentity(RichCmpOp op, double a, double b) {
        return switch (op) {
            default -> throw new IncompatibleClassChangeError();
            case RichCmpOp.Py_LT -> {
                if (a < b) {
                    yield true;
                }
                yield false;
            }
            case RichCmpOp.Py_LE -> {
                if (a <= b) {
                    yield true;
                }
                yield false;
            }
            case RichCmpOp.Py_EQ, RichCmpOp.Py_NE -> {
                if (PFloat.areIdentical(a, b) == op.isEq()) {
                    yield true;
                }
                yield false;
            }
            case RichCmpOp.Py_GT -> {
                if (a > b) {
                    yield true;
                }
                yield false;
            }
            case RichCmpOp.Py_GE -> a >= b;
        };
    }

    @Specialization
    static boolean doDoubles(double a, double b, RichCmpOp op) {
        return PyObjectRichCompareBool.compareWithFakeIdentity(op, a, b);
    }

    @Specialization
    static boolean doLongs(long a, long b, RichCmpOp op) {
        return op.compare(a, b);
    }

    @Specialization(guards={"op.isEqOrNe()"})
    static boolean doStrings(TruffleString a, TruffleString b, RichCmpOp op, @Cached TruffleString.EqualNode equalNode) {
        return equalNode.execute((AbstractTruffleString)a, (AbstractTruffleString)b, PythonUtils.TS_ENCODING) == op.isEq();
    }

    @Fallback
    static boolean doIt(VirtualFrame frame, Object a, Object b, RichCmpOp op, @Cached IsNode isNode, @Cached(inline=false) PyObjectRichCompare.GenericRichCompare richCompare, @Cached PyObjectIsTrueNode isTrueNode) {
        if (op.isEqOrNe() && isNode.execute(a, b)) {
            return op.isEq();
        }
        Object result = richCompare.execute(frame, a, b, op);
        return isTrueNode.execute((Frame)frame, result);
    }

    public static PyObjectRichCompareBool getUncached() {
        return PyObjectRichCompareBoolNodeGen.getUncached();
    }

    @GenerateInline(value=false)
    @GenerateUncached
    public static abstract class CachedPyObjectRichCompareBool
    extends Node {
        public abstract boolean execute(Frame var1, Object var2, Object var3, RichCmpOp var4);

        public final boolean executeEq(Frame frame, Object a, Object b) {
            return this.execute(frame, a, b, RichCmpOp.Py_EQ);
        }

        @Specialization
        static boolean doIt(Frame frame, Object a, Object b, RichCmpOp op, @Bind Node inliningTarget, @Cached PyObjectRichCompareBool delegate) {
            return delegate.execute(frame, inliningTarget, a, b, op);
        }

        public static CachedPyObjectRichCompareBool create() {
            return PyObjectRichCompareBoolNodeGen.CachedPyObjectRichCompareBoolNodeGen.create();
        }

        public static CachedPyObjectRichCompareBool getUncached() {
            return PyObjectRichCompareBoolNodeGen.CachedPyObjectRichCompareBoolNodeGen.getUncached();
        }
    }
}

