/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal.generator.codegen;

import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.metadata.ParameterInfoArray;
import com.ibm.db2.cmx.runtime.internal.metadata.SqlParameterInfo;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.statement.JavaType;
import com.ibm.db2.cmx.tools.internal.generator.jdt.TypeHelper;
import com.ibm.db2.cmx.tools.internal.generator.metadata.BeanInformation;
import com.ibm.db2.cmx.tools.internal.generator.metadata.BeanPropertyInformation;
import com.ibm.db2.cmx.tools.internal.generator.metadata.ClassInfo;
import com.ibm.db2.cmx.tools.internal.generator.metadata.MetaDataInfo;
import com.ibm.db2.cmx.tools.internal.generator.metadata.MethodInfo;
import com.ibm.db2.cmx.tools.internal.generator.metadata.TypeInfo;
import java.util.List;

public class CallHandlerGenerator {
    private StringBuilder stringBuilder_;
    private ClassInfo classInfo_;

    public CallHandlerGenerator(ClassInfo classInfo, StringBuilder stringBuilder) {
        this.stringBuilder_ = stringBuilder;
        this.classInfo_ = classInfo;
    }

    public void generateCallHandler(MethodInfo methodInfo, TypeInfo typeInfo) {
        Object object;
        Object object2;
        ParameterInfoArray parameterInfoArray = methodInfo.getParameterInfoArray();
        int n2 = parameterInfoArray.getSqlParameterInfo().size();
        TypeInfo typeInfo2 = typeInfo.getBaseType();
        String string = TypeHelper.getTypeNameForGenerics(typeInfo2);
        String string2 = TypeHelper.getTypeNameForGenerics(typeInfo);
        if (string2.equals("void")) {
            string2 = "Object";
        }
        this.generateComments("  ");
        this.stringBuilder_.append("  public static class " + methodInfo.getCallHandlerClassNameForStatementDescriptor() + " extends BaseGeneratorCallHandler<" + string2 + ">\n");
        this.stringBuilder_.append("  {\n");
        this.generateComments("    ");
        this.stringBuilder_.append("    public " + string2 + " handleCall (CallableStatement cstmt, Object... parameters) throws java.sql.SQLException\n");
        this.stringBuilder_.append("    {\n");
        this.stringBuilder_.append("      StoredProcedureResult storedProcedureResult = getStoredProcedureResult (cstmt, " + methodInfo.getStatementDescriptorInstanceName() + ", parameters);\n");
        int n3 = 0;
        MetaDataInfo metaDataInfo = methodInfo.getParameterMetaDataInfo();
        if (metaDataInfo != null) {
            int n4;
            object2 = metaDataInfo.getSqlParmMode();
            object = metaDataInfo.getSqlTypeForUseInExecution();
            for (int i10 = 0; i10 < n2; ++i10) {
                n4 = object2[i10];
                if (n4 != 4 && n4 != 2) continue;
                ++n3;
            }
            if (n3 > 0) {
                List<TypeInfo> list = methodInfo.getParameterListWithoutHandlers();
                n4 = parameterInfoArray.getSqlParameterInfo().size();
                boolean[] blArray = new boolean[n4];
                boolean[] blArray2 = new boolean[n4];
                int n5 = 0;
                TypeInfo typeInfo3 = null;
                String string3 = null;
                block15: for (int i11 = 0; i11 < n2; ++i11) {
                    Object object3 = object2[i11];
                    if (object3 != 4 && object3 != 2) continue;
                    SqlParameterInfo sqlParameterInfo = parameterInfoArray.getSqlParameterInfo().get(i11);
                    SqlParameterInfo.ParameterEntryInfoInSQL parameterEntryInfoInSQL = sqlParameterInfo.getParameterEntryTypeInSQLString();
                    n5 = sqlParameterInfo.getParameterPositionZeroBased();
                    switch (parameterEntryInfoInSQL) {
                        case isNonPositionalParameterMarker__: {
                            continue block15;
                        }
                        case isPositionalParameterMarker__: {
                            continue block15;
                        }
                        case isHostVariable__: {
                            typeInfo3 = list.get(0);
                            string3 = sqlParameterInfo.getHostVariableName();
                            if (typeInfo3.getJavaType() == JavaType.MAP) {
                                this.generateCallHandlerMap(blArray, i11 + 1, 0, string3, object[i11]);
                                continue block15;
                            }
                            this.generateCallHandlerBean(methodInfo, blArray2, string3, i11 + 1, 0, typeInfo3, methodInfo.getInputBeanInfo().get(n5));
                            continue block15;
                        }
                        case isBean_OR_Map__: {
                            typeInfo3 = list.get(n5);
                            string3 = sqlParameterInfo.getHostVariableName();
                            if (typeInfo3.getJavaType() == JavaType.MAP) {
                                this.generateCallHandlerMap(blArray, i11 + 1, n5, string3, object[i11]);
                                continue block15;
                            }
                            this.generateCallHandlerBean(methodInfo, blArray2, string3, i11 + 1, n5, typeInfo3, methodInfo.getInputBeanInfo().get(n5));
                        }
                    }
                }
            }
        }
        if ((object2 = (Object)((Object)typeInfo.getJavaType())) == JavaType.STOREDPROCEDURERESULT) {
            this.stringBuilder_.append("      return storedProcedureResult;\n");
        } else if (object2 == JavaType.VOID) {
            this.stringBuilder_.append("      return null;\n");
        } else {
            this.stringBuilder_.append("      return storedProcedureResult.");
            switch (1.$SwitchMap$com$ibm$db2$cmx$runtime$statement$JavaType[((Enum)object2).ordinal()]) {
                case 1: {
                    this.stringBuilder_.append("getList (");
                    break;
                }
                case 2: {
                    this.stringBuilder_.append("getIterator (");
                    break;
                }
                case 3: {
                    this.stringBuilder_.append("getArray (");
                    break;
                }
                case 4: {
                    this.stringBuilder_.append("getIterator (");
                    break;
                }
                case 5: {
                    this.stringBuilder_.append("getIterator (");
                    break;
                }
                case 6: {
                    this.stringBuilder_.append("getResults (");
                    break;
                }
                default: {
                    throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_TYPE_NOTSUP", ((Enum)object2).name()), null, 10215, null, methodInfo);
                }
            }
            object = (Object)typeInfo2.getJavaType();
            if (object != JavaType.MAP && object != JavaType.JDBCRESULTSET) {
                this.stringBuilder_.append(string + ".class");
            }
            this.stringBuilder_.append(");\n");
        }
        this.stringBuilder_.append("    }\n");
        this.stringBuilder_.append("  }\n");
    }

    public static int numberOfOutParms(MethodInfo methodInfo) {
        ParameterInfoArray parameterInfoArray = methodInfo.getParameterInfoArray();
        int n2 = parameterInfoArray.getSqlParameterInfo().size();
        int n3 = 0;
        MetaDataInfo metaDataInfo = methodInfo.getParameterMetaDataInfo();
        if (metaDataInfo != null) {
            int[] nArray = metaDataInfo.getSqlParmMode();
            for (int i10 = 0; i10 < n2; ++i10) {
                int n4 = nArray[i10];
                if (n4 != 4 && n4 != 2) continue;
                ++n3;
            }
        }
        return n3;
    }

    private void generateCallHandlerMap(boolean[] blArray, int n2, int n3, String string, int n4) {
        if (!blArray[n3]) {
            this.stringBuilder_.append("      Map<String, Object> parmMap" + n3 + " = (Map<String, Object>) parameters[" + n3 + "];\n");
            blArray[n3] = true;
        }
        if (n4 == -100010) {
            this.stringBuilder_.append("      parmMap" + n3 + ".put (\"" + string + "\", this.getDBTimestamp (cstmt, " + n2 + "));\n");
        } else {
            this.stringBuilder_.append("      parmMap" + n3 + ".put (\"" + string + "\", cstmt.getObject (" + n2 + "));\n");
        }
    }

    private void generateCallHandlerBean(MethodInfo methodInfo, boolean[] blArray, String string, int n2, int n3, TypeInfo typeInfo, BeanInformation beanInformation) {
        beanInformation.checkBeanValidityAndThrowExceptionIfNeeded(methodInfo);
        BeanPropertyInformation beanPropertyInformation = beanInformation.getPropertyUsingCaseSensitiveName(string);
        if (beanPropertyInformation == null) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_INV_HOSTVAR", string), null, 11055, null, methodInfo);
        }
        String string2 = "bean" + n3;
        if (!blArray[n3]) {
            this.stringBuilder_.append("      " + typeInfo.getTypeName() + " " + string2 + " = (" + typeInfo.getTypeName() + ") parameters[" + n3 + "];\n");
            blArray[n3] = true;
        }
        this.generateCodeToSetBeanField(methodInfo, typeInfo, beanInformation, string2, string, n2, beanPropertyInformation);
    }

    private void generateCodeToSetBeanField(MethodInfo methodInfo, TypeInfo typeInfo, BeanInformation beanInformation, String string, String string2, int n2, BeanPropertyInformation beanPropertyInformation) {
        String string3;
        String string4 = null;
        boolean bl2 = false;
        TypeInfo typeInfo2 = beanPropertyInformation.getPropertyTypeInfo();
        String string5 = this.generateCstmtGetterMethodString(typeInfo2.getJavaType(), n2, methodInfo, typeInfo2.getFullyQualifiedName());
        string4 = beanPropertyInformation.getWriteMethod();
        if (string4 != null) {
            bl2 = true;
        } else {
            string4 = beanPropertyInformation.getField();
        }
        if (string4 == null && (string3 = beanInformation.getParameterWrapperForSetMethod()) != null) {
            this.stringBuilder_.append("      " + string + "." + string3 + "(\"" + string2 + "\", " + string5 + ");\n");
            return;
        }
        if (string4 == null) {
            return;
        }
        if (bl2) {
            this.stringBuilder_.append("      " + string + "." + string4 + "(" + string5 + ");\n");
        } else {
            this.stringBuilder_.append("      " + string + "." + string4 + " = " + string5 + ";\n");
        }
    }

    private String generateCstmtGetterMethodString(JavaType javaType, Object object, MethodInfo methodInfo, String string) {
        switch (javaType) {
            case BIGDECIMAL: {
                return "cstmt.getBigDecimal (" + object + ")";
            }
            case BLOB: {
                return "cstmt.getBlob (" + object + ")";
            }
            case SIMPLE_BOOLEAN: {
                return "cstmt.getBoolean (" + object + ")";
            }
            case BOOLEAN: {
                return "testNull (cstmt.getBoolean (" + object + "), cstmt.wasNull ())";
            }
            case SIMPLE_BYTE: {
                return "cstmt.getByte (" + object + ")";
            }
            case BYTE: {
                return "testNull (cstmt.getByte (" + object + "), cstmt.wasNull ())";
            }
            case SIMPLE_BYTE_ARRAY: 
            case BYTE_ARRAY: {
                return "cstmt.getBytes (" + object + ")";
            }
            case CLOB: {
                return "cstmt.getClob (" + object + ")";
            }
            case SIMPLE_DOUBLE: {
                return "cstmt.getDouble (" + object + ")";
            }
            case DOUBLE: {
                return "testNull (cstmt.getDouble (" + object + "), cstmt.wasNull ())";
            }
            case DATE: {
                return "cstmt.getDate (" + object + ")";
            }
            case TIME: {
                return "cstmt.getTime (" + object + ")";
            }
            case TIMESTAMP: {
                return "cstmt.getTimestamp (" + object + ")";
            }
            case TIMESTAMPTZ: {
                return "this.getDBTimestamp (cstmt, " + object + ")";
            }
            case SIMPLE_FLOAT: {
                return "cstmt.getFloat (" + object + ")";
            }
            case FLOAT: {
                return "testNull (cstmt.getFloat (" + object + "), cstmt.wasNull ())";
            }
            case SIMPLE_INTEGER: {
                return "cstmt.getInt (" + object + ")";
            }
            case INTEGER: {
                return "testNull (cstmt.getInt (" + object + "), cstmt.wasNull ())";
            }
            case SIMPLE_LONG: {
                return "cstmt.getLong (" + object + ")";
            }
            case LONG: {
                return "testNull (cstmt.getLong (" + object + "), cstmt.wasNull ())";
            }
            case SIMPLE_SHORT: {
                return "cstmt.getShort (" + object + ")";
            }
            case SHORT: {
                return "testNull (cstmt.getShort (" + object + "), cstmt.wasNull ())";
            }
            case STRING: {
                return "cstmt.getString (" + object + ")";
            }
            case INPUTSTREAM: {
                return "cstmt.getBinaryStream (" + object + ")";
            }
            case READER: {
                return "cstmt.getCharacterStream (" + object + ")";
            }
            case OBJECT: {
                return "cstmt.getObject (" + object + ")";
            }
            case SQLXML: 
            case ROWID: {
                return "(" + string + ")cstmt.getObject (" + object + ")";
            }
        }
        throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_TYPE_NOTSUP", javaType.name()), null, 10214, null, methodInfo);
    }

    private void generateComments(String string) {
        this.stringBuilder_.append(string + "/**\n");
        this.stringBuilder_.append(string + " * @generated\n");
        this.stringBuilder_.append(string + " */");
        this.stringBuilder_.append("\n");
    }
}

