/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.referencetype;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeClass;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.referencetype.PReferenceType;
import com.oracle.graal.python.builtins.objects.referencetype.ReferenceTypeBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.referencetype.ReferenceTypeBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.type.PythonAbstractClass;
import com.oracle.graal.python.builtins.objects.type.PythonClass;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotHashFun;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotRichCompare;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectRichCompare;
import com.oracle.graal.python.lib.RichCmpOp;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.HiddenAttr;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.lang.ref.ReferenceQueue;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PReferenceType})
public final class ReferenceTypeBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = ReferenceTypeBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ReferenceTypeBuiltinsFactory.getFactories();
    }

    @Builtin(name="__class_getitem__", minNumOfPositionalArgs=2, isClassmethod=true)
    @GenerateNodeFactory
    public static abstract class ClassGetItemNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object classGetItem(Object cls, Object key, @Bind PythonLanguage language) {
            return PFactory.createGenericAlias(language, cls, key);
        }
    }

    @Slot(value=Slot.SlotKind.tp_richcompare, isComplex=true)
    @GenerateNodeFactory
    public static abstract class RefTypeEqNode
    extends TpSlotRichCompare.RichCmpBuiltinNode {
        @Specialization(guards={"self.getObject() != null", "other.getObject() != null", "op.isEqOrNe()"})
        static Object withObjs(VirtualFrame frame, PReferenceType self, PReferenceType other, RichCmpOp op, @Bind Node inliningTarget, @Cached PyObjectRichCompare richCompareNode) {
            return richCompareNode.execute(frame, inliningTarget, self.getObject(), other.getObject(), op);
        }

        @Specialization(guards={"self.getObject() == null || other.getObject() == null", "op.isEqOrNe()"})
        static boolean withoutObjs(PReferenceType self, PReferenceType other, RichCmpOp op) {
            return self == other == op.isEq();
        }

        @Fallback
        static Object others(Object self, Object other, RichCmpOp op) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Slot(value=Slot.SlotKind.tp_repr, isComplex=true)
    @GenerateNodeFactory
    static abstract class RefTypeReprNode
    extends PythonUnaryBuiltinNode {
        RefTypeReprNode() {
        }

        @Specialization(guards={"self.getObject() == null"})
        static TruffleString repr(PReferenceType self, @Cached.Shared(value="formatter") @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            return simpleTruffleStringFormatNode.format("<weakref at %d; dead>", PythonAbstractObject.objectHashCode(self));
        }

        @Specialization(guards={"self.getObject() != null"})
        static TruffleString repr(VirtualFrame frame, PReferenceType self, @Bind Node inliningTarget, @Cached PyObjectLookupAttr lookup, @Cached GetClassNode getClassNode, @Cached TypeNodes.GetNameNode getNameNode, @Cached.Shared(value="formatter") @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            Object object = self.getObject();
            Object cls = getClassNode.execute(inliningTarget, object);
            TruffleString className = getNameNode.execute(inliningTarget, cls);
            Object name = lookup.execute((Frame)frame, inliningTarget, object, SpecialAttributeNames.T___NAME__);
            if (name == PNone.NO_VALUE) {
                return simpleTruffleStringFormatNode.format("<weakref at %d; to '%s' at %d>", PythonAbstractObject.objectHashCode(self), className, PythonAbstractObject.objectHashCode(object));
            }
            return simpleTruffleStringFormatNode.format("<weakref at %d; to '%s' at %d (%s)>", PythonAbstractObject.objectHashCode(self), className, PythonAbstractObject.objectHashCode(object), RefTypeReprNode.toStr(name));
        }

        @CompilerDirectives.TruffleBoundary
        private static String toStr(Object o) {
            return o.toString();
        }
    }

    @Slot(value=Slot.SlotKind.tp_hash, isComplex=true)
    @GenerateNodeFactory
    public static abstract class RefTypeHashNode
    extends TpSlotHashFun.HashBuiltinNode {
        static long HASH_UNSET = -1L;

        @Specialization(guards={"self.getHash() != HASH_UNSET"})
        static long getHash(PReferenceType self) {
            return self.getHash();
        }

        @Specialization(guards={"self.getHash() == HASH_UNSET"})
        static long computeHash(VirtualFrame frame, PReferenceType self, @Bind Node inliningTarget, @Cached InlinedConditionProfile referentProfile, @Cached PyObjectHashNode hashNode, @Cached PRaiseNode raiseNode) {
            Object referent = self.getObject();
            if (referentProfile.profile(inliningTarget, referent != null)) {
                long hash = hashNode.execute((Frame)frame, inliningTarget, referent);
                self.setHash(hash);
                return hash;
            }
            throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.WEAK_OBJ_GONE_AWAY);
        }

        @Fallback
        static long hashWrong(Object self, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.DESCRIPTOR_S_REQUIRES_S_OBJ_RECEIVED_P, "__hash__", "weakref", self);
        }
    }

    @Slot(value=Slot.SlotKind.tp_call, isComplex=true)
    @Slot.SlotSignature(minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class RefTypeCallNode
    extends PythonBuiltinNode {
        @Specialization
        public Object call(PReferenceType self) {
            return self.getPyObject();
        }
    }

    @Builtin(name="__callback__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class RefTypeCallbackPropertyNode
    extends PythonBuiltinNode {
        @Specialization
        public Object getCallback(PReferenceType self) {
            return self.getCallback();
        }
    }

    @Slot(value=Slot.SlotKind.tp_init, isComplex=true)
    @Slot.SlotSignature(name="ref", minNumOfPositionalArgs=2, maxNumOfPositionalArgs=3)
    @GenerateNodeFactory
    public static abstract class InitNode
    extends PythonTernaryBuiltinNode {
        @Specialization
        Object init(Object self, Object obj, Object callback) {
            return PNone.NONE;
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="ReferenceType", minNumOfPositionalArgs=2, maxNumOfPositionalArgs=3, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class ReferenceTypeNode
    extends PythonBuiltinNode {
        @Node.Child
        private CStructAccess.ReadI64Node getTpWeaklistoffsetNode;

        public abstract PReferenceType execute(Object var1, Object var2, Object var3);

        @Specialization(guards={"!isNativeObject(object)"})
        static PReferenceType refType(Object cls, Object object, PNone none, @Bind Node inliningTarget, @Cached.Exclusive @Cached GetClassNode getClassNode, @Cached HiddenAttr.ReadNode readWeaklistNode, @Cached HiddenAttr.WriteNode writeWeakListNode, @Bind PythonLanguage language, @Cached.Exclusive @Cached TypeNodes.GetInstanceShape getInstanceShape, @Cached.Exclusive @Cached HiddenAttr.ReadNode readQueueNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            Object obj = object;
            if (object instanceof PythonBuiltinClassType) {
                PythonBuiltinClassType tobj = (PythonBuiltinClassType)((Object)object);
                obj = PythonContext.get(inliningTarget).getCore().lookupType(tobj);
            }
            Object clazz = getClassNode.execute(inliningTarget, obj);
            boolean allowed = true;
            if (clazz instanceof PythonBuiltinClassType) {
                PythonBuiltinClassType type = (PythonBuiltinClassType)((Object)clazz);
                boolean bl = allowed = type.getWeaklistoffset() != 0;
            }
            if (!allowed) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.CANNOT_CREATE_WEAK_REFERENCE_TO, obj);
            }
            assert (obj instanceof PythonAbstractObject);
            Object wr = readWeaklistNode.execute(inliningTarget, (PythonAbstractObject)obj, HiddenAttr.WEAKLIST, null);
            if (wr != null) {
                return (PReferenceType)wr;
            }
            PReferenceType ref = PFactory.createReferenceType(language, cls, getInstanceShape.execute(cls), obj, null, ReferenceTypeNode.getWeakReferenceQueue(inliningTarget, readQueueNode));
            writeWeakListNode.execute(inliningTarget, (PythonAbstractObject)obj, HiddenAttr.WEAKLIST, ref);
            return ref;
        }

        @Specialization(guards={"!isNativeObject(object)", "!isPNone(callback)"})
        static PReferenceType refTypeWithCallback(Object cls, Object object, Object callback, @Bind Node inliningTarget, @Cached.Exclusive @Cached HiddenAttr.ReadNode readQueueNode, @Bind PythonLanguage language, @Cached.Shared @Cached TypeNodes.GetInstanceShape getInstanceShape) {
            return PFactory.createReferenceType(language, cls, getInstanceShape.execute(cls), object, callback, ReferenceTypeNode.getWeakReferenceQueue(inliningTarget, readQueueNode));
        }

        @Specialization
        PReferenceType refType(Object cls, PythonAbstractNativeObject pythonObject, Object callback, @Bind Node inliningTarget, @Cached.Exclusive @Cached GetClassNode getClassNode, @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile profile, @Cached TypeNodes.GetMroNode getMroNode, @Bind PythonLanguage language, @Cached.Shared @Cached TypeNodes.GetInstanceShape getInstanceShape, @Cached.Exclusive @Cached HiddenAttr.ReadNode readQueueNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            Object actualCallback = callback instanceof PNone ? null : callback;
            Object clazz = getClassNode.execute(inliningTarget, pythonObject);
            boolean allowed = false;
            if (profile.profileClass(inliningTarget, clazz, PythonBuiltinClassType.PythonClass)) {
                allowed = true;
            } else if (PGuards.isNativeClass(clazz) || clazz instanceof PythonClass && ((PythonClass)clazz).needsNativeAllocation()) {
                for (PythonAbstractClass base : getMroNode.execute(inliningTarget, clazz)) {
                    if (PGuards.isNativeClass(base)) {
                        long tpWeaklistoffset;
                        if (this.getTpWeaklistoffsetNode == null) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            this.getTpWeaklistoffsetNode = (CStructAccess.ReadI64Node)this.insert(CStructAccess.ReadI64Node.create());
                        }
                        if ((tpWeaklistoffset = this.getTpWeaklistoffsetNode.readFromObj((PythonNativeClass)base, CFields.PyTypeObject__tp_weaklistoffset)) == 0L) continue;
                        allowed = true;
                        break;
                    }
                    if (!(base instanceof PythonClass)) continue;
                    allowed = true;
                    break;
                }
            }
            if (allowed) {
                CApiTransitions.addNativeWeakRef(this.getContext(), pythonObject);
                return PFactory.createReferenceType(language, cls, getInstanceShape.execute(cls), pythonObject, actualCallback, ReferenceTypeNode.getWeakReferenceQueue(inliningTarget, readQueueNode));
            }
            throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.CANNOT_CREATE_WEAK_REFERENCE_TO, pythonObject);
        }

        @Fallback
        static PReferenceType refType(Object cls, Object object, Object callback, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.CANNOT_CREATE_WEAK_REFERENCE_TO, object);
        }

        private static ReferenceQueue<Object> getWeakReferenceQueue(Node inliningTarget, HiddenAttr.ReadNode readNode) {
            PythonContext context = PythonContext.get(inliningTarget);
            Object queueObject = readNode.execute(inliningTarget, context.lookupType(PythonBuiltinClassType.PReferenceType), HiddenAttr.WEAK_REF_QUEUE, null);
            if (queueObject != null) {
                return (ReferenceQueue)queueObject;
            }
            if (context.isCoreInitialized()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalStateException("the weak reference queue was modified!");
            }
            return null;
        }

        @NeverDefault
        public static ReferenceTypeNode create() {
            return ReferenceTypeBuiltinsFactory.ReferenceTypeNodeFactory.create(null);
        }
    }
}

