/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.SQLException;
import java.sql.Wrapper;
import java.util.Map;
import org.firebirdsql.encodings.EncodingDefinition;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.jdbc.FBConnection;
import org.firebirdsql.jdbc.field.JdbcTypeConverter;
import org.firebirdsql.util.FirebirdSupportInfo;

public abstract class AbstractFieldMetaData
implements Wrapper {
    private final RowDescriptor rowDescriptor;
    private final FBConnection connection;
    private Map<FieldKey, ExtendedFieldInfo> extendedInfo;

    protected AbstractFieldMetaData(RowDescriptor rowDescriptor, FBConnection connection) {
        assert (rowDescriptor != null) : "rowDescriptor is required";
        this.rowDescriptor = rowDescriptor;
        this.connection = connection;
    }

    @Override
    public final boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(this.getClass());
    }

    @Override
    public final <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw FbExceptionBuilder.forException(337248338).messageParameter((Object)(iface != null ? iface.getName() : "(null)")).toSQLException();
        }
        return iface.cast(this);
    }

    protected final RowDescriptor getRowDescriptor() {
        return this.rowDescriptor;
    }

    protected final int getFieldCount() {
        return this.rowDescriptor.getCount();
    }

    protected final FieldDescriptor getFieldDescriptor(int fieldIndex) {
        return this.rowDescriptor.getFieldDescriptor(fieldIndex - 1);
    }

    protected final boolean isSignedInternal(int field) {
        return switch (this.getFieldDescriptor(field).getType() & 0xFFFFFFFE) {
            case 480, 482, 496, 500, 530, 580, 32752, 32760, 32762 -> true;
            default -> false;
        };
    }

    protected final int getScaleInternal(int field) {
        return this.getFieldDescriptor(field).getScale() * -1;
    }

    protected final String getFieldClassName(int field) throws SQLException {
        return switch (this.getFieldType(field)) {
            case -1, 1, 12 -> "java.lang.String";
            case 4, 5 -> "java.lang.Integer";
            case 6, 8 -> "java.lang.Double";
            case 93 -> "java.sql.Timestamp";
            case 2004 -> "java.sql.Blob";
            case 2005 -> "java.sql.Clob";
            case -4, -3, -2 -> "[B";
            case 2003 -> "java.sql.Array";
            case -5 -> "java.lang.Long";
            case 92 -> "java.sql.Time";
            case 91 -> "java.sql.Date";
            case 2013 -> "java.time.OffsetTime";
            case 2014 -> "java.time.OffsetDateTime";
            case -6001, 2, 3 -> "java.math.BigDecimal";
            case 16 -> "java.lang.Boolean";
            case 0, 1111 -> "java.lang.Object";
            case -8 -> "java.sql.RowId";
            default -> throw new SQLException("Field %d has unknown JDBC SQL type: %s".formatted(field, this.getFieldType(field)), "HY105");
        };
    }

    protected final String getFieldTypeName(int field) {
        FieldDescriptor fieldDescriptor = this.getFieldDescriptor(field);
        int sqlType = fieldDescriptor.getType() & 0xFFFFFFFE;
        int sqlScale = fieldDescriptor.getScale();
        int sqlSubtype = fieldDescriptor.getSubType();
        int jdbcType = JdbcTypeConverter.fromFirebirdToJdbcType(sqlType, sqlSubtype, sqlScale);
        return JdbcTypeConverter.getTypeName(jdbcType, sqlType, sqlSubtype, sqlScale);
    }

    protected final int getFieldType(int field) {
        return JdbcTypeConverter.toJdbcType(this.getFieldDescriptor(field));
    }

    protected final int getPrecisionInternal(int field) throws SQLException {
        return switch (this.getFieldType(field)) {
            case 2, 3 -> {
                ExtendedFieldInfo fieldInfo = this.getExtFieldInfo(field);
                if (fieldInfo == null || fieldInfo.fieldPrecision == 0) {
                    yield this.estimateFixedPrecision(field);
                }
                yield fieldInfo.fieldPrecision;
            }
            case -6001 -> {
                switch (this.getFieldDescriptor(field).getType() & 0xFFFFFFFE) {
                    case 32760: {
                        yield 16;
                    }
                    case 32762: {
                        yield 34;
                    }
                }
                yield 0;
            }
            case 1, 12 -> {
                FieldDescriptor fieldDesc = this.getFieldDescriptor(field);
                EncodingDefinition encodingDefinition = fieldDesc.getEncodingFactory().getEncodingDefinitionByCharacterSetId(fieldDesc.getSubType());
                int charSetSize = encodingDefinition != null ? encodingDefinition.getMaxBytesPerChar() : 1;
                yield fieldDesc.getLength() / charSetSize;
            }
            case -3, -2 -> this.getFieldDescriptor(field).getLength();
            case 6 -> {
                if (this.connection == null || FirebirdSupportInfo.supportInfoFor(this.connection).supportsFloatBinaryPrecision()) {
                    yield 24;
                }
                yield 7;
            }
            case 8 -> {
                if (this.connection == null || FirebirdSupportInfo.supportInfoFor(this.connection).supportsFloatBinaryPrecision()) {
                    yield 53;
                }
                yield 15;
            }
            case 4 -> 10;
            case -5 -> 19;
            case 5 -> 5;
            case 91 -> 10;
            case 92 -> 8;
            case 93 -> 19;
            case 2014 -> 30;
            case 2013 -> 19;
            case 16 -> 1;
            default -> 0;
        };
    }

    protected final int estimateFixedPrecision(int fieldIndex) {
        return switch (this.getFieldDescriptor(fieldIndex).getType() & 0xFFFFFFFE) {
            case 500 -> 4;
            case 496 -> 9;
            case 480, 580 -> 18;
            case 32760 -> 16;
            case 32762 -> 34;
            case 32752 -> 38;
            default -> 0;
        };
    }

    protected final ExtendedFieldInfo getExtFieldInfo(int columnIndex) throws SQLException {
        if (this.extendedInfo == null) {
            this.extendedInfo = this.getExtendedFieldInfo(this.connection);
        }
        return this.extendedInfo.get(new FieldKey(this.getFieldDescriptor(columnIndex)));
    }

    protected abstract Map<FieldKey, ExtendedFieldInfo> getExtendedFieldInfo(FBConnection var1) throws SQLException;

    protected record ExtendedFieldInfo(FieldKey fieldKey, int fieldPrecision, boolean autoIncrement) {
        public ExtendedFieldInfo(String relationName, String fieldName, int precision, boolean autoIncrement) {
            this(new FieldKey(relationName, fieldName), precision, autoIncrement);
        }
    }

    protected record FieldKey(String relationName, String fieldName) {
        public FieldKey(FieldDescriptor fieldDescriptor) {
            this(fieldDescriptor.getOriginalTableName(), fieldDescriptor.getOriginalName());
        }
    }
}

