package YAML::API;
use strict;
use warnings;

our $VERSION = '1.23_002';

sub new {
    my ($class, %args) = @_;
    return bless { %args }, $class;
}

sub load {
    my ($self, $input) = @_;
    require YAML::Perl::Loader;
    require YAML::PP::Parser;
    require YAML::Perl::Reader;
    my $reader = YAML::Perl::Reader->new(
        input => $input
    );
    my $parser = YAML::PP::Parser->new(
        reader => $reader,
    );
    my $loader = YAML::Perl::Loader->new(
        parser => $parser,
    );
    return $loader->load;
}

1;
