# Generated by default/object.tt
package Paws::DMS::ReplicationTask;
  use Moose;
  has CdcStartPosition => (is => 'ro', isa => 'Str');
  has CdcStopPosition => (is => 'ro', isa => 'Str');
  has LastFailureMessage => (is => 'ro', isa => 'Str');
  has MigrationType => (is => 'ro', isa => 'Str');
  has RecoveryCheckpoint => (is => 'ro', isa => 'Str');
  has ReplicationInstanceArn => (is => 'ro', isa => 'Str');
  has ReplicationTaskArn => (is => 'ro', isa => 'Str');
  has ReplicationTaskCreationDate => (is => 'ro', isa => 'Str');
  has ReplicationTaskIdentifier => (is => 'ro', isa => 'Str');
  has ReplicationTaskSettings => (is => 'ro', isa => 'Str');
  has ReplicationTaskStartDate => (is => 'ro', isa => 'Str');
  has ReplicationTaskStats => (is => 'ro', isa => 'Paws::DMS::ReplicationTaskStats');
  has SourceEndpointArn => (is => 'ro', isa => 'Str');
  has Status => (is => 'ro', isa => 'Str');
  has StopReason => (is => 'ro', isa => 'Str');
  has TableMappings => (is => 'ro', isa => 'Str');
  has TargetEndpointArn => (is => 'ro', isa => 'Str');
  has TargetReplicationInstanceArn => (is => 'ro', isa => 'Str');
  has TaskData => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::DMS::ReplicationTask

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::DMS::ReplicationTask object:

  $service_obj->Method(Att1 => { CdcStartPosition => $value, ..., TaskData => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::DMS::ReplicationTask object:

  $result = $service_obj->Method(...);
  $result->Att1->CdcStartPosition

=head1 DESCRIPTION

Provides information that describes a replication task created by the
C<CreateReplicationTask> operation.

=head1 ATTRIBUTES


=head2 CdcStartPosition => Str

Indicates when you want a change data capture (CDC) operation to start.
Use either C<CdcStartPosition> or C<CdcStartTime> to specify when you
want the CDC operation to start. Specifying both values results in an
error.

The value can be in date, checkpoint, or LSN/SCN format.

Date Example: --cdc-start-position E<ldquo>2018-03-08T12:12:12E<rdquo>

Checkpoint Example: --cdc-start-position
"checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"

LSN Example: --cdc-start-position
E<ldquo>mysql-bin-changelog.000024:373E<rdquo>


=head2 CdcStopPosition => Str

Indicates when you want a change data capture (CDC) operation to stop.
The value can be either server time or commit time.

Server time example: --cdc-stop-position
E<ldquo>server_time:2018-02-09T12:12:12E<rdquo>

Commit time example: --cdc-stop-position E<ldquo>commit_time:
2018-02-09T12:12:12 E<ldquo>


=head2 LastFailureMessage => Str

The last error (failure) message generated for the replication task.


=head2 MigrationType => Str

The type of migration.


=head2 RecoveryCheckpoint => Str

Indicates the last checkpoint that occurred during a change data
capture (CDC) operation. You can provide this value to the
C<CdcStartPosition> parameter to start a CDC operation that begins at
that checkpoint.


=head2 ReplicationInstanceArn => Str

The ARN of the replication instance.


=head2 ReplicationTaskArn => Str

The Amazon Resource Name (ARN) of the replication task.


=head2 ReplicationTaskCreationDate => Str

The date the replication task was created.


=head2 ReplicationTaskIdentifier => Str

The user-assigned replication task identifier or name.

Constraints:

=over

=item *

Must contain 1-255 alphanumeric characters or hyphens.

=item *

First character must be a letter.

=item *

Cannot end with a hyphen or contain two consecutive hyphens.

=back



=head2 ReplicationTaskSettings => Str

The settings for the replication task.


=head2 ReplicationTaskStartDate => Str

The date the replication task is scheduled to start.


=head2 ReplicationTaskStats => L<Paws::DMS::ReplicationTaskStats>

The statistics for the task, including elapsed time, tables loaded, and
table errors.


=head2 SourceEndpointArn => Str

The Amazon Resource Name (ARN) that uniquely identifies the endpoint.


=head2 Status => Str

The status of the replication task. This response parameter can return
one of the following values:

=over

=item *

C<"moving"> E<ndash> The task is being moved in response to running the
C<MoveReplicationTask>
(https://docs.aws.amazon.com/dms/latest/APIReference/API_MoveReplicationTask.html)
operation.

=item *

C<"creating"> E<ndash> The task is being created in response to running
the C<CreateReplicationTask>
(https://docs.aws.amazon.com/dms/latest/APIReference/API_CreateReplicationTask.html)
operation.

=item *

C<"deleting"> E<ndash> The task is being deleted in response to running
the C<DeleteReplicationTask>
(https://docs.aws.amazon.com/dms/latest/APIReference/API_DeleteReplicationTask.html)
operation.

=item *

C<"failed"> E<ndash> The task failed to successfully complete the
database migration in response to running the C<StartReplicationTask>
(https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html)
operation.

=item *

C<"failed-move"> E<ndash> The task failed to move in response to
running the C<MoveReplicationTask>
(https://docs.aws.amazon.com/dms/latest/APIReference/API_MoveReplicationTask.html)
operation.

=item *

C<"modifying"> E<ndash> The task definition is being modified in
response to running the C<ModifyReplicationTask>
(https://docs.aws.amazon.com/dms/latest/APIReference/API_ModifyReplicationTask.html)
operation.

=item *

C<"ready"> E<ndash> The task is in a C<ready> state where it can
respond to other task operations, such as C<StartReplicationTask>
(https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html)
or C<DeleteReplicationTask>
(https://docs.aws.amazon.com/dms/latest/APIReference/API_DeleteReplicationTask.html).

=item *

C<"running"> E<ndash> The task is performing a database migration in
response to running the C<StartReplicationTask>
(https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html)
operation.

=item *

C<"starting"> E<ndash> The task is preparing to perform a database
migration in response to running the C<StartReplicationTask>
(https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html)
operation.

=item *

C<"stopped"> E<ndash> The task has stopped in response to running the
C<StopReplicationTask>
(https://docs.aws.amazon.com/dms/latest/APIReference/API_StopReplicationTask.html)
operation.

=item *

C<"stopping"> E<ndash> The task is preparing to stop in response to
running the C<StopReplicationTask>
(https://docs.aws.amazon.com/dms/latest/APIReference/API_StopReplicationTask.html)
operation.

=item *

C<"testing"> E<ndash> The database migration specified for this task is
being tested in response to running either the
C<StartReplicationTaskAssessmentRun>
(https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessmentRun.html)
or the C<StartReplicationTaskAssessment>
(https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessment.html)
operation.

C<StartReplicationTaskAssessmentRun>
(https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessmentRun.html)
is an improved premigration task assessment operation. The
C<StartReplicationTaskAssessment>
(https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessment.html)
operation assesses data type compatibility only between the source and
target database of a given migration task. In contrast,
C<StartReplicationTaskAssessmentRun>
(https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessmentRun.html)
enables you to specify a variety of premigration task assessments in
addition to data type compatibility. These assessments include ones for
the validity of primary key definitions and likely issues with database
migration performance, among others.

=back



=head2 StopReason => Str

The reason the replication task was stopped. This response parameter
can return one of the following values:

=over

=item *

C<"STOP_REASON_FULL_LOAD_COMPLETED"> E<ndash> Full-load migration
completed.

=item *

C<"STOP_REASON_CACHED_CHANGES_APPLIED"> E<ndash> Change data capture
(CDC) load completed.

=item *

C<"STOP_REASON_CACHED_CHANGES_NOT_APPLIED"> E<ndash> In a full-load and
CDC migration, the full load stopped as specified before starting the
CDC migration.

=item *

C<"STOP_REASON_SERVER_TIME"> E<ndash> The migration stopped at the
specified server time.

=back



=head2 TableMappings => Str

Table mappings specified in the task.


=head2 TargetEndpointArn => Str

The ARN that uniquely identifies the endpoint.


=head2 TargetReplicationInstanceArn => Str

The ARN of the replication instance to which this task is moved in
response to running the C<MoveReplicationTask>
(https://docs.aws.amazon.com/dms/latest/APIReference/API_MoveReplicationTask.html)
operation. Otherwise, this response parameter isn't a member of the
C<ReplicationTask> object.


=head2 TaskData => Str

Supplemental information that the task requires to migrate the data for
certain source and target endpoints. For more information, see
Specifying Supplemental Data for Task Settings
(https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html)
in the I<AWS Database Migration Service User Guide.>



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::DMS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

