package XAS::System;

our $VERSION = '0.01';

use Badger::Factory::Class
  version    => $VERSION,
  item       => 'module',
  path       => 'XAS::System XAS::Lib',
  modules => {
      logger      => 'XAS::System::Logger',
      alert       => 'XAS::System::Alert',
      email       => 'XAS::System::Email',
      environment => 'XAS::System::Environment',
      spool       => 'XAS::Lib::Spool',
  }
;

1;

__END__
  
=head1 NAME

XAS::System - A factory system for the XAS environment

=head1 SYNOPSIS

You can use this module in the following manner.

 use XAS::System;

 my $xas = XAS::System->module('environment');

 ... or ...

 my $xas = XAS:System->module('Environment');

Either of the above statements will load the XAS::System::Environment module.

=head1 DESCRIPTION

This module is a factory system for the XAS environment. It will load and
initialize modules on demand. The advantage is that you don't need to load
all your modules at the beginning of your program. You also don't need to
know where individual modules live. And this system can provide nice alias 
for long module names. This should lead to cleaner more readable programs.

=head1 METHODS

=head2 module

This method loads the named module and passes any parameters to that module.

=head1 SEE ALSO

 XAS::Base
 XAS::Class
 XAS::Constants
 XAS::Exception
 XAS::System
 XAS::Utils

 XAS::Apps::Base::Alerts
 XAS::Apps::Base::Collector
 XAS::Apps::Base::ExtractData
 XAS::Apps::Base::ExtractGlobals
 XAS::Apps::Base::RemoveData
 XAS::Apps::Database::Schema
 XAS::Apps::Templates::Daemon
 XAS::Apps::Templates::Generic
 XAS::Apps::Test::Echo::Client
 XAS::Apps::Test::Echo::Server
 XAS::Apps::Test::RPC::Client
 XAS::Apps::Test::RPC::Methods
 XAS::Apps::Test::RPC::Server

 XAS::Collector::Alert
 XAS::Collector::Base
 XAS::Collector::Connector
 XAS::Collector::Factory

 XAS::Lib::App
 XAS::Lib::App::Daemon
 XAS::Lib::App::Daemon::POE
 XAS::Lib::Connector
 XAS::Lib::Counter
 XAS::Lib::Daemon::Logger
 XAS::Lib::Daemon::Logging
 XAS::Lib::Gearman::Admin
 XAS::Lib::Gearman::Admin::Status
 XAS::Lib::Gearman::Admin::Worker
 XAS::Lib::Gearman::Client
 XAS::Lib::Gearman::Client::Status
 XAS::Lib::Gearman::Worker
 XAS::Lib::Net::Client
 XAS::LIb::Net::Server
 XAS::Lib::RPC::JSON::Client
 XAS::Lib::RPC::JSON::Server
 XAS::Lib::Session
 XAS::Lib::Spool

 XAS::Model::Database
 XAS::Model::Database::Alert
 XAS::Model::Database::Counter
 XAS::Model::DBM

 XAS::Monitor::Base
 XAS::Monitor::Database
 XAS::Monitor::Database::Alert

 XAS::Scheduler::Base

 XAS::System::Alert
 XAS::System::Email
 XAS::System::Environment
 XAS::System::Logger

=head1 AUTHOR

Kevin L. Esteb, E<lt>kevin@kesteb.usE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2012 by Kevin L. Esteb

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.8 or,
at your option, any later version of Perl 5 you may have available.

=cut
