/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.PatternOpImage;
import java.awt.Point;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;

final class ConstantOpImage
extends PatternOpImage {
    private static Raster makePattern(SampleModel sampleModel, Number[] numberArray) {
        WritableRaster writableRaster = RasterFactory.createWritableRaster(sampleModel, new Point(0, 0));
        int n = sampleModel.getWidth();
        int n2 = sampleModel.getHeight();
        int n3 = sampleModel.getTransferType();
        int n4 = sampleModel.getNumBands();
        switch (n3) {
            case 0: {
                int[] nArray = new int[n4];
                int n5 = 0;
                while (n5 < n4) {
                    nArray[n5] = numberArray[n5].intValue() & 0xFF;
                    ++n5;
                }
                int n6 = 0;
                while (n6 < n) {
                    writableRaster.setPixel(n6, 0, nArray);
                    ++n6;
                }
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                int[] nArray = new int[n4];
                int n7 = 0;
                while (n7 < n4) {
                    nArray[n7] = numberArray[n7].intValue();
                    ++n7;
                }
                int n8 = 0;
                while (n8 < n) {
                    writableRaster.setPixel(n8, 0, nArray);
                    ++n8;
                }
                break;
            }
            case 4: {
                float[] fArray = new float[n4];
                int n9 = 0;
                while (n9 < n4) {
                    fArray[n9] = numberArray[n9].floatValue();
                    ++n9;
                }
                int n10 = 0;
                while (n10 < n) {
                    writableRaster.setPixel(n10, 0, fArray);
                    ++n10;
                }
                break;
            }
            case 5: {
                double[] dArray = new double[n4];
                int n11 = 0;
                while (n11 < n4) {
                    dArray[n11] = numberArray[n11].doubleValue();
                    ++n11;
                }
                int n12 = 0;
                while (n12 < n) {
                    writableRaster.setPixel(n12, 0, dArray);
                    ++n12;
                }
                break;
            }
        }
        Object object = writableRaster.getDataElements(0, 0, n, 1, null);
        int n13 = 1;
        while (n13 < n2) {
            writableRaster.setDataElements(0, n13, n, 1, object);
            ++n13;
        }
        return writableRaster;
    }

    private static SampleModel makeSampleModel(int n, int n2, Number[] numberArray) {
        int n3;
        int n4 = numberArray.length;
        if (numberArray instanceof Byte[]) {
            n3 = 0;
        } else if (numberArray instanceof Short[]) {
            n3 = 1;
            Short[] shortArray = (Short[])numberArray;
            int n5 = 0;
            while (n5 < n4) {
                if (shortArray[n5] < 0) {
                    n3 = 2;
                    break;
                }
                ++n5;
            }
        } else {
            n3 = numberArray instanceof Integer[] ? 3 : (numberArray instanceof Float[] ? 4 : (numberArray instanceof Double[] ? 5 : 32));
        }
        return RasterFactory.createPixelInterleavedSampleModel(n3, n, n2, n4);
    }

    private static Raster patternHelper(int n, int n2, Number[] numberArray) {
        SampleModel sampleModel = ConstantOpImage.makeSampleModel(n, n2, numberArray);
        return ConstantOpImage.makePattern(sampleModel, numberArray);
    }

    private static ColorModel colorModelHelper(Number[] numberArray) {
        SampleModel sampleModel = ConstantOpImage.makeSampleModel(1, 1, numberArray);
        return PlanarImage.createColorModel(sampleModel);
    }

    public ConstantOpImage(int n, int n2, int n3, int n4, int n5, int n6, Number[] numberArray) {
        super(ConstantOpImage.patternHelper(n5, n6, numberArray), ConstantOpImage.colorModelHelper(numberArray), n, n2, n3, n4);
    }
}

