#include "uulib/gettime.h"

#ifdef USE_WIN32_NATIVE
int gettimeofday(struct timeval * tv, struct timezone * tz) {
  /* Note: SYSTEMTIME has 1ms resolution.
  *       FILETIME has 100nsec resolution.
  *       struct timeval has 1usec resolution.
  *       struct timespec has 1nsec resolution.
  *
  *  Note: some broken versions only have 8 trailing zero's, the correct epoch has 9 trailing zero's
  *  This magic number is the number of 100 nanosecond intervals since January 1, 1601 (UTC)
  *  until 00:00:00 January 1, 1970
  */
  static const U64 EPOCH = ((U64)116444736000000000ULL);

  FILETIME  file_time;
  U64       time;

#ifdef HAVE_PRECISE_SYSTIME
  GetSystemTimePreciseAsFileTime( &file_time );
#else
  GetSystemTimeAsFileTime( &file_time );
#endif
  time =  ((U64)file_time.dwLowDateTime )      ;
  time += ((U64)file_time.dwHighDateTime) << 32;

  tv->tv_sec  = (long)((time - EPOCH) / 10000000L);
  tv->tv_usec = (long)(((time - EPOCH) % 10000000L) / 10);
  return 0;
}
#endif /* USE_WIN32_NATIVE */

U64 gt_100ns64(void) {
  struct timeval  tv;
  U64             rv;

  gettimeofday(&tv, 0);
  rv = tv.tv_sec * 10000000 + tv.tv_usec * 10;
  return rv;
}

/* ex:set ts=2 sw=2 itab=spaces: */
