package OpenInteract::SQLInstall::Error;

# $Id: Error.pm,v 1.5 2002/05/02 12:45:32 lachoy Exp $

# Do installation of SQL for this package

use strict;
use vars qw( %HANDLERS );
use base qw( OpenInteract::SQLInstall );

my %files = (
    tables   => [ 'sys_error.sql' ],
    tables_oracle => [ 'sys_error_oracle.sql' ],
    tables_ib => [ 'sys_error_interbase.sql' ],
    data     => [ 'install_theme_prop.dat' ],
    security => [ 'install_security.dat' ],
);

%HANDLERS = (
    create_structure => { '_default_' => [ 'create_structure',
                                           { table_file_list => $files{tables} } ],
                          'Oracle'    => [ 'create_structure',
                                           { table_file_list => $files{tables_oracle} } ],
                          'InterBase' => [ 'create_structure',
                                           { table_file_list => $files{tables_ib} } ],
    },
    install_data     => { '_default_' => [ 'install_data',
                                           { data_file_list => $files{data} } ] },
    install_security => { '_default_' => [ 'install_data',
                                           { data_file_list => $files{security} } ] },
);

1;
