# Generated by default/object.tt
package Paws::DevOpsGuru::ListEventsFilters;
  use Moose;
  has DataSource => (is => 'ro', isa => 'Str');
  has EventClass => (is => 'ro', isa => 'Str');
  has EventSource => (is => 'ro', isa => 'Str');
  has EventTimeRange => (is => 'ro', isa => 'Paws::DevOpsGuru::EventTimeRange');
  has InsightId => (is => 'ro', isa => 'Str');
  has ResourceCollection => (is => 'ro', isa => 'Paws::DevOpsGuru::ResourceCollection');

1;

### main pod documentation begin ###

=head1 NAME

Paws::DevOpsGuru::ListEventsFilters

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::DevOpsGuru::ListEventsFilters object:

  $service_obj->Method(Att1 => { DataSource => $value, ..., ResourceCollection => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::DevOpsGuru::ListEventsFilters object:

  $result = $service_obj->Method(...);
  $result->Att1->DataSource

=head1 DESCRIPTION

Filters you can use to specify which events are returned when
C<ListEvents> is called.

=head1 ATTRIBUTES


=head2 DataSource => Str

The source, C<AWS_CLOUD_TRAIL> or C<AWS_CODE_DEPLOY>, of the events you
want returned.


=head2 EventClass => Str

The class of the events you want to filter for, such as an
infrastructure change, a deployment, or a schema change.


=head2 EventSource => Str

The AWS source that emitted the events you want to filter for.


=head2 EventTimeRange => L<Paws::DevOpsGuru::EventTimeRange>

A time range during which you want the filtered events to have
occurred.


=head2 InsightId => Str

An ID of an insight that is related to the events you want to filter
for.


=head2 ResourceCollection => L<Paws::DevOpsGuru::ResourceCollection>





=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::DevOpsGuru>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

