use Test::More;
use Coro;
use Coro::Localize;
 
our $scalar = "main loop";

my @threads; 
push @threads, async {
    corolocal $scalar = "thread 1";
    is( "1 - $scalar", "1 - thread 1", "scalar thread 1, test 1" );
    cede;
    is( "3 - $scalar", "3 - thread 1", "scalar thread 1, test 2" );
    cede;
    is( "5 - $scalar", "5 - thread 1", "scalar thread 1, test 3" );
};
 
push @threads, async {
    corolocal $scalar = "thread 2";
    is( "2 - $scalar", "2 - thread 2", "scalar thread 2, test 1" );
    cede;
    is( "4 - $scalar", "4 - thread 2", "scalar thread 2, test 2" );
    cede;
    is( "6 - $scalar", "6 - thread 2", "scalar thread 2, test 3" );
};

is( $scalar, "main loop", "scalar main, test 1" );
$_->join for @threads;
is( $scalar, "main loop", "scalar main, test 2" );

done_testing;
