#!/usr/bin/env perl

use strict;
use warnings;

use lib qw(..);

use Log::Log4perl qw(:easy);
Log::Log4perl->easy_init($DEBUG);

use Amazon::API::SQS;
use Data::Dumper;

my $logger = Log::Log4perl->get_logger();
$logger->debug("logging initialized\n");

my $sqs = Amazon::API::SQS->new(
  debug                      => 1,
  raise_serialization_errors => 1,
  logger                     => Log::Log4perl->get_logger(),
);

#my $attributes = [ { Name => 'VisibilityTimeout', Value => '100' } ];
#my $tags       = [ { Key  => 'Name',              Value => 'Foo' } ];

#my @sqs_attributes = Amazon::API::param_n( { Attribute => $attributes } );
#my @sqs_tags       = Amazon::API::param_n( { Tag       => $tags } );

my $rsp = $sqs->ListQueues;

print {*STDOUT} Dumper( [ 'response', $rsp ] );

1;

__END__
