package WebService::Mattermost::V4::API::Object::Role::Status;

# ABSTRACT: Adds a "status" field to an object.

use Moo::Role;
use Types::Standard qw(Maybe Str);

################################################################################

has status => (is => 'ro', isa => Maybe[Str], lazy => 1, builder => 1);

################################################################################

sub _build_status {
    my $self = shift;

    return $self->raw_data->{status};
}

################################################################################

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

WebService::Mattermost::V4::API::Object::Role::Status - Adds a "status" field to an object.

=head1 VERSION

version 0.29

=head1 DESCRIPTION

Attach an Status to a v4::Object object.

=head2 ATTRIBUTES

=over 4

=item C<status>

An item's status.

=back

=head1 AUTHOR

Mike Jones <mike@netsplit.org.uk>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2020 by Mike Jones.

This is free software, licensed under:

  The MIT (X11) License

=cut
