/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.views;

import java.util.ArrayList;
import javax.script.ScriptException;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import org.couchbase.mock.views.View;

public class DesignDocument {
    private String body;
    private String id;
    private ArrayList<View> views;

    public DesignDocument(String body) {
        try {
            this.body = body;
            JsonConfig cfg = new JsonConfig();
            cfg.clearJsonValueProcessors();
            JSONObject json = JSONObject.fromObject(body, cfg);
            this.id = json.getString("_id");
            this.views = new ArrayList();
            JSONObject viewsJson = json.getJSONObject("views");
            for (String viewName : viewsJson.keySet()) {
                JSONObject view = viewsJson.getJSONObject(viewName);
                String mapSrc = view.getString("map");
                String reduceSrc = null;
                try {
                    reduceSrc = view.getString("reduce");
                }
                catch (JSONException _) {
                    // empty catch block
                }
                this.views.add(new View(viewName, mapSrc, reduceSrc));
            }
        }
        catch (ScriptException ex) {
        }
        catch (JSONException ex) {
            throw new IllegalArgumentException("Incomplete document body", ex);
        }
    }

    public String getBody() {
        return this.body;
    }

    public String getId() {
        return this.id;
    }

    public ArrayList<View> getViews() {
        return this.views;
    }
}

