#
# Patch given file with DATA hunks and print to STDOUT.
#
#
# Patching types in unpack.c.
#
use strict;
use warnings;
use Text::Patch 'patch';

my $in = $ARGV[0];

my ($txt, $patch);
{
    local $/;
    open my $fh, '<', $in or die "open: $in: $!";
    $txt   = <$fh>;
    $patch = <DATA>;
}

#print $txt;
#print $patch;
#exit;

my $out = patch( $txt, $patch, STYLE => 'Unified' );

print $out;
exit 0;

__END__
diff -aurN usrcP/uuid/unpack.c usrcP.targ/uuid/unpack.c
--- usrcP/uuid/unpack.c	2023-12-02 17:58:13.893295000 +0200
+++ usrcP.targ/uuid/unpack.c	2023-12-02 15:28:51.790114000 +0200
@@ -35,11 +35,12 @@
 #include "config.h"
 #include <string.h>
 #include "uuidP.h"
+#include <uuid/uuid_types.h>
 
 void uuid_unpack(const uuid_t in, struct uuid *uu)
 {
-	const uint8_t	*ptr = in;
-	uint32_t		tmp;
+	const myuint8_t	*ptr = in;
+	myuint32_t		tmp;
 
 	tmp = *ptr++;
 	tmp = (tmp << 8) | *ptr++;
