use 5.006;
use strict;
use warnings;

# this test was generated with Dist::Zilla::Plugin::Test::Compile 2.058

use Test::More;

plan tests => 43 + ($ENV{AUTHOR_TESTING} ? 1 : 0);

my @module_files = (
    'XML/Grammar/Fiction.pm',
    'XML/Grammar/Fiction/App/FromProto.pm',
    'XML/Grammar/Fiction/App/ToDocBook.pm',
    'XML/Grammar/Fiction/App/ToHTML.pm',
    'XML/Grammar/Fiction/Err.pm',
    'XML/Grammar/Fiction/FromProto.pm',
    'XML/Grammar/Fiction/FromProto/Node.pm',
    'XML/Grammar/Fiction/FromProto/Node/Comment.pm',
    'XML/Grammar/Fiction/FromProto/Node/Description.pm',
    'XML/Grammar/Fiction/FromProto/Node/Element.pm',
    'XML/Grammar/Fiction/FromProto/Node/InnerDesc.pm',
    'XML/Grammar/Fiction/FromProto/Node/List.pm',
    'XML/Grammar/Fiction/FromProto/Node/Paragraph.pm',
    'XML/Grammar/Fiction/FromProto/Node/Saying.pm',
    'XML/Grammar/Fiction/FromProto/Node/Text.pm',
    'XML/Grammar/Fiction/FromProto/Node/WithContent.pm',
    'XML/Grammar/Fiction/FromProto/Parser.pm',
    'XML/Grammar/Fiction/FromProto/Parser/QnD.pm',
    'XML/Grammar/Fiction/Struct/Tag.pm',
    'XML/Grammar/Fiction/ToDocBook.pm',
    'XML/Grammar/Fiction/ToHTML.pm',
    'XML/Grammar/FictionBase/Event.pm',
    'XML/Grammar/FictionBase/FromProto/Parser/LineIterator.pm',
    'XML/Grammar/FictionBase/FromProto/Parser/XmlIterator.pm',
    'XML/Grammar/FictionBase/TagsTree2XML.pm',
    'XML/Grammar/FictionBase/XSLT/Converter.pm',
    'XML/Grammar/Screenplay.pm',
    'XML/Grammar/Screenplay/API/Concat.pm',
    'XML/Grammar/Screenplay/API/ImageListDoc.pm',
    'XML/Grammar/Screenplay/App/FromProto.pm',
    'XML/Grammar/Screenplay/App/ToDocBook.pm',
    'XML/Grammar/Screenplay/App/ToHTML.pm',
    'XML/Grammar/Screenplay/Base.pm',
    'XML/Grammar/Screenplay/FromProto.pm',
    'XML/Grammar/Screenplay/FromProto/API/ListImages.pm',
    'XML/Grammar/Screenplay/FromProto/Parser.pm',
    'XML/Grammar/Screenplay/FromProto/Parser/QnD.pm',
    'XML/Grammar/Screenplay/ToDocBook.pm',
    'XML/Grammar/Screenplay/ToHTML.pm',
    'XML/Grammar/Screenplay/ToTEI.pm'
);

my @scripts = (
    'bin/screenplay-text--list-images',
    'bin/screenplay-text-to-screenplay-xml',
    'bin/screenplay-text-to-xhtml5'
);

# no fake home requested

my @switches = (
    -d 'blib' ? '-Mblib' : '-Ilib',
);

use File::Spec;
use IPC::Open3;
use IO::Handle;

open my $stdin, '<', File::Spec->devnull or die "can't open devnull: $!";

my @warnings;
for my $lib (@module_files)
{
    # see L<perlfaq8/How can I capture STDERR from an external command?>
    my $stderr = IO::Handle->new;

    diag('Running: ', join(', ', map { my $str = $_; $str =~ s/'/\\'/g; q{'} . $str . q{'} }
            $^X, @switches, '-e', "require q[$lib]"))
        if $ENV{PERL_COMPILE_TEST_DEBUG};

    my $pid = open3($stdin, '>&STDERR', $stderr, $^X, @switches, '-e', "require q[$lib]");
    binmode $stderr, ':crlf' if $^O eq 'MSWin32';
    my @_warnings = <$stderr>;
    waitpid($pid, 0);
    is($?, 0, "$lib loaded ok");

    shift @_warnings if @_warnings and $_warnings[0] =~ /^Using .*\bblib/
        and not eval { +require blib; blib->VERSION('1.01') };

    if (@_warnings)
    {
        warn @_warnings;
        push @warnings, @_warnings;
    }
}

foreach my $file (@scripts)
{ SKIP: {
    open my $fh, '<', $file or warn("Unable to open $file: $!"), next;
    my $line = <$fh>;

    close $fh and skip("$file isn't perl", 1) unless $line =~ /^#!\s*(?:\S*perl\S*)((?:\s+-\w*)*)(?:\s*#.*)?$/;
    @switches = (@switches, split(' ', $1)) if $1;

    close $fh and skip("$file uses -T; not testable with PERL5LIB", 1)
        if grep { $_ eq '-T' } @switches and $ENV{PERL5LIB};

    my $stderr = IO::Handle->new;

    diag('Running: ', join(', ', map { my $str = $_; $str =~ s/'/\\'/g; q{'} . $str . q{'} }
            $^X, @switches, '-c', $file))
        if $ENV{PERL_COMPILE_TEST_DEBUG};

    my $pid = open3($stdin, '>&STDERR', $stderr, $^X, @switches, '-c', $file);
    binmode $stderr, ':crlf' if $^O eq 'MSWin32';
    my @_warnings = <$stderr>;
    waitpid($pid, 0);
    is($?, 0, "$file compiled ok");

    shift @_warnings if @_warnings and $_warnings[0] =~ /^Using .*\bblib/
        and not eval { +require blib; blib->VERSION('1.01') };

    # in older perls, -c output is simply the file portion of the path being tested
    if (@_warnings = grep { !/\bsyntax OK$/ }
        grep { chomp; $_ ne (File::Spec->splitpath($file))[2] } @_warnings)
    {
        warn @_warnings;
        push @warnings, @_warnings;
    }
} }



is(scalar(@warnings), 0, 'no warnings found')
    or diag 'got warnings: ', ( Test::More->can('explain') ? Test::More::explain(\@warnings) : join("\n", '', @warnings) ) if $ENV{AUTHOR_TESTING};


