use Module::Build::Compat;

my $build = Module::Build->new(
    module_name => 'Catalyst::View::ByCode',
    license => 'perl',
    dist_author => 'Wolfgang Kinkeldei <wki@cpan.org>',
    requires => {
        'perl'                  => '5.8.8',
        'Catalyst::Runtime'     => '5.80',
        'Test::Builder'         => '0.86',
        'Test::Builder::Tester' => '1.18',
        'Test::More'            => '0.86',
        'Test::Harness'         => '3.14',
        'Devel::Declare'        => '0.005007',
        'YAML'                  => '0.68',
        'MIME::Base64'          => '3.07',
        'HTML::Tagset'          => '3.10',
        'HTML::Entities'        => '1.35',
        'List::Util'            => '1.21',
        'UUID::Random'          => '0.04',
        'Moose' => 0,
        'MooseX::AttributeHelpers' => 0,
    },
    create_makefile_pl => 'traditional',
    create_readme => 1,
    # sign => 1,
);
$build->create_build_script;
Module::Build::Compat->create_makefile_pl(traditional => $build);
