/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SuppliedParameterReference;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.expr.instruct.LocalParam;
import net.sf.saxon.expr.instruct.LocalParamSetter;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLFunction;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.style.XSLVariableDeclaration;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

public class XSLParam
extends XSLVariableDeclaration {
    Expression conversion = null;

    protected boolean allowsValue() {
        return !(this.getParent() instanceof XSLFunction);
    }

    protected boolean allowsRequired() {
        return ((StyleElement)this.getParent()).mayContainParam("required");
    }

    protected boolean allowsTunnelAttribute() {
        return true;
    }

    public void validate(Declaration decl) throws XPathException {
        NodeInfo parent = this.getParent();
        this.global = parent instanceof XSLStylesheet;
        if (!(parent instanceof StyleElement) || !((StyleElement)parent).mayContainParam(null)) {
            this.compileError("xsl:param must be immediately within a template, function or stylesheet", "XTSE0010");
        }
        if (!this.global) {
            Object node;
            AxisIterator preceding = this.iterateAxis((byte)11);
            while ((node = preceding.next()) != null) {
                if (node instanceof XSLParam) {
                    if (!this.getVariableQName().equals(((XSLParam)node).getVariableQName())) continue;
                    this.compileError("The name of the parameter is not unique", "XTSE0580");
                    continue;
                }
                if (node instanceof StyleElement) {
                    this.compileError("xsl:param must not be preceded by other instructions", "XTSE0010");
                    continue;
                }
                if (Whitespace.isWhite(node.getStringValueCS())) continue;
                this.compileError("xsl:param must not be preceded by text", "XTSE0010");
            }
            SlotManager p = this.getContainingSlotManager();
            if (p == null) {
                this.compileError("Local variable must be declared within a template or function", "XTSE0010");
            } else {
                this.setSlotNumber(p.allocateSlotNumber(this.getVariableQName()));
            }
        }
        if (this.requiredParam) {
            if (this.select != null) {
                this.compileError("The select attribute should be omitted when required='yes'", "XTSE0010");
            }
            if (this.hasChildNodes()) {
                this.compileError("A parameter specifying required='yes' must have empty content", "XTSE0010");
            }
        }
        super.validate(decl);
    }

    public void compileDeclaration(Executable exec, Declaration decl) throws XPathException {
        if (!this.redundant) {
            int slot = this.getSlotNumber();
            if (this.requiredType != null) {
                SuppliedParameterReference pref = new SuppliedParameterReference(slot);
                pref.setLocationId(this.staticContext.getLocationMap().allocateLocationId(this.getSystemId(), this.getLineNumber()));
                RoleLocator role = new RoleLocator(8, this.getVariableDisplayName(), 0);
                role.setErrorCode("XTTE0590");
                this.conversion = TypeChecker.staticTypeCheck(pref, this.requiredType, false, role, this.makeExpressionVisitor());
            }
            GlobalParam binding = new GlobalParam();
            binding.setExecutable(this.getPreparedStylesheet());
            binding.setContainer(binding);
            if (this.isRequiredParam()) {
                this.getPreparedStylesheet().addRequiredParam(this.getVariableQName());
            }
            if (this.select != null) {
                this.select.setContainer(binding);
            }
            this.compiledVariable = binding;
            this.initializeBinding(exec, decl, binding);
            binding.setVariableQName(this.getVariableQName());
            binding.setSlotNumber(slot);
            binding.setRequiredType(this.getRequiredType());
            this.fixupBinding(binding);
            this.compiledVariable = binding;
        }
    }

    public Expression compile(Executable exec, Declaration decl) throws XPathException {
        if (this.redundant) {
            return null;
        }
        if (this.getParent() instanceof XSLFunction) {
            return null;
        }
        int slot = this.getSlotNumber();
        if (this.requiredType != null) {
            SuppliedParameterReference pref = new SuppliedParameterReference(slot);
            pref.setLocationId(this.staticContext.getLocationMap().allocateLocationId(this.getSystemId(), this.getLineNumber()));
            RoleLocator role = new RoleLocator(8, this.getVariableDisplayName(), 0);
            role.setErrorCode("XTTE0590");
            this.conversion = TypeChecker.staticTypeCheck(pref, this.requiredType, false, role, this.makeExpressionVisitor());
        }
        if (this.global) {
            throw new AssertionError((Object)"compiling global param as expression");
        }
        PrincipalStylesheetModule psm = this.getPrincipalStylesheetModule();
        LocalParam binding = new LocalParam();
        binding.setConversion(this.conversion);
        binding.setParameterId(psm.allocateUniqueParameterNumber(this.getVariableQName()));
        LocalParamSetter result = new LocalParamSetter(binding);
        this.initializeBinding(exec, decl, binding);
        binding.setVariableQName(this.getVariableQName());
        binding.setSlotNumber(slot);
        binding.setRequiredType(this.getRequiredType());
        this.fixupBinding(binding);
        this.compiledVariable = binding;
        return result;
    }

    public SequenceType getRequiredType() {
        if (this.requiredType != null) {
            return this.requiredType;
        }
        return SequenceType.ANY_SEQUENCE;
    }
}

