/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.AffineOpImage;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class AffineBicubicOpImage
extends AffineOpImage {
    public AffineBicubicOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, AffineTransform affineTransform, Interpolation interpolation, double[] dArray) {
        super(renderedImage, borderExtender, map, imageLayout, affineTransform, interpolation, dArray);
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = raster.getBounds();
        int n = rectangle2.x;
        int n2 = rectangle2.y;
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.byteLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
                break;
            }
            case 2: {
                this.shortLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
                break;
            }
            case 1: {
                this.ushortLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void byteLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        int n3 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor2.getNumBands();
        int n9 = rectangle.x;
        int n10 = rectangle.y;
        int n11 = rectangle.x + rectangle.width;
        int n12 = rectangle.y + rectangle.height;
        byte[] byArray3 = new byte[n8];
        int n13 = 0;
        while (n13 < n8) {
            byArray3[n13] = (byte)this.backgroundValues[n13];
            ++n13;
        }
        int n14 = n10;
        while (n14 < n12) {
            int n15 = n3;
            ((Point2D)float_).setLocation((double)n9 + 0.5, (double)n14 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            f5 = (float)((double)f5 - 0.5);
            f6 = (float)((double)f6 - 0.5);
            int n16 = (int)Math.floor(f5);
            int n17 = (int)Math.floor(f6);
            float f7 = f5 - (float)n16;
            float f8 = f6 - (float)n17;
            int n18 = (n16 - n) * n6;
            int n19 = (n17 - n2) * n7;
            int n20 = n18 + n19 - n7 - n6;
            int n21 = n20 + n6;
            int n22 = n21 + n6;
            int n23 = n22 + n6;
            int n24 = n20 + n7;
            int n25 = n24 + n6;
            int n26 = n25 + n6;
            int n27 = n26 + n6;
            int n28 = n24 + n7;
            int n29 = n28 + n6;
            int n30 = n29 + n6;
            int n31 = n30 + n6;
            int n32 = n28 + n7;
            int n33 = n32 + n6;
            int n34 = n33 + n6;
            int n35 = n34 + n6;
            int n36 = n9;
            while (n36 < n11) {
                int n37;
                if ((float)n16 >= f + 1.0f && (float)n16 < f3 - 2.0f && (float)n17 >= f2 + 1.0f && (float)n17 < f4 - 2.0f) {
                    n37 = 0;
                    while (n37 < n8) {
                        byte[] byArray4 = byArray2[n37];
                        int n38 = nArray2[n37];
                        int n39 = byArray4[n20 + n38] & 0xFF;
                        int n40 = byArray4[n21 + n38] & 0xFF;
                        int n41 = byArray4[n22 + n38] & 0xFF;
                        int n42 = byArray4[n23 + n38] & 0xFF;
                        int n43 = byArray4[n24 + n38] & 0xFF;
                        int n44 = byArray4[n25 + n38] & 0xFF;
                        int n45 = byArray4[n26 + n38] & 0xFF;
                        int n46 = byArray4[n27 + n38] & 0xFF;
                        int n47 = byArray4[n28 + n38] & 0xFF;
                        int n48 = byArray4[n29 + n38] & 0xFF;
                        int n49 = byArray4[n30 + n38] & 0xFF;
                        int n50 = byArray4[n31 + n38] & 0xFF;
                        int n51 = byArray4[n32 + n38] & 0xFF;
                        int n52 = byArray4[n33 + n38] & 0xFF;
                        int n53 = byArray4[n34 + n38] & 0xFF;
                        int n54 = byArray4[n35 + n38] & 0xFF;
                        float f9 = f7;
                        float f10 = f8;
                        float f11 = f9 * (1.0f - f9);
                        float f12 = f9 * (1.0f - f10);
                        float f13 = (float)n44 + (float)(n45 - n44) * f9;
                        float f14 = (float)n48 + (float)(n49 - n48) * f9;
                        float f15 = (float)n40 + (float)(n41 - n40) * f9;
                        float f16 = (float)n52 + (float)(n53 - n52) * f9;
                        float f17 = (float)(n41 + n39) + (float)(n42 + n40 - (n41 + n39)) * f9;
                        float f18 = (float)(n45 + n43) + (float)(n46 + n44 - (n45 + n43)) * f9;
                        float f19 = (float)(n49 + n47) + (float)(n50 + n48 - (n49 + n47)) * f9;
                        float f20 = (float)(n53 + n51) + (float)(n54 + n52 - (n53 + n51)) * f9;
                        f17 = f15 - f17 / 2.0f;
                        f18 = f13 - f18 / 2.0f;
                        f19 = f14 - f19 / 2.0f;
                        f20 = f16 - f20 / 2.0f;
                        float f21 = (f13 += f18 * f11) + ((f14 += f19 * f11) - f13) * f10;
                        float f22 = f14 + (f15 += f17 * f11) + ((f16 += f20 * f11) + f13 - (f14 + f15)) * f10;
                        int n55 = (f21 += (f22 = f21 - f22 / 2.0f) * f12) < 0.5f ? 0 : (f21 > 254.5f ? 255 : (int)(f21 + 0.5f));
                        byArray[n37][n15 + nArray[n37]] = (byte)(n55 & 0xFF);
                        ++n37;
                    }
                } else if (this.setBackground) {
                    n37 = 0;
                    while (n37 < n8) {
                        byArray[n37][n15 + nArray[n37]] = byArray3[n37];
                        ++n37;
                    }
                }
                if ((double)f7 < this.fracdx1) {
                    n16 += this.incx;
                    f7 = (float)((double)f7 + this.fracdx);
                } else {
                    n16 += this.incx1;
                    f7 = (float)((double)f7 - this.fracdx1);
                }
                if ((double)f8 < this.fracdy1) {
                    n17 += this.incy;
                    f8 = (float)((double)f8 + this.fracdy);
                } else {
                    n17 += this.incy1;
                    f8 = (float)((double)f8 - this.fracdy1);
                }
                n18 = (n16 - n) * n6;
                n19 = (n17 - n2) * n7;
                n20 = n18 + n19 - n7 - n6;
                n21 = n20 + n6;
                n22 = n21 + n6;
                n23 = n22 + n6;
                n24 = n20 + n7;
                n25 = n24 + n6;
                n26 = n25 + n6;
                n27 = n26 + n6;
                n28 = n24 + n7;
                n29 = n28 + n6;
                n30 = n29 + n6;
                n31 = n30 + n6;
                n32 = n28 + n7;
                n33 = n32 + n6;
                n34 = n33 + n6;
                n35 = n34 + n6;
                n15 += n4;
                ++n36;
            }
            n3 += n5;
            ++n14;
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        int n3 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        int[][] nArray = rasterAccessor2.getIntDataArrays();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        int[][] nArray3 = rasterAccessor.getIntDataArrays();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor2.getNumBands();
        int n9 = rectangle.x;
        int n10 = rectangle.y;
        int n11 = rectangle.x + rectangle.width;
        int n12 = rectangle.y + rectangle.height;
        int[] nArray5 = new int[n8];
        int n13 = 0;
        while (n13 < n8) {
            nArray5[n13] = (int)this.backgroundValues[n13];
            ++n13;
        }
        int n14 = n10;
        while (n14 < n12) {
            int n15 = n3;
            ((Point2D)float_).setLocation((double)n9 + 0.5, (double)n14 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            f5 = (float)((double)f5 - 0.5);
            f6 = (float)((double)f6 - 0.5);
            int n16 = (int)Math.floor(f5);
            int n17 = (int)Math.floor(f6);
            float f7 = f5 - (float)n16;
            float f8 = f6 - (float)n17;
            int n18 = (n16 - n) * n6;
            int n19 = (n17 - n2) * n7;
            int n20 = n18 + n19 - n7 - n6;
            int n21 = n20 + n6;
            int n22 = n21 + n6;
            int n23 = n22 + n6;
            int n24 = n20 + n7;
            int n25 = n24 + n6;
            int n26 = n25 + n6;
            int n27 = n26 + n6;
            int n28 = n24 + n7;
            int n29 = n28 + n6;
            int n30 = n29 + n6;
            int n31 = n30 + n6;
            int n32 = n28 + n7;
            int n33 = n32 + n6;
            int n34 = n33 + n6;
            int n35 = n34 + n6;
            int n36 = n9;
            while (n36 < n11) {
                int n37;
                if ((float)n16 >= f + 1.0f && (float)n16 < f3 - 2.0f && (float)n17 >= f2 + 1.0f && (float)n17 < f4 - 2.0f) {
                    n37 = 0;
                    while (n37 < n8) {
                        int[] nArray6 = nArray3[n37];
                        int n38 = nArray4[n37];
                        int n39 = nArray6[n20 + n38];
                        int n40 = nArray6[n21 + n38];
                        int n41 = nArray6[n22 + n38];
                        int n42 = nArray6[n23 + n38];
                        int n43 = nArray6[n24 + n38];
                        int n44 = nArray6[n25 + n38];
                        int n45 = nArray6[n26 + n38];
                        int n46 = nArray6[n27 + n38];
                        int n47 = nArray6[n28 + n38];
                        int n48 = nArray6[n29 + n38];
                        int n49 = nArray6[n30 + n38];
                        int n50 = nArray6[n31 + n38];
                        int n51 = nArray6[n32 + n38];
                        int n52 = nArray6[n33 + n38];
                        int n53 = nArray6[n34 + n38];
                        int n54 = nArray6[n35 + n38];
                        float f9 = f7;
                        float f10 = f8;
                        float f11 = f9 * (1.0f - f9);
                        float f12 = f9 * (1.0f - f10);
                        float f13 = (float)n44 + (float)(n45 - n44) * f9;
                        float f14 = (float)n48 + (float)(n49 - n48) * f9;
                        float f15 = (float)n40 + (float)(n41 - n40) * f9;
                        float f16 = (float)n52 + (float)(n53 - n52) * f9;
                        float f17 = (float)(n41 + n39) + (float)(n42 + n40 - (n41 + n39)) * f9;
                        float f18 = (float)(n45 + n43) + (float)(n46 + n44 - (n45 + n43)) * f9;
                        float f19 = (float)(n49 + n47) + (float)(n50 + n48 - (n49 + n47)) * f9;
                        float f20 = (float)(n53 + n51) + (float)(n54 + n52 - (n53 + n51)) * f9;
                        f17 = f15 - f17 / 2.0f;
                        f18 = f13 - f18 / 2.0f;
                        f19 = f14 - f19 / 2.0f;
                        f20 = f16 - f20 / 2.0f;
                        float f21 = (f13 += f18 * f11) + ((f14 += f19 * f11) - f13) * f10;
                        float f22 = f14 + (f15 += f17 * f11) + ((f16 += f20 * f11) + f13 - (f14 + f15)) * f10;
                        int n55 = (f21 += (f22 = f21 - f22 / 2.0f) * f12) < -2.1474836E9f ? Integer.MIN_VALUE : (f21 > 2.1474836E9f ? Integer.MAX_VALUE : ((double)f21 > 0.0 ? (int)(f21 + 0.5f) : (int)(f21 - 0.5f)));
                        nArray[n37][n15 + nArray2[n37]] = n55;
                        ++n37;
                    }
                } else if (this.setBackground) {
                    n37 = 0;
                    while (n37 < n8) {
                        nArray[n37][n15 + nArray2[n37]] = nArray5[n37];
                        ++n37;
                    }
                }
                if ((double)f7 < this.fracdx1) {
                    n16 += this.incx;
                    f7 = (float)((double)f7 + this.fracdx);
                } else {
                    n16 += this.incx1;
                    f7 = (float)((double)f7 - this.fracdx1);
                }
                if ((double)f8 < this.fracdy1) {
                    n17 += this.incy;
                    f8 = (float)((double)f8 + this.fracdy);
                } else {
                    n17 += this.incy1;
                    f8 = (float)((double)f8 - this.fracdy1);
                }
                n18 = (n16 - n) * n6;
                n19 = (n17 - n2) * n7;
                n20 = n18 + n19 - n7 - n6;
                n21 = n20 + n6;
                n22 = n21 + n6;
                n23 = n22 + n6;
                n24 = n20 + n7;
                n25 = n24 + n6;
                n26 = n25 + n6;
                n27 = n26 + n6;
                n28 = n24 + n7;
                n29 = n28 + n6;
                n30 = n29 + n6;
                n31 = n30 + n6;
                n32 = n28 + n7;
                n33 = n32 + n6;
                n34 = n33 + n6;
                n35 = n34 + n6;
                n15 += n4;
                ++n36;
            }
            n3 += n5;
            ++n14;
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        int n3 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor2.getNumBands();
        int n9 = rectangle.x;
        int n10 = rectangle.y;
        int n11 = rectangle.x + rectangle.width;
        int n12 = rectangle.y + rectangle.height;
        short[] sArray3 = new short[n8];
        int n13 = 0;
        while (n13 < n8) {
            sArray3[n13] = (short)this.backgroundValues[n13];
            ++n13;
        }
        int n14 = n10;
        while (n14 < n12) {
            int n15 = n3;
            ((Point2D)float_).setLocation((double)n9 + 0.5, (double)n14 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            f5 = (float)((double)f5 - 0.5);
            f6 = (float)((double)f6 - 0.5);
            int n16 = (int)Math.floor(f5);
            int n17 = (int)Math.floor(f6);
            float f7 = f5 - (float)n16;
            float f8 = f6 - (float)n17;
            int n18 = (n16 - n) * n6;
            int n19 = (n17 - n2) * n7;
            int n20 = n18 + n19 - n7 - n6;
            int n21 = n20 + n6;
            int n22 = n21 + n6;
            int n23 = n22 + n6;
            int n24 = n20 + n7;
            int n25 = n24 + n6;
            int n26 = n25 + n6;
            int n27 = n26 + n6;
            int n28 = n24 + n7;
            int n29 = n28 + n6;
            int n30 = n29 + n6;
            int n31 = n30 + n6;
            int n32 = n28 + n7;
            int n33 = n32 + n6;
            int n34 = n33 + n6;
            int n35 = n34 + n6;
            int n36 = n9;
            while (n36 < n11) {
                int n37;
                if ((float)n16 >= f + 1.0f && (float)n16 < f3 - 2.0f && (float)n17 >= f2 + 1.0f && (float)n17 < f4 - 2.0f) {
                    n37 = 0;
                    while (n37 < n8) {
                        short[] sArray4 = sArray2[n37];
                        int n38 = nArray2[n37];
                        short s = sArray4[n20 + n38];
                        short s2 = sArray4[n21 + n38];
                        short s3 = sArray4[n22 + n38];
                        short s4 = sArray4[n23 + n38];
                        short s5 = sArray4[n24 + n38];
                        short s6 = sArray4[n25 + n38];
                        short s7 = sArray4[n26 + n38];
                        short s8 = sArray4[n27 + n38];
                        short s9 = sArray4[n28 + n38];
                        short s10 = sArray4[n29 + n38];
                        short s11 = sArray4[n30 + n38];
                        short s12 = sArray4[n31 + n38];
                        short s13 = sArray4[n32 + n38];
                        short s14 = sArray4[n33 + n38];
                        short s15 = sArray4[n34 + n38];
                        short s16 = sArray4[n35 + n38];
                        float f9 = f7;
                        float f10 = f8;
                        float f11 = f9 * (1.0f - f9);
                        float f12 = f9 * (1.0f - f10);
                        float f13 = (float)s6 + (float)(s7 - s6) * f9;
                        float f14 = (float)s10 + (float)(s11 - s10) * f9;
                        float f15 = (float)s2 + (float)(s3 - s2) * f9;
                        float f16 = (float)s14 + (float)(s15 - s14) * f9;
                        float f17 = (float)(s3 + s) + (float)(s4 + s2 - (s3 + s)) * f9;
                        float f18 = (float)(s7 + s5) + (float)(s8 + s6 - (s7 + s5)) * f9;
                        float f19 = (float)(s11 + s9) + (float)(s12 + s10 - (s11 + s9)) * f9;
                        float f20 = (float)(s15 + s13) + (float)(s16 + s14 - (s15 + s13)) * f9;
                        f17 = f15 - f17 / 2.0f;
                        f18 = f13 - f18 / 2.0f;
                        f19 = f14 - f19 / 2.0f;
                        f20 = f16 - f20 / 2.0f;
                        float f21 = (f13 += f18 * f11) + ((f14 += f19 * f11) - f13) * f10;
                        float f22 = f14 + (f15 += f17 * f11) + ((f16 += f20 * f11) + f13 - (f14 + f15)) * f10;
                        int n39 = (f21 += (f22 = f21 - f22 / 2.0f) * f12) < -32768.0f ? Short.MIN_VALUE : (f21 > 32767.0f ? Short.MAX_VALUE : ((double)f21 > 0.0 ? (int)((short)(f21 + 0.5f)) : (int)((short)(f21 - 0.5f))));
                        sArray[n37][n15 + nArray[n37]] = n39;
                        ++n37;
                    }
                } else if (this.setBackground) {
                    n37 = 0;
                    while (n37 < n8) {
                        sArray[n37][n15 + nArray[n37]] = sArray3[n37];
                        ++n37;
                    }
                }
                if ((double)f7 < this.fracdx1) {
                    n16 += this.incx;
                    f7 = (float)((double)f7 + this.fracdx);
                } else {
                    n16 += this.incx1;
                    f7 = (float)((double)f7 - this.fracdx1);
                }
                if ((double)f8 < this.fracdy1) {
                    n17 += this.incy;
                    f8 = (float)((double)f8 + this.fracdy);
                } else {
                    n17 += this.incy1;
                    f8 = (float)((double)f8 - this.fracdy1);
                }
                n18 = (n16 - n) * n6;
                n19 = (n17 - n2) * n7;
                n20 = n18 + n19 - n7 - n6;
                n21 = n20 + n6;
                n22 = n21 + n6;
                n23 = n22 + n6;
                n24 = n20 + n7;
                n25 = n24 + n6;
                n26 = n25 + n6;
                n27 = n26 + n6;
                n28 = n24 + n7;
                n29 = n28 + n6;
                n30 = n29 + n6;
                n31 = n30 + n6;
                n32 = n28 + n7;
                n33 = n32 + n6;
                n34 = n33 + n6;
                n35 = n34 + n6;
                n15 += n4;
                ++n36;
            }
            n3 += n5;
            ++n14;
        }
    }

    private void ushortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        int n3 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor2.getNumBands();
        int n9 = rectangle.x;
        int n10 = rectangle.y;
        int n11 = rectangle.x + rectangle.width;
        int n12 = rectangle.y + rectangle.height;
        short[] sArray3 = new short[n8];
        int n13 = 0;
        while (n13 < n8) {
            sArray3[n13] = (short)this.backgroundValues[n13];
            ++n13;
        }
        int n14 = n10;
        while (n14 < n12) {
            int n15 = n3;
            ((Point2D)float_).setLocation((double)n9 + 0.5, (double)n14 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            f5 = (float)((double)f5 - 0.5);
            f6 = (float)((double)f6 - 0.5);
            int n16 = (int)Math.floor(f5);
            int n17 = (int)Math.floor(f6);
            float f7 = f5 - (float)n16;
            float f8 = f6 - (float)n17;
            int n18 = (n16 - n) * n6;
            int n19 = (n17 - n2) * n7;
            int n20 = n18 + n19 - n7 - n6;
            int n21 = n20 + n6;
            int n22 = n21 + n6;
            int n23 = n22 + n6;
            int n24 = n20 + n7;
            int n25 = n24 + n6;
            int n26 = n25 + n6;
            int n27 = n26 + n6;
            int n28 = n24 + n7;
            int n29 = n28 + n6;
            int n30 = n29 + n6;
            int n31 = n30 + n6;
            int n32 = n28 + n7;
            int n33 = n32 + n6;
            int n34 = n33 + n6;
            int n35 = n34 + n6;
            int n36 = n9;
            while (n36 < n11) {
                int n37;
                if ((float)n16 >= f + 1.0f && (float)n16 < f3 - 2.0f && (float)n17 >= f2 + 1.0f && (float)n17 < f4 - 2.0f) {
                    n37 = 0;
                    while (n37 < n8) {
                        short[] sArray4 = sArray2[n37];
                        int n38 = nArray2[n37];
                        int n39 = sArray4[n20 + n38] & 0xFFFF;
                        int n40 = sArray4[n21 + n38] & 0xFFFF;
                        int n41 = sArray4[n22 + n38] & 0xFFFF;
                        int n42 = sArray4[n23 + n38] & 0xFFFF;
                        int n43 = sArray4[n24 + n38] & 0xFFFF;
                        int n44 = sArray4[n25 + n38] & 0xFFFF;
                        int n45 = sArray4[n26 + n38] & 0xFFFF;
                        int n46 = sArray4[n27 + n38] & 0xFFFF;
                        int n47 = sArray4[n28 + n38] & 0xFFFF;
                        int n48 = sArray4[n29 + n38] & 0xFFFF;
                        int n49 = sArray4[n30 + n38] & 0xFFFF;
                        int n50 = sArray4[n31 + n38] & 0xFFFF;
                        int n51 = sArray4[n32 + n38] & 0xFFFF;
                        int n52 = sArray4[n33 + n38] & 0xFFFF;
                        int n53 = sArray4[n34 + n38] & 0xFFFF;
                        int n54 = sArray4[n35 + n38] & 0xFFFF;
                        float f9 = f7;
                        float f10 = f8;
                        float f11 = f9 * (1.0f - f9);
                        float f12 = f9 * (1.0f - f10);
                        float f13 = (float)n44 + (float)(n45 - n44) * f9;
                        float f14 = (float)n48 + (float)(n49 - n48) * f9;
                        float f15 = (float)n40 + (float)(n41 - n40) * f9;
                        float f16 = (float)n52 + (float)(n53 - n52) * f9;
                        float f17 = (float)(n41 + n39) + (float)(n42 + n40 - (n41 + n39)) * f9;
                        float f18 = (float)(n45 + n43) + (float)(n46 + n44 - (n45 + n43)) * f9;
                        float f19 = (float)(n49 + n47) + (float)(n50 + n48 - (n49 + n47)) * f9;
                        float f20 = (float)(n53 + n51) + (float)(n54 + n52 - (n53 + n51)) * f9;
                        f17 = f15 - f17 / 2.0f;
                        f18 = f13 - f18 / 2.0f;
                        f19 = f14 - f19 / 2.0f;
                        f20 = f16 - f20 / 2.0f;
                        float f21 = (f13 += f18 * f11) + ((f14 += f19 * f11) - f13) * f10;
                        float f22 = f14 + (f15 += f17 * f11) + ((f16 += f20 * f11) + f13 - (f14 + f15)) * f10;
                        int n55 = (double)(f21 += (f22 = f21 - f22 / 2.0f) * f12) < 0.0 ? 0 : (f21 > 65535.0f ? 65535 : (int)(f21 + 0.5f));
                        sArray[n37][n15 + nArray[n37]] = (short)(n55 & 0xFFFF);
                        ++n37;
                    }
                } else if (this.setBackground) {
                    n37 = 0;
                    while (n37 < n8) {
                        sArray[n37][n15 + nArray[n37]] = sArray3[n37];
                        ++n37;
                    }
                }
                if ((double)f7 < this.fracdx1) {
                    n16 += this.incx;
                    f7 = (float)((double)f7 + this.fracdx);
                } else {
                    n16 += this.incx1;
                    f7 = (float)((double)f7 - this.fracdx1);
                }
                if ((double)f8 < this.fracdy1) {
                    n17 += this.incy;
                    f8 = (float)((double)f8 + this.fracdy);
                } else {
                    n17 += this.incy1;
                    f8 = (float)((double)f8 - this.fracdy1);
                }
                n18 = (n16 - n) * n6;
                n19 = (n17 - n2) * n7;
                n20 = n18 + n19 - n7 - n6;
                n21 = n20 + n6;
                n22 = n21 + n6;
                n23 = n22 + n6;
                n24 = n20 + n7;
                n25 = n24 + n6;
                n26 = n25 + n6;
                n27 = n26 + n6;
                n28 = n24 + n7;
                n29 = n28 + n6;
                n30 = n29 + n6;
                n31 = n30 + n6;
                n32 = n28 + n7;
                n33 = n32 + n6;
                n34 = n33 + n6;
                n35 = n34 + n6;
                n15 += n4;
                ++n36;
            }
            n3 += n5;
            ++n14;
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        int n3 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        float[][] fArray = rasterAccessor2.getFloatDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        float[][] fArray2 = rasterAccessor.getFloatDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor2.getNumBands();
        int n9 = rectangle.x;
        int n10 = rectangle.y;
        int n11 = rectangle.x + rectangle.width;
        int n12 = rectangle.y + rectangle.height;
        float[] fArray3 = new float[n8];
        int n13 = 0;
        while (n13 < n8) {
            fArray3[n13] = (float)this.backgroundValues[n13];
            ++n13;
        }
        int n14 = n10;
        while (n14 < n12) {
            int n15 = n3;
            ((Point2D)float_).setLocation((double)n9 + 0.5, (double)n14 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            f5 = (float)((double)f5 - 0.5);
            f6 = (float)((double)f6 - 0.5);
            int n16 = (int)Math.floor(f5);
            int n17 = (int)Math.floor(f6);
            float f7 = f5 - (float)n16;
            float f8 = f6 - (float)n17;
            int n18 = (n16 - n) * n6;
            int n19 = (n17 - n2) * n7;
            int n20 = n18 + n19 - n7 - n6;
            int n21 = n20 + n6;
            int n22 = n21 + n6;
            int n23 = n22 + n6;
            int n24 = n20 + n7;
            int n25 = n24 + n6;
            int n26 = n25 + n6;
            int n27 = n26 + n6;
            int n28 = n24 + n7;
            int n29 = n28 + n6;
            int n30 = n29 + n6;
            int n31 = n30 + n6;
            int n32 = n28 + n7;
            int n33 = n32 + n6;
            int n34 = n33 + n6;
            int n35 = n34 + n6;
            int n36 = n9;
            while (n36 < n11) {
                int n37;
                if ((float)n16 >= f + 1.0f && (float)n16 < f3 - 2.0f && (float)n17 >= f2 + 1.0f && (float)n17 < f4 - 2.0f) {
                    n37 = 0;
                    while (n37 < n8) {
                        float[] fArray4 = fArray2[n37];
                        int n38 = nArray2[n37];
                        float f9 = fArray4[n20 + n38];
                        float f10 = fArray4[n21 + n38];
                        float f11 = fArray4[n22 + n38];
                        float f12 = fArray4[n23 + n38];
                        float f13 = fArray4[n24 + n38];
                        float f14 = fArray4[n25 + n38];
                        float f15 = fArray4[n26 + n38];
                        float f16 = fArray4[n27 + n38];
                        float f17 = fArray4[n28 + n38];
                        float f18 = fArray4[n29 + n38];
                        float f19 = fArray4[n30 + n38];
                        float f20 = fArray4[n31 + n38];
                        float f21 = fArray4[n32 + n38];
                        float f22 = fArray4[n33 + n38];
                        float f23 = fArray4[n34 + n38];
                        float f24 = fArray4[n35 + n38];
                        float f25 = f7;
                        float f26 = f8;
                        float f27 = f25 * (1.0f - f25);
                        float f28 = f25 * (1.0f - f26);
                        float f29 = f14 + (f15 - f14) * f25;
                        float f30 = f18 + (f19 - f18) * f25;
                        float f31 = f10 + (f11 - f10) * f25;
                        float f32 = f22 + (f23 - f22) * f25;
                        float f33 = f11 + f9 + (f12 + f10 - (f11 + f9)) * f25;
                        float f34 = f15 + f13 + (f16 + f14 - (f15 + f13)) * f25;
                        float f35 = f19 + f17 + (f20 + f18 - (f19 + f17)) * f25;
                        float f36 = f23 + f21 + (f24 + f22 - (f23 + f21)) * f25;
                        f33 = f31 - f33 / 2.0f;
                        f34 = f29 - f34 / 2.0f;
                        f35 = f30 - f35 / 2.0f;
                        f36 = f32 - f36 / 2.0f;
                        float f37 = (f29 += f34 * f27) + ((f30 += f35 * f27) - f29) * f26;
                        float f38 = f30 + (f31 += f33 * f27) + ((f32 += f36 * f27) + f29 - (f30 + f31)) * f26;
                        f38 = f37 - f38 / 2.0f;
                        fArray[n37][n15 + nArray[n37]] = f37 += f38 * f28;
                        ++n37;
                    }
                } else if (this.setBackground) {
                    n37 = 0;
                    while (n37 < n8) {
                        fArray[n37][n15 + nArray[n37]] = fArray3[n37];
                        ++n37;
                    }
                }
                if ((double)f7 < this.fracdx1) {
                    n16 += this.incx;
                    f7 = (float)((double)f7 + this.fracdx);
                } else {
                    n16 += this.incx1;
                    f7 = (float)((double)f7 - this.fracdx1);
                }
                if ((double)f8 < this.fracdy1) {
                    n17 += this.incy;
                    f8 = (float)((double)f8 + this.fracdy);
                } else {
                    n17 += this.incy1;
                    f8 = (float)((double)f8 - this.fracdy1);
                }
                n18 = (n16 - n) * n6;
                n19 = (n17 - n2) * n7;
                n20 = n18 + n19 - n7 - n6;
                n21 = n20 + n6;
                n22 = n21 + n6;
                n23 = n22 + n6;
                n24 = n20 + n7;
                n25 = n24 + n6;
                n26 = n25 + n6;
                n27 = n26 + n6;
                n28 = n24 + n7;
                n29 = n28 + n6;
                n30 = n29 + n6;
                n31 = n30 + n6;
                n32 = n28 + n7;
                n33 = n32 + n6;
                n34 = n33 + n6;
                n35 = n34 + n6;
                n15 += n4;
                ++n36;
            }
            n3 += n5;
            ++n14;
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        int n3 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor2.getNumBands();
        int n9 = rectangle.x;
        int n10 = rectangle.y;
        int n11 = rectangle.x + rectangle.width;
        int n12 = rectangle.y + rectangle.height;
        int n13 = n10;
        while (n13 < n12) {
            int n14 = n3;
            ((Point2D)float_).setLocation((double)n9 + 0.5, (double)n13 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            double d = ((Point2D)float_2).getX();
            double d2 = ((Point2D)float_2).getY();
            int n15 = (int)Math.floor(d -= 0.5);
            int n16 = (int)Math.floor(d2 -= 0.5);
            double d3 = d - (double)n15;
            double d4 = d2 - (double)n16;
            int n17 = (n15 - n) * n6;
            int n18 = (n16 - n2) * n7;
            int n19 = n17 + n18 - n7 - n6;
            int n20 = n19 + n6;
            int n21 = n20 + n6;
            int n22 = n21 + n6;
            int n23 = n19 + n7;
            int n24 = n23 + n6;
            int n25 = n24 + n6;
            int n26 = n25 + n6;
            int n27 = n23 + n7;
            int n28 = n27 + n6;
            int n29 = n28 + n6;
            int n30 = n29 + n6;
            int n31 = n27 + n7;
            int n32 = n31 + n6;
            int n33 = n32 + n6;
            int n34 = n33 + n6;
            int n35 = n9;
            while (n35 < n11) {
                int n36;
                if ((float)n15 >= f + 1.0f && (float)n15 < f3 - 2.0f && (float)n16 >= f2 + 1.0f && (float)n16 < f4 - 2.0f) {
                    n36 = 0;
                    while (n36 < n8) {
                        double[] dArray3 = dArray2[n36];
                        int n37 = nArray2[n36];
                        double d5 = dArray3[n19 + n37];
                        double d6 = dArray3[n20 + n37];
                        double d7 = dArray3[n21 + n37];
                        double d8 = dArray3[n22 + n37];
                        double d9 = dArray3[n23 + n37];
                        double d10 = dArray3[n24 + n37];
                        double d11 = dArray3[n25 + n37];
                        double d12 = dArray3[n26 + n37];
                        double d13 = dArray3[n27 + n37];
                        double d14 = dArray3[n28 + n37];
                        double d15 = dArray3[n29 + n37];
                        double d16 = dArray3[n30 + n37];
                        double d17 = dArray3[n31 + n37];
                        double d18 = dArray3[n32 + n37];
                        double d19 = dArray3[n33 + n37];
                        double d20 = dArray3[n34 + n37];
                        double d21 = d3;
                        double d22 = d4;
                        double d23 = d21 * (1.0 - d21);
                        double d24 = d21 * (1.0 - d22);
                        double d25 = d10 + (d11 - d10) * d21;
                        double d26 = d14 + (d15 - d14) * d21;
                        double d27 = d6 + (d7 - d6) * d21;
                        double d28 = d18 + (d19 - d18) * d21;
                        double d29 = d7 + d5 + (d8 + d6 - (d7 + d5)) * d21;
                        double d30 = d11 + d9 + (d12 + d10 - (d11 + d9)) * d21;
                        double d31 = d15 + d13 + (d16 + d14 - (d15 + d13)) * d21;
                        double d32 = d19 + d17 + (d20 + d18 - (d19 + d17)) * d21;
                        d29 = d27 - d29 / 2.0;
                        d30 = d25 - d30 / 2.0;
                        d31 = d26 - d31 / 2.0;
                        d32 = d28 - d32 / 2.0;
                        double d33 = (d25 += d30 * d23) + ((d26 += d31 * d23) - d25) * d22;
                        double d34 = d26 + (d27 += d29 * d23) + ((d28 += d32 * d23) + d25 - (d26 + d27)) * d22;
                        d34 = d33 - d34 / 2.0;
                        dArray[n36][n14 + nArray[n36]] = d33 += d34 * d24;
                        ++n36;
                    }
                } else if (this.setBackground) {
                    n36 = 0;
                    while (n36 < n8) {
                        dArray[n36][n14 + nArray[n36]] = this.backgroundValues[n36];
                        ++n36;
                    }
                }
                if (d3 < this.fracdx1) {
                    n15 += this.incx;
                    d3 += this.fracdx;
                } else {
                    n15 += this.incx1;
                    d3 -= this.fracdx1;
                }
                if (d4 < this.fracdy1) {
                    n16 += this.incy;
                    d4 += this.fracdy;
                } else {
                    n16 += this.incy1;
                    d4 -= this.fracdy1;
                }
                n17 = (n15 - n) * n6;
                n18 = (n16 - n2) * n7;
                n19 = n17 + n18 - n7 - n6;
                n20 = n19 + n6;
                n21 = n20 + n6;
                n22 = n21 + n6;
                n23 = n19 + n7;
                n24 = n23 + n6;
                n25 = n24 + n6;
                n26 = n25 + n6;
                n27 = n23 + n7;
                n28 = n27 + n6;
                n29 = n28 + n6;
                n30 = n29 + n6;
                n31 = n27 + n7;
                n32 = n31 + n6;
                n33 = n32 + n6;
                n34 = n33 + n6;
                n14 += n4;
                ++n35;
            }
            n3 += n5;
            ++n13;
        }
    }
}

