/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.tracks.webvtt;

import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.googlecode.mp4parser.authoring.AbstractTrack;
import com.googlecode.mp4parser.authoring.Sample;
import com.googlecode.mp4parser.authoring.TrackMetaData;
import com.googlecode.mp4parser.authoring.tracks.webvtt.sampleboxes.CuePayloadBox;
import com.googlecode.mp4parser.authoring.tracks.webvtt.sampleboxes.CueSettingsBox;
import com.googlecode.mp4parser.authoring.tracks.webvtt.sampleboxes.VTTCueBox;
import com.googlecode.mp4parser.authoring.tracks.webvtt.sampleboxes.VTTEmptyCueBox;
import com.googlecode.mp4parser.util.ByteBufferByteChannel;
import com.googlecode.mp4parser.util.CastUtils;
import com.googlecode.mp4parser.util.Mp4Arrays;
import com.mp4parser.iso14496.part30.WebVTTConfigurationBox;
import com.mp4parser.iso14496.part30.WebVTTSampleEntry;
import com.mp4parser.iso14496.part30.WebVTTSourceLabelBox;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebVttTrack
extends AbstractTrack {
    TrackMetaData trackMetaData = new TrackMetaData();
    SampleDescriptionBox stsd;
    private static final String WEBVTT_FILE_HEADER_STRING = "^\ufeff?WEBVTT((\\u0020|\t).*)?$";
    private static final Pattern WEBVTT_FILE_HEADER = Pattern.compile("^\ufeff?WEBVTT((\\u0020|\t).*)?$");
    private static final String WEBVTT_METADATA_HEADER_STRING = "\\S*[:=]\\S*";
    private static final Pattern WEBVTT_METADATA_HEADER = Pattern.compile("\\S*[:=]\\S*");
    private static final String WEBVTT_CUE_IDENTIFIER_STRING = "^(?!.*(-->)).*$";
    private static final Pattern WEBVTT_CUE_IDENTIFIER = Pattern.compile("^(?!.*(-->)).*$");
    private static final String WEBVTT_TIMESTAMP_STRING = "(\\d+:)?[0-5]\\d:[0-5]\\d\\.\\d{3}";
    private static final Pattern WEBVTT_TIMESTAMP = Pattern.compile("(\\d+:)?[0-5]\\d:[0-5]\\d\\.\\d{3}");
    private static final String WEBVTT_CUE_SETTING_STRING = "\\S*:\\S*";
    private static final Pattern WEBVTT_CUE_SETTING = Pattern.compile("\\S*:\\S*");
    private static final Sample EMPTY_SAMPLE = new Sample(){
        ByteBuffer vtte;
        {
            VTTEmptyCueBox vttEmptyCueBox = new VTTEmptyCueBox();
            this.vtte = ByteBuffer.allocate(CastUtils.l2i(vttEmptyCueBox.getSize()));
            try {
                vttEmptyCueBox.getBox(new ByteBufferByteChannel(this.vtte));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.vtte.rewind();
        }

        public void writeTo(WritableByteChannel channel) throws IOException {
            channel.write(this.vtte.duplicate());
        }

        public long getSize() {
            return this.vtte.remaining();
        }

        public ByteBuffer asByteBuffer() {
            return this.vtte.duplicate();
        }
    };
    List<Sample> samples = new ArrayList<Sample>();
    long[] sampleDurations = new long[0];
    WebVTTSampleEntry sampleEntry;

    /*
     * Unable to fully structure code
     */
    public WebVttTrack(InputStream is, String trackName, Locale locale) throws IOException {
        super(trackName);
        this.trackMetaData.setTimescale(1000L);
        this.trackMetaData.setLanguage(locale.getISO3Language());
        mediaTimestampUs = 0L;
        this.stsd = new SampleDescriptionBox();
        this.sampleEntry = new WebVTTSampleEntry();
        this.stsd.addBox(this.sampleEntry);
        webVttConf = new WebVTTConfigurationBox();
        this.sampleEntry.addBox(webVttConf);
        this.sampleEntry.addBox(new WebVTTSourceLabelBox());
        webvttData = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        line = webvttData.readLine();
        if (line == null || !WebVttTrack.WEBVTT_FILE_HEADER.matcher(line).matches()) {
            throw new IOException("Expected WEBVTT. Got " + line);
        }
        webVttConf.setConfig(String.valueOf(webVttConf.getConfig()) + "\n" + line);
        while (true) {
            if ((line = webvttData.readLine()) == null) {
                throw new IOException("Expected an empty line after webvtt header");
            }
            if (line.isEmpty()) ** GOTO lbl69
            matcher = WebVttTrack.WEBVTT_METADATA_HEADER.matcher(line);
            if (!matcher.find()) {
                throw new IOException("Expected WebVTT metadata header. Got " + line);
            }
            webVttConf.setConfig(String.valueOf(webVttConf.getConfig()) + "\n" + line);
        }
lbl-1000:
        // 1 sources

        {
            if ("".equals(line.trim())) continue;
            matcher = WebVttTrack.WEBVTT_CUE_IDENTIFIER.matcher(line);
            if (matcher.find()) {
                line = webvttData.readLine();
            }
            if (!(matcher = WebVttTrack.WEBVTT_TIMESTAMP.matcher(line)).find()) {
                throw new IOException("Expected cue start time: " + line);
            }
            startTime = WebVttTrack.parseTimestampUs(matcher.group());
            if (!matcher.find()) {
                throw new IOException("Expected cue end time: " + line);
            }
            endTimeString = matcher.group();
            endTime = WebVttTrack.parseTimestampUs(endTimeString);
            line = line.substring(line.indexOf(endTimeString) + endTimeString.length());
            matcher = WebVttTrack.WEBVTT_CUE_SETTING.matcher(line);
            settings = null;
            while (matcher.find()) {
                settings = matcher.group();
            }
            payload = new StringBuilder();
            while ((line = webvttData.readLine()) != null && !line.isEmpty()) {
                if (payload.length() > 0) {
                    payload.append("\n");
                }
                payload.append(line.trim());
            }
            if (startTime != mediaTimestampUs) {
                this.sampleDurations = Mp4Arrays.copyOfAndAppend(this.sampleDurations, new long[]{startTime - mediaTimestampUs});
                this.samples.add(WebVttTrack.EMPTY_SAMPLE);
            }
            this.sampleDurations = Mp4Arrays.copyOfAndAppend(this.sampleDurations, new long[]{endTime - startTime});
            vttCueBox = new VTTCueBox();
            if (settings != null) {
                csb = new CueSettingsBox();
                csb.setContent(settings);
                vttCueBox.setCueSettingsBox(csb);
            }
            cuePayloadBox = new CuePayloadBox();
            cuePayloadBox.setContent(payload.toString());
            vttCueBox.setCuePayloadBox(cuePayloadBox);
            this.samples.add(new BoxBearingSample(Collections.singletonList(vttCueBox)));
            mediaTimestampUs = endTime;
lbl69:
            // 3 sources

            ** while ((line = webvttData.readLine()) != null)
        }
lbl70:
        // 1 sources

    }

    private static long parseTimestampUs(String s) throws NumberFormatException {
        if (!s.matches(WEBVTT_TIMESTAMP_STRING)) {
            throw new NumberFormatException("has invalid format");
        }
        String[] parts = s.split("\\.", 2);
        long value = 0L;
        String[] stringArray = parts[0].split(":");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String group = stringArray[n2];
            value = value * 60L + Long.parseLong(group);
            ++n2;
        }
        return value * 1000L + Long.parseLong(parts[1]);
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        return this.stsd;
    }

    @Override
    public long[] getSampleDurations() {
        long[] adoptedSampleDuration = new long[this.sampleDurations.length];
        int i = 0;
        while (i < adoptedSampleDuration.length) {
            adoptedSampleDuration[i] = this.sampleDurations[i] * this.trackMetaData.getTimescale() / 1000L;
            ++i;
        }
        return adoptedSampleDuration;
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.trackMetaData;
    }

    @Override
    public String getHandler() {
        return "text";
    }

    @Override
    public List<Sample> getSamples() {
        return this.samples;
    }

    @Override
    public void close() throws IOException {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BoxBearingSample
    implements Sample {
        List<Box> boxes;

        public BoxBearingSample(List<Box> boxes) {
            this.boxes = boxes;
        }

        @Override
        public void writeTo(WritableByteChannel channel) throws IOException {
            for (Box box : this.boxes) {
                box.getBox(channel);
            }
        }

        @Override
        public long getSize() {
            long l = 0L;
            for (Box box : this.boxes) {
                l += box.getSize();
            }
            return l;
        }

        @Override
        public ByteBuffer asByteBuffer() {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                this.writeTo(Channels.newChannel(baos));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return ByteBuffer.wrap(baos.toByteArray());
        }
    }
}

