/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.util.Map;
import javax.measure.Dimension;
import javax.measure.IncommensurableException;
import javax.measure.Quantity;
import javax.measure.UnconvertibleException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.math.Fraction;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.AbstractUnit;
import org.apache.sis.measure.LinearConverter;
import org.apache.sis.measure.SystemUnit;
import org.apache.sis.measure.UnitRegistry;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Characters;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;

final class ConventionalUnit<Q extends Quantity<Q>>
extends AbstractUnit<Q> {
    private static final long serialVersionUID = 6963634855104019466L;
    private static final char[] PREFIXES = new char[]{'y', 'z', 'a', 'f', 'p', 'n', '\u00b5', 'm', 'c', 'd', '\u3372', 'h', 'k', 'M', 'G', 'T', 'P', 'E', 'Z', 'Y'};
    static final int MAX_POWER = 8;
    private final AbstractUnit<Q> target;
    final UnitConverter toTarget;

    ConventionalUnit(AbstractUnit<Q> abstractUnit, UnitConverter unitConverter, String string, byte by, short s) {
        super(string, by, s);
        this.target = abstractUnit;
        this.toTarget = unitConverter;
    }

    static <Q extends Quantity<Q>> AbstractUnit<Q> create(AbstractUnit<Q> abstractUnit, UnitConverter unitConverter) {
        Object object;
        int n;
        Object object2;
        Object object3;
        if (unitConverter.isIdentity()) {
            return abstractUnit;
        }
        ConventionalUnit<Q>[] conventionalUnitArray = abstractUnit.related();
        if (conventionalUnitArray != null && unitConverter instanceof LinearConverter) {
            object3 = (LinearConverter)unitConverter;
            object2 = conventionalUnitArray;
            n = ((ConventionalUnit<Q>[])object2).length;
            for (int i = 0; i < n; ++i) {
                Object object4 = object2[i];
                if (!((LinearConverter)object3).equivalent((LinearConverter)((ConventionalUnit)object4).toTarget)) continue;
                return object4;
            }
        }
        object3 = null;
        if (abstractUnit.isPrefixable() && (object2 = abstractUnit.getSymbol()) != null && !((String)object2).isEmpty() && unitConverter.isLinear() && (n = ConventionalUnit.power((String)object2)) != 0) {
            double d = unitConverter.convert(1.0);
            switch (n) {
                case 1: {
                    break;
                }
                case 2: {
                    d = Math.sqrt(d);
                    break;
                }
                case 3: {
                    d = Math.cbrt(d);
                    break;
                }
                default: {
                    d = Math.pow(d, 1.0 / (double)n);
                }
            }
            char c = ConventionalUnit.prefix(d);
            if (c != '\u0000') {
                object3 = c == '\u3372' ? "da" + (String)object2 : c + (String)object2;
            }
        }
        object2 = new ConventionalUnit<Q>(abstractUnit, unitConverter, (String)object3, 0, 0);
        if (object3 != null && (object = UnitRegistry.putIfAbsent(object3, object2)) instanceof ConventionalUnit) {
            boolean bl;
            ConventionalUnit conventionalUnit = (ConventionalUnit)object;
            if (abstractUnit.equals(conventionalUnit.target) && (bl = unitConverter instanceof LinearConverter && conventionalUnit.toTarget instanceof LinearConverter ? ((LinearConverter)unitConverter).equivalent((LinearConverter)conventionalUnit.toTarget) : unitConverter.equals(conventionalUnit.toTarget))) {
                return conventionalUnit;
            }
        }
        return object2;
    }

    static int power(String string) {
        int n;
        int n2;
        int n3 = string.length();
        int n4 = 0;
        do {
            if (n4 >= n3) {
                return 1;
            }
            n2 = string.codePointAt(n4);
            n4 += Character.charCount(n2);
        } while (ConventionalUnit.isSymbolChar(n2));
        if (Character.isBmpCodePoint(n2) && (n = Characters.toNormalScript((char)n2) - 48) >= 0 && n <= 9) {
            if (n4 < n3) {
                n2 = string.codePointAt(n4);
                if (ConventionalUnit.isSymbolChar(n2)) {
                    return 0;
                }
                if (Character.isBmpCodePoint(n2) && (n2 = (int)Characters.toNormalScript((char)n2)) >= 48 && n2 <= 57) {
                    return 0;
                }
            }
            return n;
        }
        return 1;
    }

    static char prefix(double d) {
        int n = Numerics.toExp10(Math.getExponent(d)) + 1;
        if (ConventionalUnit.epsilonEquals(MathFunctions.pow10(n), d)) {
            int n2 = Math.abs(n);
            switch (n2) {
                case 0: {
                    return '\u0000';
                }
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    if (n2 > 24 || n2 % 3 != 0) {
                        return '\u0000';
                    }
                    n2 = n2 / 3 + 2;
                }
            }
            return PREFIXES[n >= 0 ? 9 + n2 : 10 - n2];
        }
        return '\u0000';
    }

    @Override
    public Dimension getDimension() {
        return this.target.getDimension();
    }

    @Override
    public SystemUnit<Q> getSystemUnit() {
        return this.target.getSystemUnit();
    }

    @Override
    public Map<SystemUnit<?>, Integer> getBaseUnits() {
        return this.target.getBaseUnits();
    }

    @Override
    final Map<SystemUnit<?>, Fraction> getBaseSystemUnits() {
        return this.target.getBaseSystemUnits();
    }

    @Override
    public <T extends Quantity<T>> Unit<T> asType(Class<T> clazz) throws ClassCastException {
        Unit<T> unit = this.target.asType(clazz);
        if (this.target.equals(unit)) {
            return this;
        }
        return unit.transform(this.toTarget);
    }

    @Override
    public UnitConverter getConverterTo(Unit<Q> unit) throws UnconvertibleException {
        if (unit == this) {
            return LinearConverter.IDENTITY;
        }
        ArgumentChecks.ensureNonNull("that", unit);
        UnitConverter unitConverter = this.toTarget;
        if (this.target != unit) {
            Unit<Q> unit2 = unit.getSystemUnit();
            if (this.target != unit2 && !this.target.isCompatible(unit2)) {
                throw new UnconvertibleException(this.incompatible(unit));
            }
            unitConverter = this.target.getConverterTo(unit2).concatenate(unitConverter);
            unitConverter = unit2.getConverterTo(unit).concatenate(unitConverter);
        }
        return unitConverter;
    }

    @Override
    public UnitConverter getConverterToAny(Unit<?> unit) throws IncommensurableException {
        if (unit == this) {
            return LinearConverter.IDENTITY;
        }
        ArgumentChecks.ensureNonNull("that", unit);
        UnitConverter unitConverter = this.toTarget;
        if (this.target != unit) {
            Unit<?> unit2 = unit.getSystemUnit();
            if (this.target != unit2 && !this.target.isCompatible(unit2)) {
                throw new IncommensurableException(this.incompatible(unit));
            }
            unitConverter = this.target.getConverterToAny(unit2).concatenate(unitConverter);
            unitConverter = unit2.getConverterToAny(unit).concatenate(unitConverter);
        }
        return unitConverter;
    }

    @Override
    public Unit<Q> alternate(String string) {
        throw new UnsupportedOperationException(Errors.format((short)106, this));
    }

    private void ensureRatioScale() {
        if (!this.toTarget.isLinear()) {
            throw new IllegalStateException(Errors.format((short)104, this));
        }
    }

    @Override
    public Unit<?> multiply(Unit<?> unit) {
        this.ensureRatioScale();
        return this.target.multiply(unit).transform(this.toTarget);
    }

    @Override
    public Unit<?> divide(Unit<?> unit) {
        this.ensureRatioScale();
        return this.target.divide(unit).transform(this.toTarget);
    }

    @Override
    public Unit<?> pow(int n) {
        this.ensureRatioScale();
        Unit<?> unit = this.target.pow(n);
        return unit == this.target ? this : unit.transform(LinearConverter.pow(this.toTarget, n, false));
    }

    @Override
    public Unit<?> root(int n) {
        this.ensureRatioScale();
        Unit<?> unit = this.target.root(n);
        return unit == this.target ? this : unit.transform(LinearConverter.pow(this.toTarget, n, true));
    }

    @Override
    public Unit<Q> transform(UnitConverter unitConverter) {
        ArgumentChecks.ensureNonNull("operation", unitConverter);
        AbstractUnit abstractUnit = this;
        if (!this.isPrefixable()) {
            abstractUnit = this.target;
            unitConverter = this.toTarget.concatenate(unitConverter);
        }
        return ConventionalUnit.create(abstractUnit, unitConverter);
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode)) {
            ConventionalUnit conventionalUnit = (ConventionalUnit)object;
            return Utilities.deepEquals(this.target, conventionalUnit.target, comparisonMode) && Utilities.deepEquals(this.toTarget, conventionalUnit.toTarget, comparisonMode);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 37 * (this.target.hashCode() + 31 * this.toTarget.hashCode());
    }
}

