/*
 * Decompiled with CFR 0.152.
 */
package opennlp.grok.preprocess.mwe;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import opennlp.common.util.PerlHelp;
import opennlp.grok.preprocess.mwe.MWEModel;

public class FixedMWEModel
implements MWEModel {
    Map map = new HashMap();

    public boolean isFixedMWE(String[] l, int pos) {
        List list = (List)this.map.get(l[pos]);
        if (list != null) {
            Iterator i = list.iterator();
            while (i.hasNext()) {
                ModelData mwe = (ModelData)i.next();
                if (mwe == null) continue;
                try {
                    String[] mweWords = mwe.getWords();
                    int j = 1;
                    while (j < mweWords.length) {
                        if (!mweWords[j].equals(l[pos + j])) {
                            return false;
                        }
                        ++j;
                    }
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        return false;
    }

    public String[] getMWE(String[] l, int pos) {
        List list = (List)this.map.get(l[pos]);
        if (list != null) {
            Iterator i = list.iterator();
            while (i.hasNext()) {
                ModelData mwe = (ModelData)i.next();
                if (!this.tryMWE(mwe, l, pos)) continue;
                return mwe.getWords();
            }
        }
        return null;
    }

    public void addMWE(String mweWords) {
        String[] spaceSplit = PerlHelp.split((String)mweWords);
        if (spaceSplit.length < 2) {
            System.out.println("+addFixedMWE: " + mweWords + " has a wrong format");
            return;
        }
        ModelData mwe = new ModelData(spaceSplit);
        String indexWord = spaceSplit[mwe.getIndexWord()];
        ArrayList<ModelData> l = (ArrayList<ModelData>)this.map.get(indexWord);
        if (l == null) {
            l = new ArrayList<ModelData>();
            this.map.put(indexWord, l);
        }
        l.add(mwe);
    }

    private boolean tryMWE(ModelData mwe, String[] l, int pos) {
        String[] mweWords = mwe.getWords();
        try {
            int i = 1;
            while (i < mweWords.length) {
                if (!mweWords[i].equals(l[pos + i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static class ModelData {
        private String[] words;

        public ModelData(String[] words) {
            this.words = words;
        }

        public String[] getWords() {
            return this.words;
        }

        public int getIndexWord() {
            return 0;
        }
    }
}

