from _typeshed import Incomplete
from collections.abc import Generator, Mapping
from os import PathLike
from typing import Any, Literal

class Box(dict):
    def __new__(
        cls,
        *args: Any,
        default_box: bool = ...,
        default_box_attr: Any = ...,
        default_box_none_transform: bool = ...,
        default_box_create_on_get: bool = ...,
        frozen_box: bool = ...,
        camel_killer_box: bool = ...,
        conversion_box: bool = ...,
        modify_tuples_box: bool = ...,
        box_safe_prefix: str = ...,
        box_duplicates: str = ...,
        box_intact_types: tuple | list = ...,
        box_recast: dict | None = ...,
        box_dots: bool = ...,
        box_dots_exclude: str | None = ...,
        box_class: dict | type[Box] | None = ...,
        box_namespace: tuple[str, ...] | Literal[False] = ...,
        **kwargs: Any,
    ): ...
    def __init__(
        self,
        *args: Any,
        default_box: bool = ...,
        default_box_attr: Any = ...,
        default_box_none_transform: bool = ...,
        default_box_create_on_get: bool = ...,
        frozen_box: bool = ...,
        camel_killer_box: bool = ...,
        conversion_box: bool = ...,
        modify_tuples_box: bool = ...,
        box_safe_prefix: str = ...,
        box_duplicates: str = ...,
        box_intact_types: tuple | list = ...,
        box_recast: dict | None = ...,
        box_dots: bool = ...,
        box_dots_exclude: str | None = ...,
        box_class: dict | type[Box] | None = ...,
        box_namespace: tuple[str, ...] | Literal[False] = ...,
        **kwargs: Any,
    ) -> None: ...
    def __add__(self, other: Mapping[Any, Any]): ...
    def __radd__(self, other: Mapping[Any, Any]): ...
    def __iadd__(self, other: Mapping[Any, Any]): ...
    def __or__(self, other: Mapping[Any, Any]): ...
    def __ror__(self, other: Mapping[Any, Any]): ...
    def __ior__(self, other: Mapping[Any, Any]): ...  # type: ignore[override]
    def __sub__(self, other: Mapping[Any, Any]): ...
    def __hash__(self): ...
    def __dir__(self) -> list[str]: ...
    def __contains__(self, item) -> bool: ...
    def keys(self, dotted: bool = ...): ...
    def items(self, dotted: bool = ...): ...
    def get(self, key, default=...): ...
    def copy(self) -> Box: ...
    def __copy__(self) -> Box: ...
    def __deepcopy__(self, memodict: Incomplete | None = ...) -> Box: ...
    def __getitem__(self, item, _ignore_default: bool = ...): ...
    def __getattr__(self, item): ...
    def __setitem__(self, key, value): ...
    def __setattr__(self, key, value): ...
    def __delitem__(self, key): ...
    def __delattr__(self, item) -> None: ...
    def pop(self, key, *args): ...
    def clear(self) -> None: ...
    def popitem(self): ...
    def __iter__(self) -> Generator: ...
    def __reversed__(self) -> Generator: ...
    def to_dict(self) -> dict: ...
    def update(self, *args, **kwargs) -> None: ...
    def merge_update(self, *args, **kwargs) -> None: ...
    def setdefault(self, item, default: Incomplete | None = ...): ...
    def to_json(self, filename: str | PathLike | None = ..., encoding: str = ..., errors: str = ..., **json_kwargs): ...
    @classmethod
    def from_json(
        cls,
        json_string: str | None = ...,
        filename: str | PathLike | None = ...,
        encoding: str = ...,
        errors: str = ...,
        **kwargs,
    ) -> Box: ...
    def to_yaml(
        self,
        filename: str | PathLike | None = ...,
        default_flow_style: bool = ...,
        encoding: str = ...,
        errors: str = ...,
        width: int = ...,
        **yaml_kwargs,
    ): ...
    @classmethod
    def from_yaml(
        cls,
        yaml_string: str | None = ...,
        filename: str | PathLike | None = ...,
        encoding: str = ...,
        errors: str = ...,
        **kwargs,
    ) -> Box: ...
    def to_toml(self, filename: str | PathLike | None = ..., encoding: str = ..., errors: str = ...): ...
    @classmethod
    def from_toml(
        cls,
        toml_string: str | None = ...,
        filename: str | PathLike | None = ...,
        encoding: str = ...,
        errors: str = ...,
        **kwargs,
    ) -> Box: ...
    def to_msgpack(self, filename: str | PathLike | None = ..., **kwargs): ...
    @classmethod
    def from_msgpack(
        cls, msgpack_bytes: bytes | None = ..., filename: str | PathLike | None = ..., **kwargs
    ) -> Box: ...
    def to_toon(self, filename: str | PathLike | None = ..., encoding: str = ..., errors: str = ..., **kwargs): ...
    @classmethod
    def from_toon(
        cls,
        toon_string: str | None = ...,
        filename: str | PathLike | None = ...,
        encoding: str = ...,
        errors: str = ...,
        **kwargs,
    ) -> Box: ...
