/***************************************************************************
 *   Copyright (C) 2005-2006 Gao Xianchao                                  *
 *                 2007 Gao Xianchao gnap_an linux_lyb ahlongxp            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/*
 * Author:	gxc
 * Create data:	2005-10-12 20:09
 */
 
#ifndef SOCKET_H_
#define SOCKET_H_

#include "BitStorm.h"

class CSocket : public ISocket
{
public:
	CSocket();
	virtual ~CSocket();
private:
		ISocketReactor* _reactor;
		int _handle;
		bool _maskRead;
		bool _maskWrite;
		bool _inReactor;
private:
	void setNonBlock();		
public:	
	void setReactor(ISocketReactor* reactor);
	ISocketReactor* getReactor();
	
	void createTCPSocket();
	void createUDPSocket();
	void close();
	void attach(int fd);
	int getHandle();
	
	bool bind(const char* ip, unsigned short port);
	void listen();
	void connect(const char* ip, unsigned short port);	
	int accept(std::string& ip, unsigned short& port);
	
	void maskRead(bool mask);
	void maskWrite(bool mask);
	bool maskRead();
	bool maskWrite();	
};

#endif /*SOCKET_H_*/
