# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import TYPE_CHECKING

from azure.mgmt.core import ARMPipelineClient
from msrest import Deserializer, Serializer

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Optional

    from azure.core.credentials import TokenCredential

from ._configuration import SignalRManagementClientConfiguration
from .operations import Operations
from .operations import SignalROperations
from .operations import SignalRPrivateEndpointConnectionsOperations
from .operations import SignalRPrivateLinkResourcesOperations
from .operations import UsagesOperations
from . import models


class SignalRManagementClient(object):
    """REST API for Azure SignalR Service.

    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.signalr.operations.Operations
    :ivar signal_r: SignalROperations operations
    :vartype signal_r: azure.mgmt.signalr.operations.SignalROperations
    :ivar signal_rprivate_endpoint_connections: SignalRPrivateEndpointConnectionsOperations operations
    :vartype signal_rprivate_endpoint_connections: azure.mgmt.signalr.operations.SignalRPrivateEndpointConnectionsOperations
    :ivar signal_rprivate_link_resources: SignalRPrivateLinkResourcesOperations operations
    :vartype signal_rprivate_link_resources: azure.mgmt.signalr.operations.SignalRPrivateLinkResourcesOperations
    :ivar usages: UsagesOperations operations
    :vartype usages: azure.mgmt.signalr.operations.UsagesOperations
    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials.TokenCredential
    :param subscription_id: Gets subscription Id which uniquely identify the Microsoft Azure subscription. The subscription ID forms part of the URI for every service call.
    :type subscription_id: str
    :param str base_url: Service URL
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
    """

    def __init__(
        self,
        credential,  # type: "TokenCredential"
        subscription_id,  # type: str
        base_url=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        if not base_url:
            base_url = 'https://management.azure.com'
        self._config = SignalRManagementClientConfiguration(credential, subscription_id, **kwargs)
        self._client = ARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._serialize.client_side_validation = False
        self._deserialize = Deserializer(client_models)

        self.operations = Operations(
            self._client, self._config, self._serialize, self._deserialize)
        self.signal_r = SignalROperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.signal_rprivate_endpoint_connections = SignalRPrivateEndpointConnectionsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.signal_rprivate_link_resources = SignalRPrivateLinkResourcesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.usages = UsagesOperations(
            self._client, self._config, self._serialize, self._deserialize)

    def close(self):
        # type: () -> None
        self._client.close()

    def __enter__(self):
        # type: () -> SignalRManagementClient
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details):
        # type: (Any) -> None
        self._client.__exit__(*exc_details)
