# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

import msrest.serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    import __init__ as _models


class ApiDefinitionInfo(msrest.serialization.Model):
    """Information about the formal API definition for the app.

    :ivar url: The URL of the API definition.
    :vartype url: str
    """

    _attribute_map = {
        'url': {'key': 'url', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        url: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword url: The URL of the API definition.
        :paramtype url: str
        """
        super(ApiDefinitionInfo, self).__init__(**kwargs)
        self.url = url


class ApplicationLogsConfig(msrest.serialization.Model):
    """Application logs configuration.

    :ivar file_system: Application logs to file system configuration.
    :vartype file_system: ~azure.mgmt.web.v2016_08_01.models.FileSystemApplicationLogsConfig
    :ivar azure_table_storage: Application logs to azure table storage configuration.
    :vartype azure_table_storage:
     ~azure.mgmt.web.v2016_08_01.models.AzureTableStorageApplicationLogsConfig
    :ivar azure_blob_storage: Application logs to blob storage configuration.
    :vartype azure_blob_storage:
     ~azure.mgmt.web.v2016_08_01.models.AzureBlobStorageApplicationLogsConfig
    """

    _attribute_map = {
        'file_system': {'key': 'fileSystem', 'type': 'FileSystemApplicationLogsConfig'},
        'azure_table_storage': {'key': 'azureTableStorage', 'type': 'AzureTableStorageApplicationLogsConfig'},
        'azure_blob_storage': {'key': 'azureBlobStorage', 'type': 'AzureBlobStorageApplicationLogsConfig'},
    }

    def __init__(
        self,
        *,
        file_system: Optional["_models.FileSystemApplicationLogsConfig"] = None,
        azure_table_storage: Optional["_models.AzureTableStorageApplicationLogsConfig"] = None,
        azure_blob_storage: Optional["_models.AzureBlobStorageApplicationLogsConfig"] = None,
        **kwargs
    ):
        """
        :keyword file_system: Application logs to file system configuration.
        :paramtype file_system: ~azure.mgmt.web.v2016_08_01.models.FileSystemApplicationLogsConfig
        :keyword azure_table_storage: Application logs to azure table storage configuration.
        :paramtype azure_table_storage:
         ~azure.mgmt.web.v2016_08_01.models.AzureTableStorageApplicationLogsConfig
        :keyword azure_blob_storage: Application logs to blob storage configuration.
        :paramtype azure_blob_storage:
         ~azure.mgmt.web.v2016_08_01.models.AzureBlobStorageApplicationLogsConfig
        """
        super(ApplicationLogsConfig, self).__init__(**kwargs)
        self.file_system = file_system
        self.azure_table_storage = azure_table_storage
        self.azure_blob_storage = azure_blob_storage


class AutoHealActions(msrest.serialization.Model):
    """Actions which to take by the auto-heal module when a rule is triggered.

    :ivar action_type: Predefined action to be taken. Known values are: "Recycle", "LogEvent",
     "CustomAction".
    :vartype action_type: str or ~azure.mgmt.web.v2016_08_01.models.AutoHealActionType
    :ivar custom_action: Custom action to be taken.
    :vartype custom_action: ~azure.mgmt.web.v2016_08_01.models.AutoHealCustomAction
    :ivar min_process_execution_time: Minimum time the process must execute
     before taking the action.
    :vartype min_process_execution_time: str
    """

    _attribute_map = {
        'action_type': {'key': 'actionType', 'type': 'str'},
        'custom_action': {'key': 'customAction', 'type': 'AutoHealCustomAction'},
        'min_process_execution_time': {'key': 'minProcessExecutionTime', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        action_type: Optional[Union[str, "_models.AutoHealActionType"]] = None,
        custom_action: Optional["_models.AutoHealCustomAction"] = None,
        min_process_execution_time: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword action_type: Predefined action to be taken. Known values are: "Recycle", "LogEvent",
         "CustomAction".
        :paramtype action_type: str or ~azure.mgmt.web.v2016_08_01.models.AutoHealActionType
        :keyword custom_action: Custom action to be taken.
        :paramtype custom_action: ~azure.mgmt.web.v2016_08_01.models.AutoHealCustomAction
        :keyword min_process_execution_time: Minimum time the process must execute
         before taking the action.
        :paramtype min_process_execution_time: str
        """
        super(AutoHealActions, self).__init__(**kwargs)
        self.action_type = action_type
        self.custom_action = custom_action
        self.min_process_execution_time = min_process_execution_time


class AutoHealCustomAction(msrest.serialization.Model):
    """Custom action to be executed
when an auto heal rule is triggered.

    :ivar exe: Executable to be run.
    :vartype exe: str
    :ivar parameters: Parameters for the executable.
    :vartype parameters: str
    """

    _attribute_map = {
        'exe': {'key': 'exe', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        exe: Optional[str] = None,
        parameters: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword exe: Executable to be run.
        :paramtype exe: str
        :keyword parameters: Parameters for the executable.
        :paramtype parameters: str
        """
        super(AutoHealCustomAction, self).__init__(**kwargs)
        self.exe = exe
        self.parameters = parameters


class AutoHealRules(msrest.serialization.Model):
    """Rules that can be defined for auto-heal.

    :ivar triggers: Conditions that describe when to execute the auto-heal actions.
    :vartype triggers: ~azure.mgmt.web.v2016_08_01.models.AutoHealTriggers
    :ivar actions: Actions to be executed when a rule is triggered.
    :vartype actions: ~azure.mgmt.web.v2016_08_01.models.AutoHealActions
    """

    _attribute_map = {
        'triggers': {'key': 'triggers', 'type': 'AutoHealTriggers'},
        'actions': {'key': 'actions', 'type': 'AutoHealActions'},
    }

    def __init__(
        self,
        *,
        triggers: Optional["_models.AutoHealTriggers"] = None,
        actions: Optional["_models.AutoHealActions"] = None,
        **kwargs
    ):
        """
        :keyword triggers: Conditions that describe when to execute the auto-heal actions.
        :paramtype triggers: ~azure.mgmt.web.v2016_08_01.models.AutoHealTriggers
        :keyword actions: Actions to be executed when a rule is triggered.
        :paramtype actions: ~azure.mgmt.web.v2016_08_01.models.AutoHealActions
        """
        super(AutoHealRules, self).__init__(**kwargs)
        self.triggers = triggers
        self.actions = actions


class AutoHealTriggers(msrest.serialization.Model):
    """Triggers for auto-heal.

    :ivar requests: A rule based on total requests.
    :vartype requests: ~azure.mgmt.web.v2016_08_01.models.RequestsBasedTrigger
    :ivar private_bytes_in_kb: A rule based on private bytes.
    :vartype private_bytes_in_kb: int
    :ivar status_codes: A rule based on status codes.
    :vartype status_codes: list[~azure.mgmt.web.v2016_08_01.models.StatusCodesBasedTrigger]
    :ivar slow_requests: A rule based on request execution time.
    :vartype slow_requests: ~azure.mgmt.web.v2016_08_01.models.SlowRequestsBasedTrigger
    """

    _attribute_map = {
        'requests': {'key': 'requests', 'type': 'RequestsBasedTrigger'},
        'private_bytes_in_kb': {'key': 'privateBytesInKB', 'type': 'int'},
        'status_codes': {'key': 'statusCodes', 'type': '[StatusCodesBasedTrigger]'},
        'slow_requests': {'key': 'slowRequests', 'type': 'SlowRequestsBasedTrigger'},
    }

    def __init__(
        self,
        *,
        requests: Optional["_models.RequestsBasedTrigger"] = None,
        private_bytes_in_kb: Optional[int] = None,
        status_codes: Optional[List["_models.StatusCodesBasedTrigger"]] = None,
        slow_requests: Optional["_models.SlowRequestsBasedTrigger"] = None,
        **kwargs
    ):
        """
        :keyword requests: A rule based on total requests.
        :paramtype requests: ~azure.mgmt.web.v2016_08_01.models.RequestsBasedTrigger
        :keyword private_bytes_in_kb: A rule based on private bytes.
        :paramtype private_bytes_in_kb: int
        :keyword status_codes: A rule based on status codes.
        :paramtype status_codes: list[~azure.mgmt.web.v2016_08_01.models.StatusCodesBasedTrigger]
        :keyword slow_requests: A rule based on request execution time.
        :paramtype slow_requests: ~azure.mgmt.web.v2016_08_01.models.SlowRequestsBasedTrigger
        """
        super(AutoHealTriggers, self).__init__(**kwargs)
        self.requests = requests
        self.private_bytes_in_kb = private_bytes_in_kb
        self.status_codes = status_codes
        self.slow_requests = slow_requests


class AzureBlobStorageApplicationLogsConfig(msrest.serialization.Model):
    """Application logs azure blob storage configuration.

    :ivar level: Log level. Known values are: "Off", "Verbose", "Information", "Warning", "Error".
    :vartype level: str or ~azure.mgmt.web.v2016_08_01.models.LogLevel
    :ivar sas_url: SAS url to a azure blob container with read/write/list/delete permissions.
    :vartype sas_url: str
    :ivar retention_in_days: Retention in days.
     Remove blobs older than X days.
     0 or lower means no retention.
    :vartype retention_in_days: int
    """

    _attribute_map = {
        'level': {'key': 'level', 'type': 'str'},
        'sas_url': {'key': 'sasUrl', 'type': 'str'},
        'retention_in_days': {'key': 'retentionInDays', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        level: Optional[Union[str, "_models.LogLevel"]] = None,
        sas_url: Optional[str] = None,
        retention_in_days: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword level: Log level. Known values are: "Off", "Verbose", "Information", "Warning",
         "Error".
        :paramtype level: str or ~azure.mgmt.web.v2016_08_01.models.LogLevel
        :keyword sas_url: SAS url to a azure blob container with read/write/list/delete permissions.
        :paramtype sas_url: str
        :keyword retention_in_days: Retention in days.
         Remove blobs older than X days.
         0 or lower means no retention.
        :paramtype retention_in_days: int
        """
        super(AzureBlobStorageApplicationLogsConfig, self).__init__(**kwargs)
        self.level = level
        self.sas_url = sas_url
        self.retention_in_days = retention_in_days


class AzureBlobStorageHttpLogsConfig(msrest.serialization.Model):
    """Http logs to azure blob storage configuration.

    :ivar sas_url: SAS url to a azure blob container with read/write/list/delete permissions.
    :vartype sas_url: str
    :ivar retention_in_days: Retention in days.
     Remove blobs older than X days.
     0 or lower means no retention.
    :vartype retention_in_days: int
    :ivar enabled: True if configuration is enabled, false if it is disabled and null if
     configuration is not set.
    :vartype enabled: bool
    """

    _attribute_map = {
        'sas_url': {'key': 'sasUrl', 'type': 'str'},
        'retention_in_days': {'key': 'retentionInDays', 'type': 'int'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        sas_url: Optional[str] = None,
        retention_in_days: Optional[int] = None,
        enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword sas_url: SAS url to a azure blob container with read/write/list/delete permissions.
        :paramtype sas_url: str
        :keyword retention_in_days: Retention in days.
         Remove blobs older than X days.
         0 or lower means no retention.
        :paramtype retention_in_days: int
        :keyword enabled: True if configuration is enabled, false if it is disabled and null if
         configuration is not set.
        :paramtype enabled: bool
        """
        super(AzureBlobStorageHttpLogsConfig, self).__init__(**kwargs)
        self.sas_url = sas_url
        self.retention_in_days = retention_in_days
        self.enabled = enabled


class AzureTableStorageApplicationLogsConfig(msrest.serialization.Model):
    """Application logs to Azure table storage configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar level: Log level. Known values are: "Off", "Verbose", "Information", "Warning", "Error".
    :vartype level: str or ~azure.mgmt.web.v2016_08_01.models.LogLevel
    :ivar sas_url: Required. SAS URL to an Azure table with add/query/delete permissions.
    :vartype sas_url: str
    """

    _validation = {
        'sas_url': {'required': True},
    }

    _attribute_map = {
        'level': {'key': 'level', 'type': 'str'},
        'sas_url': {'key': 'sasUrl', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        sas_url: str,
        level: Optional[Union[str, "_models.LogLevel"]] = None,
        **kwargs
    ):
        """
        :keyword level: Log level. Known values are: "Off", "Verbose", "Information", "Warning",
         "Error".
        :paramtype level: str or ~azure.mgmt.web.v2016_08_01.models.LogLevel
        :keyword sas_url: Required. SAS URL to an Azure table with add/query/delete permissions.
        :paramtype sas_url: str
        """
        super(AzureTableStorageApplicationLogsConfig, self).__init__(**kwargs)
        self.level = level
        self.sas_url = sas_url


class ProxyOnlyResource(msrest.serialization.Model):
    """Azure proxy only resource. This resource is not tracked by Azure Resource Manager.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super(ProxyOnlyResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.kind = kind
        self.type = None


class BackupItem(ProxyOnlyResource):
    """Backup description.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar backup_id: Id of the backup.
    :vartype backup_id: int
    :ivar storage_account_url: SAS URL for the storage account container which contains this
     backup.
    :vartype storage_account_url: str
    :ivar blob_name: Name of the blob which contains data for this backup.
    :vartype blob_name: str
    :ivar name_properties_name: Name of this backup.
    :vartype name_properties_name: str
    :ivar status: Backup status. Known values are: "InProgress", "Failed", "Succeeded", "TimedOut",
     "Created", "Skipped", "PartiallySucceeded", "DeleteInProgress", "DeleteFailed", "Deleted".
    :vartype status: str or ~azure.mgmt.web.v2016_08_01.models.BackupItemStatus
    :ivar size_in_bytes: Size of the backup in bytes.
    :vartype size_in_bytes: long
    :ivar created: Timestamp of the backup creation.
    :vartype created: ~datetime.datetime
    :ivar log: Details regarding this backup. Might contain an error message.
    :vartype log: str
    :ivar databases: List of databases included in the backup.
    :vartype databases: list[~azure.mgmt.web.v2016_08_01.models.DatabaseBackupSetting]
    :ivar scheduled: True if this backup has been created due to a schedule being triggered.
    :vartype scheduled: bool
    :ivar last_restore_time_stamp: Timestamp of a last restore operation which used this backup.
    :vartype last_restore_time_stamp: ~datetime.datetime
    :ivar finished_time_stamp: Timestamp when this backup finished.
    :vartype finished_time_stamp: ~datetime.datetime
    :ivar correlation_id: Unique correlation identifier. Please use this along with the timestamp
     while communicating with Azure support.
    :vartype correlation_id: str
    :ivar website_size_in_bytes: Size of the original web app which has been backed up.
    :vartype website_size_in_bytes: long
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'backup_id': {'readonly': True},
        'storage_account_url': {'readonly': True},
        'blob_name': {'readonly': True},
        'name_properties_name': {'readonly': True},
        'status': {'readonly': True},
        'size_in_bytes': {'readonly': True},
        'created': {'readonly': True},
        'log': {'readonly': True},
        'databases': {'readonly': True},
        'scheduled': {'readonly': True},
        'last_restore_time_stamp': {'readonly': True},
        'finished_time_stamp': {'readonly': True},
        'correlation_id': {'readonly': True},
        'website_size_in_bytes': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'backup_id': {'key': 'properties.id', 'type': 'int'},
        'storage_account_url': {'key': 'properties.storageAccountUrl', 'type': 'str'},
        'blob_name': {'key': 'properties.blobName', 'type': 'str'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'size_in_bytes': {'key': 'properties.sizeInBytes', 'type': 'long'},
        'created': {'key': 'properties.created', 'type': 'iso-8601'},
        'log': {'key': 'properties.log', 'type': 'str'},
        'databases': {'key': 'properties.databases', 'type': '[DatabaseBackupSetting]'},
        'scheduled': {'key': 'properties.scheduled', 'type': 'bool'},
        'last_restore_time_stamp': {'key': 'properties.lastRestoreTimeStamp', 'type': 'iso-8601'},
        'finished_time_stamp': {'key': 'properties.finishedTimeStamp', 'type': 'iso-8601'},
        'correlation_id': {'key': 'properties.correlationId', 'type': 'str'},
        'website_size_in_bytes': {'key': 'properties.websiteSizeInBytes', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super(BackupItem, self).__init__(kind=kind, **kwargs)
        self.backup_id = None
        self.storage_account_url = None
        self.blob_name = None
        self.name_properties_name = None
        self.status = None
        self.size_in_bytes = None
        self.created = None
        self.log = None
        self.databases = None
        self.scheduled = None
        self.last_restore_time_stamp = None
        self.finished_time_stamp = None
        self.correlation_id = None
        self.website_size_in_bytes = None


class BackupItemCollection(msrest.serialization.Model):
    """Collection of backup items.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2016_08_01.models.BackupItem]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[BackupItem]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["_models.BackupItem"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2016_08_01.models.BackupItem]
        """
        super(BackupItemCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class BackupRequest(ProxyOnlyResource):
    """Description of a backup which will be performed.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar backup_request_name: Name of the backup.
    :vartype backup_request_name: str
    :ivar enabled: True if the backup schedule is enabled (must be included in that case), false if
     the backup schedule should be disabled.
    :vartype enabled: bool
    :ivar storage_account_url: SAS URL to the container.
    :vartype storage_account_url: str
    :ivar backup_schedule: Schedule for the backup if it is executed periodically.
    :vartype backup_schedule: ~azure.mgmt.web.v2016_08_01.models.BackupSchedule
    :ivar databases: Databases included in the backup.
    :vartype databases: list[~azure.mgmt.web.v2016_08_01.models.DatabaseBackupSetting]
    :ivar type_properties_type: Type of the backup. Known values are: "Default", "Clone",
     "Relocation", "Snapshot".
    :vartype type_properties_type: str or
     ~azure.mgmt.web.v2016_08_01.models.BackupRestoreOperationType
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'backup_request_name': {'key': 'properties.name', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'storage_account_url': {'key': 'properties.storageAccountUrl', 'type': 'str'},
        'backup_schedule': {'key': 'properties.backupSchedule', 'type': 'BackupSchedule'},
        'databases': {'key': 'properties.databases', 'type': '[DatabaseBackupSetting]'},
        'type_properties_type': {'key': 'properties.type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        backup_request_name: Optional[str] = None,
        enabled: Optional[bool] = None,
        storage_account_url: Optional[str] = None,
        backup_schedule: Optional["_models.BackupSchedule"] = None,
        databases: Optional[List["_models.DatabaseBackupSetting"]] = None,
        type_properties_type: Optional[Union[str, "_models.BackupRestoreOperationType"]] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword backup_request_name: Name of the backup.
        :paramtype backup_request_name: str
        :keyword enabled: True if the backup schedule is enabled (must be included in that case), false
         if the backup schedule should be disabled.
        :paramtype enabled: bool
        :keyword storage_account_url: SAS URL to the container.
        :paramtype storage_account_url: str
        :keyword backup_schedule: Schedule for the backup if it is executed periodically.
        :paramtype backup_schedule: ~azure.mgmt.web.v2016_08_01.models.BackupSchedule
        :keyword databases: Databases included in the backup.
        :paramtype databases: list[~azure.mgmt.web.v2016_08_01.models.DatabaseBackupSetting]
        :keyword type_properties_type: Type of the backup. Known values are: "Default", "Clone",
         "Relocation", "Snapshot".
        :paramtype type_properties_type: str or
         ~azure.mgmt.web.v2016_08_01.models.BackupRestoreOperationType
        """
        super(BackupRequest, self).__init__(kind=kind, **kwargs)
        self.backup_request_name = backup_request_name
        self.enabled = enabled
        self.storage_account_url = storage_account_url
        self.backup_schedule = backup_schedule
        self.databases = databases
        self.type_properties_type = type_properties_type


class BackupSchedule(msrest.serialization.Model):
    """Description of a backup schedule. Describes how often should be the backup performed and what should be the retention policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar frequency_interval: Required. How often the backup should be executed (e.g. for weekly
     backup, this should be set to 7 and FrequencyUnit should be set to Day).
    :vartype frequency_interval: int
    :ivar frequency_unit: Required. The unit of time for how often the backup should be executed
     (e.g. for weekly backup, this should be set to Day and FrequencyInterval should be set to 7).
     Known values are: "Day", "Hour". Default value: "Day".
    :vartype frequency_unit: str or ~azure.mgmt.web.v2016_08_01.models.FrequencyUnit
    :ivar keep_at_least_one_backup: Required. True if the retention policy should always keep at
     least one backup in the storage account, regardless how old it is; false otherwise.
    :vartype keep_at_least_one_backup: bool
    :ivar retention_period_in_days: Required. After how many days backups should be deleted.
    :vartype retention_period_in_days: int
    :ivar start_time: When the schedule should start working.
    :vartype start_time: ~datetime.datetime
    :ivar last_execution_time: Last time when this schedule was triggered.
    :vartype last_execution_time: ~datetime.datetime
    """

    _validation = {
        'frequency_interval': {'required': True},
        'frequency_unit': {'required': True},
        'keep_at_least_one_backup': {'required': True},
        'retention_period_in_days': {'required': True},
        'last_execution_time': {'readonly': True},
    }

    _attribute_map = {
        'frequency_interval': {'key': 'frequencyInterval', 'type': 'int'},
        'frequency_unit': {'key': 'frequencyUnit', 'type': 'str'},
        'keep_at_least_one_backup': {'key': 'keepAtLeastOneBackup', 'type': 'bool'},
        'retention_period_in_days': {'key': 'retentionPeriodInDays', 'type': 'int'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'last_execution_time': {'key': 'lastExecutionTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        frequency_interval: int = 7,
        frequency_unit: Union[str, "_models.FrequencyUnit"] = "Day",
        keep_at_least_one_backup: bool = True,
        retention_period_in_days: int = 30,
        start_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword frequency_interval: Required. How often the backup should be executed (e.g. for weekly
         backup, this should be set to 7 and FrequencyUnit should be set to Day).
        :paramtype frequency_interval: int
        :keyword frequency_unit: Required. The unit of time for how often the backup should be executed
         (e.g. for weekly backup, this should be set to Day and FrequencyInterval should be set to 7).
         Known values are: "Day", "Hour". Default value: "Day".
        :paramtype frequency_unit: str or ~azure.mgmt.web.v2016_08_01.models.FrequencyUnit
        :keyword keep_at_least_one_backup: Required. True if the retention policy should always keep at
         least one backup in the storage account, regardless how old it is; false otherwise.
        :paramtype keep_at_least_one_backup: bool
        :keyword retention_period_in_days: Required. After how many days backups should be deleted.
        :paramtype retention_period_in_days: int
        :keyword start_time: When the schedule should start working.
        :paramtype start_time: ~datetime.datetime
        """
        super(BackupSchedule, self).__init__(**kwargs)
        self.frequency_interval = frequency_interval
        self.frequency_unit = frequency_unit
        self.keep_at_least_one_backup = keep_at_least_one_backup
        self.retention_period_in_days = retention_period_in_days
        self.start_time = start_time
        self.last_execution_time = None


class CloningInfo(msrest.serialization.Model):
    """Information needed for cloning operation.

    All required parameters must be populated in order to send to Azure.

    :ivar correlation_id: Correlation ID of cloning operation. This ID ties multiple cloning
     operations
     together to use the same snapshot.
    :vartype correlation_id: str
    :ivar overwrite: :code:`<code>true</code>` to overwrite destination app; otherwise,
     :code:`<code>false</code>`.
    :vartype overwrite: bool
    :ivar clone_custom_host_names: :code:`<code>true</code>` to clone custom hostnames from source
     app; otherwise, :code:`<code>false</code>`.
    :vartype clone_custom_host_names: bool
    :ivar clone_source_control: :code:`<code>true</code>` to clone source control from source app;
     otherwise, :code:`<code>false</code>`.
    :vartype clone_source_control: bool
    :ivar source_web_app_id: Required. ARM resource ID of the source app. App resource ID is of the
     form
    /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}
     for production slots and
    /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName}
     for other slots.
    :vartype source_web_app_id: str
    :ivar hosting_environment: App Service Environment.
    :vartype hosting_environment: str
    :ivar app_settings_overrides: Application setting overrides for cloned app. If specified, these
     settings override the settings cloned
     from source app. Otherwise, application settings from source app are retained.
    :vartype app_settings_overrides: dict[str, str]
    :ivar configure_load_balancing: :code:`<code>true</code>` to configure load balancing for
     source and destination app.
    :vartype configure_load_balancing: bool
    :ivar traffic_manager_profile_id: ARM resource ID of the Traffic Manager profile to use, if it
     exists. Traffic Manager resource ID is of the form
    /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{profileName}.
    :vartype traffic_manager_profile_id: str
    :ivar traffic_manager_profile_name: Name of Traffic Manager profile to create. This is only
     needed if Traffic Manager profile does not already exist.
    :vartype traffic_manager_profile_name: str
    :ivar ignore_quotas: :code:`<code>true</code>` if quotas should be ignored; otherwise,
     :code:`<code>false</code>`.
    :vartype ignore_quotas: bool
    """

    _validation = {
        'source_web_app_id': {'required': True},
    }

    _attribute_map = {
        'correlation_id': {'key': 'correlationId', 'type': 'str'},
        'overwrite': {'key': 'overwrite', 'type': 'bool'},
        'clone_custom_host_names': {'key': 'cloneCustomHostNames', 'type': 'bool'},
        'clone_source_control': {'key': 'cloneSourceControl', 'type': 'bool'},
        'source_web_app_id': {'key': 'sourceWebAppId', 'type': 'str'},
        'hosting_environment': {'key': 'hostingEnvironment', 'type': 'str'},
        'app_settings_overrides': {'key': 'appSettingsOverrides', 'type': '{str}'},
        'configure_load_balancing': {'key': 'configureLoadBalancing', 'type': 'bool'},
        'traffic_manager_profile_id': {'key': 'trafficManagerProfileId', 'type': 'str'},
        'traffic_manager_profile_name': {'key': 'trafficManagerProfileName', 'type': 'str'},
        'ignore_quotas': {'key': 'ignoreQuotas', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        source_web_app_id: str,
        correlation_id: Optional[str] = None,
        overwrite: Optional[bool] = None,
        clone_custom_host_names: Optional[bool] = None,
        clone_source_control: Optional[bool] = None,
        hosting_environment: Optional[str] = None,
        app_settings_overrides: Optional[Dict[str, str]] = None,
        configure_load_balancing: Optional[bool] = None,
        traffic_manager_profile_id: Optional[str] = None,
        traffic_manager_profile_name: Optional[str] = None,
        ignore_quotas: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword correlation_id: Correlation ID of cloning operation. This ID ties multiple cloning
         operations
         together to use the same snapshot.
        :paramtype correlation_id: str
        :keyword overwrite: :code:`<code>true</code>` to overwrite destination app; otherwise,
         :code:`<code>false</code>`.
        :paramtype overwrite: bool
        :keyword clone_custom_host_names: :code:`<code>true</code>` to clone custom hostnames from
         source app; otherwise, :code:`<code>false</code>`.
        :paramtype clone_custom_host_names: bool
        :keyword clone_source_control: :code:`<code>true</code>` to clone source control from source
         app; otherwise, :code:`<code>false</code>`.
        :paramtype clone_source_control: bool
        :keyword source_web_app_id: Required. ARM resource ID of the source app. App resource ID is of
         the form
        /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}
         for production slots and
        /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName}
         for other slots.
        :paramtype source_web_app_id: str
        :keyword hosting_environment: App Service Environment.
        :paramtype hosting_environment: str
        :keyword app_settings_overrides: Application setting overrides for cloned app. If specified,
         these settings override the settings cloned
         from source app. Otherwise, application settings from source app are retained.
        :paramtype app_settings_overrides: dict[str, str]
        :keyword configure_load_balancing: :code:`<code>true</code>` to configure load balancing for
         source and destination app.
        :paramtype configure_load_balancing: bool
        :keyword traffic_manager_profile_id: ARM resource ID of the Traffic Manager profile to use, if
         it exists. Traffic Manager resource ID is of the form
        /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{profileName}.
        :paramtype traffic_manager_profile_id: str
        :keyword traffic_manager_profile_name: Name of Traffic Manager profile to create. This is only
         needed if Traffic Manager profile does not already exist.
        :paramtype traffic_manager_profile_name: str
        :keyword ignore_quotas: :code:`<code>true</code>` if quotas should be ignored; otherwise,
         :code:`<code>false</code>`.
        :paramtype ignore_quotas: bool
        """
        super(CloningInfo, self).__init__(**kwargs)
        self.correlation_id = correlation_id
        self.overwrite = overwrite
        self.clone_custom_host_names = clone_custom_host_names
        self.clone_source_control = clone_source_control
        self.source_web_app_id = source_web_app_id
        self.hosting_environment = hosting_environment
        self.app_settings_overrides = app_settings_overrides
        self.configure_load_balancing = configure_load_balancing
        self.traffic_manager_profile_id = traffic_manager_profile_id
        self.traffic_manager_profile_name = traffic_manager_profile_name
        self.ignore_quotas = ignore_quotas


class ConnectionStringDictionary(ProxyOnlyResource):
    """String dictionary resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar properties: Connection strings.
    :vartype properties: dict[str, ~azure.mgmt.web.v2016_08_01.models.ConnStringValueTypePair]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{ConnStringValueTypePair}'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        properties: Optional[Dict[str, "_models.ConnStringValueTypePair"]] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword properties: Connection strings.
        :paramtype properties: dict[str, ~azure.mgmt.web.v2016_08_01.models.ConnStringValueTypePair]
        """
        super(ConnectionStringDictionary, self).__init__(kind=kind, **kwargs)
        self.properties = properties


class ConnStringInfo(msrest.serialization.Model):
    """Database connection string information.

    :ivar name: Name of connection string.
    :vartype name: str
    :ivar connection_string: Connection string value.
    :vartype connection_string: str
    :ivar type: Type of database. Known values are: "MySql", "SQLServer", "SQLAzure", "Custom",
     "NotificationHub", "ServiceBus", "EventHub", "ApiHub", "DocDb", "RedisCache", "PostgreSQL".
    :vartype type: str or ~azure.mgmt.web.v2016_08_01.models.ConnectionStringType
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'connection_string': {'key': 'connectionString', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        connection_string: Optional[str] = None,
        type: Optional[Union[str, "_models.ConnectionStringType"]] = None,
        **kwargs
    ):
        """
        :keyword name: Name of connection string.
        :paramtype name: str
        :keyword connection_string: Connection string value.
        :paramtype connection_string: str
        :keyword type: Type of database. Known values are: "MySql", "SQLServer", "SQLAzure", "Custom",
         "NotificationHub", "ServiceBus", "EventHub", "ApiHub", "DocDb", "RedisCache", "PostgreSQL".
        :paramtype type: str or ~azure.mgmt.web.v2016_08_01.models.ConnectionStringType
        """
        super(ConnStringInfo, self).__init__(**kwargs)
        self.name = name
        self.connection_string = connection_string
        self.type = type


class ConnStringValueTypePair(msrest.serialization.Model):
    """Database connection string value to type pair.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Value of pair.
    :vartype value: str
    :ivar type: Required. Type of database. Known values are: "MySql", "SQLServer", "SQLAzure",
     "Custom", "NotificationHub", "ServiceBus", "EventHub", "ApiHub", "DocDb", "RedisCache",
     "PostgreSQL".
    :vartype type: str or ~azure.mgmt.web.v2016_08_01.models.ConnectionStringType
    """

    _validation = {
        'value': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: str,
        type: Union[str, "_models.ConnectionStringType"],
        **kwargs
    ):
        """
        :keyword value: Required. Value of pair.
        :paramtype value: str
        :keyword type: Required. Type of database. Known values are: "MySql", "SQLServer", "SQLAzure",
         "Custom", "NotificationHub", "ServiceBus", "EventHub", "ApiHub", "DocDb", "RedisCache",
         "PostgreSQL".
        :paramtype type: str or ~azure.mgmt.web.v2016_08_01.models.ConnectionStringType
        """
        super(ConnStringValueTypePair, self).__init__(**kwargs)
        self.value = value
        self.type = type


class ContinuousWebJob(ProxyOnlyResource):
    """Continuous Web Job Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar status: Job status. Known values are: "Initializing", "Starting", "Running",
     "PendingRestart", "Stopped".
    :vartype status: str or ~azure.mgmt.web.v2016_08_01.models.ContinuousWebJobStatus
    :ivar detailed_status: Detailed status.
    :vartype detailed_status: str
    :ivar log_url: Log URL.
    :vartype log_url: str
    :ivar name_properties_name: Job name. Used as job identifier in ARM resource URI.
    :vartype name_properties_name: str
    :ivar run_command: Run command.
    :vartype run_command: str
    :ivar url: Job URL.
    :vartype url: str
    :ivar extra_info_url: Extra Info URL.
    :vartype extra_info_url: str
    :ivar job_type: Job type. Known values are: "Continuous", "Triggered".
    :vartype job_type: str or ~azure.mgmt.web.v2016_08_01.models.WebJobType
    :ivar error: Error information.
    :vartype error: str
    :ivar using_sdk: Using SDK?.
    :vartype using_sdk: bool
    :ivar settings: Job settings.
    :vartype settings: dict[str, any]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'name_properties_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'detailed_status': {'key': 'properties.detailedStatus', 'type': 'str'},
        'log_url': {'key': 'properties.logUrl', 'type': 'str'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'run_command': {'key': 'properties.runCommand', 'type': 'str'},
        'url': {'key': 'properties.url', 'type': 'str'},
        'extra_info_url': {'key': 'properties.extraInfoUrl', 'type': 'str'},
        'job_type': {'key': 'properties.jobType', 'type': 'str'},
        'error': {'key': 'properties.error', 'type': 'str'},
        'using_sdk': {'key': 'properties.usingSdk', 'type': 'bool'},
        'settings': {'key': 'properties.settings', 'type': '{object}'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        status: Optional[Union[str, "_models.ContinuousWebJobStatus"]] = None,
        detailed_status: Optional[str] = None,
        log_url: Optional[str] = None,
        run_command: Optional[str] = None,
        url: Optional[str] = None,
        extra_info_url: Optional[str] = None,
        job_type: Optional[Union[str, "_models.WebJobType"]] = None,
        error: Optional[str] = None,
        using_sdk: Optional[bool] = None,
        settings: Optional[Dict[str, Any]] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword status: Job status. Known values are: "Initializing", "Starting", "Running",
         "PendingRestart", "Stopped".
        :paramtype status: str or ~azure.mgmt.web.v2016_08_01.models.ContinuousWebJobStatus
        :keyword detailed_status: Detailed status.
        :paramtype detailed_status: str
        :keyword log_url: Log URL.
        :paramtype log_url: str
        :keyword run_command: Run command.
        :paramtype run_command: str
        :keyword url: Job URL.
        :paramtype url: str
        :keyword extra_info_url: Extra Info URL.
        :paramtype extra_info_url: str
        :keyword job_type: Job type. Known values are: "Continuous", "Triggered".
        :paramtype job_type: str or ~azure.mgmt.web.v2016_08_01.models.WebJobType
        :keyword error: Error information.
        :paramtype error: str
        :keyword using_sdk: Using SDK?.
        :paramtype using_sdk: bool
        :keyword settings: Job settings.
        :paramtype settings: dict[str, any]
        """
        super(ContinuousWebJob, self).__init__(kind=kind, **kwargs)
        self.status = status
        self.detailed_status = detailed_status
        self.log_url = log_url
        self.name_properties_name = None
        self.run_command = run_command
        self.url = url
        self.extra_info_url = extra_info_url
        self.job_type = job_type
        self.error = error
        self.using_sdk = using_sdk
        self.settings = settings


class ContinuousWebJobCollection(msrest.serialization.Model):
    """Collection of Kudu continuous web job information elements.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2016_08_01.models.ContinuousWebJob]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ContinuousWebJob]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["_models.ContinuousWebJob"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2016_08_01.models.ContinuousWebJob]
        :keyword next_link: Link to next page of resources.
        :paramtype next_link: str
        """
        super(ContinuousWebJobCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class CorsSettings(msrest.serialization.Model):
    """Cross-Origin Resource Sharing (CORS) settings for the app.

    :ivar allowed_origins: Gets or sets the list of origins that should be allowed to make
     cross-origin
     calls (for example: http://example.com:12345). Use "*" to allow all.
    :vartype allowed_origins: list[str]
    """

    _attribute_map = {
        'allowed_origins': {'key': 'allowedOrigins', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        allowed_origins: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword allowed_origins: Gets or sets the list of origins that should be allowed to make
         cross-origin
         calls (for example: http://example.com:12345). Use "*" to allow all.
        :paramtype allowed_origins: list[str]
        """
        super(CorsSettings, self).__init__(**kwargs)
        self.allowed_origins = allowed_origins


class CsmPublishingProfileOptions(msrest.serialization.Model):
    """Publishing options for requested profile.

    :ivar format: Name of the format. Valid values are:
     FileZilla3
     WebDeploy -- default
     Ftp. Known values are: "FileZilla3", "WebDeploy", "Ftp".
    :vartype format: str or ~azure.mgmt.web.v2016_08_01.models.PublishingProfileFormat
    """

    _attribute_map = {
        'format': {'key': 'format', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        format: Optional[Union[str, "_models.PublishingProfileFormat"]] = None,
        **kwargs
    ):
        """
        :keyword format: Name of the format. Valid values are:
         FileZilla3
         WebDeploy -- default
         Ftp. Known values are: "FileZilla3", "WebDeploy", "Ftp".
        :paramtype format: str or ~azure.mgmt.web.v2016_08_01.models.PublishingProfileFormat
        """
        super(CsmPublishingProfileOptions, self).__init__(**kwargs)
        self.format = format


class CsmSlotEntity(msrest.serialization.Model):
    """Deployment slot parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar target_slot: Required. Destination deployment slot during swap operation.
    :vartype target_slot: str
    :ivar preserve_vnet: Required. :code:`<code>true</code>` to preserve Virtual Network to the
     slot during swap; otherwise, :code:`<code>false</code>`.
    :vartype preserve_vnet: bool
    """

    _validation = {
        'target_slot': {'required': True},
        'preserve_vnet': {'required': True},
    }

    _attribute_map = {
        'target_slot': {'key': 'targetSlot', 'type': 'str'},
        'preserve_vnet': {'key': 'preserveVnet', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        target_slot: str,
        preserve_vnet: bool,
        **kwargs
    ):
        """
        :keyword target_slot: Required. Destination deployment slot during swap operation.
        :paramtype target_slot: str
        :keyword preserve_vnet: Required. :code:`<code>true</code>` to preserve Virtual Network to the
         slot during swap; otherwise, :code:`<code>false</code>`.
        :paramtype preserve_vnet: bool
        """
        super(CsmSlotEntity, self).__init__(**kwargs)
        self.target_slot = target_slot
        self.preserve_vnet = preserve_vnet


class CsmUsageQuota(msrest.serialization.Model):
    """Usage of the quota resource.

    :ivar unit: Units of measurement for the quota resource.
    :vartype unit: str
    :ivar next_reset_time: Next reset time for the resource counter.
    :vartype next_reset_time: ~datetime.datetime
    :ivar current_value: The current value of the resource counter.
    :vartype current_value: long
    :ivar limit: The resource limit.
    :vartype limit: long
    :ivar name: Quota name.
    :vartype name: ~azure.mgmt.web.v2016_08_01.models.LocalizableString
    """

    _attribute_map = {
        'unit': {'key': 'unit', 'type': 'str'},
        'next_reset_time': {'key': 'nextResetTime', 'type': 'iso-8601'},
        'current_value': {'key': 'currentValue', 'type': 'long'},
        'limit': {'key': 'limit', 'type': 'long'},
        'name': {'key': 'name', 'type': 'LocalizableString'},
    }

    def __init__(
        self,
        *,
        unit: Optional[str] = None,
        next_reset_time: Optional[datetime.datetime] = None,
        current_value: Optional[int] = None,
        limit: Optional[int] = None,
        name: Optional["_models.LocalizableString"] = None,
        **kwargs
    ):
        """
        :keyword unit: Units of measurement for the quota resource.
        :paramtype unit: str
        :keyword next_reset_time: Next reset time for the resource counter.
        :paramtype next_reset_time: ~datetime.datetime
        :keyword current_value: The current value of the resource counter.
        :paramtype current_value: long
        :keyword limit: The resource limit.
        :paramtype limit: long
        :keyword name: Quota name.
        :paramtype name: ~azure.mgmt.web.v2016_08_01.models.LocalizableString
        """
        super(CsmUsageQuota, self).__init__(**kwargs)
        self.unit = unit
        self.next_reset_time = next_reset_time
        self.current_value = current_value
        self.limit = limit
        self.name = name


class CsmUsageQuotaCollection(msrest.serialization.Model):
    """Collection of CSM usage quotas.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2016_08_01.models.CsmUsageQuota]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CsmUsageQuota]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["_models.CsmUsageQuota"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2016_08_01.models.CsmUsageQuota]
        """
        super(CsmUsageQuotaCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class CustomHostnameAnalysisResult(ProxyOnlyResource):
    """Custom domain analysis.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar is_hostname_already_verified: :code:`<code>true</code>` if hostname is already verified;
     otherwise, :code:`<code>false</code>`.
    :vartype is_hostname_already_verified: bool
    :ivar custom_domain_verification_test: DNS verification test result. Known values are:
     "Passed", "Failed", "Skipped".
    :vartype custom_domain_verification_test: str or
     ~azure.mgmt.web.v2016_08_01.models.DnsVerificationTestResult
    :ivar custom_domain_verification_failure_info: Raw failure information if DNS verification
     fails.
    :vartype custom_domain_verification_failure_info:
     ~azure.mgmt.web.v2016_08_01.models.ErrorEntity
    :ivar has_conflict_on_scale_unit: :code:`<code>true</code>` if there is a conflict on a scale
     unit; otherwise, :code:`<code>false</code>`.
    :vartype has_conflict_on_scale_unit: bool
    :ivar has_conflict_across_subscription: :code:`<code>true</code>` if there is a conflict across
     subscriptions; otherwise, :code:`<code>false</code>`.
    :vartype has_conflict_across_subscription: bool
    :ivar conflicting_app_resource_id: Name of the conflicting app on scale unit if it's within the
     same subscription.
    :vartype conflicting_app_resource_id: str
    :ivar c_name_records: CName records controller can see for this hostname.
    :vartype c_name_records: list[str]
    :ivar txt_records: TXT records controller can see for this hostname.
    :vartype txt_records: list[str]
    :ivar a_records: A records controller can see for this hostname.
    :vartype a_records: list[str]
    :ivar alternate_c_name_records: Alternate CName records controller can see for this hostname.
    :vartype alternate_c_name_records: list[str]
    :ivar alternate_txt_records: Alternate TXT records controller can see for this hostname.
    :vartype alternate_txt_records: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'is_hostname_already_verified': {'readonly': True},
        'custom_domain_verification_test': {'readonly': True},
        'custom_domain_verification_failure_info': {'readonly': True},
        'has_conflict_on_scale_unit': {'readonly': True},
        'has_conflict_across_subscription': {'readonly': True},
        'conflicting_app_resource_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'is_hostname_already_verified': {'key': 'properties.isHostnameAlreadyVerified', 'type': 'bool'},
        'custom_domain_verification_test': {'key': 'properties.customDomainVerificationTest', 'type': 'str'},
        'custom_domain_verification_failure_info': {'key': 'properties.customDomainVerificationFailureInfo', 'type': 'ErrorEntity'},
        'has_conflict_on_scale_unit': {'key': 'properties.hasConflictOnScaleUnit', 'type': 'bool'},
        'has_conflict_across_subscription': {'key': 'properties.hasConflictAcrossSubscription', 'type': 'bool'},
        'conflicting_app_resource_id': {'key': 'properties.conflictingAppResourceId', 'type': 'str'},
        'c_name_records': {'key': 'properties.cNameRecords', 'type': '[str]'},
        'txt_records': {'key': 'properties.txtRecords', 'type': '[str]'},
        'a_records': {'key': 'properties.aRecords', 'type': '[str]'},
        'alternate_c_name_records': {'key': 'properties.alternateCNameRecords', 'type': '[str]'},
        'alternate_txt_records': {'key': 'properties.alternateTxtRecords', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        c_name_records: Optional[List[str]] = None,
        txt_records: Optional[List[str]] = None,
        a_records: Optional[List[str]] = None,
        alternate_c_name_records: Optional[List[str]] = None,
        alternate_txt_records: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword c_name_records: CName records controller can see for this hostname.
        :paramtype c_name_records: list[str]
        :keyword txt_records: TXT records controller can see for this hostname.
        :paramtype txt_records: list[str]
        :keyword a_records: A records controller can see for this hostname.
        :paramtype a_records: list[str]
        :keyword alternate_c_name_records: Alternate CName records controller can see for this
         hostname.
        :paramtype alternate_c_name_records: list[str]
        :keyword alternate_txt_records: Alternate TXT records controller can see for this hostname.
        :paramtype alternate_txt_records: list[str]
        """
        super(CustomHostnameAnalysisResult, self).__init__(kind=kind, **kwargs)
        self.is_hostname_already_verified = None
        self.custom_domain_verification_test = None
        self.custom_domain_verification_failure_info = None
        self.has_conflict_on_scale_unit = None
        self.has_conflict_across_subscription = None
        self.conflicting_app_resource_id = None
        self.c_name_records = c_name_records
        self.txt_records = txt_records
        self.a_records = a_records
        self.alternate_c_name_records = alternate_c_name_records
        self.alternate_txt_records = alternate_txt_records


class DatabaseBackupSetting(msrest.serialization.Model):
    """Database backup settings.

    All required parameters must be populated in order to send to Azure.

    :ivar database_type: Required. Database type (e.g. SqlAzure / MySql). Known values are:
     "SqlAzure", "MySql", "LocalMySql", "PostgreSql".
    :vartype database_type: str or ~azure.mgmt.web.v2016_08_01.models.DatabaseType
    :ivar name:
    :vartype name: str
    :ivar connection_string_name: Contains a connection string name that is linked to the
     SiteConfig.ConnectionStrings.
     This is used during restore with overwrite connection strings options.
    :vartype connection_string_name: str
    :ivar connection_string: Contains a connection string to a database which is being backed up or
     restored. If the restore should happen to a new database, the database name inside is the new
     one.
    :vartype connection_string: str
    """

    _validation = {
        'database_type': {'required': True},
    }

    _attribute_map = {
        'database_type': {'key': 'databaseType', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'connection_string_name': {'key': 'connectionStringName', 'type': 'str'},
        'connection_string': {'key': 'connectionString', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        database_type: Union[str, "_models.DatabaseType"],
        name: Optional[str] = None,
        connection_string_name: Optional[str] = None,
        connection_string: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword database_type: Required. Database type (e.g. SqlAzure / MySql). Known values are:
         "SqlAzure", "MySql", "LocalMySql", "PostgreSql".
        :paramtype database_type: str or ~azure.mgmt.web.v2016_08_01.models.DatabaseType
        :keyword name:
        :paramtype name: str
        :keyword connection_string_name: Contains a connection string name that is linked to the
         SiteConfig.ConnectionStrings.
         This is used during restore with overwrite connection strings options.
        :paramtype connection_string_name: str
        :keyword connection_string: Contains a connection string to a database which is being backed up
         or restored. If the restore should happen to a new database, the database name inside is the
         new one.
        :paramtype connection_string: str
        """
        super(DatabaseBackupSetting, self).__init__(**kwargs)
        self.database_type = database_type
        self.name = name
        self.connection_string_name = connection_string_name
        self.connection_string = connection_string


class Deployment(ProxyOnlyResource):
    """User credentials used for publishing activity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar id_properties_id: Identifier for deployment.
    :vartype id_properties_id: str
    :ivar status: Deployment status.
    :vartype status: int
    :ivar message: Details about deployment status.
    :vartype message: str
    :ivar author: Who authored the deployment.
    :vartype author: str
    :ivar deployer: Who performed the deployment.
    :vartype deployer: str
    :ivar author_email: Author email.
    :vartype author_email: str
    :ivar start_time: Start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time.
    :vartype end_time: ~datetime.datetime
    :ivar active: True if deployment is currently active, false if completed and null if not
     started.
    :vartype active: bool
    :ivar details: Details on deployment.
    :vartype details: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'id_properties_id': {'key': 'properties.id', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'int'},
        'message': {'key': 'properties.message', 'type': 'str'},
        'author': {'key': 'properties.author', 'type': 'str'},
        'deployer': {'key': 'properties.deployer', 'type': 'str'},
        'author_email': {'key': 'properties.authorEmail', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'active': {'key': 'properties.active', 'type': 'bool'},
        'details': {'key': 'properties.details', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        id_properties_id: Optional[str] = None,
        status: Optional[int] = None,
        message: Optional[str] = None,
        author: Optional[str] = None,
        deployer: Optional[str] = None,
        author_email: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        active: Optional[bool] = None,
        details: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword id_properties_id: Identifier for deployment.
        :paramtype id_properties_id: str
        :keyword status: Deployment status.
        :paramtype status: int
        :keyword message: Details about deployment status.
        :paramtype message: str
        :keyword author: Who authored the deployment.
        :paramtype author: str
        :keyword deployer: Who performed the deployment.
        :paramtype deployer: str
        :keyword author_email: Author email.
        :paramtype author_email: str
        :keyword start_time: Start time.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: End time.
        :paramtype end_time: ~datetime.datetime
        :keyword active: True if deployment is currently active, false if completed and null if not
         started.
        :paramtype active: bool
        :keyword details: Details on deployment.
        :paramtype details: str
        """
        super(Deployment, self).__init__(kind=kind, **kwargs)
        self.id_properties_id = id_properties_id
        self.status = status
        self.message = message
        self.author = author
        self.deployer = deployer
        self.author_email = author_email
        self.start_time = start_time
        self.end_time = end_time
        self.active = active
        self.details = details


class DeploymentCollection(msrest.serialization.Model):
    """Collection of app deployments.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2016_08_01.models.Deployment]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Deployment]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["_models.Deployment"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2016_08_01.models.Deployment]
        """
        super(DeploymentCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class EnabledConfig(msrest.serialization.Model):
    """Enabled configuration.

    :ivar enabled: True if configuration is enabled, false if it is disabled and null if
     configuration is not set.
    :vartype enabled: bool
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword enabled: True if configuration is enabled, false if it is disabled and null if
         configuration is not set.
        :paramtype enabled: bool
        """
        super(EnabledConfig, self).__init__(**kwargs)
        self.enabled = enabled


class ErrorEntity(msrest.serialization.Model):
    """Body of the error response returned from the API.

    :ivar extended_code: Type of error.
    :vartype extended_code: str
    :ivar message_template: Message template.
    :vartype message_template: str
    :ivar parameters: Parameters for the template.
    :vartype parameters: list[str]
    :ivar inner_errors: Inner errors.
    :vartype inner_errors: list[~azure.mgmt.web.v2016_08_01.models.ErrorEntity]
    :ivar code: Basic error code.
    :vartype code: str
    :ivar message: Any details of the error.
    :vartype message: str
    """

    _attribute_map = {
        'extended_code': {'key': 'extendedCode', 'type': 'str'},
        'message_template': {'key': 'messageTemplate', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '[str]'},
        'inner_errors': {'key': 'innerErrors', 'type': '[ErrorEntity]'},
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        extended_code: Optional[str] = None,
        message_template: Optional[str] = None,
        parameters: Optional[List[str]] = None,
        inner_errors: Optional[List["_models.ErrorEntity"]] = None,
        code: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword extended_code: Type of error.
        :paramtype extended_code: str
        :keyword message_template: Message template.
        :paramtype message_template: str
        :keyword parameters: Parameters for the template.
        :paramtype parameters: list[str]
        :keyword inner_errors: Inner errors.
        :paramtype inner_errors: list[~azure.mgmt.web.v2016_08_01.models.ErrorEntity]
        :keyword code: Basic error code.
        :paramtype code: str
        :keyword message: Any details of the error.
        :paramtype message: str
        """
        super(ErrorEntity, self).__init__(**kwargs)
        self.extended_code = extended_code
        self.message_template = message_template
        self.parameters = parameters
        self.inner_errors = inner_errors
        self.code = code
        self.message = message


class Experiments(msrest.serialization.Model):
    """Routing rules in production experiments.

    :ivar ramp_up_rules: List of ramp-up rules.
    :vartype ramp_up_rules: list[~azure.mgmt.web.v2016_08_01.models.RampUpRule]
    """

    _attribute_map = {
        'ramp_up_rules': {'key': 'rampUpRules', 'type': '[RampUpRule]'},
    }

    def __init__(
        self,
        *,
        ramp_up_rules: Optional[List["_models.RampUpRule"]] = None,
        **kwargs
    ):
        """
        :keyword ramp_up_rules: List of ramp-up rules.
        :paramtype ramp_up_rules: list[~azure.mgmt.web.v2016_08_01.models.RampUpRule]
        """
        super(Experiments, self).__init__(**kwargs)
        self.ramp_up_rules = ramp_up_rules


class FileSystemApplicationLogsConfig(msrest.serialization.Model):
    """Application logs to file system configuration.

    :ivar level: Log level. Known values are: "Off", "Verbose", "Information", "Warning", "Error".
    :vartype level: str or ~azure.mgmt.web.v2016_08_01.models.LogLevel
    """

    _attribute_map = {
        'level': {'key': 'level', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        level: Optional[Union[str, "_models.LogLevel"]] = None,
        **kwargs
    ):
        """
        :keyword level: Log level. Known values are: "Off", "Verbose", "Information", "Warning",
         "Error".
        :paramtype level: str or ~azure.mgmt.web.v2016_08_01.models.LogLevel
        """
        super(FileSystemApplicationLogsConfig, self).__init__(**kwargs)
        self.level = level


class FileSystemHttpLogsConfig(msrest.serialization.Model):
    """Http logs to file system configuration.

    :ivar retention_in_mb: Maximum size in megabytes that http log files can use.
     When reached old log files will be removed to make space for new ones.
     Value can range between 25 and 100.
    :vartype retention_in_mb: int
    :ivar retention_in_days: Retention in days.
     Remove files older than X days.
     0 or lower means no retention.
    :vartype retention_in_days: int
    :ivar enabled: True if configuration is enabled, false if it is disabled and null if
     configuration is not set.
    :vartype enabled: bool
    """

    _validation = {
        'retention_in_mb': {'maximum': 100, 'minimum': 25},
    }

    _attribute_map = {
        'retention_in_mb': {'key': 'retentionInMb', 'type': 'int'},
        'retention_in_days': {'key': 'retentionInDays', 'type': 'int'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        retention_in_mb: Optional[int] = None,
        retention_in_days: Optional[int] = None,
        enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword retention_in_mb: Maximum size in megabytes that http log files can use.
         When reached old log files will be removed to make space for new ones.
         Value can range between 25 and 100.
        :paramtype retention_in_mb: int
        :keyword retention_in_days: Retention in days.
         Remove files older than X days.
         0 or lower means no retention.
        :paramtype retention_in_days: int
        :keyword enabled: True if configuration is enabled, false if it is disabled and null if
         configuration is not set.
        :paramtype enabled: bool
        """
        super(FileSystemHttpLogsConfig, self).__init__(**kwargs)
        self.retention_in_mb = retention_in_mb
        self.retention_in_days = retention_in_days
        self.enabled = enabled


class FunctionEnvelope(ProxyOnlyResource):
    """Web Job Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar name_properties_name: Function name.
    :vartype name_properties_name: str
    :ivar function_app_id: Function App ID.
    :vartype function_app_id: str
    :ivar script_root_path_href: Script root path URI.
    :vartype script_root_path_href: str
    :ivar script_href: Script URI.
    :vartype script_href: str
    :ivar config_href: Config URI.
    :vartype config_href: str
    :ivar secrets_file_href: Secrets file URI.
    :vartype secrets_file_href: str
    :ivar href: Function URI.
    :vartype href: str
    :ivar config: Config information.
    :vartype config: any
    :ivar files: File list.
    :vartype files: dict[str, str]
    :ivar test_data: Test data used when testing via the Azure Portal.
    :vartype test_data: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'name_properties_name': {'readonly': True},
        'function_app_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'function_app_id': {'key': 'properties.functionAppId', 'type': 'str'},
        'script_root_path_href': {'key': 'properties.scriptRootPathHref', 'type': 'str'},
        'script_href': {'key': 'properties.scriptHref', 'type': 'str'},
        'config_href': {'key': 'properties.configHref', 'type': 'str'},
        'secrets_file_href': {'key': 'properties.secretsFileHref', 'type': 'str'},
        'href': {'key': 'properties.href', 'type': 'str'},
        'config': {'key': 'properties.config', 'type': 'object'},
        'files': {'key': 'properties.files', 'type': '{str}'},
        'test_data': {'key': 'properties.testData', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        script_root_path_href: Optional[str] = None,
        script_href: Optional[str] = None,
        config_href: Optional[str] = None,
        secrets_file_href: Optional[str] = None,
        href: Optional[str] = None,
        config: Optional[Any] = None,
        files: Optional[Dict[str, str]] = None,
        test_data: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword script_root_path_href: Script root path URI.
        :paramtype script_root_path_href: str
        :keyword script_href: Script URI.
        :paramtype script_href: str
        :keyword config_href: Config URI.
        :paramtype config_href: str
        :keyword secrets_file_href: Secrets file URI.
        :paramtype secrets_file_href: str
        :keyword href: Function URI.
        :paramtype href: str
        :keyword config: Config information.
        :paramtype config: any
        :keyword files: File list.
        :paramtype files: dict[str, str]
        :keyword test_data: Test data used when testing via the Azure Portal.
        :paramtype test_data: str
        """
        super(FunctionEnvelope, self).__init__(kind=kind, **kwargs)
        self.name_properties_name = None
        self.function_app_id = None
        self.script_root_path_href = script_root_path_href
        self.script_href = script_href
        self.config_href = config_href
        self.secrets_file_href = secrets_file_href
        self.href = href
        self.config = config
        self.files = files
        self.test_data = test_data


class FunctionEnvelopeCollection(msrest.serialization.Model):
    """Collection of Kudu function information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2016_08_01.models.FunctionEnvelope]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[FunctionEnvelope]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["_models.FunctionEnvelope"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2016_08_01.models.FunctionEnvelope]
        """
        super(FunctionEnvelopeCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class FunctionSecrets(ProxyOnlyResource):
    """Function secrets.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar key: Secret key.
    :vartype key: str
    :ivar trigger_url: Trigger URL.
    :vartype trigger_url: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'key': {'key': 'properties.key', 'type': 'str'},
        'trigger_url': {'key': 'properties.triggerUrl', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        key: Optional[str] = None,
        trigger_url: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword key: Secret key.
        :paramtype key: str
        :keyword trigger_url: Trigger URL.
        :paramtype trigger_url: str
        """
        super(FunctionSecrets, self).__init__(kind=kind, **kwargs)
        self.key = key
        self.trigger_url = trigger_url


class HandlerMapping(msrest.serialization.Model):
    """The IIS handler mappings used to define which handler processes HTTP requests with certain extension. 
For example, it is used to configure php-cgi.exe process to handle all HTTP requests with *.php extension.

    :ivar extension: Requests with this extension will be handled using the specified FastCGI
     application.
    :vartype extension: str
    :ivar script_processor: The absolute path to the FastCGI application.
    :vartype script_processor: str
    :ivar arguments: Command-line arguments to be passed to the script processor.
    :vartype arguments: str
    """

    _attribute_map = {
        'extension': {'key': 'extension', 'type': 'str'},
        'script_processor': {'key': 'scriptProcessor', 'type': 'str'},
        'arguments': {'key': 'arguments', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        extension: Optional[str] = None,
        script_processor: Optional[str] = None,
        arguments: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword extension: Requests with this extension will be handled using the specified FastCGI
         application.
        :paramtype extension: str
        :keyword script_processor: The absolute path to the FastCGI application.
        :paramtype script_processor: str
        :keyword arguments: Command-line arguments to be passed to the script processor.
        :paramtype arguments: str
        """
        super(HandlerMapping, self).__init__(**kwargs)
        self.extension = extension
        self.script_processor = script_processor
        self.arguments = arguments


class HostingEnvironmentProfile(msrest.serialization.Model):
    """Specification for an App Service Environment to use for this resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID of the App Service Environment.
    :vartype id: str
    :ivar name: Name of the App Service Environment.
    :vartype name: str
    :ivar type: Resource type of the App Service Environment.
    :vartype type: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID of the App Service Environment.
        :paramtype id: str
        """
        super(HostingEnvironmentProfile, self).__init__(**kwargs)
        self.id = id
        self.name = None
        self.type = None


class HostNameBinding(ProxyOnlyResource):
    """A hostname binding object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar site_name: App Service app name.
    :vartype site_name: str
    :ivar domain_id: Fully qualified ARM domain resource URI.
    :vartype domain_id: str
    :ivar azure_resource_name: Azure resource name.
    :vartype azure_resource_name: str
    :ivar azure_resource_type: Azure resource type. Known values are: "Website", "TrafficManager".
    :vartype azure_resource_type: str or ~azure.mgmt.web.v2016_08_01.models.AzureResourceType
    :ivar custom_host_name_dns_record_type: Custom DNS record type. Known values are: "CName", "A".
    :vartype custom_host_name_dns_record_type: str or
     ~azure.mgmt.web.v2016_08_01.models.CustomHostNameDnsRecordType
    :ivar host_name_type: Hostname type. Known values are: "Verified", "Managed".
    :vartype host_name_type: str or ~azure.mgmt.web.v2016_08_01.models.HostNameType
    :ivar ssl_state: SSL type. Known values are: "Disabled", "SniEnabled", "IpBasedEnabled".
    :vartype ssl_state: str or ~azure.mgmt.web.v2016_08_01.models.SslState
    :ivar thumbprint: SSL certificate thumbprint.
    :vartype thumbprint: str
    :ivar virtual_ip: Virtual IP address assigned to the hostname if IP based SSL is enabled.
    :vartype virtual_ip: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'virtual_ip': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'site_name': {'key': 'properties.siteName', 'type': 'str'},
        'domain_id': {'key': 'properties.domainId', 'type': 'str'},
        'azure_resource_name': {'key': 'properties.azureResourceName', 'type': 'str'},
        'azure_resource_type': {'key': 'properties.azureResourceType', 'type': 'str'},
        'custom_host_name_dns_record_type': {'key': 'properties.customHostNameDnsRecordType', 'type': 'str'},
        'host_name_type': {'key': 'properties.hostNameType', 'type': 'str'},
        'ssl_state': {'key': 'properties.sslState', 'type': 'str'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
        'virtual_ip': {'key': 'properties.virtualIP', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        site_name: Optional[str] = None,
        domain_id: Optional[str] = None,
        azure_resource_name: Optional[str] = None,
        azure_resource_type: Optional[Union[str, "_models.AzureResourceType"]] = None,
        custom_host_name_dns_record_type: Optional[Union[str, "_models.CustomHostNameDnsRecordType"]] = None,
        host_name_type: Optional[Union[str, "_models.HostNameType"]] = None,
        ssl_state: Optional[Union[str, "_models.SslState"]] = None,
        thumbprint: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword site_name: App Service app name.
        :paramtype site_name: str
        :keyword domain_id: Fully qualified ARM domain resource URI.
        :paramtype domain_id: str
        :keyword azure_resource_name: Azure resource name.
        :paramtype azure_resource_name: str
        :keyword azure_resource_type: Azure resource type. Known values are: "Website",
         "TrafficManager".
        :paramtype azure_resource_type: str or ~azure.mgmt.web.v2016_08_01.models.AzureResourceType
        :keyword custom_host_name_dns_record_type: Custom DNS record type. Known values are: "CName",
         "A".
        :paramtype custom_host_name_dns_record_type: str or
         ~azure.mgmt.web.v2016_08_01.models.CustomHostNameDnsRecordType
        :keyword host_name_type: Hostname type. Known values are: "Verified", "Managed".
        :paramtype host_name_type: str or ~azure.mgmt.web.v2016_08_01.models.HostNameType
        :keyword ssl_state: SSL type. Known values are: "Disabled", "SniEnabled", "IpBasedEnabled".
        :paramtype ssl_state: str or ~azure.mgmt.web.v2016_08_01.models.SslState
        :keyword thumbprint: SSL certificate thumbprint.
        :paramtype thumbprint: str
        """
        super(HostNameBinding, self).__init__(kind=kind, **kwargs)
        self.site_name = site_name
        self.domain_id = domain_id
        self.azure_resource_name = azure_resource_name
        self.azure_resource_type = azure_resource_type
        self.custom_host_name_dns_record_type = custom_host_name_dns_record_type
        self.host_name_type = host_name_type
        self.ssl_state = ssl_state
        self.thumbprint = thumbprint
        self.virtual_ip = None


class HostNameBindingCollection(msrest.serialization.Model):
    """Collection of hostname bindings.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2016_08_01.models.HostNameBinding]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[HostNameBinding]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["_models.HostNameBinding"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2016_08_01.models.HostNameBinding]
        """
        super(HostNameBindingCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class HostNameSslState(msrest.serialization.Model):
    """SSL-enabled hostname.

    :ivar name: Hostname.
    :vartype name: str
    :ivar ssl_state: SSL type. Known values are: "Disabled", "SniEnabled", "IpBasedEnabled".
    :vartype ssl_state: str or ~azure.mgmt.web.v2016_08_01.models.SslState
    :ivar virtual_ip: Virtual IP address assigned to the hostname if IP based SSL is enabled.
    :vartype virtual_ip: str
    :ivar thumbprint: SSL certificate thumbprint.
    :vartype thumbprint: str
    :ivar to_update: Set to :code:`<code>true</code>` to update existing hostname.
    :vartype to_update: bool
    :ivar host_type: Indicates whether the hostname is a standard or repository hostname. Known
     values are: "Standard", "Repository".
    :vartype host_type: str or ~azure.mgmt.web.v2016_08_01.models.HostType
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'ssl_state': {'key': 'sslState', 'type': 'str'},
        'virtual_ip': {'key': 'virtualIP', 'type': 'str'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'to_update': {'key': 'toUpdate', 'type': 'bool'},
        'host_type': {'key': 'hostType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        ssl_state: Optional[Union[str, "_models.SslState"]] = None,
        virtual_ip: Optional[str] = None,
        thumbprint: Optional[str] = None,
        to_update: Optional[bool] = None,
        host_type: Optional[Union[str, "_models.HostType"]] = None,
        **kwargs
    ):
        """
        :keyword name: Hostname.
        :paramtype name: str
        :keyword ssl_state: SSL type. Known values are: "Disabled", "SniEnabled", "IpBasedEnabled".
        :paramtype ssl_state: str or ~azure.mgmt.web.v2016_08_01.models.SslState
        :keyword virtual_ip: Virtual IP address assigned to the hostname if IP based SSL is enabled.
        :paramtype virtual_ip: str
        :keyword thumbprint: SSL certificate thumbprint.
        :paramtype thumbprint: str
        :keyword to_update: Set to :code:`<code>true</code>` to update existing hostname.
        :paramtype to_update: bool
        :keyword host_type: Indicates whether the hostname is a standard or repository hostname. Known
         values are: "Standard", "Repository".
        :paramtype host_type: str or ~azure.mgmt.web.v2016_08_01.models.HostType
        """
        super(HostNameSslState, self).__init__(**kwargs)
        self.name = name
        self.ssl_state = ssl_state
        self.virtual_ip = virtual_ip
        self.thumbprint = thumbprint
        self.to_update = to_update
        self.host_type = host_type


class HttpLogsConfig(msrest.serialization.Model):
    """Http logs configuration.

    :ivar file_system: Http logs to file system configuration.
    :vartype file_system: ~azure.mgmt.web.v2016_08_01.models.FileSystemHttpLogsConfig
    :ivar azure_blob_storage: Http logs to azure blob storage configuration.
    :vartype azure_blob_storage: ~azure.mgmt.web.v2016_08_01.models.AzureBlobStorageHttpLogsConfig
    """

    _attribute_map = {
        'file_system': {'key': 'fileSystem', 'type': 'FileSystemHttpLogsConfig'},
        'azure_blob_storage': {'key': 'azureBlobStorage', 'type': 'AzureBlobStorageHttpLogsConfig'},
    }

    def __init__(
        self,
        *,
        file_system: Optional["_models.FileSystemHttpLogsConfig"] = None,
        azure_blob_storage: Optional["_models.AzureBlobStorageHttpLogsConfig"] = None,
        **kwargs
    ):
        """
        :keyword file_system: Http logs to file system configuration.
        :paramtype file_system: ~azure.mgmt.web.v2016_08_01.models.FileSystemHttpLogsConfig
        :keyword azure_blob_storage: Http logs to azure blob storage configuration.
        :paramtype azure_blob_storage:
         ~azure.mgmt.web.v2016_08_01.models.AzureBlobStorageHttpLogsConfig
        """
        super(HttpLogsConfig, self).__init__(**kwargs)
        self.file_system = file_system
        self.azure_blob_storage = azure_blob_storage


class HybridConnection(ProxyOnlyResource):
    """Hybrid Connection contract. This is used to configure a Hybrid Connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar service_bus_namespace: The name of the Service Bus namespace.
    :vartype service_bus_namespace: str
    :ivar relay_name: The name of the Service Bus relay.
    :vartype relay_name: str
    :ivar relay_arm_uri: The ARM URI to the Service Bus relay.
    :vartype relay_arm_uri: str
    :ivar hostname: The hostname of the endpoint.
    :vartype hostname: str
    :ivar port: The port of the endpoint.
    :vartype port: int
    :ivar send_key_name: The name of the Service Bus key which has Send permissions. This is used
     to authenticate to Service Bus.
    :vartype send_key_name: str
    :ivar send_key_value: The value of the Service Bus key. This is used to authenticate to Service
     Bus. In ARM this key will not be returned
     normally, use the POST /listKeys API instead.
    :vartype send_key_value: str
    :ivar service_bus_suffix: The suffix for the service bus endpoint. By default this is
     .servicebus.windows.net.
    :vartype service_bus_suffix: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'service_bus_namespace': {'key': 'properties.serviceBusNamespace', 'type': 'str'},
        'relay_name': {'key': 'properties.relayName', 'type': 'str'},
        'relay_arm_uri': {'key': 'properties.relayArmUri', 'type': 'str'},
        'hostname': {'key': 'properties.hostname', 'type': 'str'},
        'port': {'key': 'properties.port', 'type': 'int'},
        'send_key_name': {'key': 'properties.sendKeyName', 'type': 'str'},
        'send_key_value': {'key': 'properties.sendKeyValue', 'type': 'str'},
        'service_bus_suffix': {'key': 'properties.serviceBusSuffix', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        service_bus_namespace: Optional[str] = None,
        relay_name: Optional[str] = None,
        relay_arm_uri: Optional[str] = None,
        hostname: Optional[str] = None,
        port: Optional[int] = None,
        send_key_name: Optional[str] = None,
        send_key_value: Optional[str] = None,
        service_bus_suffix: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword service_bus_namespace: The name of the Service Bus namespace.
        :paramtype service_bus_namespace: str
        :keyword relay_name: The name of the Service Bus relay.
        :paramtype relay_name: str
        :keyword relay_arm_uri: The ARM URI to the Service Bus relay.
        :paramtype relay_arm_uri: str
        :keyword hostname: The hostname of the endpoint.
        :paramtype hostname: str
        :keyword port: The port of the endpoint.
        :paramtype port: int
        :keyword send_key_name: The name of the Service Bus key which has Send permissions. This is
         used to authenticate to Service Bus.
        :paramtype send_key_name: str
        :keyword send_key_value: The value of the Service Bus key. This is used to authenticate to
         Service Bus. In ARM this key will not be returned
         normally, use the POST /listKeys API instead.
        :paramtype send_key_value: str
        :keyword service_bus_suffix: The suffix for the service bus endpoint. By default this is
         .servicebus.windows.net.
        :paramtype service_bus_suffix: str
        """
        super(HybridConnection, self).__init__(kind=kind, **kwargs)
        self.service_bus_namespace = service_bus_namespace
        self.relay_name = relay_name
        self.relay_arm_uri = relay_arm_uri
        self.hostname = hostname
        self.port = port
        self.send_key_name = send_key_name
        self.send_key_value = send_key_value
        self.service_bus_suffix = service_bus_suffix


class HybridConnectionKey(ProxyOnlyResource):
    """Hybrid Connection key contract. This has the send key name and value for a Hybrid Connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar send_key_name: The name of the send key.
    :vartype send_key_name: str
    :ivar send_key_value: The value of the send key.
    :vartype send_key_value: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'send_key_name': {'readonly': True},
        'send_key_value': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'send_key_name': {'key': 'properties.sendKeyName', 'type': 'str'},
        'send_key_value': {'key': 'properties.sendKeyValue', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super(HybridConnectionKey, self).__init__(kind=kind, **kwargs)
        self.send_key_name = None
        self.send_key_value = None


class Identifier(ProxyOnlyResource):
    """A domain specific resource identifier.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar id_properties_id: String representation of the identity.
    :vartype id_properties_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'id_properties_id': {'key': 'properties.id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        id_properties_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword id_properties_id: String representation of the identity.
        :paramtype id_properties_id: str
        """
        super(Identifier, self).__init__(kind=kind, **kwargs)
        self.id_properties_id = id_properties_id


class IdentifierCollection(msrest.serialization.Model):
    """Collection of identifiers.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2016_08_01.models.Identifier]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Identifier]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["_models.Identifier"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2016_08_01.models.Identifier]
        """
        super(IdentifierCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class IpSecurityRestriction(msrest.serialization.Model):
    """IP security restriction on an app.

    All required parameters must be populated in order to send to Azure.

    :ivar ip_address: Required. IP address the security restriction is valid for.
    :vartype ip_address: str
    :ivar subnet_mask: Subnet mask for the range of IP addresses the restriction is valid for.
    :vartype subnet_mask: str
    """

    _validation = {
        'ip_address': {'required': True},
    }

    _attribute_map = {
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
        'subnet_mask': {'key': 'subnetMask', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        ip_address: str,
        subnet_mask: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword ip_address: Required. IP address the security restriction is valid for.
        :paramtype ip_address: str
        :keyword subnet_mask: Subnet mask for the range of IP addresses the restriction is valid for.
        :paramtype subnet_mask: str
        """
        super(IpSecurityRestriction, self).__init__(**kwargs)
        self.ip_address = ip_address
        self.subnet_mask = subnet_mask


class LocalizableString(msrest.serialization.Model):
    """Localizable string object containing the name and a localized value.

    :ivar value: Non-localized name.
    :vartype value: str
    :ivar localized_value: Localized name.
    :vartype localized_value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[str] = None,
        localized_value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Non-localized name.
        :paramtype value: str
        :keyword localized_value: Localized name.
        :paramtype localized_value: str
        """
        super(LocalizableString, self).__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class ManagedServiceIdentity(msrest.serialization.Model):
    """Managed service identity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: Type of managed service identity. Known values are: "SystemAssigned".
    :vartype type: str or ~azure.mgmt.web.v2016_08_01.models.ManagedServiceIdentityType
    :ivar tenant_id: Tenant of managed service identity.
    :vartype tenant_id: str
    :ivar principal_id: Principal Id of managed service identity.
    :vartype principal_id: str
    """

    _validation = {
        'tenant_id': {'readonly': True},
        'principal_id': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ManagedServiceIdentityType"]] = None,
        **kwargs
    ):
        """
        :keyword type: Type of managed service identity. Known values are: "SystemAssigned".
        :paramtype type: str or ~azure.mgmt.web.v2016_08_01.models.ManagedServiceIdentityType
        """
        super(ManagedServiceIdentity, self).__init__(**kwargs)
        self.type = type
        self.tenant_id = None
        self.principal_id = None


class MigrateMySqlRequest(ProxyOnlyResource):
    """MySQL migration request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar connection_string: Connection string to the remote MySQL database.
    :vartype connection_string: str
    :ivar migration_type: The type of migration operation to be done. Known values are:
     "LocalToRemote", "RemoteToLocal".
    :vartype migration_type: str or ~azure.mgmt.web.v2016_08_01.models.MySqlMigrationType
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'connection_string': {'key': 'properties.connectionString', 'type': 'str'},
        'migration_type': {'key': 'properties.migrationType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        connection_string: Optional[str] = None,
        migration_type: Optional[Union[str, "_models.MySqlMigrationType"]] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword connection_string: Connection string to the remote MySQL database.
        :paramtype connection_string: str
        :keyword migration_type: The type of migration operation to be done. Known values are:
         "LocalToRemote", "RemoteToLocal".
        :paramtype migration_type: str or ~azure.mgmt.web.v2016_08_01.models.MySqlMigrationType
        """
        super(MigrateMySqlRequest, self).__init__(kind=kind, **kwargs)
        self.connection_string = connection_string
        self.migration_type = migration_type


class MigrateMySqlStatus(ProxyOnlyResource):
    """MySQL migration status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar migration_operation_status: Status of the migration task. Known values are: "InProgress",
     "Failed", "Succeeded", "TimedOut", "Created".
    :vartype migration_operation_status: str or ~azure.mgmt.web.v2016_08_01.models.OperationStatus
    :ivar operation_id: Operation ID for the migration task.
    :vartype operation_id: str
    :ivar local_my_sql_enabled: True if the web app has in app MySql enabled.
    :vartype local_my_sql_enabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'migration_operation_status': {'readonly': True},
        'operation_id': {'readonly': True},
        'local_my_sql_enabled': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'migration_operation_status': {'key': 'properties.migrationOperationStatus', 'type': 'str'},
        'operation_id': {'key': 'properties.operationId', 'type': 'str'},
        'local_my_sql_enabled': {'key': 'properties.localMySqlEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super(MigrateMySqlStatus, self).__init__(kind=kind, **kwargs)
        self.migration_operation_status = None
        self.operation_id = None
        self.local_my_sql_enabled = None


class MSDeploy(ProxyOnlyResource):
    """MSDeploy ARM PUT information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar package_uri: Package URI.
    :vartype package_uri: str
    :ivar connection_string: SQL Connection String.
    :vartype connection_string: str
    :ivar db_type: Database Type.
    :vartype db_type: str
    :ivar set_parameters_xml_file_uri: URI of MSDeploy Parameters file. Must not be set if
     SetParameters is used.
    :vartype set_parameters_xml_file_uri: str
    :ivar set_parameters: MSDeploy Parameters. Must not be set if SetParametersXmlFileUri is used.
    :vartype set_parameters: dict[str, str]
    :ivar skip_app_data: Controls whether the MSDeploy operation skips the App_Data directory.
     If set to :code:`<code>true</code>`, the existing App_Data directory on the destination
     will not be deleted, and any App_Data directory in the source will be ignored.
     Setting is :code:`<code>false</code>` by default.
    :vartype skip_app_data: bool
    :ivar app_offline: Sets the AppOffline rule while the MSDeploy operation executes.
     Setting is :code:`<code>false</code>` by default.
    :vartype app_offline: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'package_uri': {'key': 'properties.packageUri', 'type': 'str'},
        'connection_string': {'key': 'properties.connectionString', 'type': 'str'},
        'db_type': {'key': 'properties.dbType', 'type': 'str'},
        'set_parameters_xml_file_uri': {'key': 'properties.setParametersXmlFileUri', 'type': 'str'},
        'set_parameters': {'key': 'properties.setParameters', 'type': '{str}'},
        'skip_app_data': {'key': 'properties.skipAppData', 'type': 'bool'},
        'app_offline': {'key': 'properties.appOffline', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        package_uri: Optional[str] = None,
        connection_string: Optional[str] = None,
        db_type: Optional[str] = None,
        set_parameters_xml_file_uri: Optional[str] = None,
        set_parameters: Optional[Dict[str, str]] = None,
        skip_app_data: Optional[bool] = None,
        app_offline: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword package_uri: Package URI.
        :paramtype package_uri: str
        :keyword connection_string: SQL Connection String.
        :paramtype connection_string: str
        :keyword db_type: Database Type.
        :paramtype db_type: str
        :keyword set_parameters_xml_file_uri: URI of MSDeploy Parameters file. Must not be set if
         SetParameters is used.
        :paramtype set_parameters_xml_file_uri: str
        :keyword set_parameters: MSDeploy Parameters. Must not be set if SetParametersXmlFileUri is
         used.
        :paramtype set_parameters: dict[str, str]
        :keyword skip_app_data: Controls whether the MSDeploy operation skips the App_Data directory.
         If set to :code:`<code>true</code>`, the existing App_Data directory on the destination
         will not be deleted, and any App_Data directory in the source will be ignored.
         Setting is :code:`<code>false</code>` by default.
        :paramtype skip_app_data: bool
        :keyword app_offline: Sets the AppOffline rule while the MSDeploy operation executes.
         Setting is :code:`<code>false</code>` by default.
        :paramtype app_offline: bool
        """
        super(MSDeploy, self).__init__(kind=kind, **kwargs)
        self.package_uri = package_uri
        self.connection_string = connection_string
        self.db_type = db_type
        self.set_parameters_xml_file_uri = set_parameters_xml_file_uri
        self.set_parameters = set_parameters
        self.skip_app_data = skip_app_data
        self.app_offline = app_offline


class MSDeployLog(ProxyOnlyResource):
    """MSDeploy log.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar entries: List of log entry messages.
    :vartype entries: list[~azure.mgmt.web.v2016_08_01.models.MSDeployLogEntry]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'entries': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'entries': {'key': 'properties.entries', 'type': '[MSDeployLogEntry]'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super(MSDeployLog, self).__init__(kind=kind, **kwargs)
        self.entries = None


class MSDeployLogEntry(msrest.serialization.Model):
    """MSDeploy log entry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar time: Timestamp of log entry.
    :vartype time: ~datetime.datetime
    :ivar type: Log entry type. Known values are: "Message", "Warning", "Error".
    :vartype type: str or ~azure.mgmt.web.v2016_08_01.models.MSDeployLogEntryType
    :ivar message: Log entry message.
    :vartype message: str
    """

    _validation = {
        'time': {'readonly': True},
        'type': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'time': {'key': 'time', 'type': 'iso-8601'},
        'type': {'key': 'type', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(MSDeployLogEntry, self).__init__(**kwargs)
        self.time = None
        self.type = None
        self.message = None


class MSDeployStatus(ProxyOnlyResource):
    """MSDeploy ARM response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar deployer: Username of deployer.
    :vartype deployer: str
    :ivar provisioning_state: Provisioning state. Known values are: "accepted", "running",
     "succeeded", "failed", "canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.web.v2016_08_01.models.MSDeployProvisioningState
    :ivar start_time: Start time of deploy operation.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of deploy operation.
    :vartype end_time: ~datetime.datetime
    :ivar complete: Whether the deployment operation has completed.
    :vartype complete: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'deployer': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'complete': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'deployer': {'key': 'properties.deployer', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'complete': {'key': 'properties.complete', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super(MSDeployStatus, self).__init__(kind=kind, **kwargs)
        self.deployer = None
        self.provisioning_state = None
        self.start_time = None
        self.end_time = None
        self.complete = None


class NameValuePair(msrest.serialization.Model):
    """Name value pair.

    :ivar name: Pair name.
    :vartype name: str
    :ivar value: Pair value.
    :vartype value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Pair name.
        :paramtype name: str
        :keyword value: Pair value.
        :paramtype value: str
        """
        super(NameValuePair, self).__init__(**kwargs)
        self.name = name
        self.value = value


class NetworkFeatures(ProxyOnlyResource):
    """Full view of network features for an app (presently VNET integration and Hybrid Connections).

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar virtual_network_name: The Virtual Network name.
    :vartype virtual_network_name: str
    :ivar virtual_network_connection: The Virtual Network summary view.
    :vartype virtual_network_connection: ~azure.mgmt.web.v2016_08_01.models.VnetInfo
    :ivar hybrid_connections: The Hybrid Connections summary view.
    :vartype hybrid_connections:
     list[~azure.mgmt.web.v2016_08_01.models.RelayServiceConnectionEntity]
    :ivar hybrid_connections_v2: The Hybrid Connection V2 (Service Bus) view.
    :vartype hybrid_connections_v2: list[~azure.mgmt.web.v2016_08_01.models.HybridConnection]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'virtual_network_name': {'readonly': True},
        'virtual_network_connection': {'readonly': True},
        'hybrid_connections': {'readonly': True},
        'hybrid_connections_v2': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'virtual_network_name': {'key': 'properties.virtualNetworkName', 'type': 'str'},
        'virtual_network_connection': {'key': 'properties.virtualNetworkConnection', 'type': 'VnetInfo'},
        'hybrid_connections': {'key': 'properties.hybridConnections', 'type': '[RelayServiceConnectionEntity]'},
        'hybrid_connections_v2': {'key': 'properties.hybridConnectionsV2', 'type': '[HybridConnection]'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super(NetworkFeatures, self).__init__(kind=kind, **kwargs)
        self.virtual_network_name = None
        self.virtual_network_connection = None
        self.hybrid_connections = None
        self.hybrid_connections_v2 = None


class Operation(msrest.serialization.Model):
    """An operation on a resource.

    :ivar id: Operation ID.
    :vartype id: str
    :ivar name: Operation name.
    :vartype name: str
    :ivar status: The current status of the operation. Known values are: "InProgress", "Failed",
     "Succeeded", "TimedOut", "Created".
    :vartype status: str or ~azure.mgmt.web.v2016_08_01.models.OperationStatus
    :ivar errors: Any errors associate with the operation.
    :vartype errors: list[~azure.mgmt.web.v2016_08_01.models.ErrorEntity]
    :ivar created_time: Time when operation has started.
    :vartype created_time: ~datetime.datetime
    :ivar modified_time: Time when operation has been updated.
    :vartype modified_time: ~datetime.datetime
    :ivar expiration_time: Time when operation will expire.
    :vartype expiration_time: ~datetime.datetime
    :ivar geo_master_operation_id: Applicable only for stamp operation ids.
    :vartype geo_master_operation_id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ErrorEntity]'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'modified_time': {'key': 'modifiedTime', 'type': 'iso-8601'},
        'expiration_time': {'key': 'expirationTime', 'type': 'iso-8601'},
        'geo_master_operation_id': {'key': 'geoMasterOperationId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        status: Optional[Union[str, "_models.OperationStatus"]] = None,
        errors: Optional[List["_models.ErrorEntity"]] = None,
        created_time: Optional[datetime.datetime] = None,
        modified_time: Optional[datetime.datetime] = None,
        expiration_time: Optional[datetime.datetime] = None,
        geo_master_operation_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Operation ID.
        :paramtype id: str
        :keyword name: Operation name.
        :paramtype name: str
        :keyword status: The current status of the operation. Known values are: "InProgress", "Failed",
         "Succeeded", "TimedOut", "Created".
        :paramtype status: str or ~azure.mgmt.web.v2016_08_01.models.OperationStatus
        :keyword errors: Any errors associate with the operation.
        :paramtype errors: list[~azure.mgmt.web.v2016_08_01.models.ErrorEntity]
        :keyword created_time: Time when operation has started.
        :paramtype created_time: ~datetime.datetime
        :keyword modified_time: Time when operation has been updated.
        :paramtype modified_time: ~datetime.datetime
        :keyword expiration_time: Time when operation will expire.
        :paramtype expiration_time: ~datetime.datetime
        :keyword geo_master_operation_id: Applicable only for stamp operation ids.
        :paramtype geo_master_operation_id: str
        """
        super(Operation, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.status = status
        self.errors = errors
        self.created_time = created_time
        self.modified_time = modified_time
        self.expiration_time = expiration_time
        self.geo_master_operation_id = geo_master_operation_id


class PerfMonCounterCollection(msrest.serialization.Model):
    """Collection of performance monitor counters.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2016_08_01.models.PerfMonResponse]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PerfMonResponse]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["_models.PerfMonResponse"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2016_08_01.models.PerfMonResponse]
        """
        super(PerfMonCounterCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class PerfMonResponse(msrest.serialization.Model):
    """Performance monitor API response.

    :ivar code: The response code.
    :vartype code: str
    :ivar message: The message.
    :vartype message: str
    :ivar data: The performance monitor counters.
    :vartype data: ~azure.mgmt.web.v2016_08_01.models.PerfMonSet
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'data': {'key': 'data', 'type': 'PerfMonSet'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        data: Optional["_models.PerfMonSet"] = None,
        **kwargs
    ):
        """
        :keyword code: The response code.
        :paramtype code: str
        :keyword message: The message.
        :paramtype message: str
        :keyword data: The performance monitor counters.
        :paramtype data: ~azure.mgmt.web.v2016_08_01.models.PerfMonSet
        """
        super(PerfMonResponse, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.data = data


class PerfMonSample(msrest.serialization.Model):
    """Performance monitor sample in a set.

    :ivar time: Point in time for which counter was measured.
    :vartype time: ~datetime.datetime
    :ivar instance_name: Name of the server on which the measurement is made.
    :vartype instance_name: str
    :ivar value: Value of counter at a certain time.
    :vartype value: float
    :ivar core_count: Core Count of worker. Not a data member.
    :vartype core_count: int
    """

    _attribute_map = {
        'time': {'key': 'time', 'type': 'iso-8601'},
        'instance_name': {'key': 'instanceName', 'type': 'str'},
        'value': {'key': 'value', 'type': 'float'},
        'core_count': {'key': 'coreCount', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        time: Optional[datetime.datetime] = None,
        instance_name: Optional[str] = None,
        value: Optional[float] = None,
        core_count: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword time: Point in time for which counter was measured.
        :paramtype time: ~datetime.datetime
        :keyword instance_name: Name of the server on which the measurement is made.
        :paramtype instance_name: str
        :keyword value: Value of counter at a certain time.
        :paramtype value: float
        :keyword core_count: Core Count of worker. Not a data member.
        :paramtype core_count: int
        """
        super(PerfMonSample, self).__init__(**kwargs)
        self.time = time
        self.instance_name = instance_name
        self.value = value
        self.core_count = core_count


class PerfMonSet(msrest.serialization.Model):
    """Metric information.

    :ivar name: Unique key name of the counter.
    :vartype name: str
    :ivar start_time: Start time of the period.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the period.
    :vartype end_time: ~datetime.datetime
    :ivar time_grain: Presented time grain.
    :vartype time_grain: str
    :ivar values: Collection of workers that are active during this time.
    :vartype values: list[~azure.mgmt.web.v2016_08_01.models.PerfMonSample]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'time_grain': {'key': 'timeGrain', 'type': 'str'},
        'values': {'key': 'values', 'type': '[PerfMonSample]'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        time_grain: Optional[str] = None,
        values: Optional[List["_models.PerfMonSample"]] = None,
        **kwargs
    ):
        """
        :keyword name: Unique key name of the counter.
        :paramtype name: str
        :keyword start_time: Start time of the period.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: End time of the period.
        :paramtype end_time: ~datetime.datetime
        :keyword time_grain: Presented time grain.
        :paramtype time_grain: str
        :keyword values: Collection of workers that are active during this time.
        :paramtype values: list[~azure.mgmt.web.v2016_08_01.models.PerfMonSample]
        """
        super(PerfMonSet, self).__init__(**kwargs)
        self.name = name
        self.start_time = start_time
        self.end_time = end_time
        self.time_grain = time_grain
        self.values = values


class Resource(msrest.serialization.Model):
    """Azure resource. This resource is tracked in Azure Resource Manager.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar location: Required. Resource Location.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword location: Required. Resource Location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        """
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.kind = kind
        self.location = location
        self.type = None
        self.tags = tags


class PremierAddOn(Resource):
    """Premier add-on.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar location: Required. Resource Location.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: Premier add on SKU.
    :vartype sku: str
    :ivar product: Premier add on Product.
    :vartype product: str
    :ivar vendor: Premier add on Vendor.
    :vartype vendor: str
    :ivar premier_add_on_name: Premier add on Name.
    :vartype premier_add_on_name: str
    :ivar location_properties_location: Premier add on Location.
    :vartype location_properties_location: str
    :ivar tags_properties_tags: Premier add on Tags.
    :vartype tags_properties_tags: dict[str, str]
    :ivar marketplace_publisher: Premier add on Marketplace publisher.
    :vartype marketplace_publisher: str
    :ivar marketplace_offer: Premier add on Marketplace offer.
    :vartype marketplace_offer: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'properties.sku', 'type': 'str'},
        'product': {'key': 'properties.product', 'type': 'str'},
        'vendor': {'key': 'properties.vendor', 'type': 'str'},
        'premier_add_on_name': {'key': 'properties.name', 'type': 'str'},
        'location_properties_location': {'key': 'properties.location', 'type': 'str'},
        'tags_properties_tags': {'key': 'properties.tags', 'type': '{str}'},
        'marketplace_publisher': {'key': 'properties.marketplacePublisher', 'type': 'str'},
        'marketplace_offer': {'key': 'properties.marketplaceOffer', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional[str] = None,
        product: Optional[str] = None,
        vendor: Optional[str] = None,
        premier_add_on_name: Optional[str] = None,
        location_properties_location: Optional[str] = None,
        tags_properties_tags: Optional[Dict[str, str]] = None,
        marketplace_publisher: Optional[str] = None,
        marketplace_offer: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword location: Required. Resource Location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: Premier add on SKU.
        :paramtype sku: str
        :keyword product: Premier add on Product.
        :paramtype product: str
        :keyword vendor: Premier add on Vendor.
        :paramtype vendor: str
        :keyword premier_add_on_name: Premier add on Name.
        :paramtype premier_add_on_name: str
        :keyword location_properties_location: Premier add on Location.
        :paramtype location_properties_location: str
        :keyword tags_properties_tags: Premier add on Tags.
        :paramtype tags_properties_tags: dict[str, str]
        :keyword marketplace_publisher: Premier add on Marketplace publisher.
        :paramtype marketplace_publisher: str
        :keyword marketplace_offer: Premier add on Marketplace offer.
        :paramtype marketplace_offer: str
        """
        super(PremierAddOn, self).__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.sku = sku
        self.product = product
        self.vendor = vendor
        self.premier_add_on_name = premier_add_on_name
        self.location_properties_location = location_properties_location
        self.tags_properties_tags = tags_properties_tags
        self.marketplace_publisher = marketplace_publisher
        self.marketplace_offer = marketplace_offer


class ProcessInfo(ProxyOnlyResource):
    """Process Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar id_properties_id: ARM Identifier for deployment.
    :vartype id_properties_id: int
    :ivar name_properties_name: Deployment name.
    :vartype name_properties_name: str
    :ivar href: HRef URI.
    :vartype href: str
    :ivar mini_dump: Minidump URI.
    :vartype mini_dump: str
    :ivar is_profile_running: Is profile running?.
    :vartype is_profile_running: bool
    :ivar is_iis_profile_running: Is the IIS Profile running?.
    :vartype is_iis_profile_running: bool
    :ivar iis_profile_timeout_in_seconds: IIS Profile timeout (seconds).
    :vartype iis_profile_timeout_in_seconds: float
    :ivar parent: Parent process.
    :vartype parent: str
    :ivar children: Child process list.
    :vartype children: list[str]
    :ivar threads: Thread list.
    :vartype threads: list[~azure.mgmt.web.v2016_08_01.models.ProcessThreadInfo]
    :ivar open_file_handles: List of open files.
    :vartype open_file_handles: list[str]
    :ivar modules: List of modules.
    :vartype modules: list[~azure.mgmt.web.v2016_08_01.models.ProcessModuleInfo]
    :ivar file_name: File name of this process.
    :vartype file_name: str
    :ivar command_line: Command line.
    :vartype command_line: str
    :ivar user_name: User name.
    :vartype user_name: str
    :ivar handle_count: Handle count.
    :vartype handle_count: int
    :ivar module_count: Module count.
    :vartype module_count: int
    :ivar thread_count: Thread count.
    :vartype thread_count: int
    :ivar start_time: Start time.
    :vartype start_time: ~datetime.datetime
    :ivar total_processor_time: Total CPU time.
    :vartype total_processor_time: str
    :ivar user_processor_time: User CPU time.
    :vartype user_processor_time: str
    :ivar privileged_processor_time: Privileged CPU time.
    :vartype privileged_processor_time: str
    :ivar working_set64: Working set.
    :vartype working_set64: long
    :ivar peak_working_set64: Peak working set.
    :vartype peak_working_set64: long
    :ivar private_memory_size64: Private memory size.
    :vartype private_memory_size64: long
    :ivar virtual_memory_size64: Virtual memory size.
    :vartype virtual_memory_size64: long
    :ivar peak_virtual_memory_size64: Peak virtual memory usage.
    :vartype peak_virtual_memory_size64: long
    :ivar paged_system_memory_size64: Paged system memory.
    :vartype paged_system_memory_size64: long
    :ivar nonpaged_system_memory_size64: Non-paged system memory.
    :vartype nonpaged_system_memory_size64: long
    :ivar paged_memory_size64: Paged memory.
    :vartype paged_memory_size64: long
    :ivar peak_paged_memory_size64: Peak paged memory.
    :vartype peak_paged_memory_size64: long
    :ivar time_stamp: Time stamp.
    :vartype time_stamp: ~datetime.datetime
    :ivar environment_variables: List of environment variables.
    :vartype environment_variables: dict[str, str]
    :ivar is_scm_site: Is this the SCM site?.
    :vartype is_scm_site: bool
    :ivar is_web_job: Is this a Web Job?.
    :vartype is_web_job: bool
    :ivar description: Description of process.
    :vartype description: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'id_properties_id': {'key': 'properties.id', 'type': 'int'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'href': {'key': 'properties.href', 'type': 'str'},
        'mini_dump': {'key': 'properties.miniDump', 'type': 'str'},
        'is_profile_running': {'key': 'properties.isProfileRunning', 'type': 'bool'},
        'is_iis_profile_running': {'key': 'properties.isIisProfileRunning', 'type': 'bool'},
        'iis_profile_timeout_in_seconds': {'key': 'properties.iisProfileTimeoutInSeconds', 'type': 'float'},
        'parent': {'key': 'properties.parent', 'type': 'str'},
        'children': {'key': 'properties.children', 'type': '[str]'},
        'threads': {'key': 'properties.threads', 'type': '[ProcessThreadInfo]'},
        'open_file_handles': {'key': 'properties.openFileHandles', 'type': '[str]'},
        'modules': {'key': 'properties.modules', 'type': '[ProcessModuleInfo]'},
        'file_name': {'key': 'properties.fileName', 'type': 'str'},
        'command_line': {'key': 'properties.commandLine', 'type': 'str'},
        'user_name': {'key': 'properties.userName', 'type': 'str'},
        'handle_count': {'key': 'properties.handleCount', 'type': 'int'},
        'module_count': {'key': 'properties.moduleCount', 'type': 'int'},
        'thread_count': {'key': 'properties.threadCount', 'type': 'int'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'total_processor_time': {'key': 'properties.totalProcessorTime', 'type': 'str'},
        'user_processor_time': {'key': 'properties.userProcessorTime', 'type': 'str'},
        'privileged_processor_time': {'key': 'properties.privilegedProcessorTime', 'type': 'str'},
        'working_set64': {'key': 'properties.workingSet64', 'type': 'long'},
        'peak_working_set64': {'key': 'properties.peakWorkingSet64', 'type': 'long'},
        'private_memory_size64': {'key': 'properties.privateMemorySize64', 'type': 'long'},
        'virtual_memory_size64': {'key': 'properties.virtualMemorySize64', 'type': 'long'},
        'peak_virtual_memory_size64': {'key': 'properties.peakVirtualMemorySize64', 'type': 'long'},
        'paged_system_memory_size64': {'key': 'properties.pagedSystemMemorySize64', 'type': 'long'},
        'nonpaged_system_memory_size64': {'key': 'properties.nonpagedSystemMemorySize64', 'type': 'long'},
        'paged_memory_size64': {'key': 'properties.pagedMemorySize64', 'type': 'long'},
        'peak_paged_memory_size64': {'key': 'properties.peakPagedMemorySize64', 'type': 'long'},
        'time_stamp': {'key': 'properties.timeStamp', 'type': 'iso-8601'},
        'environment_variables': {'key': 'properties.environmentVariables', 'type': '{str}'},
        'is_scm_site': {'key': 'properties.isScmSite', 'type': 'bool'},
        'is_web_job': {'key': 'properties.isWebJob', 'type': 'bool'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        id_properties_id: Optional[int] = None,
        name_properties_name: Optional[str] = None,
        href: Optional[str] = None,
        mini_dump: Optional[str] = None,
        is_profile_running: Optional[bool] = None,
        is_iis_profile_running: Optional[bool] = None,
        iis_profile_timeout_in_seconds: Optional[float] = None,
        parent: Optional[str] = None,
        children: Optional[List[str]] = None,
        threads: Optional[List["_models.ProcessThreadInfo"]] = None,
        open_file_handles: Optional[List[str]] = None,
        modules: Optional[List["_models.ProcessModuleInfo"]] = None,
        file_name: Optional[str] = None,
        command_line: Optional[str] = None,
        user_name: Optional[str] = None,
        handle_count: Optional[int] = None,
        module_count: Optional[int] = None,
        thread_count: Optional[int] = None,
        start_time: Optional[datetime.datetime] = None,
        total_processor_time: Optional[str] = None,
        user_processor_time: Optional[str] = None,
        privileged_processor_time: Optional[str] = None,
        working_set64: Optional[int] = None,
        peak_working_set64: Optional[int] = None,
        private_memory_size64: Optional[int] = None,
        virtual_memory_size64: Optional[int] = None,
        peak_virtual_memory_size64: Optional[int] = None,
        paged_system_memory_size64: Optional[int] = None,
        nonpaged_system_memory_size64: Optional[int] = None,
        paged_memory_size64: Optional[int] = None,
        peak_paged_memory_size64: Optional[int] = None,
        time_stamp: Optional[datetime.datetime] = None,
        environment_variables: Optional[Dict[str, str]] = None,
        is_scm_site: Optional[bool] = None,
        is_web_job: Optional[bool] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword id_properties_id: ARM Identifier for deployment.
        :paramtype id_properties_id: int
        :keyword name_properties_name: Deployment name.
        :paramtype name_properties_name: str
        :keyword href: HRef URI.
        :paramtype href: str
        :keyword mini_dump: Minidump URI.
        :paramtype mini_dump: str
        :keyword is_profile_running: Is profile running?.
        :paramtype is_profile_running: bool
        :keyword is_iis_profile_running: Is the IIS Profile running?.
        :paramtype is_iis_profile_running: bool
        :keyword iis_profile_timeout_in_seconds: IIS Profile timeout (seconds).
        :paramtype iis_profile_timeout_in_seconds: float
        :keyword parent: Parent process.
        :paramtype parent: str
        :keyword children: Child process list.
        :paramtype children: list[str]
        :keyword threads: Thread list.
        :paramtype threads: list[~azure.mgmt.web.v2016_08_01.models.ProcessThreadInfo]
        :keyword open_file_handles: List of open files.
        :paramtype open_file_handles: list[str]
        :keyword modules: List of modules.
        :paramtype modules: list[~azure.mgmt.web.v2016_08_01.models.ProcessModuleInfo]
        :keyword file_name: File name of this process.
        :paramtype file_name: str
        :keyword command_line: Command line.
        :paramtype command_line: str
        :keyword user_name: User name.
        :paramtype user_name: str
        :keyword handle_count: Handle count.
        :paramtype handle_count: int
        :keyword module_count: Module count.
        :paramtype module_count: int
        :keyword thread_count: Thread count.
        :paramtype thread_count: int
        :keyword start_time: Start time.
        :paramtype start_time: ~datetime.datetime
        :keyword total_processor_time: Total CPU time.
        :paramtype total_processor_time: str
        :keyword user_processor_time: User CPU time.
        :paramtype user_processor_time: str
        :keyword privileged_processor_time: Privileged CPU time.
        :paramtype privileged_processor_time: str
        :keyword working_set64: Working set.
        :paramtype working_set64: long
        :keyword peak_working_set64: Peak working set.
        :paramtype peak_working_set64: long
        :keyword private_memory_size64: Private memory size.
        :paramtype private_memory_size64: long
        :keyword virtual_memory_size64: Virtual memory size.
        :paramtype virtual_memory_size64: long
        :keyword peak_virtual_memory_size64: Peak virtual memory usage.
        :paramtype peak_virtual_memory_size64: long
        :keyword paged_system_memory_size64: Paged system memory.
        :paramtype paged_system_memory_size64: long
        :keyword nonpaged_system_memory_size64: Non-paged system memory.
        :paramtype nonpaged_system_memory_size64: long
        :keyword paged_memory_size64: Paged memory.
        :paramtype paged_memory_size64: long
        :keyword peak_paged_memory_size64: Peak paged memory.
        :paramtype peak_paged_memory_size64: long
        :keyword time_stamp: Time stamp.
        :paramtype time_stamp: ~datetime.datetime
        :keyword environment_variables: List of environment variables.
        :paramtype environment_variables: dict[str, str]
        :keyword is_scm_site: Is this the SCM site?.
        :paramtype is_scm_site: bool
        :keyword is_web_job: Is this a Web Job?.
        :paramtype is_web_job: bool
        :keyword description: Description of process.
        :paramtype description: str
        """
        super(ProcessInfo, self).__init__(kind=kind, **kwargs)
        self.id_properties_id = id_properties_id
        self.name_properties_name = name_properties_name
        self.href = href
        self.mini_dump = mini_dump
        self.is_profile_running = is_profile_running
        self.is_iis_profile_running = is_iis_profile_running
        self.iis_profile_timeout_in_seconds = iis_profile_timeout_in_seconds
        self.parent = parent
        self.children = children
        self.threads = threads
        self.open_file_handles = open_file_handles
        self.modules = modules
        self.file_name = file_name
        self.command_line = command_line
        self.user_name = user_name
        self.handle_count = handle_count
        self.module_count = module_count
        self.thread_count = thread_count
        self.start_time = start_time
        self.total_processor_time = total_processor_time
        self.user_processor_time = user_processor_time
        self.privileged_processor_time = privileged_processor_time
        self.working_set64 = working_set64
        self.peak_working_set64 = peak_working_set64
        self.private_memory_size64 = private_memory_size64
        self.virtual_memory_size64 = virtual_memory_size64
        self.peak_virtual_memory_size64 = peak_virtual_memory_size64
        self.paged_system_memory_size64 = paged_system_memory_size64
        self.nonpaged_system_memory_size64 = nonpaged_system_memory_size64
        self.paged_memory_size64 = paged_memory_size64
        self.peak_paged_memory_size64 = peak_paged_memory_size64
        self.time_stamp = time_stamp
        self.environment_variables = environment_variables
        self.is_scm_site = is_scm_site
        self.is_web_job = is_web_job
        self.description = description


class ProcessInfoCollection(msrest.serialization.Model):
    """Collection of Kudu process information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2016_08_01.models.ProcessInfo]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ProcessInfo]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["_models.ProcessInfo"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2016_08_01.models.ProcessInfo]
        """
        super(ProcessInfoCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ProcessModuleInfo(ProxyOnlyResource):
    """Process Module Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar base_address: Base address. Used as module identifier in ARM resource URI.
    :vartype base_address: str
    :ivar file_name: File name.
    :vartype file_name: str
    :ivar href: HRef URI.
    :vartype href: str
    :ivar file_path: File path.
    :vartype file_path: str
    :ivar module_memory_size: Module memory size.
    :vartype module_memory_size: int
    :ivar file_version: File version.
    :vartype file_version: str
    :ivar file_description: File description.
    :vartype file_description: str
    :ivar product: Product name.
    :vartype product: str
    :ivar product_version: Product version.
    :vartype product_version: str
    :ivar is_debug: Is debug?.
    :vartype is_debug: bool
    :ivar language: Module language (locale).
    :vartype language: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'base_address': {'key': 'properties.baseAddress', 'type': 'str'},
        'file_name': {'key': 'properties.fileName', 'type': 'str'},
        'href': {'key': 'properties.href', 'type': 'str'},
        'file_path': {'key': 'properties.filePath', 'type': 'str'},
        'module_memory_size': {'key': 'properties.moduleMemorySize', 'type': 'int'},
        'file_version': {'key': 'properties.fileVersion', 'type': 'str'},
        'file_description': {'key': 'properties.fileDescription', 'type': 'str'},
        'product': {'key': 'properties.product', 'type': 'str'},
        'product_version': {'key': 'properties.productVersion', 'type': 'str'},
        'is_debug': {'key': 'properties.isDebug', 'type': 'bool'},
        'language': {'key': 'properties.language', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        base_address: Optional[str] = None,
        file_name: Optional[str] = None,
        href: Optional[str] = None,
        file_path: Optional[str] = None,
        module_memory_size: Optional[int] = None,
        file_version: Optional[str] = None,
        file_description: Optional[str] = None,
        product: Optional[str] = None,
        product_version: Optional[str] = None,
        is_debug: Optional[bool] = None,
        language: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword base_address: Base address. Used as module identifier in ARM resource URI.
        :paramtype base_address: str
        :keyword file_name: File name.
        :paramtype file_name: str
        :keyword href: HRef URI.
        :paramtype href: str
        :keyword file_path: File path.
        :paramtype file_path: str
        :keyword module_memory_size: Module memory size.
        :paramtype module_memory_size: int
        :keyword file_version: File version.
        :paramtype file_version: str
        :keyword file_description: File description.
        :paramtype file_description: str
        :keyword product: Product name.
        :paramtype product: str
        :keyword product_version: Product version.
        :paramtype product_version: str
        :keyword is_debug: Is debug?.
        :paramtype is_debug: bool
        :keyword language: Module language (locale).
        :paramtype language: str
        """
        super(ProcessModuleInfo, self).__init__(kind=kind, **kwargs)
        self.base_address = base_address
        self.file_name = file_name
        self.href = href
        self.file_path = file_path
        self.module_memory_size = module_memory_size
        self.file_version = file_version
        self.file_description = file_description
        self.product = product
        self.product_version = product_version
        self.is_debug = is_debug
        self.language = language


class ProcessModuleInfoCollection(msrest.serialization.Model):
    """Collection of Kudu thread information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2016_08_01.models.ProcessModuleInfo]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ProcessModuleInfo]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["_models.ProcessModuleInfo"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2016_08_01.models.ProcessModuleInfo]
        """
        super(ProcessModuleInfoCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ProcessThreadInfo(ProxyOnlyResource):
    """Process Thread Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar id_properties_id: ARM Identifier for deployment.
    :vartype id_properties_id: int
    :ivar href: HRef URI.
    :vartype href: str
    :ivar process: Process URI.
    :vartype process: str
    :ivar start_address: Start address.
    :vartype start_address: str
    :ivar current_priority: Current thread priority.
    :vartype current_priority: int
    :ivar priority_level: Thread priority level.
    :vartype priority_level: str
    :ivar base_priority: Base priority.
    :vartype base_priority: int
    :ivar start_time: Start time.
    :vartype start_time: ~datetime.datetime
    :ivar total_processor_time: Total processor time.
    :vartype total_processor_time: str
    :ivar user_processor_time: User processor time.
    :vartype user_processor_time: str
    :ivar priviledged_processor_time: Privileged processor time.
    :vartype priviledged_processor_time: str
    :ivar state: Thread state.
    :vartype state: str
    :ivar wait_reason: Wait reason.
    :vartype wait_reason: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'id_properties_id': {'key': 'properties.id', 'type': 'int'},
        'href': {'key': 'properties.href', 'type': 'str'},
        'process': {'key': 'properties.process', 'type': 'str'},
        'start_address': {'key': 'properties.startAddress', 'type': 'str'},
        'current_priority': {'key': 'properties.currentPriority', 'type': 'int'},
        'priority_level': {'key': 'properties.priorityLevel', 'type': 'str'},
        'base_priority': {'key': 'properties.basePriority', 'type': 'int'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'total_processor_time': {'key': 'properties.totalProcessorTime', 'type': 'str'},
        'user_processor_time': {'key': 'properties.userProcessorTime', 'type': 'str'},
        'priviledged_processor_time': {'key': 'properties.priviledgedProcessorTime', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'wait_reason': {'key': 'properties.waitReason', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        id_properties_id: Optional[int] = None,
        href: Optional[str] = None,
        process: Optional[str] = None,
        start_address: Optional[str] = None,
        current_priority: Optional[int] = None,
        priority_level: Optional[str] = None,
        base_priority: Optional[int] = None,
        start_time: Optional[datetime.datetime] = None,
        total_processor_time: Optional[str] = None,
        user_processor_time: Optional[str] = None,
        priviledged_processor_time: Optional[str] = None,
        state: Optional[str] = None,
        wait_reason: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword id_properties_id: ARM Identifier for deployment.
        :paramtype id_properties_id: int
        :keyword href: HRef URI.
        :paramtype href: str
        :keyword process: Process URI.
        :paramtype process: str
        :keyword start_address: Start address.
        :paramtype start_address: str
        :keyword current_priority: Current thread priority.
        :paramtype current_priority: int
        :keyword priority_level: Thread priority level.
        :paramtype priority_level: str
        :keyword base_priority: Base priority.
        :paramtype base_priority: int
        :keyword start_time: Start time.
        :paramtype start_time: ~datetime.datetime
        :keyword total_processor_time: Total processor time.
        :paramtype total_processor_time: str
        :keyword user_processor_time: User processor time.
        :paramtype user_processor_time: str
        :keyword priviledged_processor_time: Privileged processor time.
        :paramtype priviledged_processor_time: str
        :keyword state: Thread state.
        :paramtype state: str
        :keyword wait_reason: Wait reason.
        :paramtype wait_reason: str
        """
        super(ProcessThreadInfo, self).__init__(kind=kind, **kwargs)
        self.id_properties_id = id_properties_id
        self.href = href
        self.process = process
        self.start_address = start_address
        self.current_priority = current_priority
        self.priority_level = priority_level
        self.base_priority = base_priority
        self.start_time = start_time
        self.total_processor_time = total_processor_time
        self.user_processor_time = user_processor_time
        self.priviledged_processor_time = priviledged_processor_time
        self.state = state
        self.wait_reason = wait_reason


class ProcessThreadInfoCollection(msrest.serialization.Model):
    """Collection of Kudu thread information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2016_08_01.models.ProcessThreadInfo]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ProcessThreadInfo]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["_models.ProcessThreadInfo"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2016_08_01.models.ProcessThreadInfo]
        """
        super(ProcessThreadInfoCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class PublicCertificate(ProxyOnlyResource):
    """Public certificate object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar blob: Public Certificate byte array.
    :vartype blob: bytearray
    :ivar public_certificate_location: Public Certificate Location. Known values are:
     "CurrentUserMy", "LocalMachineMy", "Unknown".
    :vartype public_certificate_location: str or
     ~azure.mgmt.web.v2016_08_01.models.PublicCertificateLocation
    :ivar thumbprint: Certificate Thumbprint.
    :vartype thumbprint: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'thumbprint': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'blob': {'key': 'properties.blob', 'type': 'bytearray'},
        'public_certificate_location': {'key': 'properties.publicCertificateLocation', 'type': 'str'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        blob: Optional[bytearray] = None,
        public_certificate_location: Optional[Union[str, "_models.PublicCertificateLocation"]] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword blob: Public Certificate byte array.
        :paramtype blob: bytearray
        :keyword public_certificate_location: Public Certificate Location. Known values are:
         "CurrentUserMy", "LocalMachineMy", "Unknown".
        :paramtype public_certificate_location: str or
         ~azure.mgmt.web.v2016_08_01.models.PublicCertificateLocation
        """
        super(PublicCertificate, self).__init__(kind=kind, **kwargs)
        self.blob = blob
        self.public_certificate_location = public_certificate_location
        self.thumbprint = None


class PublicCertificateCollection(msrest.serialization.Model):
    """Collection of public certificates.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2016_08_01.models.PublicCertificate]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PublicCertificate]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["_models.PublicCertificate"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2016_08_01.models.PublicCertificate]
        """
        super(PublicCertificateCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class PushSettings(ProxyOnlyResource):
    """Push settings for the App.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar is_push_enabled: Gets or sets a flag indicating whether the Push endpoint is enabled.
    :vartype is_push_enabled: bool
    :ivar tag_whitelist_json: Gets or sets a JSON string containing a list of tags that are
     whitelisted for use by the push registration endpoint.
    :vartype tag_whitelist_json: str
    :ivar tags_requiring_auth: Gets or sets a JSON string containing a list of tags that require
     user authentication to be used in the push registration endpoint.
     Tags can consist of alphanumeric characters and the following:
     '_', '@', '#', '.', ':', '-'.
     Validation should be performed at the PushRequestHandler.
    :vartype tags_requiring_auth: str
    :ivar dynamic_tags_json: Gets or sets a JSON string containing a list of dynamic tags that will
     be evaluated from user claims in the push registration endpoint.
    :vartype dynamic_tags_json: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'is_push_enabled': {'key': 'properties.isPushEnabled', 'type': 'bool'},
        'tag_whitelist_json': {'key': 'properties.tagWhitelistJson', 'type': 'str'},
        'tags_requiring_auth': {'key': 'properties.tagsRequiringAuth', 'type': 'str'},
        'dynamic_tags_json': {'key': 'properties.dynamicTagsJson', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        is_push_enabled: Optional[bool] = None,
        tag_whitelist_json: Optional[str] = None,
        tags_requiring_auth: Optional[str] = None,
        dynamic_tags_json: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword is_push_enabled: Gets or sets a flag indicating whether the Push endpoint is enabled.
        :paramtype is_push_enabled: bool
        :keyword tag_whitelist_json: Gets or sets a JSON string containing a list of tags that are
         whitelisted for use by the push registration endpoint.
        :paramtype tag_whitelist_json: str
        :keyword tags_requiring_auth: Gets or sets a JSON string containing a list of tags that require
         user authentication to be used in the push registration endpoint.
         Tags can consist of alphanumeric characters and the following:
         '_', '@', '#', '.', ':', '-'.
         Validation should be performed at the PushRequestHandler.
        :paramtype tags_requiring_auth: str
        :keyword dynamic_tags_json: Gets or sets a JSON string containing a list of dynamic tags that
         will be evaluated from user claims in the push registration endpoint.
        :paramtype dynamic_tags_json: str
        """
        super(PushSettings, self).__init__(kind=kind, **kwargs)
        self.is_push_enabled = is_push_enabled
        self.tag_whitelist_json = tag_whitelist_json
        self.tags_requiring_auth = tags_requiring_auth
        self.dynamic_tags_json = dynamic_tags_json


class RampUpRule(msrest.serialization.Model):
    """Routing rules for ramp up testing. This rule allows to redirect static traffic % to a slot or to gradually change routing % based on performance.

    :ivar action_host_name: Hostname of a slot to which the traffic will be redirected if decided
     to. E.g. myapp-stage.azurewebsites.net.
    :vartype action_host_name: str
    :ivar reroute_percentage: Percentage of the traffic which will be redirected to
     :code:`<code>ActionHostName</code>`.
    :vartype reroute_percentage: float
    :ivar change_step: In auto ramp up scenario this is the step to add/remove from
     :code:`<code>ReroutePercentage</code>` until it reaches
     :code:`<code>MinReroutePercentage</code>` or :code:`<code>MaxReroutePercentage</code>`. Site
     metrics are checked every N minutes specified in :code:`<code>ChangeIntervalInMinutes</code>`.
     Custom decision algorithm can be provided in TiPCallback site extension which URL can be
     specified in :code:`<code>ChangeDecisionCallbackUrl</code>`.
    :vartype change_step: float
    :ivar change_interval_in_minutes: Specifies interval in minutes to reevaluate
     ReroutePercentage.
    :vartype change_interval_in_minutes: int
    :ivar min_reroute_percentage: Specifies lower boundary above which ReroutePercentage will stay.
    :vartype min_reroute_percentage: float
    :ivar max_reroute_percentage: Specifies upper boundary below which ReroutePercentage will stay.
    :vartype max_reroute_percentage: float
    :ivar change_decision_callback_url: Custom decision algorithm can be provided in TiPCallback
     site extension which URL can be specified. See TiPCallback site extension for the scaffold and
     contracts.
     https://www.siteextensions.net/packages/TiPCallback/.
    :vartype change_decision_callback_url: str
    :ivar name: Name of the routing rule. The recommended name would be to point to the slot which
     will receive the traffic in the experiment.
    :vartype name: str
    """

    _attribute_map = {
        'action_host_name': {'key': 'actionHostName', 'type': 'str'},
        'reroute_percentage': {'key': 'reroutePercentage', 'type': 'float'},
        'change_step': {'key': 'changeStep', 'type': 'float'},
        'change_interval_in_minutes': {'key': 'changeIntervalInMinutes', 'type': 'int'},
        'min_reroute_percentage': {'key': 'minReroutePercentage', 'type': 'float'},
        'max_reroute_percentage': {'key': 'maxReroutePercentage', 'type': 'float'},
        'change_decision_callback_url': {'key': 'changeDecisionCallbackUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        action_host_name: Optional[str] = None,
        reroute_percentage: Optional[float] = None,
        change_step: Optional[float] = None,
        change_interval_in_minutes: Optional[int] = None,
        min_reroute_percentage: Optional[float] = None,
        max_reroute_percentage: Optional[float] = None,
        change_decision_callback_url: Optional[str] = None,
        name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword action_host_name: Hostname of a slot to which the traffic will be redirected if
         decided to. E.g. myapp-stage.azurewebsites.net.
        :paramtype action_host_name: str
        :keyword reroute_percentage: Percentage of the traffic which will be redirected to
         :code:`<code>ActionHostName</code>`.
        :paramtype reroute_percentage: float
        :keyword change_step: In auto ramp up scenario this is the step to add/remove from
         :code:`<code>ReroutePercentage</code>` until it reaches
         :code:`<code>MinReroutePercentage</code>` or :code:`<code>MaxReroutePercentage</code>`. Site
         metrics are checked every N minutes specified in :code:`<code>ChangeIntervalInMinutes</code>`.
         Custom decision algorithm can be provided in TiPCallback site extension which URL can be
         specified in :code:`<code>ChangeDecisionCallbackUrl</code>`.
        :paramtype change_step: float
        :keyword change_interval_in_minutes: Specifies interval in minutes to reevaluate
         ReroutePercentage.
        :paramtype change_interval_in_minutes: int
        :keyword min_reroute_percentage: Specifies lower boundary above which ReroutePercentage will
         stay.
        :paramtype min_reroute_percentage: float
        :keyword max_reroute_percentage: Specifies upper boundary below which ReroutePercentage will
         stay.
        :paramtype max_reroute_percentage: float
        :keyword change_decision_callback_url: Custom decision algorithm can be provided in TiPCallback
         site extension which URL can be specified. See TiPCallback site extension for the scaffold and
         contracts.
         https://www.siteextensions.net/packages/TiPCallback/.
        :paramtype change_decision_callback_url: str
        :keyword name: Name of the routing rule. The recommended name would be to point to the slot
         which will receive the traffic in the experiment.
        :paramtype name: str
        """
        super(RampUpRule, self).__init__(**kwargs)
        self.action_host_name = action_host_name
        self.reroute_percentage = reroute_percentage
        self.change_step = change_step
        self.change_interval_in_minutes = change_interval_in_minutes
        self.min_reroute_percentage = min_reroute_percentage
        self.max_reroute_percentage = max_reroute_percentage
        self.change_decision_callback_url = change_decision_callback_url
        self.name = name


class RelayServiceConnectionEntity(ProxyOnlyResource):
    """Hybrid Connection for an App Service app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar entity_name:
    :vartype entity_name: str
    :ivar entity_connection_string:
    :vartype entity_connection_string: str
    :ivar resource_type:
    :vartype resource_type: str
    :ivar resource_connection_string:
    :vartype resource_connection_string: str
    :ivar hostname:
    :vartype hostname: str
    :ivar port:
    :vartype port: int
    :ivar biztalk_uri:
    :vartype biztalk_uri: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'entity_name': {'key': 'properties.entityName', 'type': 'str'},
        'entity_connection_string': {'key': 'properties.entityConnectionString', 'type': 'str'},
        'resource_type': {'key': 'properties.resourceType', 'type': 'str'},
        'resource_connection_string': {'key': 'properties.resourceConnectionString', 'type': 'str'},
        'hostname': {'key': 'properties.hostname', 'type': 'str'},
        'port': {'key': 'properties.port', 'type': 'int'},
        'biztalk_uri': {'key': 'properties.biztalkUri', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        entity_name: Optional[str] = None,
        entity_connection_string: Optional[str] = None,
        resource_type: Optional[str] = None,
        resource_connection_string: Optional[str] = None,
        hostname: Optional[str] = None,
        port: Optional[int] = None,
        biztalk_uri: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword entity_name:
        :paramtype entity_name: str
        :keyword entity_connection_string:
        :paramtype entity_connection_string: str
        :keyword resource_type:
        :paramtype resource_type: str
        :keyword resource_connection_string:
        :paramtype resource_connection_string: str
        :keyword hostname:
        :paramtype hostname: str
        :keyword port:
        :paramtype port: int
        :keyword biztalk_uri:
        :paramtype biztalk_uri: str
        """
        super(RelayServiceConnectionEntity, self).__init__(kind=kind, **kwargs)
        self.entity_name = entity_name
        self.entity_connection_string = entity_connection_string
        self.resource_type = resource_type
        self.resource_connection_string = resource_connection_string
        self.hostname = hostname
        self.port = port
        self.biztalk_uri = biztalk_uri


class RequestsBasedTrigger(msrest.serialization.Model):
    """Trigger based on total requests.

    :ivar count: Request Count.
    :vartype count: int
    :ivar time_interval: Time interval.
    :vartype time_interval: str
    """

    _attribute_map = {
        'count': {'key': 'count', 'type': 'int'},
        'time_interval': {'key': 'timeInterval', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        count: Optional[int] = None,
        time_interval: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword count: Request Count.
        :paramtype count: int
        :keyword time_interval: Time interval.
        :paramtype time_interval: str
        """
        super(RequestsBasedTrigger, self).__init__(**kwargs)
        self.count = count
        self.time_interval = time_interval


class ResourceMetric(msrest.serialization.Model):
    """Object representing a metric for any resource .

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of metric.
    :vartype name: ~azure.mgmt.web.v2016_08_01.models.ResourceMetricName
    :ivar unit: Metric unit.
    :vartype unit: str
    :ivar time_grain: Metric granularity. E.g PT1H, PT5M, P1D.
    :vartype time_grain: str
    :ivar start_time: Metric start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Metric end time.
    :vartype end_time: ~datetime.datetime
    :ivar resource_id: Metric resource Id.
    :vartype resource_id: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar metric_values: Metric values.
    :vartype metric_values: list[~azure.mgmt.web.v2016_08_01.models.ResourceMetricValue]
    :ivar properties: Resource metric properties collection.
    :vartype properties: list[~azure.mgmt.web.v2016_08_01.models.ResourceMetricProperty]
    """

    _validation = {
        'name': {'readonly': True},
        'unit': {'readonly': True},
        'time_grain': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'resource_id': {'readonly': True},
        'id': {'readonly': True},
        'metric_values': {'readonly': True},
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'ResourceMetricName'},
        'unit': {'key': 'unit', 'type': 'str'},
        'time_grain': {'key': 'timeGrain', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'metric_values': {'key': 'metricValues', 'type': '[ResourceMetricValue]'},
        'properties': {'key': 'properties', 'type': '[ResourceMetricProperty]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ResourceMetric, self).__init__(**kwargs)
        self.name = None
        self.unit = None
        self.time_grain = None
        self.start_time = None
        self.end_time = None
        self.resource_id = None
        self.id = None
        self.metric_values = None
        self.properties = None


class ResourceMetricAvailability(msrest.serialization.Model):
    """Metrics availability and retention.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar time_grain: Time grain .
    :vartype time_grain: str
    :ivar retention: Retention period for the current time grain.
    :vartype retention: str
    """

    _validation = {
        'time_grain': {'readonly': True},
        'retention': {'readonly': True},
    }

    _attribute_map = {
        'time_grain': {'key': 'timeGrain', 'type': 'str'},
        'retention': {'key': 'retention', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ResourceMetricAvailability, self).__init__(**kwargs)
        self.time_grain = None
        self.retention = None


class ResourceMetricCollection(msrest.serialization.Model):
    """Collection of metric responses.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2016_08_01.models.ResourceMetric]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ResourceMetric]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["_models.ResourceMetric"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2016_08_01.models.ResourceMetric]
        """
        super(ResourceMetricCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ResourceMetricDefinition(ProxyOnlyResource):
    """Metadata for the metrics.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar name_properties_name: Name of the metric.
    :vartype name_properties_name: ~azure.mgmt.web.v2016_08_01.models.ResourceMetricName
    :ivar unit: Unit of the metric.
    :vartype unit: str
    :ivar primary_aggregation_type: Primary aggregation type.
    :vartype primary_aggregation_type: str
    :ivar metric_availabilities: List of time grains supported for the metric together with
     retention period.
    :vartype metric_availabilities:
     list[~azure.mgmt.web.v2016_08_01.models.ResourceMetricAvailability]
    :ivar resource_uri: Resource URI.
    :vartype resource_uri: str
    :ivar id_properties_id: Resource ID.
    :vartype id_properties_id: str
    :ivar properties: Resource metric definition properties.
    :vartype properties: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'name_properties_name': {'readonly': True},
        'unit': {'readonly': True},
        'primary_aggregation_type': {'readonly': True},
        'metric_availabilities': {'readonly': True},
        'resource_uri': {'readonly': True},
        'id_properties_id': {'readonly': True},
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name_properties_name': {'key': 'properties.name', 'type': 'ResourceMetricName'},
        'unit': {'key': 'properties.unit', 'type': 'str'},
        'primary_aggregation_type': {'key': 'properties.primaryAggregationType', 'type': 'str'},
        'metric_availabilities': {'key': 'properties.metricAvailabilities', 'type': '[ResourceMetricAvailability]'},
        'resource_uri': {'key': 'properties.resourceUri', 'type': 'str'},
        'id_properties_id': {'key': 'properties.id', 'type': 'str'},
        'properties': {'key': 'properties.properties', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super(ResourceMetricDefinition, self).__init__(kind=kind, **kwargs)
        self.name_properties_name = None
        self.unit = None
        self.primary_aggregation_type = None
        self.metric_availabilities = None
        self.resource_uri = None
        self.id_properties_id = None
        self.properties = None


class ResourceMetricDefinitionCollection(msrest.serialization.Model):
    """Collection of metric definitions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2016_08_01.models.ResourceMetricDefinition]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ResourceMetricDefinition]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["_models.ResourceMetricDefinition"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2016_08_01.models.ResourceMetricDefinition]
        """
        super(ResourceMetricDefinitionCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ResourceMetricName(msrest.serialization.Model):
    """Name of a metric for any resource .

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: metric name value.
    :vartype value: str
    :ivar localized_value: Localized metric name value.
    :vartype localized_value: str
    """

    _validation = {
        'value': {'readonly': True},
        'localized_value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ResourceMetricName, self).__init__(**kwargs)
        self.value = None
        self.localized_value = None


class ResourceMetricProperty(msrest.serialization.Model):
    """Resource metric property.

    :ivar key: Key for resource metric property.
    :vartype key: str
    :ivar value: Value of pair.
    :vartype value: str
    """

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key: Optional[str] = None,
        value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword key: Key for resource metric property.
        :paramtype key: str
        :keyword value: Value of pair.
        :paramtype value: str
        """
        super(ResourceMetricProperty, self).__init__(**kwargs)
        self.key = key
        self.value = value


class ResourceMetricValue(msrest.serialization.Model):
    """Value of resource metric.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar timestamp: Value timestamp.
    :vartype timestamp: str
    :ivar average: Value average.
    :vartype average: float
    :ivar minimum: Value minimum.
    :vartype minimum: float
    :ivar maximum: Value maximum.
    :vartype maximum: float
    :ivar total: Value total.
    :vartype total: float
    :ivar count: Value count.
    :vartype count: float
    :ivar properties: Resource metric properties collection.
    :vartype properties: list[~azure.mgmt.web.v2016_08_01.models.ResourceMetricProperty]
    """

    _validation = {
        'timestamp': {'readonly': True},
        'average': {'readonly': True},
        'minimum': {'readonly': True},
        'maximum': {'readonly': True},
        'total': {'readonly': True},
        'count': {'readonly': True},
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'timestamp': {'key': 'timestamp', 'type': 'str'},
        'average': {'key': 'average', 'type': 'float'},
        'minimum': {'key': 'minimum', 'type': 'float'},
        'maximum': {'key': 'maximum', 'type': 'float'},
        'total': {'key': 'total', 'type': 'float'},
        'count': {'key': 'count', 'type': 'float'},
        'properties': {'key': 'properties', 'type': '[ResourceMetricProperty]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ResourceMetricValue, self).__init__(**kwargs)
        self.timestamp = None
        self.average = None
        self.minimum = None
        self.maximum = None
        self.total = None
        self.count = None
        self.properties = None


class RestoreRequest(ProxyOnlyResource):
    """Description of a restore request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar storage_account_url: SAS URL to the container.
    :vartype storage_account_url: str
    :ivar blob_name: Name of a blob which contains the backup.
    :vartype blob_name: str
    :ivar overwrite: :code:`<code>true</code>` if the restore operation can overwrite target app;
     otherwise, :code:`<code>false</code>`. :code:`<code>true</code>` is needed if trying to restore
     over an existing app.
    :vartype overwrite: bool
    :ivar site_name: Name of an app.
    :vartype site_name: str
    :ivar databases: Collection of databases which should be restored. This list has to match the
     list of databases included in the backup.
    :vartype databases: list[~azure.mgmt.web.v2016_08_01.models.DatabaseBackupSetting]
    :ivar ignore_conflicting_host_names: Changes a logic when restoring an app with custom domains.
     :code:`<code>true</code>` to remove custom domains automatically. If
     :code:`<code>false</code>`, custom domains are added to
     the app's object when it is being restored, but that might fail due to conflicts during the
     operation.
    :vartype ignore_conflicting_host_names: bool
    :ivar ignore_databases: Ignore the databases and only restore the site content.
    :vartype ignore_databases: bool
    :ivar app_service_plan: Specify app service plan that will own restored site.
    :vartype app_service_plan: str
    :ivar operation_type: Operation type. Known values are: "Default", "Clone", "Relocation",
     "Snapshot".
    :vartype operation_type: str or ~azure.mgmt.web.v2016_08_01.models.BackupRestoreOperationType
    :ivar adjust_connection_strings: :code:`<code>true</code>` if SiteConfig.ConnectionStrings
     should be set in new app; otherwise, :code:`<code>false</code>`.
    :vartype adjust_connection_strings: bool
    :ivar hosting_environment: App Service Environment name, if needed (only when restoring an app
     to an App Service Environment).
    :vartype hosting_environment: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'storage_account_url': {'key': 'properties.storageAccountUrl', 'type': 'str'},
        'blob_name': {'key': 'properties.blobName', 'type': 'str'},
        'overwrite': {'key': 'properties.overwrite', 'type': 'bool'},
        'site_name': {'key': 'properties.siteName', 'type': 'str'},
        'databases': {'key': 'properties.databases', 'type': '[DatabaseBackupSetting]'},
        'ignore_conflicting_host_names': {'key': 'properties.ignoreConflictingHostNames', 'type': 'bool'},
        'ignore_databases': {'key': 'properties.ignoreDatabases', 'type': 'bool'},
        'app_service_plan': {'key': 'properties.appServicePlan', 'type': 'str'},
        'operation_type': {'key': 'properties.operationType', 'type': 'str'},
        'adjust_connection_strings': {'key': 'properties.adjustConnectionStrings', 'type': 'bool'},
        'hosting_environment': {'key': 'properties.hostingEnvironment', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        storage_account_url: Optional[str] = None,
        blob_name: Optional[str] = None,
        overwrite: Optional[bool] = None,
        site_name: Optional[str] = None,
        databases: Optional[List["_models.DatabaseBackupSetting"]] = None,
        ignore_conflicting_host_names: Optional[bool] = False,
        ignore_databases: Optional[bool] = False,
        app_service_plan: Optional[str] = None,
        operation_type: Optional[Union[str, "_models.BackupRestoreOperationType"]] = None,
        adjust_connection_strings: Optional[bool] = None,
        hosting_environment: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword storage_account_url: SAS URL to the container.
        :paramtype storage_account_url: str
        :keyword blob_name: Name of a blob which contains the backup.
        :paramtype blob_name: str
        :keyword overwrite: :code:`<code>true</code>` if the restore operation can overwrite target
         app; otherwise, :code:`<code>false</code>`. :code:`<code>true</code>` is needed if trying to
         restore over an existing app.
        :paramtype overwrite: bool
        :keyword site_name: Name of an app.
        :paramtype site_name: str
        :keyword databases: Collection of databases which should be restored. This list has to match
         the list of databases included in the backup.
        :paramtype databases: list[~azure.mgmt.web.v2016_08_01.models.DatabaseBackupSetting]
        :keyword ignore_conflicting_host_names: Changes a logic when restoring an app with custom
         domains. :code:`<code>true</code>` to remove custom domains automatically. If
         :code:`<code>false</code>`, custom domains are added to
         the app's object when it is being restored, but that might fail due to conflicts during the
         operation.
        :paramtype ignore_conflicting_host_names: bool
        :keyword ignore_databases: Ignore the databases and only restore the site content.
        :paramtype ignore_databases: bool
        :keyword app_service_plan: Specify app service plan that will own restored site.
        :paramtype app_service_plan: str
        :keyword operation_type: Operation type. Known values are: "Default", "Clone", "Relocation",
         "Snapshot".
        :paramtype operation_type: str or ~azure.mgmt.web.v2016_08_01.models.BackupRestoreOperationType
        :keyword adjust_connection_strings: :code:`<code>true</code>` if SiteConfig.ConnectionStrings
         should be set in new app; otherwise, :code:`<code>false</code>`.
        :paramtype adjust_connection_strings: bool
        :keyword hosting_environment: App Service Environment name, if needed (only when restoring an
         app to an App Service Environment).
        :paramtype hosting_environment: str
        """
        super(RestoreRequest, self).__init__(kind=kind, **kwargs)
        self.storage_account_url = storage_account_url
        self.blob_name = blob_name
        self.overwrite = overwrite
        self.site_name = site_name
        self.databases = databases
        self.ignore_conflicting_host_names = ignore_conflicting_host_names
        self.ignore_databases = ignore_databases
        self.app_service_plan = app_service_plan
        self.operation_type = operation_type
        self.adjust_connection_strings = adjust_connection_strings
        self.hosting_environment = hosting_environment


class RestoreResponse(ProxyOnlyResource):
    """Response for an app restore request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar operation_id: When server starts the restore process, it will return an operation ID
     identifying that particular restore operation.
    :vartype operation_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'operation_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'operation_id': {'key': 'properties.operationId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super(RestoreResponse, self).__init__(kind=kind, **kwargs)
        self.operation_id = None


class Site(Resource):
    """A web app, a mobile app backend, or an API app.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar location: Required. Resource Location.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar identity: Managed service identity.
    :vartype identity: ~azure.mgmt.web.v2016_08_01.models.ManagedServiceIdentity
    :ivar state: Current state of the app.
    :vartype state: str
    :ivar host_names: Hostnames associated with the app.
    :vartype host_names: list[str]
    :ivar repository_site_name: Name of the repository site.
    :vartype repository_site_name: str
    :ivar usage_state: State indicating whether the app has exceeded its quota usage. Read-only.
     Known values are: "Normal", "Exceeded".
    :vartype usage_state: str or ~azure.mgmt.web.v2016_08_01.models.UsageState
    :ivar enabled: :code:`<code>true</code>` if the app is enabled; otherwise,
     :code:`<code>false</code>`. Setting this value to false disables the app (takes the app
     offline).
    :vartype enabled: bool
    :ivar enabled_host_names: Enabled hostnames for the app.Hostnames need to be assigned (see
     HostNames) AND enabled. Otherwise,
     the app is not served on those hostnames.
    :vartype enabled_host_names: list[str]
    :ivar availability_state: Management information availability state for the app. Known values
     are: "Normal", "Limited", "DisasterRecoveryMode".
    :vartype availability_state: str or ~azure.mgmt.web.v2016_08_01.models.SiteAvailabilityState
    :ivar host_name_ssl_states: Hostname SSL states are used to manage the SSL bindings for app's
     hostnames.
    :vartype host_name_ssl_states: list[~azure.mgmt.web.v2016_08_01.models.HostNameSslState]
    :ivar server_farm_id: Resource ID of the associated App Service plan, formatted as:
     "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
    :vartype server_farm_id: str
    :ivar reserved: :code:`<code>true</code>` if reserved; otherwise, :code:`<code>false</code>`.
    :vartype reserved: bool
    :ivar last_modified_time_utc: Last time the app was modified, in UTC. Read-only.
    :vartype last_modified_time_utc: ~datetime.datetime
    :ivar site_config: Configuration of the app.
    :vartype site_config: ~azure.mgmt.web.v2016_08_01.models.SiteConfig
    :ivar traffic_manager_host_names: Azure Traffic Manager hostnames associated with the app.
     Read-only.
    :vartype traffic_manager_host_names: list[str]
    :ivar scm_site_also_stopped: :code:`<code>true</code>` to stop SCM (KUDU) site when the app is
     stopped; otherwise, :code:`<code>false</code>`. The default is :code:`<code>false</code>`.
    :vartype scm_site_also_stopped: bool
    :ivar target_swap_slot: Specifies which deployment slot this app will swap into. Read-only.
    :vartype target_swap_slot: str
    :ivar hosting_environment_profile: App Service Environment to use for the app.
    :vartype hosting_environment_profile:
     ~azure.mgmt.web.v2016_08_01.models.HostingEnvironmentProfile
    :ivar client_affinity_enabled: :code:`<code>true</code>` to enable client affinity;
     :code:`<code>false</code>` to stop sending session affinity cookies, which route client
     requests in the same session to the same instance. Default is :code:`<code>true</code>`.
    :vartype client_affinity_enabled: bool
    :ivar client_cert_enabled: :code:`<code>true</code>` to enable client certificate
     authentication (TLS mutual authentication); otherwise, :code:`<code>false</code>`. Default is
     :code:`<code>false</code>`.
    :vartype client_cert_enabled: bool
    :ivar host_names_disabled: :code:`<code>true</code>` to disable the public hostnames of the
     app; otherwise, :code:`<code>false</code>`.
      If :code:`<code>true</code>`, the app is only accessible via API management process.
    :vartype host_names_disabled: bool
    :ivar outbound_ip_addresses: List of IP addresses that the app uses for outbound connections
     (e.g. database access). Includes VIPs from tenants that site can be hosted with current
     settings. Read-only.
    :vartype outbound_ip_addresses: str
    :ivar possible_outbound_ip_addresses: List of IP addresses that the app uses for outbound
     connections (e.g. database access). Includes VIPs from all tenants. Read-only.
    :vartype possible_outbound_ip_addresses: str
    :ivar container_size: Size of the function container.
    :vartype container_size: int
    :ivar daily_memory_time_quota: Maximum allowed daily memory-time quota (applicable on dynamic
     apps only).
    :vartype daily_memory_time_quota: int
    :ivar suspended_till: App suspended till in case memory-time quota is exceeded.
    :vartype suspended_till: ~datetime.datetime
    :ivar max_number_of_workers: Maximum number of workers.
     This only applies to Functions container.
    :vartype max_number_of_workers: int
    :ivar cloning_info: If specified during app creation, the app is cloned from a source app.
    :vartype cloning_info: ~azure.mgmt.web.v2016_08_01.models.CloningInfo
    :ivar snapshot_info: If specified during app creation, the app is created from a previous
     snapshot.
    :vartype snapshot_info: ~azure.mgmt.web.v2016_08_01.models.SnapshotRecoveryRequest
    :ivar resource_group: Name of the resource group the app belongs to. Read-only.
    :vartype resource_group: str
    :ivar is_default_container: :code:`<code>true</code>` if the app is a default container;
     otherwise, :code:`<code>false</code>`.
    :vartype is_default_container: bool
    :ivar default_host_name: Default hostname of the app. Read-only.
    :vartype default_host_name: str
    :ivar slot_swap_status: Status of the last deployment slot swap operation.
    :vartype slot_swap_status: ~azure.mgmt.web.v2016_08_01.models.SlotSwapStatus
    :ivar https_only: HttpsOnly: configures a web site to accept only https requests. Issues
     redirect for
     http requests.
    :vartype https_only: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
        'state': {'readonly': True},
        'host_names': {'readonly': True},
        'repository_site_name': {'readonly': True},
        'usage_state': {'readonly': True},
        'enabled_host_names': {'readonly': True},
        'availability_state': {'readonly': True},
        'last_modified_time_utc': {'readonly': True},
        'traffic_manager_host_names': {'readonly': True},
        'target_swap_slot': {'readonly': True},
        'outbound_ip_addresses': {'readonly': True},
        'possible_outbound_ip_addresses': {'readonly': True},
        'suspended_till': {'readonly': True},
        'max_number_of_workers': {'readonly': True},
        'resource_group': {'readonly': True},
        'is_default_container': {'readonly': True},
        'default_host_name': {'readonly': True},
        'slot_swap_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'host_names': {'key': 'properties.hostNames', 'type': '[str]'},
        'repository_site_name': {'key': 'properties.repositorySiteName', 'type': 'str'},
        'usage_state': {'key': 'properties.usageState', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'enabled_host_names': {'key': 'properties.enabledHostNames', 'type': '[str]'},
        'availability_state': {'key': 'properties.availabilityState', 'type': 'str'},
        'host_name_ssl_states': {'key': 'properties.hostNameSslStates', 'type': '[HostNameSslState]'},
        'server_farm_id': {'key': 'properties.serverFarmId', 'type': 'str'},
        'reserved': {'key': 'properties.reserved', 'type': 'bool'},
        'last_modified_time_utc': {'key': 'properties.lastModifiedTimeUtc', 'type': 'iso-8601'},
        'site_config': {'key': 'properties.siteConfig', 'type': 'SiteConfig'},
        'traffic_manager_host_names': {'key': 'properties.trafficManagerHostNames', 'type': '[str]'},
        'scm_site_also_stopped': {'key': 'properties.scmSiteAlsoStopped', 'type': 'bool'},
        'target_swap_slot': {'key': 'properties.targetSwapSlot', 'type': 'str'},
        'hosting_environment_profile': {'key': 'properties.hostingEnvironmentProfile', 'type': 'HostingEnvironmentProfile'},
        'client_affinity_enabled': {'key': 'properties.clientAffinityEnabled', 'type': 'bool'},
        'client_cert_enabled': {'key': 'properties.clientCertEnabled', 'type': 'bool'},
        'host_names_disabled': {'key': 'properties.hostNamesDisabled', 'type': 'bool'},
        'outbound_ip_addresses': {'key': 'properties.outboundIpAddresses', 'type': 'str'},
        'possible_outbound_ip_addresses': {'key': 'properties.possibleOutboundIpAddresses', 'type': 'str'},
        'container_size': {'key': 'properties.containerSize', 'type': 'int'},
        'daily_memory_time_quota': {'key': 'properties.dailyMemoryTimeQuota', 'type': 'int'},
        'suspended_till': {'key': 'properties.suspendedTill', 'type': 'iso-8601'},
        'max_number_of_workers': {'key': 'properties.maxNumberOfWorkers', 'type': 'int'},
        'cloning_info': {'key': 'properties.cloningInfo', 'type': 'CloningInfo'},
        'snapshot_info': {'key': 'properties.snapshotInfo', 'type': 'SnapshotRecoveryRequest'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'is_default_container': {'key': 'properties.isDefaultContainer', 'type': 'bool'},
        'default_host_name': {'key': 'properties.defaultHostName', 'type': 'str'},
        'slot_swap_status': {'key': 'properties.slotSwapStatus', 'type': 'SlotSwapStatus'},
        'https_only': {'key': 'properties.httpsOnly', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        enabled: Optional[bool] = None,
        host_name_ssl_states: Optional[List["_models.HostNameSslState"]] = None,
        server_farm_id: Optional[str] = None,
        reserved: Optional[bool] = False,
        site_config: Optional["_models.SiteConfig"] = None,
        scm_site_also_stopped: Optional[bool] = False,
        hosting_environment_profile: Optional["_models.HostingEnvironmentProfile"] = None,
        client_affinity_enabled: Optional[bool] = None,
        client_cert_enabled: Optional[bool] = None,
        host_names_disabled: Optional[bool] = None,
        container_size: Optional[int] = None,
        daily_memory_time_quota: Optional[int] = None,
        cloning_info: Optional["_models.CloningInfo"] = None,
        snapshot_info: Optional["_models.SnapshotRecoveryRequest"] = None,
        https_only: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword location: Required. Resource Location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword identity: Managed service identity.
        :paramtype identity: ~azure.mgmt.web.v2016_08_01.models.ManagedServiceIdentity
        :keyword enabled: :code:`<code>true</code>` if the app is enabled; otherwise,
         :code:`<code>false</code>`. Setting this value to false disables the app (takes the app
         offline).
        :paramtype enabled: bool
        :keyword host_name_ssl_states: Hostname SSL states are used to manage the SSL bindings for
         app's hostnames.
        :paramtype host_name_ssl_states: list[~azure.mgmt.web.v2016_08_01.models.HostNameSslState]
        :keyword server_farm_id: Resource ID of the associated App Service plan, formatted as:
         "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
        :paramtype server_farm_id: str
        :keyword reserved: :code:`<code>true</code>` if reserved; otherwise,
         :code:`<code>false</code>`.
        :paramtype reserved: bool
        :keyword site_config: Configuration of the app.
        :paramtype site_config: ~azure.mgmt.web.v2016_08_01.models.SiteConfig
        :keyword scm_site_also_stopped: :code:`<code>true</code>` to stop SCM (KUDU) site when the app
         is stopped; otherwise, :code:`<code>false</code>`. The default is :code:`<code>false</code>`.
        :paramtype scm_site_also_stopped: bool
        :keyword hosting_environment_profile: App Service Environment to use for the app.
        :paramtype hosting_environment_profile:
         ~azure.mgmt.web.v2016_08_01.models.HostingEnvironmentProfile
        :keyword client_affinity_enabled: :code:`<code>true</code>` to enable client affinity;
         :code:`<code>false</code>` to stop sending session affinity cookies, which route client
         requests in the same session to the same instance. Default is :code:`<code>true</code>`.
        :paramtype client_affinity_enabled: bool
        :keyword client_cert_enabled: :code:`<code>true</code>` to enable client certificate
         authentication (TLS mutual authentication); otherwise, :code:`<code>false</code>`. Default is
         :code:`<code>false</code>`.
        :paramtype client_cert_enabled: bool
        :keyword host_names_disabled: :code:`<code>true</code>` to disable the public hostnames of the
         app; otherwise, :code:`<code>false</code>`.
          If :code:`<code>true</code>`, the app is only accessible via API management process.
        :paramtype host_names_disabled: bool
        :keyword container_size: Size of the function container.
        :paramtype container_size: int
        :keyword daily_memory_time_quota: Maximum allowed daily memory-time quota (applicable on
         dynamic apps only).
        :paramtype daily_memory_time_quota: int
        :keyword cloning_info: If specified during app creation, the app is cloned from a source app.
        :paramtype cloning_info: ~azure.mgmt.web.v2016_08_01.models.CloningInfo
        :keyword snapshot_info: If specified during app creation, the app is created from a previous
         snapshot.
        :paramtype snapshot_info: ~azure.mgmt.web.v2016_08_01.models.SnapshotRecoveryRequest
        :keyword https_only: HttpsOnly: configures a web site to accept only https requests. Issues
         redirect for
         http requests.
        :paramtype https_only: bool
        """
        super(Site, self).__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.identity = identity
        self.state = None
        self.host_names = None
        self.repository_site_name = None
        self.usage_state = None
        self.enabled = enabled
        self.enabled_host_names = None
        self.availability_state = None
        self.host_name_ssl_states = host_name_ssl_states
        self.server_farm_id = server_farm_id
        self.reserved = reserved
        self.last_modified_time_utc = None
        self.site_config = site_config
        self.traffic_manager_host_names = None
        self.scm_site_also_stopped = scm_site_also_stopped
        self.target_swap_slot = None
        self.hosting_environment_profile = hosting_environment_profile
        self.client_affinity_enabled = client_affinity_enabled
        self.client_cert_enabled = client_cert_enabled
        self.host_names_disabled = host_names_disabled
        self.outbound_ip_addresses = None
        self.possible_outbound_ip_addresses = None
        self.container_size = container_size
        self.daily_memory_time_quota = daily_memory_time_quota
        self.suspended_till = None
        self.max_number_of_workers = None
        self.cloning_info = cloning_info
        self.snapshot_info = snapshot_info
        self.resource_group = None
        self.is_default_container = None
        self.default_host_name = None
        self.slot_swap_status = None
        self.https_only = https_only


class SiteAuthSettings(ProxyOnlyResource):
    """Configuration settings for the Azure App Service Authentication / Authorization feature.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar enabled: :code:`<code>true</code>` if the Authentication / Authorization feature is
     enabled for the current app; otherwise, :code:`<code>false</code>`.
    :vartype enabled: bool
    :ivar runtime_version: The RuntimeVersion of the Authentication / Authorization feature in use
     for the current app.
     The setting in this value can control the behavior of certain features in the Authentication /
     Authorization module.
    :vartype runtime_version: str
    :ivar unauthenticated_client_action: The action to take when an unauthenticated client attempts
     to access the app. Known values are: "RedirectToLoginPage", "AllowAnonymous".
    :vartype unauthenticated_client_action: str or
     ~azure.mgmt.web.v2016_08_01.models.UnauthenticatedClientAction
    :ivar token_store_enabled: :code:`<code>true</code>` to durably store platform-specific
     security tokens that are obtained during login flows; otherwise, :code:`<code>false</code>`.
      The default is :code:`<code>false</code>`.
    :vartype token_store_enabled: bool
    :ivar allowed_external_redirect_urls: External URLs that can be redirected to as part of
     logging in or logging out of the app. Note that the query string part of the URL is ignored.
     This is an advanced setting typically only needed by Windows Store application backends.
     Note that URLs within the current domain are always implicitly allowed.
    :vartype allowed_external_redirect_urls: list[str]
    :ivar default_provider: The default authentication provider to use when multiple providers are
     configured.
     This setting is only needed if multiple providers are configured and the unauthenticated
     client
     action is set to "RedirectToLoginPage". Known values are: "AzureActiveDirectory", "Facebook",
     "Google", "MicrosoftAccount", "Twitter".
    :vartype default_provider: str or
     ~azure.mgmt.web.v2016_08_01.models.BuiltInAuthenticationProvider
    :ivar token_refresh_extension_hours: The number of hours after session token expiration that a
     session token can be used to
     call the token refresh API. The default is 72 hours.
    :vartype token_refresh_extension_hours: float
    :ivar client_id: The Client ID of this relying party application, known as the client_id.
     This setting is required for enabling OpenID Connection authentication with Azure Active
     Directory or
     other 3rd party OpenID Connect providers.
     More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html.
    :vartype client_id: str
    :ivar client_secret: The Client Secret of this relying party application (in Azure Active
     Directory, this is also referred to as the Key).
     This setting is optional. If no client secret is configured, the OpenID Connect implicit auth
     flow is used to authenticate end users.
     Otherwise, the OpenID Connect Authorization Code Flow is used to authenticate end users.
     More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html.
    :vartype client_secret: str
    :ivar issuer: The OpenID Connect Issuer URI that represents the entity which issues access
     tokens for this application.
     When using Azure Active Directory, this value is the URI of the directory tenant, e.g.
     https://sts.windows.net/{tenant-guid}/.
     This URI is a case-sensitive identifier for the token issuer.
     More information on OpenID Connect Discovery:
     http://openid.net/specs/openid-connect-discovery-1_0.html.
    :vartype issuer: str
    :ivar allowed_audiences: Allowed audience values to consider when validating JWTs issued by
     Azure Active Directory. Note that the :code:`<code>ClientID</code>` value is always considered
     an
     allowed audience, regardless of this setting.
    :vartype allowed_audiences: list[str]
    :ivar additional_login_params: Login parameters to send to the OpenID Connect authorization
     endpoint when
     a user logs in. Each parameter must be in the form "key=value".
    :vartype additional_login_params: list[str]
    :ivar google_client_id: The OpenID Connect Client ID for the Google web application.
     This setting is required for enabling Google Sign-In.
     Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/.
    :vartype google_client_id: str
    :ivar google_client_secret: The client secret associated with the Google web application.
     This setting is required for enabling Google Sign-In.
     Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/.
    :vartype google_client_secret: str
    :ivar google_o_auth_scopes: The OAuth 2.0 scopes that will be requested as part of Google
     Sign-In authentication.
     This setting is optional. If not specified, "openid", "profile", and "email" are used as
     default scopes.
     Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/.
    :vartype google_o_auth_scopes: list[str]
    :ivar facebook_app_id: The App ID of the Facebook app used for login.
     This setting is required for enabling Facebook Login.
     Facebook Login documentation: https://developers.facebook.com/docs/facebook-login.
    :vartype facebook_app_id: str
    :ivar facebook_app_secret: The App Secret of the Facebook app used for Facebook Login.
     This setting is required for enabling Facebook Login.
     Facebook Login documentation: https://developers.facebook.com/docs/facebook-login.
    :vartype facebook_app_secret: str
    :ivar facebook_o_auth_scopes: The OAuth 2.0 scopes that will be requested as part of Facebook
     Login authentication.
     This setting is optional.
     Facebook Login documentation: https://developers.facebook.com/docs/facebook-login.
    :vartype facebook_o_auth_scopes: list[str]
    :ivar twitter_consumer_key: The OAuth 1.0a consumer key of the Twitter application used for
     sign-in.
     This setting is required for enabling Twitter Sign-In.
     Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in.
    :vartype twitter_consumer_key: str
    :ivar twitter_consumer_secret: The OAuth 1.0a consumer secret of the Twitter application used
     for sign-in.
     This setting is required for enabling Twitter Sign-In.
     Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in.
    :vartype twitter_consumer_secret: str
    :ivar microsoft_account_client_id: The OAuth 2.0 client ID that was created for the app used
     for authentication.
     This setting is required for enabling Microsoft Account authentication.
     Microsoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm.
    :vartype microsoft_account_client_id: str
    :ivar microsoft_account_client_secret: The OAuth 2.0 client secret that was created for the app
     used for authentication.
     This setting is required for enabling Microsoft Account authentication.
     Microsoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm.
    :vartype microsoft_account_client_secret: str
    :ivar microsoft_account_o_auth_scopes: The OAuth 2.0 scopes that will be requested as part of
     Microsoft Account authentication.
     This setting is optional. If not specified, "wl.basic" is used as the default scope.
     Microsoft Account Scopes and permissions documentation:
     https://msdn.microsoft.com/en-us/library/dn631845.aspx.
    :vartype microsoft_account_o_auth_scopes: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'runtime_version': {'key': 'properties.runtimeVersion', 'type': 'str'},
        'unauthenticated_client_action': {'key': 'properties.unauthenticatedClientAction', 'type': 'str'},
        'token_store_enabled': {'key': 'properties.tokenStoreEnabled', 'type': 'bool'},
        'allowed_external_redirect_urls': {'key': 'properties.allowedExternalRedirectUrls', 'type': '[str]'},
        'default_provider': {'key': 'properties.defaultProvider', 'type': 'str'},
        'token_refresh_extension_hours': {'key': 'properties.tokenRefreshExtensionHours', 'type': 'float'},
        'client_id': {'key': 'properties.clientId', 'type': 'str'},
        'client_secret': {'key': 'properties.clientSecret', 'type': 'str'},
        'issuer': {'key': 'properties.issuer', 'type': 'str'},
        'allowed_audiences': {'key': 'properties.allowedAudiences', 'type': '[str]'},
        'additional_login_params': {'key': 'properties.additionalLoginParams', 'type': '[str]'},
        'google_client_id': {'key': 'properties.googleClientId', 'type': 'str'},
        'google_client_secret': {'key': 'properties.googleClientSecret', 'type': 'str'},
        'google_o_auth_scopes': {'key': 'properties.googleOAuthScopes', 'type': '[str]'},
        'facebook_app_id': {'key': 'properties.facebookAppId', 'type': 'str'},
        'facebook_app_secret': {'key': 'properties.facebookAppSecret', 'type': 'str'},
        'facebook_o_auth_scopes': {'key': 'properties.facebookOAuthScopes', 'type': '[str]'},
        'twitter_consumer_key': {'key': 'properties.twitterConsumerKey', 'type': 'str'},
        'twitter_consumer_secret': {'key': 'properties.twitterConsumerSecret', 'type': 'str'},
        'microsoft_account_client_id': {'key': 'properties.microsoftAccountClientId', 'type': 'str'},
        'microsoft_account_client_secret': {'key': 'properties.microsoftAccountClientSecret', 'type': 'str'},
        'microsoft_account_o_auth_scopes': {'key': 'properties.microsoftAccountOAuthScopes', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        enabled: Optional[bool] = None,
        runtime_version: Optional[str] = None,
        unauthenticated_client_action: Optional[Union[str, "_models.UnauthenticatedClientAction"]] = None,
        token_store_enabled: Optional[bool] = None,
        allowed_external_redirect_urls: Optional[List[str]] = None,
        default_provider: Optional[Union[str, "_models.BuiltInAuthenticationProvider"]] = None,
        token_refresh_extension_hours: Optional[float] = None,
        client_id: Optional[str] = None,
        client_secret: Optional[str] = None,
        issuer: Optional[str] = None,
        allowed_audiences: Optional[List[str]] = None,
        additional_login_params: Optional[List[str]] = None,
        google_client_id: Optional[str] = None,
        google_client_secret: Optional[str] = None,
        google_o_auth_scopes: Optional[List[str]] = None,
        facebook_app_id: Optional[str] = None,
        facebook_app_secret: Optional[str] = None,
        facebook_o_auth_scopes: Optional[List[str]] = None,
        twitter_consumer_key: Optional[str] = None,
        twitter_consumer_secret: Optional[str] = None,
        microsoft_account_client_id: Optional[str] = None,
        microsoft_account_client_secret: Optional[str] = None,
        microsoft_account_o_auth_scopes: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword enabled: :code:`<code>true</code>` if the Authentication / Authorization feature is
         enabled for the current app; otherwise, :code:`<code>false</code>`.
        :paramtype enabled: bool
        :keyword runtime_version: The RuntimeVersion of the Authentication / Authorization feature in
         use for the current app.
         The setting in this value can control the behavior of certain features in the Authentication /
         Authorization module.
        :paramtype runtime_version: str
        :keyword unauthenticated_client_action: The action to take when an unauthenticated client
         attempts to access the app. Known values are: "RedirectToLoginPage", "AllowAnonymous".
        :paramtype unauthenticated_client_action: str or
         ~azure.mgmt.web.v2016_08_01.models.UnauthenticatedClientAction
        :keyword token_store_enabled: :code:`<code>true</code>` to durably store platform-specific
         security tokens that are obtained during login flows; otherwise, :code:`<code>false</code>`.
          The default is :code:`<code>false</code>`.
        :paramtype token_store_enabled: bool
        :keyword allowed_external_redirect_urls: External URLs that can be redirected to as part of
         logging in or logging out of the app. Note that the query string part of the URL is ignored.
         This is an advanced setting typically only needed by Windows Store application backends.
         Note that URLs within the current domain are always implicitly allowed.
        :paramtype allowed_external_redirect_urls: list[str]
        :keyword default_provider: The default authentication provider to use when multiple providers
         are configured.
         This setting is only needed if multiple providers are configured and the unauthenticated
         client
         action is set to "RedirectToLoginPage". Known values are: "AzureActiveDirectory", "Facebook",
         "Google", "MicrosoftAccount", "Twitter".
        :paramtype default_provider: str or
         ~azure.mgmt.web.v2016_08_01.models.BuiltInAuthenticationProvider
        :keyword token_refresh_extension_hours: The number of hours after session token expiration that
         a session token can be used to
         call the token refresh API. The default is 72 hours.
        :paramtype token_refresh_extension_hours: float
        :keyword client_id: The Client ID of this relying party application, known as the client_id.
         This setting is required for enabling OpenID Connection authentication with Azure Active
         Directory or
         other 3rd party OpenID Connect providers.
         More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html.
        :paramtype client_id: str
        :keyword client_secret: The Client Secret of this relying party application (in Azure Active
         Directory, this is also referred to as the Key).
         This setting is optional. If no client secret is configured, the OpenID Connect implicit auth
         flow is used to authenticate end users.
         Otherwise, the OpenID Connect Authorization Code Flow is used to authenticate end users.
         More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html.
        :paramtype client_secret: str
        :keyword issuer: The OpenID Connect Issuer URI that represents the entity which issues access
         tokens for this application.
         When using Azure Active Directory, this value is the URI of the directory tenant, e.g.
         https://sts.windows.net/{tenant-guid}/.
         This URI is a case-sensitive identifier for the token issuer.
         More information on OpenID Connect Discovery:
         http://openid.net/specs/openid-connect-discovery-1_0.html.
        :paramtype issuer: str
        :keyword allowed_audiences: Allowed audience values to consider when validating JWTs issued by
         Azure Active Directory. Note that the :code:`<code>ClientID</code>` value is always considered
         an
         allowed audience, regardless of this setting.
        :paramtype allowed_audiences: list[str]
        :keyword additional_login_params: Login parameters to send to the OpenID Connect authorization
         endpoint when
         a user logs in. Each parameter must be in the form "key=value".
        :paramtype additional_login_params: list[str]
        :keyword google_client_id: The OpenID Connect Client ID for the Google web application.
         This setting is required for enabling Google Sign-In.
         Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/.
        :paramtype google_client_id: str
        :keyword google_client_secret: The client secret associated with the Google web application.
         This setting is required for enabling Google Sign-In.
         Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/.
        :paramtype google_client_secret: str
        :keyword google_o_auth_scopes: The OAuth 2.0 scopes that will be requested as part of Google
         Sign-In authentication.
         This setting is optional. If not specified, "openid", "profile", and "email" are used as
         default scopes.
         Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/.
        :paramtype google_o_auth_scopes: list[str]
        :keyword facebook_app_id: The App ID of the Facebook app used for login.
         This setting is required for enabling Facebook Login.
         Facebook Login documentation: https://developers.facebook.com/docs/facebook-login.
        :paramtype facebook_app_id: str
        :keyword facebook_app_secret: The App Secret of the Facebook app used for Facebook Login.
         This setting is required for enabling Facebook Login.
         Facebook Login documentation: https://developers.facebook.com/docs/facebook-login.
        :paramtype facebook_app_secret: str
        :keyword facebook_o_auth_scopes: The OAuth 2.0 scopes that will be requested as part of
         Facebook Login authentication.
         This setting is optional.
         Facebook Login documentation: https://developers.facebook.com/docs/facebook-login.
        :paramtype facebook_o_auth_scopes: list[str]
        :keyword twitter_consumer_key: The OAuth 1.0a consumer key of the Twitter application used for
         sign-in.
         This setting is required for enabling Twitter Sign-In.
         Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in.
        :paramtype twitter_consumer_key: str
        :keyword twitter_consumer_secret: The OAuth 1.0a consumer secret of the Twitter application
         used for sign-in.
         This setting is required for enabling Twitter Sign-In.
         Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in.
        :paramtype twitter_consumer_secret: str
        :keyword microsoft_account_client_id: The OAuth 2.0 client ID that was created for the app used
         for authentication.
         This setting is required for enabling Microsoft Account authentication.
         Microsoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm.
        :paramtype microsoft_account_client_id: str
        :keyword microsoft_account_client_secret: The OAuth 2.0 client secret that was created for the
         app used for authentication.
         This setting is required for enabling Microsoft Account authentication.
         Microsoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm.
        :paramtype microsoft_account_client_secret: str
        :keyword microsoft_account_o_auth_scopes: The OAuth 2.0 scopes that will be requested as part
         of Microsoft Account authentication.
         This setting is optional. If not specified, "wl.basic" is used as the default scope.
         Microsoft Account Scopes and permissions documentation:
         https://msdn.microsoft.com/en-us/library/dn631845.aspx.
        :paramtype microsoft_account_o_auth_scopes: list[str]
        """
        super(SiteAuthSettings, self).__init__(kind=kind, **kwargs)
        self.enabled = enabled
        self.runtime_version = runtime_version
        self.unauthenticated_client_action = unauthenticated_client_action
        self.token_store_enabled = token_store_enabled
        self.allowed_external_redirect_urls = allowed_external_redirect_urls
        self.default_provider = default_provider
        self.token_refresh_extension_hours = token_refresh_extension_hours
        self.client_id = client_id
        self.client_secret = client_secret
        self.issuer = issuer
        self.allowed_audiences = allowed_audiences
        self.additional_login_params = additional_login_params
        self.google_client_id = google_client_id
        self.google_client_secret = google_client_secret
        self.google_o_auth_scopes = google_o_auth_scopes
        self.facebook_app_id = facebook_app_id
        self.facebook_app_secret = facebook_app_secret
        self.facebook_o_auth_scopes = facebook_o_auth_scopes
        self.twitter_consumer_key = twitter_consumer_key
        self.twitter_consumer_secret = twitter_consumer_secret
        self.microsoft_account_client_id = microsoft_account_client_id
        self.microsoft_account_client_secret = microsoft_account_client_secret
        self.microsoft_account_o_auth_scopes = microsoft_account_o_auth_scopes


class SiteCloneability(msrest.serialization.Model):
    """Represents whether or not an app is cloneable.

    :ivar result: Name of app. Known values are: "Cloneable", "PartiallyCloneable", "NotCloneable".
    :vartype result: str or ~azure.mgmt.web.v2016_08_01.models.CloneAbilityResult
    :ivar blocking_features: List of features enabled on app that prevent cloning.
    :vartype blocking_features: list[~azure.mgmt.web.v2016_08_01.models.SiteCloneabilityCriterion]
    :ivar unsupported_features: List of features enabled on app that are non-blocking but cannot be
     cloned. The app can still be cloned
     but the features in this list will not be set up on cloned app.
    :vartype unsupported_features:
     list[~azure.mgmt.web.v2016_08_01.models.SiteCloneabilityCriterion]
    :ivar blocking_characteristics: List of blocking application characteristics.
    :vartype blocking_characteristics:
     list[~azure.mgmt.web.v2016_08_01.models.SiteCloneabilityCriterion]
    """

    _attribute_map = {
        'result': {'key': 'result', 'type': 'str'},
        'blocking_features': {'key': 'blockingFeatures', 'type': '[SiteCloneabilityCriterion]'},
        'unsupported_features': {'key': 'unsupportedFeatures', 'type': '[SiteCloneabilityCriterion]'},
        'blocking_characteristics': {'key': 'blockingCharacteristics', 'type': '[SiteCloneabilityCriterion]'},
    }

    def __init__(
        self,
        *,
        result: Optional[Union[str, "_models.CloneAbilityResult"]] = None,
        blocking_features: Optional[List["_models.SiteCloneabilityCriterion"]] = None,
        unsupported_features: Optional[List["_models.SiteCloneabilityCriterion"]] = None,
        blocking_characteristics: Optional[List["_models.SiteCloneabilityCriterion"]] = None,
        **kwargs
    ):
        """
        :keyword result: Name of app. Known values are: "Cloneable", "PartiallyCloneable",
         "NotCloneable".
        :paramtype result: str or ~azure.mgmt.web.v2016_08_01.models.CloneAbilityResult
        :keyword blocking_features: List of features enabled on app that prevent cloning.
        :paramtype blocking_features:
         list[~azure.mgmt.web.v2016_08_01.models.SiteCloneabilityCriterion]
        :keyword unsupported_features: List of features enabled on app that are non-blocking but cannot
         be cloned. The app can still be cloned
         but the features in this list will not be set up on cloned app.
        :paramtype unsupported_features:
         list[~azure.mgmt.web.v2016_08_01.models.SiteCloneabilityCriterion]
        :keyword blocking_characteristics: List of blocking application characteristics.
        :paramtype blocking_characteristics:
         list[~azure.mgmt.web.v2016_08_01.models.SiteCloneabilityCriterion]
        """
        super(SiteCloneability, self).__init__(**kwargs)
        self.result = result
        self.blocking_features = blocking_features
        self.unsupported_features = unsupported_features
        self.blocking_characteristics = blocking_characteristics


class SiteCloneabilityCriterion(msrest.serialization.Model):
    """An app cloneability criterion.

    :ivar name: Name of criterion.
    :vartype name: str
    :ivar description: Description of criterion.
    :vartype description: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Name of criterion.
        :paramtype name: str
        :keyword description: Description of criterion.
        :paramtype description: str
        """
        super(SiteCloneabilityCriterion, self).__init__(**kwargs)
        self.name = name
        self.description = description


class SiteConfig(msrest.serialization.Model):
    """Configuration of an App Service app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar number_of_workers: Number of workers.
    :vartype number_of_workers: int
    :ivar default_documents: Default documents.
    :vartype default_documents: list[str]
    :ivar net_framework_version: .NET Framework version.
    :vartype net_framework_version: str
    :ivar php_version: Version of PHP.
    :vartype php_version: str
    :ivar python_version: Version of Python.
    :vartype python_version: str
    :ivar node_version: Version of Node.js.
    :vartype node_version: str
    :ivar linux_fx_version: Linux App Framework and version.
    :vartype linux_fx_version: str
    :ivar request_tracing_enabled: :code:`<code>true</code>` if request tracing is enabled;
     otherwise, :code:`<code>false</code>`.
    :vartype request_tracing_enabled: bool
    :ivar request_tracing_expiration_time: Request tracing expiration time.
    :vartype request_tracing_expiration_time: ~datetime.datetime
    :ivar remote_debugging_enabled: :code:`<code>true</code>` if remote debugging is enabled;
     otherwise, :code:`<code>false</code>`.
    :vartype remote_debugging_enabled: bool
    :ivar remote_debugging_version: Remote debugging version.
    :vartype remote_debugging_version: str
    :ivar http_logging_enabled: :code:`<code>true</code>` if HTTP logging is enabled; otherwise,
     :code:`<code>false</code>`.
    :vartype http_logging_enabled: bool
    :ivar logs_directory_size_limit: HTTP logs directory size limit.
    :vartype logs_directory_size_limit: int
    :ivar detailed_error_logging_enabled: :code:`<code>true</code>` if detailed error logging is
     enabled; otherwise, :code:`<code>false</code>`.
    :vartype detailed_error_logging_enabled: bool
    :ivar publishing_username: Publishing user name.
    :vartype publishing_username: str
    :ivar app_settings: Application settings.
    :vartype app_settings: list[~azure.mgmt.web.v2016_08_01.models.NameValuePair]
    :ivar connection_strings: Connection strings.
    :vartype connection_strings: list[~azure.mgmt.web.v2016_08_01.models.ConnStringInfo]
    :ivar machine_key: Site MachineKey.
    :vartype machine_key: ~azure.mgmt.web.v2016_08_01.models.SiteMachineKey
    :ivar handler_mappings: Handler mappings.
    :vartype handler_mappings: list[~azure.mgmt.web.v2016_08_01.models.HandlerMapping]
    :ivar document_root: Document root.
    :vartype document_root: str
    :ivar scm_type: SCM type. Known values are: "None", "Dropbox", "Tfs", "LocalGit", "GitHub",
     "CodePlexGit", "CodePlexHg", "BitbucketGit", "BitbucketHg", "ExternalGit", "ExternalHg",
     "OneDrive", "VSO".
    :vartype scm_type: str or ~azure.mgmt.web.v2016_08_01.models.ScmType
    :ivar use32_bit_worker_process: :code:`<code>true</code>` to use 32-bit worker process;
     otherwise, :code:`<code>false</code>`.
    :vartype use32_bit_worker_process: bool
    :ivar web_sockets_enabled: :code:`<code>true</code>` if WebSocket is enabled; otherwise,
     :code:`<code>false</code>`.
    :vartype web_sockets_enabled: bool
    :ivar always_on: :code:`<code>true</code>` if Always On is enabled; otherwise,
     :code:`<code>false</code>`.
    :vartype always_on: bool
    :ivar java_version: Java version.
    :vartype java_version: str
    :ivar java_container: Java container.
    :vartype java_container: str
    :ivar java_container_version: Java container version.
    :vartype java_container_version: str
    :ivar app_command_line: App command line to launch.
    :vartype app_command_line: str
    :ivar managed_pipeline_mode: Managed pipeline mode. Known values are: "Integrated", "Classic".
    :vartype managed_pipeline_mode: str or ~azure.mgmt.web.v2016_08_01.models.ManagedPipelineMode
    :ivar virtual_applications: Virtual applications.
    :vartype virtual_applications: list[~azure.mgmt.web.v2016_08_01.models.VirtualApplication]
    :ivar load_balancing: Site load balancing. Known values are: "WeightedRoundRobin",
     "LeastRequests", "LeastResponseTime", "WeightedTotalTraffic", "RequestHash".
    :vartype load_balancing: str or ~azure.mgmt.web.v2016_08_01.models.SiteLoadBalancing
    :ivar experiments: This is work around for polymorphic types.
    :vartype experiments: ~azure.mgmt.web.v2016_08_01.models.Experiments
    :ivar limits: Site limits.
    :vartype limits: ~azure.mgmt.web.v2016_08_01.models.SiteLimits
    :ivar auto_heal_enabled: :code:`<code>true</code>` if Auto Heal is enabled; otherwise,
     :code:`<code>false</code>`.
    :vartype auto_heal_enabled: bool
    :ivar auto_heal_rules: Auto Heal rules.
    :vartype auto_heal_rules: ~azure.mgmt.web.v2016_08_01.models.AutoHealRules
    :ivar tracing_options: Tracing options.
    :vartype tracing_options: str
    :ivar vnet_name: Virtual Network name.
    :vartype vnet_name: str
    :ivar cors: Cross-Origin Resource Sharing (CORS) settings.
    :vartype cors: ~azure.mgmt.web.v2016_08_01.models.CorsSettings
    :ivar push: Push endpoint settings.
    :vartype push: ~azure.mgmt.web.v2016_08_01.models.PushSettings
    :ivar api_definition: Information about the formal API definition for the app.
    :vartype api_definition: ~azure.mgmt.web.v2016_08_01.models.ApiDefinitionInfo
    :ivar auto_swap_slot_name: Auto-swap slot name.
    :vartype auto_swap_slot_name: str
    :ivar local_my_sql_enabled: :code:`<code>true</code>` to enable local MySQL; otherwise,
     :code:`<code>false</code>`.
    :vartype local_my_sql_enabled: bool
    :ivar ip_security_restrictions: IP security restrictions.
    :vartype ip_security_restrictions:
     list[~azure.mgmt.web.v2016_08_01.models.IpSecurityRestriction]
    :ivar http20_enabled: Http20Enabled: configures a web site to allow clients to connect over
     http2.0.
    :vartype http20_enabled: bool
    :ivar min_tls_version: MinTlsVersion: configures the minimum version of TLS required for SSL
     requests. Known values are: "1.0", "1.1", "1.2".
    :vartype min_tls_version: str or ~azure.mgmt.web.v2016_08_01.models.SupportedTlsVersions
    """

    _validation = {
        'machine_key': {'readonly': True},
    }

    _attribute_map = {
        'number_of_workers': {'key': 'numberOfWorkers', 'type': 'int'},
        'default_documents': {'key': 'defaultDocuments', 'type': '[str]'},
        'net_framework_version': {'key': 'netFrameworkVersion', 'type': 'str'},
        'php_version': {'key': 'phpVersion', 'type': 'str'},
        'python_version': {'key': 'pythonVersion', 'type': 'str'},
        'node_version': {'key': 'nodeVersion', 'type': 'str'},
        'linux_fx_version': {'key': 'linuxFxVersion', 'type': 'str'},
        'request_tracing_enabled': {'key': 'requestTracingEnabled', 'type': 'bool'},
        'request_tracing_expiration_time': {'key': 'requestTracingExpirationTime', 'type': 'iso-8601'},
        'remote_debugging_enabled': {'key': 'remoteDebuggingEnabled', 'type': 'bool'},
        'remote_debugging_version': {'key': 'remoteDebuggingVersion', 'type': 'str'},
        'http_logging_enabled': {'key': 'httpLoggingEnabled', 'type': 'bool'},
        'logs_directory_size_limit': {'key': 'logsDirectorySizeLimit', 'type': 'int'},
        'detailed_error_logging_enabled': {'key': 'detailedErrorLoggingEnabled', 'type': 'bool'},
        'publishing_username': {'key': 'publishingUsername', 'type': 'str'},
        'app_settings': {'key': 'appSettings', 'type': '[NameValuePair]'},
        'connection_strings': {'key': 'connectionStrings', 'type': '[ConnStringInfo]'},
        'machine_key': {'key': 'machineKey', 'type': 'SiteMachineKey'},
        'handler_mappings': {'key': 'handlerMappings', 'type': '[HandlerMapping]'},
        'document_root': {'key': 'documentRoot', 'type': 'str'},
        'scm_type': {'key': 'scmType', 'type': 'str'},
        'use32_bit_worker_process': {'key': 'use32BitWorkerProcess', 'type': 'bool'},
        'web_sockets_enabled': {'key': 'webSocketsEnabled', 'type': 'bool'},
        'always_on': {'key': 'alwaysOn', 'type': 'bool'},
        'java_version': {'key': 'javaVersion', 'type': 'str'},
        'java_container': {'key': 'javaContainer', 'type': 'str'},
        'java_container_version': {'key': 'javaContainerVersion', 'type': 'str'},
        'app_command_line': {'key': 'appCommandLine', 'type': 'str'},
        'managed_pipeline_mode': {'key': 'managedPipelineMode', 'type': 'str'},
        'virtual_applications': {'key': 'virtualApplications', 'type': '[VirtualApplication]'},
        'load_balancing': {'key': 'loadBalancing', 'type': 'str'},
        'experiments': {'key': 'experiments', 'type': 'Experiments'},
        'limits': {'key': 'limits', 'type': 'SiteLimits'},
        'auto_heal_enabled': {'key': 'autoHealEnabled', 'type': 'bool'},
        'auto_heal_rules': {'key': 'autoHealRules', 'type': 'AutoHealRules'},
        'tracing_options': {'key': 'tracingOptions', 'type': 'str'},
        'vnet_name': {'key': 'vnetName', 'type': 'str'},
        'cors': {'key': 'cors', 'type': 'CorsSettings'},
        'push': {'key': 'push', 'type': 'PushSettings'},
        'api_definition': {'key': 'apiDefinition', 'type': 'ApiDefinitionInfo'},
        'auto_swap_slot_name': {'key': 'autoSwapSlotName', 'type': 'str'},
        'local_my_sql_enabled': {'key': 'localMySqlEnabled', 'type': 'bool'},
        'ip_security_restrictions': {'key': 'ipSecurityRestrictions', 'type': '[IpSecurityRestriction]'},
        'http20_enabled': {'key': 'http20Enabled', 'type': 'bool'},
        'min_tls_version': {'key': 'minTlsVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        number_of_workers: Optional[int] = None,
        default_documents: Optional[List[str]] = None,
        net_framework_version: Optional[str] = "v4.6",
        php_version: Optional[str] = None,
        python_version: Optional[str] = None,
        node_version: Optional[str] = None,
        linux_fx_version: Optional[str] = None,
        request_tracing_enabled: Optional[bool] = None,
        request_tracing_expiration_time: Optional[datetime.datetime] = None,
        remote_debugging_enabled: Optional[bool] = None,
        remote_debugging_version: Optional[str] = None,
        http_logging_enabled: Optional[bool] = None,
        logs_directory_size_limit: Optional[int] = None,
        detailed_error_logging_enabled: Optional[bool] = None,
        publishing_username: Optional[str] = None,
        app_settings: Optional[List["_models.NameValuePair"]] = None,
        connection_strings: Optional[List["_models.ConnStringInfo"]] = None,
        handler_mappings: Optional[List["_models.HandlerMapping"]] = None,
        document_root: Optional[str] = None,
        scm_type: Optional[Union[str, "_models.ScmType"]] = None,
        use32_bit_worker_process: Optional[bool] = None,
        web_sockets_enabled: Optional[bool] = None,
        always_on: Optional[bool] = None,
        java_version: Optional[str] = None,
        java_container: Optional[str] = None,
        java_container_version: Optional[str] = None,
        app_command_line: Optional[str] = None,
        managed_pipeline_mode: Optional[Union[str, "_models.ManagedPipelineMode"]] = None,
        virtual_applications: Optional[List["_models.VirtualApplication"]] = None,
        load_balancing: Optional[Union[str, "_models.SiteLoadBalancing"]] = None,
        experiments: Optional["_models.Experiments"] = None,
        limits: Optional["_models.SiteLimits"] = None,
        auto_heal_enabled: Optional[bool] = None,
        auto_heal_rules: Optional["_models.AutoHealRules"] = None,
        tracing_options: Optional[str] = None,
        vnet_name: Optional[str] = None,
        cors: Optional["_models.CorsSettings"] = None,
        push: Optional["_models.PushSettings"] = None,
        api_definition: Optional["_models.ApiDefinitionInfo"] = None,
        auto_swap_slot_name: Optional[str] = None,
        local_my_sql_enabled: Optional[bool] = False,
        ip_security_restrictions: Optional[List["_models.IpSecurityRestriction"]] = None,
        http20_enabled: Optional[bool] = True,
        min_tls_version: Optional[Union[str, "_models.SupportedTlsVersions"]] = None,
        **kwargs
    ):
        """
        :keyword number_of_workers: Number of workers.
        :paramtype number_of_workers: int
        :keyword default_documents: Default documents.
        :paramtype default_documents: list[str]
        :keyword net_framework_version: .NET Framework version.
        :paramtype net_framework_version: str
        :keyword php_version: Version of PHP.
        :paramtype php_version: str
        :keyword python_version: Version of Python.
        :paramtype python_version: str
        :keyword node_version: Version of Node.js.
        :paramtype node_version: str
        :keyword linux_fx_version: Linux App Framework and version.
        :paramtype linux_fx_version: str
        :keyword request_tracing_enabled: :code:`<code>true</code>` if request tracing is enabled;
         otherwise, :code:`<code>false</code>`.
        :paramtype request_tracing_enabled: bool
        :keyword request_tracing_expiration_time: Request tracing expiration time.
        :paramtype request_tracing_expiration_time: ~datetime.datetime
        :keyword remote_debugging_enabled: :code:`<code>true</code>` if remote debugging is enabled;
         otherwise, :code:`<code>false</code>`.
        :paramtype remote_debugging_enabled: bool
        :keyword remote_debugging_version: Remote debugging version.
        :paramtype remote_debugging_version: str
        :keyword http_logging_enabled: :code:`<code>true</code>` if HTTP logging is enabled; otherwise,
         :code:`<code>false</code>`.
        :paramtype http_logging_enabled: bool
        :keyword logs_directory_size_limit: HTTP logs directory size limit.
        :paramtype logs_directory_size_limit: int
        :keyword detailed_error_logging_enabled: :code:`<code>true</code>` if detailed error logging is
         enabled; otherwise, :code:`<code>false</code>`.
        :paramtype detailed_error_logging_enabled: bool
        :keyword publishing_username: Publishing user name.
        :paramtype publishing_username: str
        :keyword app_settings: Application settings.
        :paramtype app_settings: list[~azure.mgmt.web.v2016_08_01.models.NameValuePair]
        :keyword connection_strings: Connection strings.
        :paramtype connection_strings: list[~azure.mgmt.web.v2016_08_01.models.ConnStringInfo]
        :keyword handler_mappings: Handler mappings.
        :paramtype handler_mappings: list[~azure.mgmt.web.v2016_08_01.models.HandlerMapping]
        :keyword document_root: Document root.
        :paramtype document_root: str
        :keyword scm_type: SCM type. Known values are: "None", "Dropbox", "Tfs", "LocalGit", "GitHub",
         "CodePlexGit", "CodePlexHg", "BitbucketGit", "BitbucketHg", "ExternalGit", "ExternalHg",
         "OneDrive", "VSO".
        :paramtype scm_type: str or ~azure.mgmt.web.v2016_08_01.models.ScmType
        :keyword use32_bit_worker_process: :code:`<code>true</code>` to use 32-bit worker process;
         otherwise, :code:`<code>false</code>`.
        :paramtype use32_bit_worker_process: bool
        :keyword web_sockets_enabled: :code:`<code>true</code>` if WebSocket is enabled; otherwise,
         :code:`<code>false</code>`.
        :paramtype web_sockets_enabled: bool
        :keyword always_on: :code:`<code>true</code>` if Always On is enabled; otherwise,
         :code:`<code>false</code>`.
        :paramtype always_on: bool
        :keyword java_version: Java version.
        :paramtype java_version: str
        :keyword java_container: Java container.
        :paramtype java_container: str
        :keyword java_container_version: Java container version.
        :paramtype java_container_version: str
        :keyword app_command_line: App command line to launch.
        :paramtype app_command_line: str
        :keyword managed_pipeline_mode: Managed pipeline mode. Known values are: "Integrated",
         "Classic".
        :paramtype managed_pipeline_mode: str or ~azure.mgmt.web.v2016_08_01.models.ManagedPipelineMode
        :keyword virtual_applications: Virtual applications.
        :paramtype virtual_applications: list[~azure.mgmt.web.v2016_08_01.models.VirtualApplication]
        :keyword load_balancing: Site load balancing. Known values are: "WeightedRoundRobin",
         "LeastRequests", "LeastResponseTime", "WeightedTotalTraffic", "RequestHash".
        :paramtype load_balancing: str or ~azure.mgmt.web.v2016_08_01.models.SiteLoadBalancing
        :keyword experiments: This is work around for polymorphic types.
        :paramtype experiments: ~azure.mgmt.web.v2016_08_01.models.Experiments
        :keyword limits: Site limits.
        :paramtype limits: ~azure.mgmt.web.v2016_08_01.models.SiteLimits
        :keyword auto_heal_enabled: :code:`<code>true</code>` if Auto Heal is enabled; otherwise,
         :code:`<code>false</code>`.
        :paramtype auto_heal_enabled: bool
        :keyword auto_heal_rules: Auto Heal rules.
        :paramtype auto_heal_rules: ~azure.mgmt.web.v2016_08_01.models.AutoHealRules
        :keyword tracing_options: Tracing options.
        :paramtype tracing_options: str
        :keyword vnet_name: Virtual Network name.
        :paramtype vnet_name: str
        :keyword cors: Cross-Origin Resource Sharing (CORS) settings.
        :paramtype cors: ~azure.mgmt.web.v2016_08_01.models.CorsSettings
        :keyword push: Push endpoint settings.
        :paramtype push: ~azure.mgmt.web.v2016_08_01.models.PushSettings
        :keyword api_definition: Information about the formal API definition for the app.
        :paramtype api_definition: ~azure.mgmt.web.v2016_08_01.models.ApiDefinitionInfo
        :keyword auto_swap_slot_name: Auto-swap slot name.
        :paramtype auto_swap_slot_name: str
        :keyword local_my_sql_enabled: :code:`<code>true</code>` to enable local MySQL; otherwise,
         :code:`<code>false</code>`.
        :paramtype local_my_sql_enabled: bool
        :keyword ip_security_restrictions: IP security restrictions.
        :paramtype ip_security_restrictions:
         list[~azure.mgmt.web.v2016_08_01.models.IpSecurityRestriction]
        :keyword http20_enabled: Http20Enabled: configures a web site to allow clients to connect over
         http2.0.
        :paramtype http20_enabled: bool
        :keyword min_tls_version: MinTlsVersion: configures the minimum version of TLS required for SSL
         requests. Known values are: "1.0", "1.1", "1.2".
        :paramtype min_tls_version: str or ~azure.mgmt.web.v2016_08_01.models.SupportedTlsVersions
        """
        super(SiteConfig, self).__init__(**kwargs)
        self.number_of_workers = number_of_workers
        self.default_documents = default_documents
        self.net_framework_version = net_framework_version
        self.php_version = php_version
        self.python_version = python_version
        self.node_version = node_version
        self.linux_fx_version = linux_fx_version
        self.request_tracing_enabled = request_tracing_enabled
        self.request_tracing_expiration_time = request_tracing_expiration_time
        self.remote_debugging_enabled = remote_debugging_enabled
        self.remote_debugging_version = remote_debugging_version
        self.http_logging_enabled = http_logging_enabled
        self.logs_directory_size_limit = logs_directory_size_limit
        self.detailed_error_logging_enabled = detailed_error_logging_enabled
        self.publishing_username = publishing_username
        self.app_settings = app_settings
        self.connection_strings = connection_strings
        self.machine_key = None
        self.handler_mappings = handler_mappings
        self.document_root = document_root
        self.scm_type = scm_type
        self.use32_bit_worker_process = use32_bit_worker_process
        self.web_sockets_enabled = web_sockets_enabled
        self.always_on = always_on
        self.java_version = java_version
        self.java_container = java_container
        self.java_container_version = java_container_version
        self.app_command_line = app_command_line
        self.managed_pipeline_mode = managed_pipeline_mode
        self.virtual_applications = virtual_applications
        self.load_balancing = load_balancing
        self.experiments = experiments
        self.limits = limits
        self.auto_heal_enabled = auto_heal_enabled
        self.auto_heal_rules = auto_heal_rules
        self.tracing_options = tracing_options
        self.vnet_name = vnet_name
        self.cors = cors
        self.push = push
        self.api_definition = api_definition
        self.auto_swap_slot_name = auto_swap_slot_name
        self.local_my_sql_enabled = local_my_sql_enabled
        self.ip_security_restrictions = ip_security_restrictions
        self.http20_enabled = http20_enabled
        self.min_tls_version = min_tls_version


class SiteConfigResource(ProxyOnlyResource):
    """Web app configuration ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar number_of_workers: Number of workers.
    :vartype number_of_workers: int
    :ivar default_documents: Default documents.
    :vartype default_documents: list[str]
    :ivar net_framework_version: .NET Framework version.
    :vartype net_framework_version: str
    :ivar php_version: Version of PHP.
    :vartype php_version: str
    :ivar python_version: Version of Python.
    :vartype python_version: str
    :ivar node_version: Version of Node.js.
    :vartype node_version: str
    :ivar linux_fx_version: Linux App Framework and version.
    :vartype linux_fx_version: str
    :ivar request_tracing_enabled: :code:`<code>true</code>` if request tracing is enabled;
     otherwise, :code:`<code>false</code>`.
    :vartype request_tracing_enabled: bool
    :ivar request_tracing_expiration_time: Request tracing expiration time.
    :vartype request_tracing_expiration_time: ~datetime.datetime
    :ivar remote_debugging_enabled: :code:`<code>true</code>` if remote debugging is enabled;
     otherwise, :code:`<code>false</code>`.
    :vartype remote_debugging_enabled: bool
    :ivar remote_debugging_version: Remote debugging version.
    :vartype remote_debugging_version: str
    :ivar http_logging_enabled: :code:`<code>true</code>` if HTTP logging is enabled; otherwise,
     :code:`<code>false</code>`.
    :vartype http_logging_enabled: bool
    :ivar logs_directory_size_limit: HTTP logs directory size limit.
    :vartype logs_directory_size_limit: int
    :ivar detailed_error_logging_enabled: :code:`<code>true</code>` if detailed error logging is
     enabled; otherwise, :code:`<code>false</code>`.
    :vartype detailed_error_logging_enabled: bool
    :ivar publishing_username: Publishing user name.
    :vartype publishing_username: str
    :ivar app_settings: Application settings.
    :vartype app_settings: list[~azure.mgmt.web.v2016_08_01.models.NameValuePair]
    :ivar connection_strings: Connection strings.
    :vartype connection_strings: list[~azure.mgmt.web.v2016_08_01.models.ConnStringInfo]
    :ivar machine_key: Site MachineKey.
    :vartype machine_key: ~azure.mgmt.web.v2016_08_01.models.SiteMachineKey
    :ivar handler_mappings: Handler mappings.
    :vartype handler_mappings: list[~azure.mgmt.web.v2016_08_01.models.HandlerMapping]
    :ivar document_root: Document root.
    :vartype document_root: str
    :ivar scm_type: SCM type. Known values are: "None", "Dropbox", "Tfs", "LocalGit", "GitHub",
     "CodePlexGit", "CodePlexHg", "BitbucketGit", "BitbucketHg", "ExternalGit", "ExternalHg",
     "OneDrive", "VSO".
    :vartype scm_type: str or ~azure.mgmt.web.v2016_08_01.models.ScmType
    :ivar use32_bit_worker_process: :code:`<code>true</code>` to use 32-bit worker process;
     otherwise, :code:`<code>false</code>`.
    :vartype use32_bit_worker_process: bool
    :ivar web_sockets_enabled: :code:`<code>true</code>` if WebSocket is enabled; otherwise,
     :code:`<code>false</code>`.
    :vartype web_sockets_enabled: bool
    :ivar always_on: :code:`<code>true</code>` if Always On is enabled; otherwise,
     :code:`<code>false</code>`.
    :vartype always_on: bool
    :ivar java_version: Java version.
    :vartype java_version: str
    :ivar java_container: Java container.
    :vartype java_container: str
    :ivar java_container_version: Java container version.
    :vartype java_container_version: str
    :ivar app_command_line: App command line to launch.
    :vartype app_command_line: str
    :ivar managed_pipeline_mode: Managed pipeline mode. Known values are: "Integrated", "Classic".
    :vartype managed_pipeline_mode: str or ~azure.mgmt.web.v2016_08_01.models.ManagedPipelineMode
    :ivar virtual_applications: Virtual applications.
    :vartype virtual_applications: list[~azure.mgmt.web.v2016_08_01.models.VirtualApplication]
    :ivar load_balancing: Site load balancing. Known values are: "WeightedRoundRobin",
     "LeastRequests", "LeastResponseTime", "WeightedTotalTraffic", "RequestHash".
    :vartype load_balancing: str or ~azure.mgmt.web.v2016_08_01.models.SiteLoadBalancing
    :ivar experiments: This is work around for polymorphic types.
    :vartype experiments: ~azure.mgmt.web.v2016_08_01.models.Experiments
    :ivar limits: Site limits.
    :vartype limits: ~azure.mgmt.web.v2016_08_01.models.SiteLimits
    :ivar auto_heal_enabled: :code:`<code>true</code>` if Auto Heal is enabled; otherwise,
     :code:`<code>false</code>`.
    :vartype auto_heal_enabled: bool
    :ivar auto_heal_rules: Auto Heal rules.
    :vartype auto_heal_rules: ~azure.mgmt.web.v2016_08_01.models.AutoHealRules
    :ivar tracing_options: Tracing options.
    :vartype tracing_options: str
    :ivar vnet_name: Virtual Network name.
    :vartype vnet_name: str
    :ivar cors: Cross-Origin Resource Sharing (CORS) settings.
    :vartype cors: ~azure.mgmt.web.v2016_08_01.models.CorsSettings
    :ivar push: Push endpoint settings.
    :vartype push: ~azure.mgmt.web.v2016_08_01.models.PushSettings
    :ivar api_definition: Information about the formal API definition for the app.
    :vartype api_definition: ~azure.mgmt.web.v2016_08_01.models.ApiDefinitionInfo
    :ivar auto_swap_slot_name: Auto-swap slot name.
    :vartype auto_swap_slot_name: str
    :ivar local_my_sql_enabled: :code:`<code>true</code>` to enable local MySQL; otherwise,
     :code:`<code>false</code>`.
    :vartype local_my_sql_enabled: bool
    :ivar ip_security_restrictions: IP security restrictions.
    :vartype ip_security_restrictions:
     list[~azure.mgmt.web.v2016_08_01.models.IpSecurityRestriction]
    :ivar http20_enabled: Http20Enabled: configures a web site to allow clients to connect over
     http2.0.
    :vartype http20_enabled: bool
    :ivar min_tls_version: MinTlsVersion: configures the minimum version of TLS required for SSL
     requests. Known values are: "1.0", "1.1", "1.2".
    :vartype min_tls_version: str or ~azure.mgmt.web.v2016_08_01.models.SupportedTlsVersions
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'machine_key': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'number_of_workers': {'key': 'properties.numberOfWorkers', 'type': 'int'},
        'default_documents': {'key': 'properties.defaultDocuments', 'type': '[str]'},
        'net_framework_version': {'key': 'properties.netFrameworkVersion', 'type': 'str'},
        'php_version': {'key': 'properties.phpVersion', 'type': 'str'},
        'python_version': {'key': 'properties.pythonVersion', 'type': 'str'},
        'node_version': {'key': 'properties.nodeVersion', 'type': 'str'},
        'linux_fx_version': {'key': 'properties.linuxFxVersion', 'type': 'str'},
        'request_tracing_enabled': {'key': 'properties.requestTracingEnabled', 'type': 'bool'},
        'request_tracing_expiration_time': {'key': 'properties.requestTracingExpirationTime', 'type': 'iso-8601'},
        'remote_debugging_enabled': {'key': 'properties.remoteDebuggingEnabled', 'type': 'bool'},
        'remote_debugging_version': {'key': 'properties.remoteDebuggingVersion', 'type': 'str'},
        'http_logging_enabled': {'key': 'properties.httpLoggingEnabled', 'type': 'bool'},
        'logs_directory_size_limit': {'key': 'properties.logsDirectorySizeLimit', 'type': 'int'},
        'detailed_error_logging_enabled': {'key': 'properties.detailedErrorLoggingEnabled', 'type': 'bool'},
        'publishing_username': {'key': 'properties.publishingUsername', 'type': 'str'},
        'app_settings': {'key': 'properties.appSettings', 'type': '[NameValuePair]'},
        'connection_strings': {'key': 'properties.connectionStrings', 'type': '[ConnStringInfo]'},
        'machine_key': {'key': 'properties.machineKey', 'type': 'SiteMachineKey'},
        'handler_mappings': {'key': 'properties.handlerMappings', 'type': '[HandlerMapping]'},
        'document_root': {'key': 'properties.documentRoot', 'type': 'str'},
        'scm_type': {'key': 'properties.scmType', 'type': 'str'},
        'use32_bit_worker_process': {'key': 'properties.use32BitWorkerProcess', 'type': 'bool'},
        'web_sockets_enabled': {'key': 'properties.webSocketsEnabled', 'type': 'bool'},
        'always_on': {'key': 'properties.alwaysOn', 'type': 'bool'},
        'java_version': {'key': 'properties.javaVersion', 'type': 'str'},
        'java_container': {'key': 'properties.javaContainer', 'type': 'str'},
        'java_container_version': {'key': 'properties.javaContainerVersion', 'type': 'str'},
        'app_command_line': {'key': 'properties.appCommandLine', 'type': 'str'},
        'managed_pipeline_mode': {'key': 'properties.managedPipelineMode', 'type': 'str'},
        'virtual_applications': {'key': 'properties.virtualApplications', 'type': '[VirtualApplication]'},
        'load_balancing': {'key': 'properties.loadBalancing', 'type': 'str'},
        'experiments': {'key': 'properties.experiments', 'type': 'Experiments'},
        'limits': {'key': 'properties.limits', 'type': 'SiteLimits'},
        'auto_heal_enabled': {'key': 'properties.autoHealEnabled', 'type': 'bool'},
        'auto_heal_rules': {'key': 'properties.autoHealRules', 'type': 'AutoHealRules'},
        'tracing_options': {'key': 'properties.tracingOptions', 'type': 'str'},
        'vnet_name': {'key': 'properties.vnetName', 'type': 'str'},
        'cors': {'key': 'properties.cors', 'type': 'CorsSettings'},
        'push': {'key': 'properties.push', 'type': 'PushSettings'},
        'api_definition': {'key': 'properties.apiDefinition', 'type': 'ApiDefinitionInfo'},
        'auto_swap_slot_name': {'key': 'properties.autoSwapSlotName', 'type': 'str'},
        'local_my_sql_enabled': {'key': 'properties.localMySqlEnabled', 'type': 'bool'},
        'ip_security_restrictions': {'key': 'properties.ipSecurityRestrictions', 'type': '[IpSecurityRestriction]'},
        'http20_enabled': {'key': 'properties.http20Enabled', 'type': 'bool'},
        'min_tls_version': {'key': 'properties.minTlsVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        number_of_workers: Optional[int] = None,
        default_documents: Optional[List[str]] = None,
        net_framework_version: Optional[str] = "v4.6",
        php_version: Optional[str] = None,
        python_version: Optional[str] = None,
        node_version: Optional[str] = None,
        linux_fx_version: Optional[str] = None,
        request_tracing_enabled: Optional[bool] = None,
        request_tracing_expiration_time: Optional[datetime.datetime] = None,
        remote_debugging_enabled: Optional[bool] = None,
        remote_debugging_version: Optional[str] = None,
        http_logging_enabled: Optional[bool] = None,
        logs_directory_size_limit: Optional[int] = None,
        detailed_error_logging_enabled: Optional[bool] = None,
        publishing_username: Optional[str] = None,
        app_settings: Optional[List["_models.NameValuePair"]] = None,
        connection_strings: Optional[List["_models.ConnStringInfo"]] = None,
        handler_mappings: Optional[List["_models.HandlerMapping"]] = None,
        document_root: Optional[str] = None,
        scm_type: Optional[Union[str, "_models.ScmType"]] = None,
        use32_bit_worker_process: Optional[bool] = None,
        web_sockets_enabled: Optional[bool] = None,
        always_on: Optional[bool] = None,
        java_version: Optional[str] = None,
        java_container: Optional[str] = None,
        java_container_version: Optional[str] = None,
        app_command_line: Optional[str] = None,
        managed_pipeline_mode: Optional[Union[str, "_models.ManagedPipelineMode"]] = None,
        virtual_applications: Optional[List["_models.VirtualApplication"]] = None,
        load_balancing: Optional[Union[str, "_models.SiteLoadBalancing"]] = None,
        experiments: Optional["_models.Experiments"] = None,
        limits: Optional["_models.SiteLimits"] = None,
        auto_heal_enabled: Optional[bool] = None,
        auto_heal_rules: Optional["_models.AutoHealRules"] = None,
        tracing_options: Optional[str] = None,
        vnet_name: Optional[str] = None,
        cors: Optional["_models.CorsSettings"] = None,
        push: Optional["_models.PushSettings"] = None,
        api_definition: Optional["_models.ApiDefinitionInfo"] = None,
        auto_swap_slot_name: Optional[str] = None,
        local_my_sql_enabled: Optional[bool] = False,
        ip_security_restrictions: Optional[List["_models.IpSecurityRestriction"]] = None,
        http20_enabled: Optional[bool] = True,
        min_tls_version: Optional[Union[str, "_models.SupportedTlsVersions"]] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword number_of_workers: Number of workers.
        :paramtype number_of_workers: int
        :keyword default_documents: Default documents.
        :paramtype default_documents: list[str]
        :keyword net_framework_version: .NET Framework version.
        :paramtype net_framework_version: str
        :keyword php_version: Version of PHP.
        :paramtype php_version: str
        :keyword python_version: Version of Python.
        :paramtype python_version: str
        :keyword node_version: Version of Node.js.
        :paramtype node_version: str
        :keyword linux_fx_version: Linux App Framework and version.
        :paramtype linux_fx_version: str
        :keyword request_tracing_enabled: :code:`<code>true</code>` if request tracing is enabled;
         otherwise, :code:`<code>false</code>`.
        :paramtype request_tracing_enabled: bool
        :keyword request_tracing_expiration_time: Request tracing expiration time.
        :paramtype request_tracing_expiration_time: ~datetime.datetime
        :keyword remote_debugging_enabled: :code:`<code>true</code>` if remote debugging is enabled;
         otherwise, :code:`<code>false</code>`.
        :paramtype remote_debugging_enabled: bool
        :keyword remote_debugging_version: Remote debugging version.
        :paramtype remote_debugging_version: str
        :keyword http_logging_enabled: :code:`<code>true</code>` if HTTP logging is enabled; otherwise,
         :code:`<code>false</code>`.
        :paramtype http_logging_enabled: bool
        :keyword logs_directory_size_limit: HTTP logs directory size limit.
        :paramtype logs_directory_size_limit: int
        :keyword detailed_error_logging_enabled: :code:`<code>true</code>` if detailed error logging is
         enabled; otherwise, :code:`<code>false</code>`.
        :paramtype detailed_error_logging_enabled: bool
        :keyword publishing_username: Publishing user name.
        :paramtype publishing_username: str
        :keyword app_settings: Application settings.
        :paramtype app_settings: list[~azure.mgmt.web.v2016_08_01.models.NameValuePair]
        :keyword connection_strings: Connection strings.
        :paramtype connection_strings: list[~azure.mgmt.web.v2016_08_01.models.ConnStringInfo]
        :keyword handler_mappings: Handler mappings.
        :paramtype handler_mappings: list[~azure.mgmt.web.v2016_08_01.models.HandlerMapping]
        :keyword document_root: Document root.
        :paramtype document_root: str
        :keyword scm_type: SCM type. Known values are: "None", "Dropbox", "Tfs", "LocalGit", "GitHub",
         "CodePlexGit", "CodePlexHg", "BitbucketGit", "BitbucketHg", "ExternalGit", "ExternalHg",
         "OneDrive", "VSO".
        :paramtype scm_type: str or ~azure.mgmt.web.v2016_08_01.models.ScmType
        :keyword use32_bit_worker_process: :code:`<code>true</code>` to use 32-bit worker process;
         otherwise, :code:`<code>false</code>`.
        :paramtype use32_bit_worker_process: bool
        :keyword web_sockets_enabled: :code:`<code>true</code>` if WebSocket is enabled; otherwise,
         :code:`<code>false</code>`.
        :paramtype web_sockets_enabled: bool
        :keyword always_on: :code:`<code>true</code>` if Always On is enabled; otherwise,
         :code:`<code>false</code>`.
        :paramtype always_on: bool
        :keyword java_version: Java version.
        :paramtype java_version: str
        :keyword java_container: Java container.
        :paramtype java_container: str
        :keyword java_container_version: Java container version.
        :paramtype java_container_version: str
        :keyword app_command_line: App command line to launch.
        :paramtype app_command_line: str
        :keyword managed_pipeline_mode: Managed pipeline mode. Known values are: "Integrated",
         "Classic".
        :paramtype managed_pipeline_mode: str or ~azure.mgmt.web.v2016_08_01.models.ManagedPipelineMode
        :keyword virtual_applications: Virtual applications.
        :paramtype virtual_applications: list[~azure.mgmt.web.v2016_08_01.models.VirtualApplication]
        :keyword load_balancing: Site load balancing. Known values are: "WeightedRoundRobin",
         "LeastRequests", "LeastResponseTime", "WeightedTotalTraffic", "RequestHash".
        :paramtype load_balancing: str or ~azure.mgmt.web.v2016_08_01.models.SiteLoadBalancing
        :keyword experiments: This is work around for polymorphic types.
        :paramtype experiments: ~azure.mgmt.web.v2016_08_01.models.Experiments
        :keyword limits: Site limits.
        :paramtype limits: ~azure.mgmt.web.v2016_08_01.models.SiteLimits
        :keyword auto_heal_enabled: :code:`<code>true</code>` if Auto Heal is enabled; otherwise,
         :code:`<code>false</code>`.
        :paramtype auto_heal_enabled: bool
        :keyword auto_heal_rules: Auto Heal rules.
        :paramtype auto_heal_rules: ~azure.mgmt.web.v2016_08_01.models.AutoHealRules
        :keyword tracing_options: Tracing options.
        :paramtype tracing_options: str
        :keyword vnet_name: Virtual Network name.
        :paramtype vnet_name: str
        :keyword cors: Cross-Origin Resource Sharing (CORS) settings.
        :paramtype cors: ~azure.mgmt.web.v2016_08_01.models.CorsSettings
        :keyword push: Push endpoint settings.
        :paramtype push: ~azure.mgmt.web.v2016_08_01.models.PushSettings
        :keyword api_definition: Information about the formal API definition for the app.
        :paramtype api_definition: ~azure.mgmt.web.v2016_08_01.models.ApiDefinitionInfo
        :keyword auto_swap_slot_name: Auto-swap slot name.
        :paramtype auto_swap_slot_name: str
        :keyword local_my_sql_enabled: :code:`<code>true</code>` to enable local MySQL; otherwise,
         :code:`<code>false</code>`.
        :paramtype local_my_sql_enabled: bool
        :keyword ip_security_restrictions: IP security restrictions.
        :paramtype ip_security_restrictions:
         list[~azure.mgmt.web.v2016_08_01.models.IpSecurityRestriction]
        :keyword http20_enabled: Http20Enabled: configures a web site to allow clients to connect over
         http2.0.
        :paramtype http20_enabled: bool
        :keyword min_tls_version: MinTlsVersion: configures the minimum version of TLS required for SSL
         requests. Known values are: "1.0", "1.1", "1.2".
        :paramtype min_tls_version: str or ~azure.mgmt.web.v2016_08_01.models.SupportedTlsVersions
        """
        super(SiteConfigResource, self).__init__(kind=kind, **kwargs)
        self.number_of_workers = number_of_workers
        self.default_documents = default_documents
        self.net_framework_version = net_framework_version
        self.php_version = php_version
        self.python_version = python_version
        self.node_version = node_version
        self.linux_fx_version = linux_fx_version
        self.request_tracing_enabled = request_tracing_enabled
        self.request_tracing_expiration_time = request_tracing_expiration_time
        self.remote_debugging_enabled = remote_debugging_enabled
        self.remote_debugging_version = remote_debugging_version
        self.http_logging_enabled = http_logging_enabled
        self.logs_directory_size_limit = logs_directory_size_limit
        self.detailed_error_logging_enabled = detailed_error_logging_enabled
        self.publishing_username = publishing_username
        self.app_settings = app_settings
        self.connection_strings = connection_strings
        self.machine_key = None
        self.handler_mappings = handler_mappings
        self.document_root = document_root
        self.scm_type = scm_type
        self.use32_bit_worker_process = use32_bit_worker_process
        self.web_sockets_enabled = web_sockets_enabled
        self.always_on = always_on
        self.java_version = java_version
        self.java_container = java_container
        self.java_container_version = java_container_version
        self.app_command_line = app_command_line
        self.managed_pipeline_mode = managed_pipeline_mode
        self.virtual_applications = virtual_applications
        self.load_balancing = load_balancing
        self.experiments = experiments
        self.limits = limits
        self.auto_heal_enabled = auto_heal_enabled
        self.auto_heal_rules = auto_heal_rules
        self.tracing_options = tracing_options
        self.vnet_name = vnet_name
        self.cors = cors
        self.push = push
        self.api_definition = api_definition
        self.auto_swap_slot_name = auto_swap_slot_name
        self.local_my_sql_enabled = local_my_sql_enabled
        self.ip_security_restrictions = ip_security_restrictions
        self.http20_enabled = http20_enabled
        self.min_tls_version = min_tls_version


class SiteConfigResourceCollection(msrest.serialization.Model):
    """Collection of site configurations.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2016_08_01.models.SiteConfigResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SiteConfigResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["_models.SiteConfigResource"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2016_08_01.models.SiteConfigResource]
        """
        super(SiteConfigResourceCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class SiteConfigurationSnapshotInfo(ProxyOnlyResource):
    """A snapshot of a web app configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar time: The time the snapshot was taken.
    :vartype time: ~datetime.datetime
    :ivar id_properties_id: The id of the snapshot.
    :vartype id_properties_id: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'time': {'readonly': True},
        'id_properties_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'time': {'key': 'properties.time', 'type': 'iso-8601'},
        'id_properties_id': {'key': 'properties.id', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super(SiteConfigurationSnapshotInfo, self).__init__(kind=kind, **kwargs)
        self.time = None
        self.id_properties_id = None


class SiteConfigurationSnapshotInfoCollection(msrest.serialization.Model):
    """Collection of metadata for the app configuration snapshots that can be restored.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2016_08_01.models.SiteConfigurationSnapshotInfo]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SiteConfigurationSnapshotInfo]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["_models.SiteConfigurationSnapshotInfo"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2016_08_01.models.SiteConfigurationSnapshotInfo]
        """
        super(SiteConfigurationSnapshotInfoCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class SiteExtensionInfo(ProxyOnlyResource):
    """Site Extension Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar id_properties_id: Site extension ID.
    :vartype id_properties_id: str
    :ivar title: Site extension title.
    :vartype title: str
    :ivar type_properties_type: Site extension type. Known values are: "Gallery", "WebRoot".
    :vartype type_properties_type: str or ~azure.mgmt.web.v2016_08_01.models.SiteExtensionType
    :ivar summary: Summary description.
    :vartype summary: str
    :ivar description: Detailed description.
    :vartype description: str
    :ivar version: Version information.
    :vartype version: str
    :ivar extension_url: Extension URL.
    :vartype extension_url: str
    :ivar project_url: Project URL.
    :vartype project_url: str
    :ivar icon_url: Icon URL.
    :vartype icon_url: str
    :ivar license_url: License URL.
    :vartype license_url: str
    :ivar feed_url: Feed URL.
    :vartype feed_url: str
    :ivar authors: List of authors.
    :vartype authors: list[str]
    :ivar installation_args: Installer command line parameters.
    :vartype installation_args: str
    :ivar published_date_time: Published timestamp.
    :vartype published_date_time: ~datetime.datetime
    :ivar download_count: Count of downloads.
    :vartype download_count: int
    :ivar local_is_latest_version: :code:`<code>true</code>` if the local version is the latest
     version; :code:`<code>false</code>` otherwise.
    :vartype local_is_latest_version: bool
    :ivar local_path: Local path.
    :vartype local_path: str
    :ivar installed_date_time: Installed timestamp.
    :vartype installed_date_time: ~datetime.datetime
    :ivar provisioning_state: Provisioning state.
    :vartype provisioning_state: str
    :ivar comment: Site Extension comment.
    :vartype comment: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'id_properties_id': {'key': 'properties.id', 'type': 'str'},
        'title': {'key': 'properties.title', 'type': 'str'},
        'type_properties_type': {'key': 'properties.type', 'type': 'str'},
        'summary': {'key': 'properties.summary', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'extension_url': {'key': 'properties.extensionUrl', 'type': 'str'},
        'project_url': {'key': 'properties.projectUrl', 'type': 'str'},
        'icon_url': {'key': 'properties.iconUrl', 'type': 'str'},
        'license_url': {'key': 'properties.licenseUrl', 'type': 'str'},
        'feed_url': {'key': 'properties.feedUrl', 'type': 'str'},
        'authors': {'key': 'properties.authors', 'type': '[str]'},
        'installation_args': {'key': 'properties.installationArgs', 'type': 'str'},
        'published_date_time': {'key': 'properties.publishedDateTime', 'type': 'iso-8601'},
        'download_count': {'key': 'properties.downloadCount', 'type': 'int'},
        'local_is_latest_version': {'key': 'properties.localIsLatestVersion', 'type': 'bool'},
        'local_path': {'key': 'properties.localPath', 'type': 'str'},
        'installed_date_time': {'key': 'properties.installedDateTime', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'comment': {'key': 'properties.comment', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        id_properties_id: Optional[str] = None,
        title: Optional[str] = None,
        type_properties_type: Optional[Union[str, "_models.SiteExtensionType"]] = None,
        summary: Optional[str] = None,
        description: Optional[str] = None,
        version: Optional[str] = None,
        extension_url: Optional[str] = None,
        project_url: Optional[str] = None,
        icon_url: Optional[str] = None,
        license_url: Optional[str] = None,
        feed_url: Optional[str] = None,
        authors: Optional[List[str]] = None,
        installation_args: Optional[str] = None,
        published_date_time: Optional[datetime.datetime] = None,
        download_count: Optional[int] = None,
        local_is_latest_version: Optional[bool] = None,
        local_path: Optional[str] = None,
        installed_date_time: Optional[datetime.datetime] = None,
        provisioning_state: Optional[str] = None,
        comment: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword id_properties_id: Site extension ID.
        :paramtype id_properties_id: str
        :keyword title: Site extension title.
        :paramtype title: str
        :keyword type_properties_type: Site extension type. Known values are: "Gallery", "WebRoot".
        :paramtype type_properties_type: str or ~azure.mgmt.web.v2016_08_01.models.SiteExtensionType
        :keyword summary: Summary description.
        :paramtype summary: str
        :keyword description: Detailed description.
        :paramtype description: str
        :keyword version: Version information.
        :paramtype version: str
        :keyword extension_url: Extension URL.
        :paramtype extension_url: str
        :keyword project_url: Project URL.
        :paramtype project_url: str
        :keyword icon_url: Icon URL.
        :paramtype icon_url: str
        :keyword license_url: License URL.
        :paramtype license_url: str
        :keyword feed_url: Feed URL.
        :paramtype feed_url: str
        :keyword authors: List of authors.
        :paramtype authors: list[str]
        :keyword installation_args: Installer command line parameters.
        :paramtype installation_args: str
        :keyword published_date_time: Published timestamp.
        :paramtype published_date_time: ~datetime.datetime
        :keyword download_count: Count of downloads.
        :paramtype download_count: int
        :keyword local_is_latest_version: :code:`<code>true</code>` if the local version is the latest
         version; :code:`<code>false</code>` otherwise.
        :paramtype local_is_latest_version: bool
        :keyword local_path: Local path.
        :paramtype local_path: str
        :keyword installed_date_time: Installed timestamp.
        :paramtype installed_date_time: ~datetime.datetime
        :keyword provisioning_state: Provisioning state.
        :paramtype provisioning_state: str
        :keyword comment: Site Extension comment.
        :paramtype comment: str
        """
        super(SiteExtensionInfo, self).__init__(kind=kind, **kwargs)
        self.id_properties_id = id_properties_id
        self.title = title
        self.type_properties_type = type_properties_type
        self.summary = summary
        self.description = description
        self.version = version
        self.extension_url = extension_url
        self.project_url = project_url
        self.icon_url = icon_url
        self.license_url = license_url
        self.feed_url = feed_url
        self.authors = authors
        self.installation_args = installation_args
        self.published_date_time = published_date_time
        self.download_count = download_count
        self.local_is_latest_version = local_is_latest_version
        self.local_path = local_path
        self.installed_date_time = installed_date_time
        self.provisioning_state = provisioning_state
        self.comment = comment


class SiteExtensionInfoCollection(msrest.serialization.Model):
    """Collection of Kudu site extension information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2016_08_01.models.SiteExtensionInfo]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SiteExtensionInfo]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["_models.SiteExtensionInfo"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2016_08_01.models.SiteExtensionInfo]
        """
        super(SiteExtensionInfoCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class SiteInstance(ProxyOnlyResource):
    """Instance of an app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar name_properties_name: Name of instance.
    :vartype name_properties_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'name_properties_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super(SiteInstance, self).__init__(kind=kind, **kwargs)
        self.name_properties_name = None


class SiteLimits(msrest.serialization.Model):
    """Metric limits set on an app.

    :ivar max_percentage_cpu: Maximum allowed CPU usage percentage.
    :vartype max_percentage_cpu: float
    :ivar max_memory_in_mb: Maximum allowed memory usage in MB.
    :vartype max_memory_in_mb: long
    :ivar max_disk_size_in_mb: Maximum allowed disk size usage in MB.
    :vartype max_disk_size_in_mb: long
    """

    _attribute_map = {
        'max_percentage_cpu': {'key': 'maxPercentageCpu', 'type': 'float'},
        'max_memory_in_mb': {'key': 'maxMemoryInMb', 'type': 'long'},
        'max_disk_size_in_mb': {'key': 'maxDiskSizeInMb', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        max_percentage_cpu: Optional[float] = None,
        max_memory_in_mb: Optional[int] = None,
        max_disk_size_in_mb: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword max_percentage_cpu: Maximum allowed CPU usage percentage.
        :paramtype max_percentage_cpu: float
        :keyword max_memory_in_mb: Maximum allowed memory usage in MB.
        :paramtype max_memory_in_mb: long
        :keyword max_disk_size_in_mb: Maximum allowed disk size usage in MB.
        :paramtype max_disk_size_in_mb: long
        """
        super(SiteLimits, self).__init__(**kwargs)
        self.max_percentage_cpu = max_percentage_cpu
        self.max_memory_in_mb = max_memory_in_mb
        self.max_disk_size_in_mb = max_disk_size_in_mb


class SiteLogsConfig(ProxyOnlyResource):
    """Configuration of App Service site logs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar application_logs: Application logs configuration.
    :vartype application_logs: ~azure.mgmt.web.v2016_08_01.models.ApplicationLogsConfig
    :ivar http_logs: HTTP logs configuration.
    :vartype http_logs: ~azure.mgmt.web.v2016_08_01.models.HttpLogsConfig
    :ivar failed_requests_tracing: Failed requests tracing configuration.
    :vartype failed_requests_tracing: ~azure.mgmt.web.v2016_08_01.models.EnabledConfig
    :ivar detailed_error_messages: Detailed error messages configuration.
    :vartype detailed_error_messages: ~azure.mgmt.web.v2016_08_01.models.EnabledConfig
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'application_logs': {'key': 'properties.applicationLogs', 'type': 'ApplicationLogsConfig'},
        'http_logs': {'key': 'properties.httpLogs', 'type': 'HttpLogsConfig'},
        'failed_requests_tracing': {'key': 'properties.failedRequestsTracing', 'type': 'EnabledConfig'},
        'detailed_error_messages': {'key': 'properties.detailedErrorMessages', 'type': 'EnabledConfig'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        application_logs: Optional["_models.ApplicationLogsConfig"] = None,
        http_logs: Optional["_models.HttpLogsConfig"] = None,
        failed_requests_tracing: Optional["_models.EnabledConfig"] = None,
        detailed_error_messages: Optional["_models.EnabledConfig"] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword application_logs: Application logs configuration.
        :paramtype application_logs: ~azure.mgmt.web.v2016_08_01.models.ApplicationLogsConfig
        :keyword http_logs: HTTP logs configuration.
        :paramtype http_logs: ~azure.mgmt.web.v2016_08_01.models.HttpLogsConfig
        :keyword failed_requests_tracing: Failed requests tracing configuration.
        :paramtype failed_requests_tracing: ~azure.mgmt.web.v2016_08_01.models.EnabledConfig
        :keyword detailed_error_messages: Detailed error messages configuration.
        :paramtype detailed_error_messages: ~azure.mgmt.web.v2016_08_01.models.EnabledConfig
        """
        super(SiteLogsConfig, self).__init__(kind=kind, **kwargs)
        self.application_logs = application_logs
        self.http_logs = http_logs
        self.failed_requests_tracing = failed_requests_tracing
        self.detailed_error_messages = detailed_error_messages


class SiteMachineKey(msrest.serialization.Model):
    """MachineKey of an app.

    :ivar validation: MachineKey validation.
    :vartype validation: str
    :ivar validation_key: Validation key.
    :vartype validation_key: str
    :ivar decryption: Algorithm used for decryption.
    :vartype decryption: str
    :ivar decryption_key: Decryption key.
    :vartype decryption_key: str
    """

    _attribute_map = {
        'validation': {'key': 'validation', 'type': 'str'},
        'validation_key': {'key': 'validationKey', 'type': 'str'},
        'decryption': {'key': 'decryption', 'type': 'str'},
        'decryption_key': {'key': 'decryptionKey', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        validation: Optional[str] = None,
        validation_key: Optional[str] = None,
        decryption: Optional[str] = None,
        decryption_key: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword validation: MachineKey validation.
        :paramtype validation: str
        :keyword validation_key: Validation key.
        :paramtype validation_key: str
        :keyword decryption: Algorithm used for decryption.
        :paramtype decryption: str
        :keyword decryption_key: Decryption key.
        :paramtype decryption_key: str
        """
        super(SiteMachineKey, self).__init__(**kwargs)
        self.validation = validation
        self.validation_key = validation_key
        self.decryption = decryption
        self.decryption_key = decryption_key


class SitePatchResource(ProxyOnlyResource):
    """ARM resource for a site.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar state: Current state of the app.
    :vartype state: str
    :ivar host_names: Hostnames associated with the app.
    :vartype host_names: list[str]
    :ivar repository_site_name: Name of the repository site.
    :vartype repository_site_name: str
    :ivar usage_state: State indicating whether the app has exceeded its quota usage. Read-only.
     Known values are: "Normal", "Exceeded".
    :vartype usage_state: str or ~azure.mgmt.web.v2016_08_01.models.UsageState
    :ivar enabled: :code:`<code>true</code>` if the app is enabled; otherwise,
     :code:`<code>false</code>`. Setting this value to false disables the app (takes the app
     offline).
    :vartype enabled: bool
    :ivar enabled_host_names: Enabled hostnames for the app.Hostnames need to be assigned (see
     HostNames) AND enabled. Otherwise,
     the app is not served on those hostnames.
    :vartype enabled_host_names: list[str]
    :ivar availability_state: Management information availability state for the app. Known values
     are: "Normal", "Limited", "DisasterRecoveryMode".
    :vartype availability_state: str or ~azure.mgmt.web.v2016_08_01.models.SiteAvailabilityState
    :ivar host_name_ssl_states: Hostname SSL states are used to manage the SSL bindings for app's
     hostnames.
    :vartype host_name_ssl_states: list[~azure.mgmt.web.v2016_08_01.models.HostNameSslState]
    :ivar server_farm_id: Resource ID of the associated App Service plan, formatted as:
     "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
    :vartype server_farm_id: str
    :ivar reserved: :code:`<code>true</code>` if reserved; otherwise, :code:`<code>false</code>`.
    :vartype reserved: bool
    :ivar last_modified_time_utc: Last time the app was modified, in UTC. Read-only.
    :vartype last_modified_time_utc: ~datetime.datetime
    :ivar site_config: Configuration of the app.
    :vartype site_config: ~azure.mgmt.web.v2016_08_01.models.SiteConfig
    :ivar traffic_manager_host_names: Azure Traffic Manager hostnames associated with the app.
     Read-only.
    :vartype traffic_manager_host_names: list[str]
    :ivar scm_site_also_stopped: :code:`<code>true</code>` to stop SCM (KUDU) site when the app is
     stopped; otherwise, :code:`<code>false</code>`. The default is :code:`<code>false</code>`.
    :vartype scm_site_also_stopped: bool
    :ivar target_swap_slot: Specifies which deployment slot this app will swap into. Read-only.
    :vartype target_swap_slot: str
    :ivar hosting_environment_profile: App Service Environment to use for the app.
    :vartype hosting_environment_profile:
     ~azure.mgmt.web.v2016_08_01.models.HostingEnvironmentProfile
    :ivar client_affinity_enabled: :code:`<code>true</code>` to enable client affinity;
     :code:`<code>false</code>` to stop sending session affinity cookies, which route client
     requests in the same session to the same instance. Default is :code:`<code>true</code>`.
    :vartype client_affinity_enabled: bool
    :ivar client_cert_enabled: :code:`<code>true</code>` to enable client certificate
     authentication (TLS mutual authentication); otherwise, :code:`<code>false</code>`. Default is
     :code:`<code>false</code>`.
    :vartype client_cert_enabled: bool
    :ivar host_names_disabled: :code:`<code>true</code>` to disable the public hostnames of the
     app; otherwise, :code:`<code>false</code>`.
      If :code:`<code>true</code>`, the app is only accessible via API management process.
    :vartype host_names_disabled: bool
    :ivar outbound_ip_addresses: List of IP addresses that the app uses for outbound connections
     (e.g. database access). Includes VIPs from tenants that site can be hosted with current
     settings. Read-only.
    :vartype outbound_ip_addresses: str
    :ivar possible_outbound_ip_addresses: List of IP addresses that the app uses for outbound
     connections (e.g. database access). Includes VIPs from all tenants. Read-only.
    :vartype possible_outbound_ip_addresses: str
    :ivar container_size: Size of the function container.
    :vartype container_size: int
    :ivar daily_memory_time_quota: Maximum allowed daily memory-time quota (applicable on dynamic
     apps only).
    :vartype daily_memory_time_quota: int
    :ivar suspended_till: App suspended till in case memory-time quota is exceeded.
    :vartype suspended_till: ~datetime.datetime
    :ivar max_number_of_workers: Maximum number of workers.
     This only applies to Functions container.
    :vartype max_number_of_workers: int
    :ivar cloning_info: If specified during app creation, the app is cloned from a source app.
    :vartype cloning_info: ~azure.mgmt.web.v2016_08_01.models.CloningInfo
    :ivar snapshot_info: If specified during app creation, the app is created from a previous
     snapshot.
    :vartype snapshot_info: ~azure.mgmt.web.v2016_08_01.models.SnapshotRecoveryRequest
    :ivar resource_group: Name of the resource group the app belongs to. Read-only.
    :vartype resource_group: str
    :ivar is_default_container: :code:`<code>true</code>` if the app is a default container;
     otherwise, :code:`<code>false</code>`.
    :vartype is_default_container: bool
    :ivar default_host_name: Default hostname of the app. Read-only.
    :vartype default_host_name: str
    :ivar slot_swap_status: Status of the last deployment slot swap operation.
    :vartype slot_swap_status: ~azure.mgmt.web.v2016_08_01.models.SlotSwapStatus
    :ivar https_only: HttpsOnly: configures a web site to accept only https requests. Issues
     redirect for
     http requests.
    :vartype https_only: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'state': {'readonly': True},
        'host_names': {'readonly': True},
        'repository_site_name': {'readonly': True},
        'usage_state': {'readonly': True},
        'enabled_host_names': {'readonly': True},
        'availability_state': {'readonly': True},
        'last_modified_time_utc': {'readonly': True},
        'traffic_manager_host_names': {'readonly': True},
        'target_swap_slot': {'readonly': True},
        'outbound_ip_addresses': {'readonly': True},
        'possible_outbound_ip_addresses': {'readonly': True},
        'suspended_till': {'readonly': True},
        'max_number_of_workers': {'readonly': True},
        'resource_group': {'readonly': True},
        'is_default_container': {'readonly': True},
        'default_host_name': {'readonly': True},
        'slot_swap_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'host_names': {'key': 'properties.hostNames', 'type': '[str]'},
        'repository_site_name': {'key': 'properties.repositorySiteName', 'type': 'str'},
        'usage_state': {'key': 'properties.usageState', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'enabled_host_names': {'key': 'properties.enabledHostNames', 'type': '[str]'},
        'availability_state': {'key': 'properties.availabilityState', 'type': 'str'},
        'host_name_ssl_states': {'key': 'properties.hostNameSslStates', 'type': '[HostNameSslState]'},
        'server_farm_id': {'key': 'properties.serverFarmId', 'type': 'str'},
        'reserved': {'key': 'properties.reserved', 'type': 'bool'},
        'last_modified_time_utc': {'key': 'properties.lastModifiedTimeUtc', 'type': 'iso-8601'},
        'site_config': {'key': 'properties.siteConfig', 'type': 'SiteConfig'},
        'traffic_manager_host_names': {'key': 'properties.trafficManagerHostNames', 'type': '[str]'},
        'scm_site_also_stopped': {'key': 'properties.scmSiteAlsoStopped', 'type': 'bool'},
        'target_swap_slot': {'key': 'properties.targetSwapSlot', 'type': 'str'},
        'hosting_environment_profile': {'key': 'properties.hostingEnvironmentProfile', 'type': 'HostingEnvironmentProfile'},
        'client_affinity_enabled': {'key': 'properties.clientAffinityEnabled', 'type': 'bool'},
        'client_cert_enabled': {'key': 'properties.clientCertEnabled', 'type': 'bool'},
        'host_names_disabled': {'key': 'properties.hostNamesDisabled', 'type': 'bool'},
        'outbound_ip_addresses': {'key': 'properties.outboundIpAddresses', 'type': 'str'},
        'possible_outbound_ip_addresses': {'key': 'properties.possibleOutboundIpAddresses', 'type': 'str'},
        'container_size': {'key': 'properties.containerSize', 'type': 'int'},
        'daily_memory_time_quota': {'key': 'properties.dailyMemoryTimeQuota', 'type': 'int'},
        'suspended_till': {'key': 'properties.suspendedTill', 'type': 'iso-8601'},
        'max_number_of_workers': {'key': 'properties.maxNumberOfWorkers', 'type': 'int'},
        'cloning_info': {'key': 'properties.cloningInfo', 'type': 'CloningInfo'},
        'snapshot_info': {'key': 'properties.snapshotInfo', 'type': 'SnapshotRecoveryRequest'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'is_default_container': {'key': 'properties.isDefaultContainer', 'type': 'bool'},
        'default_host_name': {'key': 'properties.defaultHostName', 'type': 'str'},
        'slot_swap_status': {'key': 'properties.slotSwapStatus', 'type': 'SlotSwapStatus'},
        'https_only': {'key': 'properties.httpsOnly', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        enabled: Optional[bool] = None,
        host_name_ssl_states: Optional[List["_models.HostNameSslState"]] = None,
        server_farm_id: Optional[str] = None,
        reserved: Optional[bool] = False,
        site_config: Optional["_models.SiteConfig"] = None,
        scm_site_also_stopped: Optional[bool] = False,
        hosting_environment_profile: Optional["_models.HostingEnvironmentProfile"] = None,
        client_affinity_enabled: Optional[bool] = None,
        client_cert_enabled: Optional[bool] = None,
        host_names_disabled: Optional[bool] = None,
        container_size: Optional[int] = None,
        daily_memory_time_quota: Optional[int] = None,
        cloning_info: Optional["_models.CloningInfo"] = None,
        snapshot_info: Optional["_models.SnapshotRecoveryRequest"] = None,
        https_only: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword enabled: :code:`<code>true</code>` if the app is enabled; otherwise,
         :code:`<code>false</code>`. Setting this value to false disables the app (takes the app
         offline).
        :paramtype enabled: bool
        :keyword host_name_ssl_states: Hostname SSL states are used to manage the SSL bindings for
         app's hostnames.
        :paramtype host_name_ssl_states: list[~azure.mgmt.web.v2016_08_01.models.HostNameSslState]
        :keyword server_farm_id: Resource ID of the associated App Service plan, formatted as:
         "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
        :paramtype server_farm_id: str
        :keyword reserved: :code:`<code>true</code>` if reserved; otherwise,
         :code:`<code>false</code>`.
        :paramtype reserved: bool
        :keyword site_config: Configuration of the app.
        :paramtype site_config: ~azure.mgmt.web.v2016_08_01.models.SiteConfig
        :keyword scm_site_also_stopped: :code:`<code>true</code>` to stop SCM (KUDU) site when the app
         is stopped; otherwise, :code:`<code>false</code>`. The default is :code:`<code>false</code>`.
        :paramtype scm_site_also_stopped: bool
        :keyword hosting_environment_profile: App Service Environment to use for the app.
        :paramtype hosting_environment_profile:
         ~azure.mgmt.web.v2016_08_01.models.HostingEnvironmentProfile
        :keyword client_affinity_enabled: :code:`<code>true</code>` to enable client affinity;
         :code:`<code>false</code>` to stop sending session affinity cookies, which route client
         requests in the same session to the same instance. Default is :code:`<code>true</code>`.
        :paramtype client_affinity_enabled: bool
        :keyword client_cert_enabled: :code:`<code>true</code>` to enable client certificate
         authentication (TLS mutual authentication); otherwise, :code:`<code>false</code>`. Default is
         :code:`<code>false</code>`.
        :paramtype client_cert_enabled: bool
        :keyword host_names_disabled: :code:`<code>true</code>` to disable the public hostnames of the
         app; otherwise, :code:`<code>false</code>`.
          If :code:`<code>true</code>`, the app is only accessible via API management process.
        :paramtype host_names_disabled: bool
        :keyword container_size: Size of the function container.
        :paramtype container_size: int
        :keyword daily_memory_time_quota: Maximum allowed daily memory-time quota (applicable on
         dynamic apps only).
        :paramtype daily_memory_time_quota: int
        :keyword cloning_info: If specified during app creation, the app is cloned from a source app.
        :paramtype cloning_info: ~azure.mgmt.web.v2016_08_01.models.CloningInfo
        :keyword snapshot_info: If specified during app creation, the app is created from a previous
         snapshot.
        :paramtype snapshot_info: ~azure.mgmt.web.v2016_08_01.models.SnapshotRecoveryRequest
        :keyword https_only: HttpsOnly: configures a web site to accept only https requests. Issues
         redirect for
         http requests.
        :paramtype https_only: bool
        """
        super(SitePatchResource, self).__init__(kind=kind, **kwargs)
        self.state = None
        self.host_names = None
        self.repository_site_name = None
        self.usage_state = None
        self.enabled = enabled
        self.enabled_host_names = None
        self.availability_state = None
        self.host_name_ssl_states = host_name_ssl_states
        self.server_farm_id = server_farm_id
        self.reserved = reserved
        self.last_modified_time_utc = None
        self.site_config = site_config
        self.traffic_manager_host_names = None
        self.scm_site_also_stopped = scm_site_also_stopped
        self.target_swap_slot = None
        self.hosting_environment_profile = hosting_environment_profile
        self.client_affinity_enabled = client_affinity_enabled
        self.client_cert_enabled = client_cert_enabled
        self.host_names_disabled = host_names_disabled
        self.outbound_ip_addresses = None
        self.possible_outbound_ip_addresses = None
        self.container_size = container_size
        self.daily_memory_time_quota = daily_memory_time_quota
        self.suspended_till = None
        self.max_number_of_workers = None
        self.cloning_info = cloning_info
        self.snapshot_info = snapshot_info
        self.resource_group = None
        self.is_default_container = None
        self.default_host_name = None
        self.slot_swap_status = None
        self.https_only = https_only


class SitePhpErrorLogFlag(ProxyOnlyResource):
    """Used for getting PHP error logging flag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar local_log_errors: Local log_errors setting.
    :vartype local_log_errors: str
    :ivar master_log_errors: Master log_errors setting.
    :vartype master_log_errors: str
    :ivar local_log_errors_max_length: Local log_errors_max_len setting.
    :vartype local_log_errors_max_length: str
    :ivar master_log_errors_max_length: Master log_errors_max_len setting.
    :vartype master_log_errors_max_length: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'local_log_errors': {'key': 'properties.localLogErrors', 'type': 'str'},
        'master_log_errors': {'key': 'properties.masterLogErrors', 'type': 'str'},
        'local_log_errors_max_length': {'key': 'properties.localLogErrorsMaxLength', 'type': 'str'},
        'master_log_errors_max_length': {'key': 'properties.masterLogErrorsMaxLength', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        local_log_errors: Optional[str] = None,
        master_log_errors: Optional[str] = None,
        local_log_errors_max_length: Optional[str] = None,
        master_log_errors_max_length: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword local_log_errors: Local log_errors setting.
        :paramtype local_log_errors: str
        :keyword master_log_errors: Master log_errors setting.
        :paramtype master_log_errors: str
        :keyword local_log_errors_max_length: Local log_errors_max_len setting.
        :paramtype local_log_errors_max_length: str
        :keyword master_log_errors_max_length: Master log_errors_max_len setting.
        :paramtype master_log_errors_max_length: str
        """
        super(SitePhpErrorLogFlag, self).__init__(kind=kind, **kwargs)
        self.local_log_errors = local_log_errors
        self.master_log_errors = master_log_errors
        self.local_log_errors_max_length = local_log_errors_max_length
        self.master_log_errors_max_length = master_log_errors_max_length


class SiteSourceControl(ProxyOnlyResource):
    """Source control configuration for an app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar repo_url: Repository or source control URL.
    :vartype repo_url: str
    :ivar branch: Name of branch to use for deployment.
    :vartype branch: str
    :ivar is_manual_integration: :code:`<code>true</code>` to limit to manual integration;
     :code:`<code>false</code>` to enable continuous integration (which configures webhooks into
     online repos like GitHub).
    :vartype is_manual_integration: bool
    :ivar deployment_rollback_enabled: :code:`<code>true</code>` to enable deployment rollback;
     otherwise, :code:`<code>false</code>`.
    :vartype deployment_rollback_enabled: bool
    :ivar is_mercurial: :code:`<code>true</code>` for a Mercurial repository;
     :code:`<code>false</code>` for a Git repository.
    :vartype is_mercurial: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'repo_url': {'key': 'properties.repoUrl', 'type': 'str'},
        'branch': {'key': 'properties.branch', 'type': 'str'},
        'is_manual_integration': {'key': 'properties.isManualIntegration', 'type': 'bool'},
        'deployment_rollback_enabled': {'key': 'properties.deploymentRollbackEnabled', 'type': 'bool'},
        'is_mercurial': {'key': 'properties.isMercurial', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        repo_url: Optional[str] = None,
        branch: Optional[str] = None,
        is_manual_integration: Optional[bool] = None,
        deployment_rollback_enabled: Optional[bool] = None,
        is_mercurial: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword repo_url: Repository or source control URL.
        :paramtype repo_url: str
        :keyword branch: Name of branch to use for deployment.
        :paramtype branch: str
        :keyword is_manual_integration: :code:`<code>true</code>` to limit to manual integration;
         :code:`<code>false</code>` to enable continuous integration (which configures webhooks into
         online repos like GitHub).
        :paramtype is_manual_integration: bool
        :keyword deployment_rollback_enabled: :code:`<code>true</code>` to enable deployment rollback;
         otherwise, :code:`<code>false</code>`.
        :paramtype deployment_rollback_enabled: bool
        :keyword is_mercurial: :code:`<code>true</code>` for a Mercurial repository;
         :code:`<code>false</code>` for a Git repository.
        :paramtype is_mercurial: bool
        """
        super(SiteSourceControl, self).__init__(kind=kind, **kwargs)
        self.repo_url = repo_url
        self.branch = branch
        self.is_manual_integration = is_manual_integration
        self.deployment_rollback_enabled = deployment_rollback_enabled
        self.is_mercurial = is_mercurial


class SlotConfigNamesResource(ProxyOnlyResource):
    """Slot Config names azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar connection_string_names: List of connection string names.
    :vartype connection_string_names: list[str]
    :ivar app_setting_names: List of application settings names.
    :vartype app_setting_names: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'connection_string_names': {'key': 'properties.connectionStringNames', 'type': '[str]'},
        'app_setting_names': {'key': 'properties.appSettingNames', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        connection_string_names: Optional[List[str]] = None,
        app_setting_names: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword connection_string_names: List of connection string names.
        :paramtype connection_string_names: list[str]
        :keyword app_setting_names: List of application settings names.
        :paramtype app_setting_names: list[str]
        """
        super(SlotConfigNamesResource, self).__init__(kind=kind, **kwargs)
        self.connection_string_names = connection_string_names
        self.app_setting_names = app_setting_names


class SlotDifference(ProxyOnlyResource):
    """A setting difference between two deployment slots of an app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar type_properties_type: Type of the difference: Information, Warning or Error.
    :vartype type_properties_type: str
    :ivar setting_type: The type of the setting: General, AppSetting or ConnectionString.
    :vartype setting_type: str
    :ivar diff_rule: Rule that describes how to process the setting difference during a slot swap.
    :vartype diff_rule: str
    :ivar setting_name: Name of the setting.
    :vartype setting_name: str
    :ivar value_in_current_slot: Value of the setting in the current slot.
    :vartype value_in_current_slot: str
    :ivar value_in_target_slot: Value of the setting in the target slot.
    :vartype value_in_target_slot: str
    :ivar description: Description of the setting difference.
    :vartype description: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'type_properties_type': {'readonly': True},
        'setting_type': {'readonly': True},
        'diff_rule': {'readonly': True},
        'setting_name': {'readonly': True},
        'value_in_current_slot': {'readonly': True},
        'value_in_target_slot': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'type_properties_type': {'key': 'properties.type', 'type': 'str'},
        'setting_type': {'key': 'properties.settingType', 'type': 'str'},
        'diff_rule': {'key': 'properties.diffRule', 'type': 'str'},
        'setting_name': {'key': 'properties.settingName', 'type': 'str'},
        'value_in_current_slot': {'key': 'properties.valueInCurrentSlot', 'type': 'str'},
        'value_in_target_slot': {'key': 'properties.valueInTargetSlot', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super(SlotDifference, self).__init__(kind=kind, **kwargs)
        self.type_properties_type = None
        self.setting_type = None
        self.diff_rule = None
        self.setting_name = None
        self.value_in_current_slot = None
        self.value_in_target_slot = None
        self.description = None


class SlotDifferenceCollection(msrest.serialization.Model):
    """Collection of slot differences.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2016_08_01.models.SlotDifference]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SlotDifference]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["_models.SlotDifference"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2016_08_01.models.SlotDifference]
        """
        super(SlotDifferenceCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class SlotSwapStatus(msrest.serialization.Model):
    """The status of the last successful slot swap operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar timestamp_utc: The time the last successful slot swap completed.
    :vartype timestamp_utc: ~datetime.datetime
    :ivar source_slot_name: The source slot of the last swap operation.
    :vartype source_slot_name: str
    :ivar destination_slot_name: The destination slot of the last swap operation.
    :vartype destination_slot_name: str
    """

    _validation = {
        'timestamp_utc': {'readonly': True},
        'source_slot_name': {'readonly': True},
        'destination_slot_name': {'readonly': True},
    }

    _attribute_map = {
        'timestamp_utc': {'key': 'timestampUtc', 'type': 'iso-8601'},
        'source_slot_name': {'key': 'sourceSlotName', 'type': 'str'},
        'destination_slot_name': {'key': 'destinationSlotName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(SlotSwapStatus, self).__init__(**kwargs)
        self.timestamp_utc = None
        self.source_slot_name = None
        self.destination_slot_name = None


class SlowRequestsBasedTrigger(msrest.serialization.Model):
    """Trigger based on request execution time.

    :ivar time_taken: Time taken.
    :vartype time_taken: str
    :ivar count: Request Count.
    :vartype count: int
    :ivar time_interval: Time interval.
    :vartype time_interval: str
    """

    _attribute_map = {
        'time_taken': {'key': 'timeTaken', 'type': 'str'},
        'count': {'key': 'count', 'type': 'int'},
        'time_interval': {'key': 'timeInterval', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        time_taken: Optional[str] = None,
        count: Optional[int] = None,
        time_interval: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword time_taken: Time taken.
        :paramtype time_taken: str
        :keyword count: Request Count.
        :paramtype count: int
        :keyword time_interval: Time interval.
        :paramtype time_interval: str
        """
        super(SlowRequestsBasedTrigger, self).__init__(**kwargs)
        self.time_taken = time_taken
        self.count = count
        self.time_interval = time_interval


class Snapshot(ProxyOnlyResource):
    """A snapshot of an app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar time: The time the snapshot was taken.
    :vartype time: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'time': {'key': 'properties.time', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super(Snapshot, self).__init__(kind=kind, **kwargs)
        self.time = None


class SnapshotCollection(msrest.serialization.Model):
    """Collection of snapshots which can be used to revert an app to a previous time.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2016_08_01.models.Snapshot]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Snapshot]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["_models.Snapshot"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2016_08_01.models.Snapshot]
        """
        super(SnapshotCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class SnapshotRecoveryRequest(ProxyOnlyResource):
    """Details about app recovery operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar snapshot_time: Point in time in which the app recovery should be attempted, formatted as
     a DateTime string.
    :vartype snapshot_time: str
    :ivar recovery_target: Specifies the web app that snapshot contents will be written to.
    :vartype recovery_target: ~azure.mgmt.web.v2016_08_01.models.SnapshotRecoveryTarget
    :ivar overwrite: If :code:`<code>true</code>` the recovery operation can overwrite source app;
     otherwise, :code:`<code>false</code>`.
    :vartype overwrite: bool
    :ivar recover_configuration: If true, site configuration, in addition to content, will be
     reverted.
    :vartype recover_configuration: bool
    :ivar ignore_conflicting_host_names: If true, custom hostname conflicts will be ignored when
     recovering to a target web app.
     This setting is only necessary when RecoverConfiguration is enabled.
    :vartype ignore_conflicting_host_names: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'snapshot_time': {'key': 'properties.snapshotTime', 'type': 'str'},
        'recovery_target': {'key': 'properties.recoveryTarget', 'type': 'SnapshotRecoveryTarget'},
        'overwrite': {'key': 'properties.overwrite', 'type': 'bool'},
        'recover_configuration': {'key': 'properties.recoverConfiguration', 'type': 'bool'},
        'ignore_conflicting_host_names': {'key': 'properties.ignoreConflictingHostNames', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        snapshot_time: Optional[str] = None,
        recovery_target: Optional["_models.SnapshotRecoveryTarget"] = None,
        overwrite: Optional[bool] = None,
        recover_configuration: Optional[bool] = None,
        ignore_conflicting_host_names: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword snapshot_time: Point in time in which the app recovery should be attempted, formatted
         as a DateTime string.
        :paramtype snapshot_time: str
        :keyword recovery_target: Specifies the web app that snapshot contents will be written to.
        :paramtype recovery_target: ~azure.mgmt.web.v2016_08_01.models.SnapshotRecoveryTarget
        :keyword overwrite: If :code:`<code>true</code>` the recovery operation can overwrite source
         app; otherwise, :code:`<code>false</code>`.
        :paramtype overwrite: bool
        :keyword recover_configuration: If true, site configuration, in addition to content, will be
         reverted.
        :paramtype recover_configuration: bool
        :keyword ignore_conflicting_host_names: If true, custom hostname conflicts will be ignored when
         recovering to a target web app.
         This setting is only necessary when RecoverConfiguration is enabled.
        :paramtype ignore_conflicting_host_names: bool
        """
        super(SnapshotRecoveryRequest, self).__init__(kind=kind, **kwargs)
        self.snapshot_time = snapshot_time
        self.recovery_target = recovery_target
        self.overwrite = overwrite
        self.recover_configuration = recover_configuration
        self.ignore_conflicting_host_names = ignore_conflicting_host_names


class SnapshotRecoveryTarget(msrest.serialization.Model):
    """Specifies the web app that snapshot contents will be written to.

    :ivar location: Geographical location of the target web app, e.g. SouthEastAsia,
     SouthCentralUS.
    :vartype location: str
    :ivar id: ARM resource ID of the target app.
    /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}
     for production slots and
    /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName}
     for other slots.
    :vartype id: str
    """

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword location: Geographical location of the target web app, e.g. SouthEastAsia,
         SouthCentralUS.
        :paramtype location: str
        :keyword id: ARM resource ID of the target app.
        /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}
         for production slots and
        /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName}
         for other slots.
        :paramtype id: str
        """
        super(SnapshotRecoveryTarget, self).__init__(**kwargs)
        self.location = location
        self.id = id


class StatusCodesBasedTrigger(msrest.serialization.Model):
    """Trigger based on status code.

    :ivar status: HTTP status code.
    :vartype status: int
    :ivar sub_status: Request Sub Status.
    :vartype sub_status: int
    :ivar win32_status: Win32 error code.
    :vartype win32_status: int
    :ivar count: Request Count.
    :vartype count: int
    :ivar time_interval: Time interval.
    :vartype time_interval: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'int'},
        'sub_status': {'key': 'subStatus', 'type': 'int'},
        'win32_status': {'key': 'win32Status', 'type': 'int'},
        'count': {'key': 'count', 'type': 'int'},
        'time_interval': {'key': 'timeInterval', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Optional[int] = None,
        sub_status: Optional[int] = None,
        win32_status: Optional[int] = None,
        count: Optional[int] = None,
        time_interval: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword status: HTTP status code.
        :paramtype status: int
        :keyword sub_status: Request Sub Status.
        :paramtype sub_status: int
        :keyword win32_status: Win32 error code.
        :paramtype win32_status: int
        :keyword count: Request Count.
        :paramtype count: int
        :keyword time_interval: Time interval.
        :paramtype time_interval: str
        """
        super(StatusCodesBasedTrigger, self).__init__(**kwargs)
        self.status = status
        self.sub_status = sub_status
        self.win32_status = win32_status
        self.count = count
        self.time_interval = time_interval


class StorageMigrationOptions(ProxyOnlyResource):
    """Options for app content migration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar azurefiles_connection_string: AzureFiles connection string.
    :vartype azurefiles_connection_string: str
    :ivar azurefiles_share: AzureFiles share.
    :vartype azurefiles_share: str
    :ivar switch_site_after_migration: :code:`<code>true</code>`if the app should be switched over;
     otherwise, :code:`<code>false</code>`.
    :vartype switch_site_after_migration: bool
    :ivar block_write_access_to_site: :code:`<code>true</code>` if the app should be read only
     during copy operation; otherwise, :code:`<code>false</code>`.
    :vartype block_write_access_to_site: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'azurefiles_connection_string': {'key': 'properties.azurefilesConnectionString', 'type': 'str'},
        'azurefiles_share': {'key': 'properties.azurefilesShare', 'type': 'str'},
        'switch_site_after_migration': {'key': 'properties.switchSiteAfterMigration', 'type': 'bool'},
        'block_write_access_to_site': {'key': 'properties.blockWriteAccessToSite', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        azurefiles_connection_string: Optional[str] = None,
        azurefiles_share: Optional[str] = None,
        switch_site_after_migration: Optional[bool] = False,
        block_write_access_to_site: Optional[bool] = False,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword azurefiles_connection_string: AzureFiles connection string.
        :paramtype azurefiles_connection_string: str
        :keyword azurefiles_share: AzureFiles share.
        :paramtype azurefiles_share: str
        :keyword switch_site_after_migration: :code:`<code>true</code>`if the app should be switched
         over; otherwise, :code:`<code>false</code>`.
        :paramtype switch_site_after_migration: bool
        :keyword block_write_access_to_site: :code:`<code>true</code>` if the app should be read only
         during copy operation; otherwise, :code:`<code>false</code>`.
        :paramtype block_write_access_to_site: bool
        """
        super(StorageMigrationOptions, self).__init__(kind=kind, **kwargs)
        self.azurefiles_connection_string = azurefiles_connection_string
        self.azurefiles_share = azurefiles_share
        self.switch_site_after_migration = switch_site_after_migration
        self.block_write_access_to_site = block_write_access_to_site


class StorageMigrationResponse(ProxyOnlyResource):
    """Response for a migration of app content request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar operation_id: When server starts the migration process, it will return an operation ID
     identifying that particular migration operation.
    :vartype operation_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'operation_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'operation_id': {'key': 'properties.operationId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super(StorageMigrationResponse, self).__init__(kind=kind, **kwargs)
        self.operation_id = None


class StringDictionary(ProxyOnlyResource):
    """String dictionary resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar properties: Settings.
    :vartype properties: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword properties: Settings.
        :paramtype properties: dict[str, str]
        """
        super(StringDictionary, self).__init__(kind=kind, **kwargs)
        self.properties = properties


class TriggeredJobHistory(ProxyOnlyResource):
    """Triggered Web Job History. List of Triggered Web Job Run Information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar triggered_job_runs: List of triggered web job runs.
    :vartype triggered_job_runs: list[~azure.mgmt.web.v2016_08_01.models.TriggeredJobRun]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'triggered_job_runs': {'key': 'properties.triggeredJobRuns', 'type': '[TriggeredJobRun]'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        triggered_job_runs: Optional[List["_models.TriggeredJobRun"]] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword triggered_job_runs: List of triggered web job runs.
        :paramtype triggered_job_runs: list[~azure.mgmt.web.v2016_08_01.models.TriggeredJobRun]
        """
        super(TriggeredJobHistory, self).__init__(kind=kind, **kwargs)
        self.triggered_job_runs = triggered_job_runs


class TriggeredJobHistoryCollection(msrest.serialization.Model):
    """Collection of Kudu continuous web job information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2016_08_01.models.TriggeredJobHistory]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TriggeredJobHistory]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["_models.TriggeredJobHistory"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2016_08_01.models.TriggeredJobHistory]
        """
        super(TriggeredJobHistoryCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class TriggeredJobRun(ProxyOnlyResource):
    """Triggered Web Job Run Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar id_properties_id: Job ID.
    :vartype id_properties_id: str
    :ivar name_properties_name: Job name.
    :vartype name_properties_name: str
    :ivar status: Job status. Known values are: "Success", "Failed", "Error".
    :vartype status: str or ~azure.mgmt.web.v2016_08_01.models.TriggeredWebJobStatus
    :ivar start_time: Start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time.
    :vartype end_time: ~datetime.datetime
    :ivar duration: Job duration.
    :vartype duration: str
    :ivar output_url: Output URL.
    :vartype output_url: str
    :ivar error_url: Error URL.
    :vartype error_url: str
    :ivar url: Job URL.
    :vartype url: str
    :ivar job_name: Job name.
    :vartype job_name: str
    :ivar trigger: Job trigger.
    :vartype trigger: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'name_properties_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'id_properties_id': {'key': 'properties.id', 'type': 'str'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'duration': {'key': 'properties.duration', 'type': 'str'},
        'output_url': {'key': 'properties.outputUrl', 'type': 'str'},
        'error_url': {'key': 'properties.errorUrl', 'type': 'str'},
        'url': {'key': 'properties.url', 'type': 'str'},
        'job_name': {'key': 'properties.jobName', 'type': 'str'},
        'trigger': {'key': 'properties.trigger', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        id_properties_id: Optional[str] = None,
        status: Optional[Union[str, "_models.TriggeredWebJobStatus"]] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        duration: Optional[str] = None,
        output_url: Optional[str] = None,
        error_url: Optional[str] = None,
        url: Optional[str] = None,
        job_name: Optional[str] = None,
        trigger: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword id_properties_id: Job ID.
        :paramtype id_properties_id: str
        :keyword status: Job status. Known values are: "Success", "Failed", "Error".
        :paramtype status: str or ~azure.mgmt.web.v2016_08_01.models.TriggeredWebJobStatus
        :keyword start_time: Start time.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: End time.
        :paramtype end_time: ~datetime.datetime
        :keyword duration: Job duration.
        :paramtype duration: str
        :keyword output_url: Output URL.
        :paramtype output_url: str
        :keyword error_url: Error URL.
        :paramtype error_url: str
        :keyword url: Job URL.
        :paramtype url: str
        :keyword job_name: Job name.
        :paramtype job_name: str
        :keyword trigger: Job trigger.
        :paramtype trigger: str
        """
        super(TriggeredJobRun, self).__init__(kind=kind, **kwargs)
        self.id_properties_id = id_properties_id
        self.name_properties_name = None
        self.status = status
        self.start_time = start_time
        self.end_time = end_time
        self.duration = duration
        self.output_url = output_url
        self.error_url = error_url
        self.url = url
        self.job_name = job_name
        self.trigger = trigger


class TriggeredWebJob(ProxyOnlyResource):
    """Triggered Web Job Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar latest_run: Latest job run information.
    :vartype latest_run: ~azure.mgmt.web.v2016_08_01.models.TriggeredJobRun
    :ivar history_url: History URL.
    :vartype history_url: str
    :ivar scheduler_logs_url: Scheduler Logs URL.
    :vartype scheduler_logs_url: str
    :ivar name_properties_name: Job name. Used as job identifier in ARM resource URI.
    :vartype name_properties_name: str
    :ivar run_command: Run command.
    :vartype run_command: str
    :ivar url: Job URL.
    :vartype url: str
    :ivar extra_info_url: Extra Info URL.
    :vartype extra_info_url: str
    :ivar job_type: Job type. Known values are: "Continuous", "Triggered".
    :vartype job_type: str or ~azure.mgmt.web.v2016_08_01.models.WebJobType
    :ivar error: Error information.
    :vartype error: str
    :ivar using_sdk: Using SDK?.
    :vartype using_sdk: bool
    :ivar settings: Job settings.
    :vartype settings: dict[str, any]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'name_properties_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'latest_run': {'key': 'properties.latestRun', 'type': 'TriggeredJobRun'},
        'history_url': {'key': 'properties.historyUrl', 'type': 'str'},
        'scheduler_logs_url': {'key': 'properties.schedulerLogsUrl', 'type': 'str'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'run_command': {'key': 'properties.runCommand', 'type': 'str'},
        'url': {'key': 'properties.url', 'type': 'str'},
        'extra_info_url': {'key': 'properties.extraInfoUrl', 'type': 'str'},
        'job_type': {'key': 'properties.jobType', 'type': 'str'},
        'error': {'key': 'properties.error', 'type': 'str'},
        'using_sdk': {'key': 'properties.usingSdk', 'type': 'bool'},
        'settings': {'key': 'properties.settings', 'type': '{object}'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        latest_run: Optional["_models.TriggeredJobRun"] = None,
        history_url: Optional[str] = None,
        scheduler_logs_url: Optional[str] = None,
        run_command: Optional[str] = None,
        url: Optional[str] = None,
        extra_info_url: Optional[str] = None,
        job_type: Optional[Union[str, "_models.WebJobType"]] = None,
        error: Optional[str] = None,
        using_sdk: Optional[bool] = None,
        settings: Optional[Dict[str, Any]] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword latest_run: Latest job run information.
        :paramtype latest_run: ~azure.mgmt.web.v2016_08_01.models.TriggeredJobRun
        :keyword history_url: History URL.
        :paramtype history_url: str
        :keyword scheduler_logs_url: Scheduler Logs URL.
        :paramtype scheduler_logs_url: str
        :keyword run_command: Run command.
        :paramtype run_command: str
        :keyword url: Job URL.
        :paramtype url: str
        :keyword extra_info_url: Extra Info URL.
        :paramtype extra_info_url: str
        :keyword job_type: Job type. Known values are: "Continuous", "Triggered".
        :paramtype job_type: str or ~azure.mgmt.web.v2016_08_01.models.WebJobType
        :keyword error: Error information.
        :paramtype error: str
        :keyword using_sdk: Using SDK?.
        :paramtype using_sdk: bool
        :keyword settings: Job settings.
        :paramtype settings: dict[str, any]
        """
        super(TriggeredWebJob, self).__init__(kind=kind, **kwargs)
        self.latest_run = latest_run
        self.history_url = history_url
        self.scheduler_logs_url = scheduler_logs_url
        self.name_properties_name = None
        self.run_command = run_command
        self.url = url
        self.extra_info_url = extra_info_url
        self.job_type = job_type
        self.error = error
        self.using_sdk = using_sdk
        self.settings = settings


class TriggeredWebJobCollection(msrest.serialization.Model):
    """Collection of Kudu continuous web job information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2016_08_01.models.TriggeredWebJob]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TriggeredWebJob]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["_models.TriggeredWebJob"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2016_08_01.models.TriggeredWebJob]
        """
        super(TriggeredWebJobCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class User(ProxyOnlyResource):
    """User credentials used for publishing activity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar user_name: Username.
    :vartype user_name: str
    :ivar publishing_user_name: Username used for publishing.
    :vartype publishing_user_name: str
    :ivar publishing_password: Password used for publishing.
    :vartype publishing_password: str
    :ivar publishing_password_hash: Password hash used for publishing.
    :vartype publishing_password_hash: str
    :ivar publishing_password_hash_salt: Password hash salt used for publishing.
    :vartype publishing_password_hash_salt: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'user_name': {'key': 'properties.name', 'type': 'str'},
        'publishing_user_name': {'key': 'properties.publishingUserName', 'type': 'str'},
        'publishing_password': {'key': 'properties.publishingPassword', 'type': 'str'},
        'publishing_password_hash': {'key': 'properties.publishingPasswordHash', 'type': 'str'},
        'publishing_password_hash_salt': {'key': 'properties.publishingPasswordHashSalt', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        user_name: Optional[str] = None,
        publishing_user_name: Optional[str] = None,
        publishing_password: Optional[str] = None,
        publishing_password_hash: Optional[str] = None,
        publishing_password_hash_salt: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword user_name: Username.
        :paramtype user_name: str
        :keyword publishing_user_name: Username used for publishing.
        :paramtype publishing_user_name: str
        :keyword publishing_password: Password used for publishing.
        :paramtype publishing_password: str
        :keyword publishing_password_hash: Password hash used for publishing.
        :paramtype publishing_password_hash: str
        :keyword publishing_password_hash_salt: Password hash salt used for publishing.
        :paramtype publishing_password_hash_salt: str
        """
        super(User, self).__init__(kind=kind, **kwargs)
        self.user_name = user_name
        self.publishing_user_name = publishing_user_name
        self.publishing_password = publishing_password
        self.publishing_password_hash = publishing_password_hash
        self.publishing_password_hash_salt = publishing_password_hash_salt


class VirtualApplication(msrest.serialization.Model):
    """Virtual application in an app.

    :ivar virtual_path: Virtual path.
    :vartype virtual_path: str
    :ivar physical_path: Physical path.
    :vartype physical_path: str
    :ivar preload_enabled: :code:`<code>true</code>` if preloading is enabled; otherwise,
     :code:`<code>false</code>`.
    :vartype preload_enabled: bool
    :ivar virtual_directories: Virtual directories for virtual application.
    :vartype virtual_directories: list[~azure.mgmt.web.v2016_08_01.models.VirtualDirectory]
    """

    _attribute_map = {
        'virtual_path': {'key': 'virtualPath', 'type': 'str'},
        'physical_path': {'key': 'physicalPath', 'type': 'str'},
        'preload_enabled': {'key': 'preloadEnabled', 'type': 'bool'},
        'virtual_directories': {'key': 'virtualDirectories', 'type': '[VirtualDirectory]'},
    }

    def __init__(
        self,
        *,
        virtual_path: Optional[str] = None,
        physical_path: Optional[str] = None,
        preload_enabled: Optional[bool] = None,
        virtual_directories: Optional[List["_models.VirtualDirectory"]] = None,
        **kwargs
    ):
        """
        :keyword virtual_path: Virtual path.
        :paramtype virtual_path: str
        :keyword physical_path: Physical path.
        :paramtype physical_path: str
        :keyword preload_enabled: :code:`<code>true</code>` if preloading is enabled; otherwise,
         :code:`<code>false</code>`.
        :paramtype preload_enabled: bool
        :keyword virtual_directories: Virtual directories for virtual application.
        :paramtype virtual_directories: list[~azure.mgmt.web.v2016_08_01.models.VirtualDirectory]
        """
        super(VirtualApplication, self).__init__(**kwargs)
        self.virtual_path = virtual_path
        self.physical_path = physical_path
        self.preload_enabled = preload_enabled
        self.virtual_directories = virtual_directories


class VirtualDirectory(msrest.serialization.Model):
    """Directory for virtual application.

    :ivar virtual_path: Path to virtual application.
    :vartype virtual_path: str
    :ivar physical_path: Physical path.
    :vartype physical_path: str
    """

    _attribute_map = {
        'virtual_path': {'key': 'virtualPath', 'type': 'str'},
        'physical_path': {'key': 'physicalPath', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        virtual_path: Optional[str] = None,
        physical_path: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword virtual_path: Path to virtual application.
        :paramtype virtual_path: str
        :keyword physical_path: Physical path.
        :paramtype physical_path: str
        """
        super(VirtualDirectory, self).__init__(**kwargs)
        self.virtual_path = virtual_path
        self.physical_path = physical_path


class VnetGateway(ProxyOnlyResource):
    """The Virtual Network gateway contract. This is used to give the Virtual Network gateway access to the VPN package.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar vnet_name: The Virtual Network name.
    :vartype vnet_name: str
    :ivar vpn_package_uri: The URI where the VPN package can be downloaded.
    :vartype vpn_package_uri: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'vnet_name': {'key': 'properties.vnetName', 'type': 'str'},
        'vpn_package_uri': {'key': 'properties.vpnPackageUri', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        vnet_name: Optional[str] = None,
        vpn_package_uri: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword vnet_name: The Virtual Network name.
        :paramtype vnet_name: str
        :keyword vpn_package_uri: The URI where the VPN package can be downloaded.
        :paramtype vpn_package_uri: str
        """
        super(VnetGateway, self).__init__(kind=kind, **kwargs)
        self.vnet_name = vnet_name
        self.vpn_package_uri = vpn_package_uri


class VnetInfo(ProxyOnlyResource):
    """Virtual Network information contract.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar vnet_resource_id: The Virtual Network's resource ID.
    :vartype vnet_resource_id: str
    :ivar cert_thumbprint: The client certificate thumbprint.
    :vartype cert_thumbprint: str
    :ivar cert_blob: A certificate file (.cer) blob containing the public key of the private key
     used to authenticate a
     Point-To-Site VPN connection.
    :vartype cert_blob: bytearray
    :ivar routes: The routes that this Virtual Network connection uses.
    :vartype routes: list[~azure.mgmt.web.v2016_08_01.models.VnetRoute]
    :ivar resync_required: :code:`<code>true</code>` if a resync is required; otherwise,
     :code:`<code>false</code>`.
    :vartype resync_required: bool
    :ivar dns_servers: DNS servers to be used by this Virtual Network. This should be a
     comma-separated list of IP addresses.
    :vartype dns_servers: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'cert_thumbprint': {'readonly': True},
        'routes': {'readonly': True},
        'resync_required': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'vnet_resource_id': {'key': 'properties.vnetResourceId', 'type': 'str'},
        'cert_thumbprint': {'key': 'properties.certThumbprint', 'type': 'str'},
        'cert_blob': {'key': 'properties.certBlob', 'type': 'bytearray'},
        'routes': {'key': 'properties.routes', 'type': '[VnetRoute]'},
        'resync_required': {'key': 'properties.resyncRequired', 'type': 'bool'},
        'dns_servers': {'key': 'properties.dnsServers', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        vnet_resource_id: Optional[str] = None,
        cert_blob: Optional[bytearray] = None,
        dns_servers: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword vnet_resource_id: The Virtual Network's resource ID.
        :paramtype vnet_resource_id: str
        :keyword cert_blob: A certificate file (.cer) blob containing the public key of the private key
         used to authenticate a
         Point-To-Site VPN connection.
        :paramtype cert_blob: bytearray
        :keyword dns_servers: DNS servers to be used by this Virtual Network. This should be a
         comma-separated list of IP addresses.
        :paramtype dns_servers: str
        """
        super(VnetInfo, self).__init__(kind=kind, **kwargs)
        self.vnet_resource_id = vnet_resource_id
        self.cert_thumbprint = None
        self.cert_blob = cert_blob
        self.routes = None
        self.resync_required = None
        self.dns_servers = dns_servers


class VnetRoute(ProxyOnlyResource):
    """Virtual Network route contract used to pass routing information for a Virtual Network.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar vnet_route_name: The name of this route. This is only returned by the server and does not
     need to be set by the client.
    :vartype vnet_route_name: str
    :ivar start_address: The starting address for this route. This may also include a CIDR
     notation, in which case the end address must not be specified.
    :vartype start_address: str
    :ivar end_address: The ending address for this route. If the start address is specified in CIDR
     notation, this must be omitted.
    :vartype end_address: str
    :ivar route_type: The type of route this is:
     DEFAULT - By default, every app has routes to the local address ranges specified by RFC1918
     INHERITED - Routes inherited from the real Virtual Network routes
     STATIC - Static route set on the app only
    
     These values will be used for syncing an app's routes with those from a Virtual Network. Known
     values are: "DEFAULT", "INHERITED", "STATIC".
    :vartype route_type: str or ~azure.mgmt.web.v2016_08_01.models.RouteType
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'vnet_route_name': {'key': 'properties.name', 'type': 'str'},
        'start_address': {'key': 'properties.startAddress', 'type': 'str'},
        'end_address': {'key': 'properties.endAddress', 'type': 'str'},
        'route_type': {'key': 'properties.routeType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        vnet_route_name: Optional[str] = None,
        start_address: Optional[str] = None,
        end_address: Optional[str] = None,
        route_type: Optional[Union[str, "_models.RouteType"]] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword vnet_route_name: The name of this route. This is only returned by the server and does
         not need to be set by the client.
        :paramtype vnet_route_name: str
        :keyword start_address: The starting address for this route. This may also include a CIDR
         notation, in which case the end address must not be specified.
        :paramtype start_address: str
        :keyword end_address: The ending address for this route. If the start address is specified in
         CIDR notation, this must be omitted.
        :paramtype end_address: str
        :keyword route_type: The type of route this is:
         DEFAULT - By default, every app has routes to the local address ranges specified by RFC1918
         INHERITED - Routes inherited from the real Virtual Network routes
         STATIC - Static route set on the app only
        
         These values will be used for syncing an app's routes with those from a Virtual Network. Known
         values are: "DEFAULT", "INHERITED", "STATIC".
        :paramtype route_type: str or ~azure.mgmt.web.v2016_08_01.models.RouteType
        """
        super(VnetRoute, self).__init__(kind=kind, **kwargs)
        self.vnet_route_name = vnet_route_name
        self.start_address = start_address
        self.end_address = end_address
        self.route_type = route_type


class WebAppCollection(msrest.serialization.Model):
    """Collection of App Service apps.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2016_08_01.models.Site]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Site]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["_models.Site"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2016_08_01.models.Site]
        """
        super(WebAppCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class WebAppInstanceCollection(msrest.serialization.Model):
    """Collection of app instances.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2016_08_01.models.SiteInstance]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SiteInstance]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["_models.SiteInstance"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2016_08_01.models.SiteInstance]
        """
        super(WebAppInstanceCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class WebJob(ProxyOnlyResource):
    """Web Job Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar name_properties_name: Job name. Used as job identifier in ARM resource URI.
    :vartype name_properties_name: str
    :ivar run_command: Run command.
    :vartype run_command: str
    :ivar url: Job URL.
    :vartype url: str
    :ivar extra_info_url: Extra Info URL.
    :vartype extra_info_url: str
    :ivar job_type: Job type. Known values are: "Continuous", "Triggered".
    :vartype job_type: str or ~azure.mgmt.web.v2016_08_01.models.WebJobType
    :ivar error: Error information.
    :vartype error: str
    :ivar using_sdk: Using SDK?.
    :vartype using_sdk: bool
    :ivar settings: Job settings.
    :vartype settings: dict[str, any]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'name_properties_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'run_command': {'key': 'properties.runCommand', 'type': 'str'},
        'url': {'key': 'properties.url', 'type': 'str'},
        'extra_info_url': {'key': 'properties.extraInfoUrl', 'type': 'str'},
        'job_type': {'key': 'properties.jobType', 'type': 'str'},
        'error': {'key': 'properties.error', 'type': 'str'},
        'using_sdk': {'key': 'properties.usingSdk', 'type': 'bool'},
        'settings': {'key': 'properties.settings', 'type': '{object}'},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        run_command: Optional[str] = None,
        url: Optional[str] = None,
        extra_info_url: Optional[str] = None,
        job_type: Optional[Union[str, "_models.WebJobType"]] = None,
        error: Optional[str] = None,
        using_sdk: Optional[bool] = None,
        settings: Optional[Dict[str, Any]] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword run_command: Run command.
        :paramtype run_command: str
        :keyword url: Job URL.
        :paramtype url: str
        :keyword extra_info_url: Extra Info URL.
        :paramtype extra_info_url: str
        :keyword job_type: Job type. Known values are: "Continuous", "Triggered".
        :paramtype job_type: str or ~azure.mgmt.web.v2016_08_01.models.WebJobType
        :keyword error: Error information.
        :paramtype error: str
        :keyword using_sdk: Using SDK?.
        :paramtype using_sdk: bool
        :keyword settings: Job settings.
        :paramtype settings: dict[str, any]
        """
        super(WebJob, self).__init__(kind=kind, **kwargs)
        self.name_properties_name = None
        self.run_command = run_command
        self.url = url
        self.extra_info_url = extra_info_url
        self.job_type = job_type
        self.error = error
        self.using_sdk = using_sdk
        self.settings = settings


class WebJobCollection(msrest.serialization.Model):
    """Collection of Kudu web job information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. Collection of resources.
    :vartype value: list[~azure.mgmt.web.v2016_08_01.models.WebJob]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[WebJob]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["_models.WebJob"],
        **kwargs
    ):
        """
        :keyword value: Required. Collection of resources.
        :paramtype value: list[~azure.mgmt.web.v2016_08_01.models.WebJob]
        """
        super(WebJobCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = None
