# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AccessRights(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Access rights of an authorization."""

    MANAGE = "Manage"
    SEND = "Send"
    LISTEN = "Listen"


class EntityAvailabilityStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Availability status of the entity."""

    AVAILABLE = "Available"
    LIMITED = "Limited"
    RENAMING = "Renaming"
    RESTORING = "Restoring"
    UNKNOWN = "Unknown"


class EntityStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status of a Service Bus resource."""

    ACTIVE = "Active"
    CREATING = "Creating"
    DELETING = "Deleting"
    DISABLED = "Disabled"
    RECEIVE_DISABLED = "ReceiveDisabled"
    RENAMING = "Renaming"
    RESTORING = "Restoring"
    SEND_DISABLED = "SendDisabled"
    UNKNOWN = "Unknown"


class MessagingSku(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The SKU for the messaging entity."""

    BASIC = "Basic"
    STANDARD = "Standard"
    PREMIUM = "Premium"


class NamespaceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of entities the namespace can contain."""

    MESSAGING = "Messaging"
    NOTIFICATION_HUB = "NotificationHub"
    MIXED = "Mixed"
    EVENT_HUB = "EventHub"
    RELAY = "Relay"
