# Copyright 2012 Facebook
#
# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

"""Data used by the tornado.locale module."""

LOCALE_NAMES = {
    "af_ZA": {"name_en": "Afrikaans", "name": "Afrikaans"},
    "am_ET": {"name_en": "Amharic", "name": "አማርኛ"},
    "ar_AR": {"name_en": "Arabic", "name": "العربية"},
    "bg_BG": {"name_en": "Bulgarian", "name": "Български"},
    "bn_IN": {"name_en": "Bengali", "name": "বাংলা"},
    "bs_BA": {"name_en": "Bosnian", "name": "Bosanski"},
    "ca_ES": {"name_en": "Catalan", "name": "Català"},
    "cs_CZ": {"name_en": "Czech", "name": "Čeština"},
    "cy_GB": {"name_en": "Welsh", "name": "Cymraeg"},
    "da_DK": {"name_en": "Danish", "name": "Dansk"},
    "de_DE": {"name_en": "German", "name": "Deutsch"},
    "el_GR": {"name_en": "Greek", "name": "Ελληνικά"},
    "en_GB": {"name_en": "English (UK)", "name": "English (UK)"},
    "en_US": {"name_en": "English (US)", "name": "English (US)"},
    "es_ES": {"name_en": "Spanish (Spain)", "name": "Español (España)"},
    "es_LA": {"name_en": "Spanish", "name": "Español"},
    "et_EE": {"name_en": "Estonian", "name": "Eesti"},
    "eu_ES": {"name_en": "Basque", "name": "Euskara"},
    "fa_IR": {"name_en": "Persian", "name": "فارسی"},
    "fi_FI": {"name_en": "Finnish", "name": "Suomi"},
    "fr_CA": {"name_en": "French (Canada)", "name": "Français (Canada)"},
    "fr_FR": {"name_en": "French", "name": "Français"},
    "ga_IE": {"name_en": "Irish", "name": "Gaeilge"},
    "gl_ES": {"name_en": "Galician", "name": "Galego"},
    "he_IL": {"name_en": "Hebrew", "name": "עברית"},
    "hi_IN": {"name_en": "Hindi", "name": "हिन्दी"},
    "hr_HR": {"name_en": "Croatian", "name": "Hrvatski"},
    "hu_HU": {"name_en": "Hungarian", "name": "Magyar"},
    "id_ID": {"name_en": "Indonesian", "name": "Bahasa Indonesia"},
    "is_IS": {"name_en": "Icelandic", "name": "Íslenska"},
    "it_IT": {"name_en": "Italian", "name": "Italiano"},
    "ja_JP": {"name_en": "Japanese", "name": "日本語"},
    "ko_KR": {"name_en": "Korean", "name": "한국어"},
    "lt_LT": {"name_en": "Lithuanian", "name": "Lietuvių"},
    "lv_LV": {"name_en": "Latvian", "name": "Latviešu"},
    "mk_MK": {"name_en": "Macedonian", "name": "Македонски"},
    "ml_IN": {"name_en": "Malayalam", "name": "മലയാളം"},
    "ms_MY": {"name_en": "Malay", "name": "Bahasa Melayu"},
    "nb_NO": {"name_en": "Norwegian (bokmal)", "name": "Norsk (bokmål)"},
    "nl_NL": {"name_en": "Dutch", "name": "Nederlands"},
    "nn_NO": {"name_en": "Norwegian (nynorsk)", "name": "Norsk (nynorsk)"},
    "pa_IN": {"name_en": "Punjabi", "name": "ਪੰਜਾਬੀ"},
    "pl_PL": {"name_en": "Polish", "name": "Polski"},
    "pt_BR": {"name_en": "Portuguese (Brazil)", "name": "Português (Brasil)"},
    "pt_PT": {"name_en": "Portuguese (Portugal)", "name": "Português (Portugal)"},
    "ro_RO": {"name_en": "Romanian", "name": "Română"},
    "ru_RU": {"name_en": "Russian", "name": "Русский"},
    "sk_SK": {"name_en": "Slovak", "name": "Slovenčina"},
    "sl_SI": {"name_en": "Slovenian", "name": "Slovenščina"},
    "sq_AL": {"name_en": "Albanian", "name": "Shqip"},
    "sr_RS": {"name_en": "Serbian", "name": "Српски"},
    "sv_SE": {"name_en": "Swedish", "name": "Svenska"},
    "sw_KE": {"name_en": "Swahili", "name": "Kiswahili"},
    "ta_IN": {"name_en": "Tamil", "name": "தமிழ்"},
    "te_IN": {"name_en": "Telugu", "name": "తెలుగు"},
    "th_TH": {"name_en": "Thai", "name": "ภาษาไทย"},
    "tl_PH": {"name_en": "Filipino", "name": "Filipino"},
    "tr_TR": {"name_en": "Turkish", "name": "Türkçe"},
    "uk_UA": {"name_en": "Ukraini ", "name": "Українська"},
    "vi_VN": {"name_en": "Vietnamese", "name": "Tiếng Việt"},
    "zh_CN": {"name_en": "Chinese (Simplified)", "name": "中文(简体)"},
    "zh_TW": {"name_en": "Chinese (Traditional)", "name": "中文(繁體)"},
}
