% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reflog.R
\name{print.git_reflog_entry}
\alias{print.git_reflog_entry}
\title{Print a reflog entry}
\usage{
\method{print}{git_reflog_entry}(x, ...)
}
\arguments{
\item{x}{The reflog entry}

\item{...}{Unused}
}
\value{
None (invisible 'NULL').
}
\description{
Print a reflog entry
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Create a user and commit a file
config(repo, user.name = "Alice", user.email = "alice@example.org")
writeLines("Hello world!", file.path(path, "example.txt"))
add(repo, "example.txt")
commit(repo, "First commit message")

## View repository HEAD reflog
reflog(repo)
}
}
