# - Find Asciidoc
# this module looks for asciidoc and a2x
#
# ASCIIDOC_EXECUTABLE - the full path to asciidoc
# ASCIIDOC_FOUND - If false, don't attempt to use asciidoc.
# A2X_EXECUTABLE - the full path to a2x
# A2X_FOUND - If false, don't attempt to use a2x.


FIND_PROGRAM(ASCIIDOC_EXECUTABLE
asciidoc
)

MARK_AS_ADVANCED(
ASCIIDOC_EXECUTABLE
)

IF (NOT ASCIIDOC_EXECUTABLE)
SET(ASCIIDOC_FOUND "NO")
ELSE (NOT ASCIIDOC_EXECUTABLE)
SET(ASCIIDOC_FOUND "YES")
ENDIF (NOT ASCIIDOC_EXECUTABLE)


IF (NOT ASCIIDOC_FOUND AND Asciidoc_FIND_REQUIRED)
MESSAGE(FATAL_ERROR "Could not find asciidoc")
ENDIF (NOT ASCIIDOC_FOUND AND Asciidoc_FIND_REQUIRED)

FIND_PROGRAM(A2X_EXECUTABLE
a2x
)

MARK_AS_ADVANCED(
A2X_EXECUTABLE
)

IF (NOT A2X_EXECUTABLE)
SET(A2X_FOUND "NO")
ELSE (NOT A2X_EXECUTABLE)
SET(A2X_FOUND "YES")
ENDIF (NOT A2X_EXECUTABLE)


IF (NOT A2X_FOUND AND A2x_FIND_REQUIRED)
MESSAGE(FATAL_ERROR "Could not find a2x")
ENDIF (NOT A2X_FOUND AND A2x_FIND_REQUIRED)
