import React, { useCallback, useMemo } from 'react';
import { default as AnalyticsReactContext } from '@atlaskit/analytics-next-stable-react-context';
import { useAnalyticsContext } from '../../hooks/useAnalyticsContext';
import { useTrackedRef } from '../../hooks/useTrackedRef';
const AnalyticsListener = ({
  children,
  channel,
  onEvent
}) => {
  const {
    getAtlaskitAnalyticsEventHandlers = () => [],
    getAtlaskitAnalyticsContext
  } = useAnalyticsContext();
  const onEventRef = useTrackedRef(onEvent);
  const channelRef = useTrackedRef(channel);
  const getAnalyticsEventHandlers = useCallback(() => {
    const thisHandler = (event, eventChannel) => {
      if (channelRef.current === '*' || channelRef.current === eventChannel) {
        onEventRef.current(event, eventChannel);
      }
    };
    return [thisHandler, ...getAtlaskitAnalyticsEventHandlers()];
  }, [channelRef, onEventRef, getAtlaskitAnalyticsEventHandlers]);
  const value = useMemo(() => ({
    getAtlaskitAnalyticsContext,
    getAtlaskitAnalyticsEventHandlers: getAnalyticsEventHandlers
  }), [getAtlaskitAnalyticsContext, getAnalyticsEventHandlers]);
  return /*#__PURE__*/React.createElement(AnalyticsReactContext.Provider, {
    value: value
  }, children);
};
export default AnalyticsListener;