import _typeof from "@babel/runtime/helpers/typeof";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/inherits";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
import React, { Component } from 'react';
import PropTypes from 'prop-types';
import index from '../matchEvent';
export var ContextTypes = {
  onAnalyticsEvent: PropTypes.func,
  getParentAnalyticsData: PropTypes.func
};

/**
 * The Decorator component extends analytics event data
 * for any events fired by its descendents,
 * then passes the event up the hierarchy
 */
// eslint-disable-next-line @repo/internal/react/no-class-components
export var AnalyticsDecorator = /*#__PURE__*/function (_Component) {
  function AnalyticsDecorator() {
    var _this;
    _classCallCheck(this, AnalyticsDecorator);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, AnalyticsDecorator, [].concat(args));
    _defineProperty(_this, "getDecoratedAnalyticsData", function (name, srcData, isPrivate) {
      var _this$props = _this.props,
        data = _this$props.data,
        getData = _this$props.getData,
        match = _this$props.match,
        matchPrivate = _this$props.matchPrivate;
      var decoratedData = _objectSpread({}, srcData);
      if (matchPrivate === isPrivate && index(match, name)) {
        if (_typeof(data) === 'object') {
          Object.assign(decoratedData, data);
        }
        if (typeof getData === 'function') {
          Object.assign(decoratedData, getData(name, decoratedData));
        }
      }
      return decoratedData;
    });
    _defineProperty(_this, "onAnalyticsEvent", function (name, srcData, isPrivate) {
      var _ref = _this.context,
        onAnalyticsEvent = _ref.onAnalyticsEvent;
      if (typeof onAnalyticsEvent !== 'function') {
        return;
      }
      var decoratedData = _this.getDecoratedAnalyticsData(name, srcData, isPrivate);
      onAnalyticsEvent(name, decoratedData, isPrivate);
    });
    _defineProperty(_this, "getParentAnalyticsData", function (name, isPrivate) {
      var parentData = _this.getDecoratedAnalyticsData(name, {}, isPrivate);
      var _ref2 = _this.context,
        getParentAnalyticsData = _ref2.getParentAnalyticsData;
      if (typeof getParentAnalyticsData === 'function') {
        Object.assign(parentData, getParentAnalyticsData(name, isPrivate));
      }
      return parentData;
    });
    return _this;
  }
  _inherits(AnalyticsDecorator, _Component);
  return _createClass(AnalyticsDecorator, [{
    key: "getChildContext",
    value: function getChildContext() {
      return {
        onAnalyticsEvent: this.onAnalyticsEvent,
        getParentAnalyticsData: this.getParentAnalyticsData
      };
    }
  }, {
    key: "render",
    value: function render() {
      var children = this.props.children;
      return React.Children.only(children);
    }
  }]);
}(Component);
_defineProperty(AnalyticsDecorator, "defaultProps", {
  match: '*',
  matchPrivate: false
});
_defineProperty(AnalyticsDecorator, "contextTypes", ContextTypes);
_defineProperty(AnalyticsDecorator, "childContextTypes", ContextTypes);
export default AnalyticsDecorator;