/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import proguard.io.DataEntry;
import proguard.io.DataEntryWriter;

public class FixedFileWriter
implements DataEntryWriter {
    private final File file;
    private OutputStream outputStream;

    public FixedFileWriter(File file) {
        this.file = file;
    }

    @Override
    public boolean createDirectory(DataEntry dataEntry) throws IOException {
        File directory = this.file;
        if (!directory.exists() && !directory.mkdirs()) {
            throw new IOException("Can't create directory [" + directory.getPath() + "]");
        }
        return true;
    }

    @Override
    public boolean sameOutputStream(DataEntry dataEntry1, DataEntry dataEntry2) throws IOException {
        return true;
    }

    @Override
    public OutputStream createOutputStream(DataEntry dataEntry) throws IOException {
        File file = this.file;
        File parentDirectory = file.getParentFile();
        if (parentDirectory != null && !parentDirectory.exists() && !parentDirectory.mkdirs()) {
            throw new IOException("Can't create directory [" + parentDirectory.getPath() + "]");
        }
        this.outputStream = new BufferedOutputStream(new FileOutputStream(file));
        return this.outputStream;
    }

    @Override
    public void close() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.close();
            this.outputStream = null;
        }
    }

    @Override
    public void println(PrintWriter pw, String prefix) {
        pw.println(prefix + "FixedFileWriter (file [" + this.file + "])");
    }
}

