// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package bind

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// DeleteBindLogForwardAcceptedCode is the HTTP code returned for type DeleteBindLogForwardAccepted
const DeleteBindLogForwardAcceptedCode int = 202

/*
DeleteBindLogForwardAccepted Configuration change accepted and reload requested

swagger:response deleteBindLogForwardAccepted
*/
type DeleteBindLogForwardAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`
}

// NewDeleteBindLogForwardAccepted creates DeleteBindLogForwardAccepted with default headers values
func NewDeleteBindLogForwardAccepted() *DeleteBindLogForwardAccepted {

	return &DeleteBindLogForwardAccepted{}
}

// WithReloadID adds the reloadId to the delete bind log forward accepted response
func (o *DeleteBindLogForwardAccepted) WithReloadID(reloadID string) *DeleteBindLogForwardAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the delete bind log forward accepted response
func (o *DeleteBindLogForwardAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WriteResponse to the client
func (o *DeleteBindLogForwardAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(202)
}

// DeleteBindLogForwardNoContentCode is the HTTP code returned for type DeleteBindLogForwardNoContent
const DeleteBindLogForwardNoContentCode int = 204

/*
DeleteBindLogForwardNoContent Bind deleted

swagger:response deleteBindLogForwardNoContent
*/
type DeleteBindLogForwardNoContent struct {
}

// NewDeleteBindLogForwardNoContent creates DeleteBindLogForwardNoContent with default headers values
func NewDeleteBindLogForwardNoContent() *DeleteBindLogForwardNoContent {

	return &DeleteBindLogForwardNoContent{}
}

// WriteResponse to the client
func (o *DeleteBindLogForwardNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// DeleteBindLogForwardNotFoundCode is the HTTP code returned for type DeleteBindLogForwardNotFound
const DeleteBindLogForwardNotFoundCode int = 404

/*
DeleteBindLogForwardNotFound The specified resource was not found

swagger:response deleteBindLogForwardNotFound
*/
type DeleteBindLogForwardNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteBindLogForwardNotFound creates DeleteBindLogForwardNotFound with default headers values
func NewDeleteBindLogForwardNotFound() *DeleteBindLogForwardNotFound {

	return &DeleteBindLogForwardNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the delete bind log forward not found response
func (o *DeleteBindLogForwardNotFound) WithConfigurationVersion(configurationVersion string) *DeleteBindLogForwardNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete bind log forward not found response
func (o *DeleteBindLogForwardNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete bind log forward not found response
func (o *DeleteBindLogForwardNotFound) WithPayload(payload *models.Error) *DeleteBindLogForwardNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete bind log forward not found response
func (o *DeleteBindLogForwardNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteBindLogForwardNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
DeleteBindLogForwardDefault General Error

swagger:response deleteBindLogForwardDefault
*/
type DeleteBindLogForwardDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteBindLogForwardDefault creates DeleteBindLogForwardDefault with default headers values
func NewDeleteBindLogForwardDefault(code int) *DeleteBindLogForwardDefault {
	if code <= 0 {
		code = 500
	}

	return &DeleteBindLogForwardDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the delete bind log forward default response
func (o *DeleteBindLogForwardDefault) WithStatusCode(code int) *DeleteBindLogForwardDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the delete bind log forward default response
func (o *DeleteBindLogForwardDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the delete bind log forward default response
func (o *DeleteBindLogForwardDefault) WithConfigurationVersion(configurationVersion string) *DeleteBindLogForwardDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete bind log forward default response
func (o *DeleteBindLogForwardDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete bind log forward default response
func (o *DeleteBindLogForwardDefault) WithPayload(payload *models.Error) *DeleteBindLogForwardDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete bind log forward default response
func (o *DeleteBindLogForwardDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteBindLogForwardDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
