# Welcome, Open Source Contributor

Welcome, potential new Open Source contributor! This is a guide to show you exactly how to make a contribution, and will lead you through the entire process.

There are many people who wish to start contributing, but don't know how or where to start.
If this might be the case for you, then please read on, this guide is for you.
Because we want you to join in the fun with Open Source - it can be fun and rewarding, improve your skills, or just give you a way to contribute back to a project.

## How to Help

Help is needed in all areas of Taskwarrior development - design, coding, testing, support and marketing.
Applicants must be friendly.
Perhaps you are looking to help, but don't know where to start.
Perhaps you have skills we are looking for, here are ways you may be able to help:

-   Use Taskwarrior, become familiar with it, and make suggestions.
    We get great feedback from both new users and veteran users.
    New users have a fresh approach that we can no longer achieve, while veteran users develop clever and crafty ways to use the product.

-   Report bugs and odd behavior when you see it.
    We don't necessarily know it's broken, unless you tell us.

-   Suggest enhancements.
    We get lots of these, and it's great.
    Some really good ideas have been suggested and implemented.
    Sure, some are out of scope, or plain crazy, but the stream of suggestions is fascinating to think about.

-   Participate in the [bug tracking](https://github.com/GothenburgBitFactory/taskwarrior/issues) database, to help others and maybe learn something yourself.

-   Proofread the documentation and man pages.

-   Improve the documentation.

-   Improve the man pages.

-   Help improve the tutorials.
    Make your own tutorial.

-   Confirm a bug.
    Nothing gets fixed without confirmation.

-   Refine a bug.
    Provide relevant details, elaborate on the behavior.

-   Fix a bug.
    Send a patch.
    For this you'll need to know some C++ or Rust, and understand the [GitHub flow](https://docs.github.com/en/get-started/quickstart/github-flow).
    See [Developing Taskwarrior](./development.md) for more information.
    We welcome all bug fixes, provided the work is done well and doesn't create other problems or introduce new dependencies.
    We recommend talking to us before starting: we are happy to help you out!

-   Write a unit test.
    Unit tests are possibly the most useful contributions of all, because they not only improve the quality of the code, but prevent future regressions, therefore maintaining quality of subsequent releases.
    Plus, broken tests are a great motivator for us to fix the causal defect.
    You'll need Python skills.

-   Spread the word.
    Help others become more effective at managing tasks.
    Share your methodology, to inspire others.

-   Encouragement.
    Tell us what works for you, and what doesn't.
    It's all good.

-   Donate! Help offset costs.

Please remember that we need contributions from all skillsets, however small.
Every contribution helps.
