import { TFormForwardRef } from "./Form";
import { FieldValues, UseFormProps } from "react-hook-form";
import { ForwardedRef, ReactNode } from "react";
import { TErrorContext, THandleFormResponseError, TMutateFnReturn } from "./types";
export declare const ErrorContext: import("react").Context<TErrorContext>;
export declare const useErrorContext: () => TErrorContext;
type TConnectedFormProps<TFormFields extends FieldValues, TTransformedFormFields, TResponseData = unknown, TResponseErrorPayload = unknown> = {
    mutateFn: (data: TTransformedFormFields) => Promise<TMutateFnReturn<TResponseData, TResponseErrorPayload>>;
    preMutateFn?: (data: TFormFields) => TTransformedFormFields;
    onSuccessfulRequest?: (data?: TResponseData) => void;
    onErrorResponse?: THandleFormResponseError<TResponseErrorPayload, TTransformedFormFields, TFormFields>;
    children: ReactNode;
    options?: UseFormProps<TFormFields>;
};
export type TConnectedFormForwardRef<TFormFields extends FieldValues> = {
    submit: (formData: TFormFields) => Promise<void>;
    getForm: TFormForwardRef<TFormFields>["getForm"];
};
declare function ConnectedFormRaw<TFormFields extends FieldValues, TTransformedFormFields = TFormFields, TResponseData = unknown, TResponseErrorPayload = unknown>(props: TConnectedFormProps<TFormFields, TTransformedFormFields, TResponseData, TResponseErrorPayload>, ref: ForwardedRef<TConnectedFormForwardRef<TFormFields>>): import("react/jsx-runtime").JSX.Element;
declare const ConnectedForm: <TFormFields extends FieldValues, TTransformedFormFields, TResponseData, TResponseError>(props: TConnectedFormProps<TFormFields, TTransformedFormFields, TResponseData, TResponseError> & {
    ref?: React.ForwardedRef<TConnectedFormForwardRef<TFormFields>>;
}) => ReturnType<typeof ConnectedFormRaw>;
export { ConnectedForm };
//# sourceMappingURL=ConnectedForm.d.ts.map