/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.visual.router;

import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.router.Router;
import org.netbeans.api.visual.widget.ConnectionWidget;

import java.awt.*;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 *
 * @author alex
 */
public class FreeRouter implements Router {
    
    public FreeRouter() {
    }
    
    public List<Point> routeConnection(ConnectionWidget widget) {
        ArrayList<Point> list = new ArrayList<Point> ();
        
        Anchor sourceAnchor = widget.getSourceAnchor();
        Anchor targetAnchor = widget.getTargetAnchor();
        if (sourceAnchor == null  ||  targetAnchor == null)
            return Collections.emptyList();

        list.add(sourceAnchor.compute(widget.getSourceAnchorEntry()).getAnchorSceneLocation());

        List<Point> oldControlPoints = widget.getControlPoints ();
        if(oldControlPoints !=null) {
            ArrayList<Point> oldList = new ArrayList<Point> (oldControlPoints);
            oldList.remove(widget.getFirstControlPoint());
            oldList.remove(widget.getLastControlPoint());
            list.addAll(oldList);
        }

        list.add(targetAnchor.compute(widget.getTargetAnchorEntry()).getAnchorSceneLocation());

        return list;
    }
    
}
