#!/bin/sh
set -e

cp debian/tests/testfiles/* $AUTOPKGTEST_TMP

echo "Testing if z80 binary is as expected"
pasmo $AUTOPKGTEST_TMP/test_z80.asm $AUTOPKGTEST_TMP/test_z80.bin
cmp $AUTOPKGTEST_TMP/test_z80.bin $AUTOPKGTEST_TMP/expected_output_test_z80.bin
echo "PASS"

echo "Testing if 8086 binary is as expected"
pasmo --86 $AUTOPKGTEST_TMP/test_8086.asm $AUTOPKGTEST_TMP/test_8086.bin
cmp $AUTOPKGTEST_TMP/expected_output_test_8086.bin $AUTOPKGTEST_TMP/test_8086.bin
echo "PASS"

echo "Testing if pasmo handles error correctly"
pasmo --err $AUTOPKGTEST_TMP/test_error.asm $AUTOPKGTEST_TMP/test_error.bin | grep "ERROR" > /dev/null
echo "PASS"

exit 0
